/*! For license information please see index.js.LICENSE.txt */
!function(e,t){if("object"==typeof exports&&"object"==typeof module)module.exports=t();else if("function"==typeof define&&define.amd)define([],t);else{var i=t();for(var n in i)("object"==typeof exports?exports:e)[n]=i[n]}}(self,()=>(()=>{var e={5(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActionBarStyle=void 0;const n=i(6199);t.ActionBarStyle=`\n    .ide-action-bar {\n        white-space: nowrap;\n        height: 100%;\n    }\n\n    .ide-action-bar .actions-container {\n        display: flex;\n        margin: 0 auto;\n        padding: 0;\n        height: 100%;\n        width: 100%;\n        align-items: center;\n    }\n\n    .ide-action-bar.vertical .actions-container {\n        display: inline-block;\n    }\n\n    .ide-action-bar .action-item {\n        display: block;\n        align-items: center;\n        justify-content: center;\n        cursor: pointer;\n        position: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n    }\n\n    .ide-action-bar .action-item.disabled {\n        cursor: default;\n    }\n\n    .ide-action-bar .action-item .icon,\n    .ide-action-bar .action-item .codicon {\n        display: block;\n    }\n\n    .ide-action-bar .action-item .codicon {\n        align-items: center;\n    }\n\n    .ide-action-bar .action-label {\n        font-size: ${n.fontSize.mainText};\n        padding: 3px;\n        border-radius: 5px;\n    }\n\n    .ide-action-bar .action-item.disabled .action-label,\n    .ide-action-bar .action-item.disabled .action-label::before,\n    .ide-action-bar .action-item.disabled .action-label:hover {\n        opacity: 0.6;\n    }\n\n    /* Vertical actions */\n\n    .ide-action-bar.vertical {\n        text-align: left;\n    }\n\n    .ide-action-bar.vertical .action-item {\n        display: block;\n    }\n\n    .ide-action-bar.vertical .action-label.separator {\n        display: block;\n        border-bottom: 1px solid #bbb;\n        padding-top: 1px;\n        margin-left: .8em;\n        margin-right: .8em;\n    }\n\n    .ide-action-bar .action-item .action-label.separator {\n        width: 1px;\n        height: 18px;\n        margin: 2px 4px !important;\n        cursor: default;\n        min-width: 1px;\n        padding: 0;\n        background-color: ${n.actionSeparatorColor};\n    }\n\n    .secondary-actions .ide-action-bar .action-label {\n        margin-left: 6px;\n    }\n\n    :host {\n        display: var(--user-view-action-bar-display, flex);\n        flex: var(--user-view-action-bar-flex, 0);\n        overflow: var(--user-view-action-bar-overflow, visible);\n        margin: var(--user-view-action-bar-margin, 0px);\n        position: var(--user-view-action-bar-position);\n        right: var(--user-view-action-bar-right);\n        top: var(--user-view-action-bar-top);\n        visibility: var(--user-view-action-bar-visibility);\n    }\n\n    :host .actions-container {\n        justify-content: var(--user-view-action-item-justify-content, flex);\n    }\n\n    :host .ide-action-bar {\n        flex: var(--user-view-action-bar-flex, 0);\n    }\n\n    :host .ide-action-bar .action-item {\n        margin: var(--user-view-action-item-margin);\n    }\n\n    :host .action-label.codicon::before {\n        color: var(--user-view-action-item-color, var(--user-view-icon-color));\n    }\n\n    :host .action-label.codicon:focus-visible {\n        outline: 1px solid ${n.primaryColorHover};\n        outline-offset: -1px;\n        border-radius: 4px;\n    }\n\n    :host .action-label {\n        color: var(--user-view-action-item-color, ${n.actionViewItemIconColor});\n    }\n\n    :host .action-label.checked {\n        background-color: ${n.actionViewItemHover};\n    }\n\n    :host .action-label.icon {\n        width: 16px;\n        height: 16px;\n        background-repeat: no-repeat;\n        background-position: 50%;\n        background-size: 16px;\n    }\n\n    .ide-action-bar .action-label {\n        font-size: ${n.fontSize.mainText};\n        padding: 3px;\n        border-radius: 5px;\n    }\n\n    .ide-action-bar:not(.side-bar) .action-label:not(.disabled):hover {\n        background-color: ${n.actionViewItemHover};\n    }\n\n    .ide-action-bar.side-bar .action-item.focused {\n        outline: 1px solid ${n.primaryColorHover};\n        outline-offset: -1px;\n        border-radius: 4px;\n    }\n\n    .ide-action-bar.side-bar .action-item {\n        color: ${n.primaryFontColor};\n        max-height: 200px;\n        max-width: 200px;\n    }\n\n    .ide-action-bar.side-bar.vertical {\n        text-align: center;\n    }\n\n    .ide-action-bar.side-bar.vertical .action-item {\n        margin: 4px 4px 10px 4px;\n        padding: 4px 1px;\n    }\n\n    .ide-action-bar.side-bar.vertical .badge {\n        transform: rotate(-90deg);\n        max-height: 40px;\n        width: 22px;\n    }\n\n    .ide-action-bar.side-bar .action-label.icon {\n        background-color: ${n.actionViewItemIconColor};\n    }\n\n    .ide-action-bar.side-bar .action-item.checked .action-label.icon {\n        background-color: ${n.siderbarIconDownActive};\n    }\n\n    .ide-action-bar.side-bar .action-label {\n        color: ${n.primaryFontColor};\n    }\n\n    .ide-action-bar.side-bar.vertical .action-name {\n        writing-mode: vertical-rl;\n        margin: 0px 2px 0px 2px;\n        display: inline-block;\n        padding: 1px 0px 0px 0px;\n        text-orientation: sideways-right;\n        transform: rotate(180deg);\n    }\n\n    .ide-action-bar.side-bar.vertical .action-item:not(.checked):hover {\n        box-shadow: ${n.actionSideBarHoverBoxShadow};\n        background: ${n.actionSideBarHoverBackground};\n        border-radius: ${n.radius.normal};\n        color: ${n.actionSideBarNameColor};\n    }\n\n    :host-context(.left) .ide-action-bar.side-bar.vertical .action-name {\n        margin: 4px 2px -4px 2px;\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar.vertical .action-name {\n        transform: rotate(0deg);\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar.vertical .action-label {\n        transform: rotate(0deg);\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar.vertical .badge {\n        transform: rotate(90deg);\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar .action-item:not(.checked):hover {\n        box-shadow: ${n.actionSideBarHoverBoxShadow};\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar .action-item.checked {\n        box-shadow: ${n.actionSideBarCheckedBoxShadow};\n    }\n\n    .ide-action-bar.side-bar .action-item:not(.checked):hover.removeHover .action-label{\n        color: ${n.primaryFontColor};\n    }\n\n    .ide-action-bar.side-bar .action-item:not(.checked):hover.removeHover {\n        background: ${n.actionSideBarRemoveHoverBackground};\n        box-shadow: ${n.actionSideBarHoverRemoveBoxShadow};\n        color: ${n.primaryFontColor};\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar .action-item:not(.checked):hover.removeHover {\n        background: ${n.actionSideBarRemoveHoverBackground};\n        box-shadow: ${n.actionSideBarHoverRemoveBoxShadow};\n        color: ${n.primaryFontColor};\n    }\n\n    .ide-action-bar.side-bar:not(.vertical) .action-item:not(.checked):hover.removeHover {\n        background: ${n.actionSideBarRemoveHoverBackground};\n        box-shadow: ${n.actionSideBarCheckedRemoveBoxShadow};\n        color: ${n.primaryFontColor};\n    }\n\n    .ide-action-bar.side-bar .action-item.moving {\n        background: ${n.actionSideBarMovingBackground};\n        border-radius: ${n.radius.normal};\n    }\n\n    .ide-action-bar.side-bar .action-item:not(.checked):hover.moving {\n        background: ${n.actionSideBarMovingBackground};\n        box-shadow: ${n.actionSideBarHoverRemoveBoxShadow};\n    }\n\n    :host-context(.right) .ide-action-bar.side-bar .action-item:not(.checked):hover.moving {\n        background: ${n.actionSideBarMovingBackground};\n        box-shadow: ${n.actionSideBarHoverRemoveBoxShadow};\n    }\n\n    .ide-action-bar.side-bar .action-item.checked.moving {\n        background: ${n.actionSideBarMovingBackground};\n        box-shadow: ${n.actionSideBarCheckedRemoveBoxShadow};\n    }\n\n    .ide-action-bar.side-bar.vertical .action-item.checked.moving {\n        background: ${n.actionSideBarMovingBackground};\n        box-shadow: ${n.actionSideBarCheckedRemoveBoxShadow};\n    }\n\n    .ide-action-bar.side-bar:not(.vertical) .action-item:not(.checked):hover.moving {\n        background: ${n.actionSideBarMovingBackground};\n        box-shadow: ${n.actionSideBarCheckedRemoveBoxShadow};\n    }\n\n    .moving .action-name {\n        visibility: hidden;\n    }\n\n    .moving .action-label {\n        visibility: hidden;\n    }\n\n    .moving .badge {\n        visibility: hidden;\n    }\n\n    .ide-action-bar.side-bar:not(.vertical) .action-item {\n        display: inline-flex;\n        padding: 1px 4px;\n        margin: 4px 6px;\n    }\n\n    .ide-action-bar.side-bar:not(.vertical) .action-item:not(.checked):hover {\n        box-shadow: ${n.actionSideBarHoverBoxShadow};\n        background: ${n.actionSideBarHoverBackground};\n        border-radius: ${n.radius.normal};\n        color: ${n.actionSideBarNameColor};\n    }\n\n    .ide-action-bar.side-bar .action-item.checked {\n        background: ${n.actionSideBarCheckBackground};\n        box-shadow: ${n.actionSideBarCheckedBoxShadow};\n        border-radius: ${n.radius.normal};\n        color: ${n.actionSideBarNameColor};\n    }\n\n    .ide-action-bar.side-bar.vertical .action-item.checked {\n        box-shadow: ${n.actionSideBarCheckedBoxShadow};\n    }\n\n    .ide-action-bar.side-bar .action-item.checked .action-label {\n        color: ${n.actionSideBarNameColor};\n    }\n\n    .ide-action-bar.side-bar .action-item:not(.checked):hover .action-label {\n        color: ${n.actionSideBarNameColor};\n    }\n\n    .ide-action-bar.side-bar .action-name {\n        font-family: ${n.fontFamily};\n        font-size: ${n.fontSize.mainText};\n        letter-spacing: 0;\n        margin: 2px 0px 2px 0px;\n        padding: 1px 2px 0px 0px;\n        white-space: nowrap;\n        overflow: hidden;\n        text-overflow: ellipsis;\n        max-height: 120px;\n        max-width: 120px;\n    }\n`},79(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.CheckBoxDirectionType=t.CheckBoxGroup=t.IconPosition=t.CheckBox=void 0;var n=i(9302);Object.defineProperty(t,"CheckBox",{enumerable:!0,get:function(){return n.CheckBox}}),Object.defineProperty(t,"IconPosition",{enumerable:!0,get:function(){return n.IconPosition}});var o=i(2755);Object.defineProperty(t,"CheckBoxGroup",{enumerable:!0,get:function(){return o.CheckBoxGroup}}),Object.defineProperty(t,"CheckBoxDirectionType",{enumerable:!0,get:function(){return o.CheckBoxDirectionType}})},194(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActionViewItemStyle=void 0;const n=i(6199);t.ActionViewItemStyle=`\n    .codicon:before {\n        font-size: var(--user-view-action-item-font-size, 16px);\n        color: ${n.actionViewItemColor};\n    }\n\n    /* Action Items */\n    :host-content(.select-container) {\n        overflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n        flex: 1;\n        max-width: 170px;\n        min-width: 60px;\n        display: flex;\n        align-items: center;\n        justify-content: center;\n        margin-right: 10px;\n    }\n\n    :host-content(.action-dropdown-item) {\n        display: flex;\n    }\n\n    :host-content(.action-dropdown-item) > .action-label {\n        margin-right: 1px;\n    }\n\n    :host {\n        cursor: pointer;\n    }\n\n    :host(.always-visible) .action-label {\n        display: flex;\n    }\n\n    :host-context(.ide-action-bar:not(.side-bar)) .action-label:not(.disabled):hover {\n        background-color: ${n.actionViewItemHover};\n    }\n\n    :host-context(.action-item.disabled) .action-label,\n    :host-context(.action-item.disabled) .action-label::before,\n    :host-context(.action-item.disabled) .action-label:hover {\n        opacity: 0.6;\n    }\n\n    :host-context(.action-item.disabled) {\n        cursor: not-allowed;\n    }\n\n    :host .action-label.disabled {\n        cursor: not-allowed;\n        opacity: 0.6;\n    }\n\n    :host-context(.ide-action-bar) .action-label {\n        font-size: 12px;\n        padding: 3px;\n    }\n\n    :host .action-name {\n        font-size: 12px;\n    }\n\n    :host .action-label {\n        display: var(--user-view-action-item-display, inline-flex) !important;\n        border-radius: 4px;\n        padding: 5px 6px 3px 3px;\n        opacity: var(--user-view-action-item-opacity, 1);\n        color: var(--user-view-action-item-color, ${n.actionViewItemIconColor});\n    }\n\n    :host .vertical .action-label {\n        display: var(--user-view-action-item-display, flex) !important;\n        writing-mode: vertical-lr;\n        padding-left: 2px;\n    }\n\n    :host .action-label.checked {\n        background-color: ${n.actionViewItemChecked};\n    }\n\n    :host-context(.ide-action-bar:not(.side-bar)) .action-element.active .action-label {\n        background-color: ${n.actionViewItemChecked};\n        border-radius: 4px;\n    }\n\n    :host .action-label:not(:hover)::before {\n        content: var(--user-view-action-item-content, var(--user-view-icon-content));\n    }\n\n    :host .action-label.codicon {\n        margin: var(--user-view-action-item-codicon-margin);\n        padding: var(--user-view-action-item-padding, 2px);\n    }\n\n    :host .action-label.codicon::before {\n        color: var(--user-view-action-item-color, var(--user-view-icon-color));\n    }\n\n    :host .action-label:focus {\n        outline: 1px solid ${n.primaryColorHover};\n\t    outline-offset: -1px;\n    }\n\n    :host .action-label:focus-visible {\n        outline: 1px solid ${n.primaryColorHover};\n        outline-offset: -1px;\n    }\n\n    :host .action-label.codicon.always-visible {\n        display: flex;\n    }\n\n    :host .vertical .action-name {\n        padding: 4px 2px 2px 2px;\n    }\n\n    :host .action-name {\n        font-family: ${n.fontFamily};\n        color: var(--user-view-action-item-color, ${n.actionSideBarNameColor});\n    }\n\n    :host .action-element:not(.vertical) .codicon .action-name {\n        margin: 1px 3px 0px 2px;\n    }\n\n    :host .action-element {\n        align-items: center;\n        justify-content: center;\n        display: flex;\n    }\n\n    :host .action-element:focus-visible {\n        outline: 1px solid ${n.primaryColorHover};\n        outline-offset: -1px;\n        border-radius: 4px;\n    }\n\n    :host .action-element.disabled {\n        cursor: not-allowed;\n    }\n\n    :host .action-element.separator {\n        cursor: default !important;\n    }\n\n    :host .vertical.action-element.separator {\n        width: 20px;\n        height: 1px;\n        opacity: 1;\n        margin: 4px 0px 4px 0px;\n        background: #424447;\n    }\n\n    :host .vertical.action-element {\n        align-items: center;\n        display: flex;\n        flex-direction: column;\n        justify-content: center;\n    }\n\n    :host .action-element:not(.vertical) .action-label.separator {\n        width: 1px;\n        height: 18px;\n        margin: 2px 4px !important;\n        cursor: default;\n        min-width: 1px;\n        padding: 0;\n        background-color: ${n.actionSeparatorColor};\n    }\n`},231(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SELECT_STATUS_CLASSNAMES=t.SELECT_SEARCH_CLASSNAMES=t.SELECT_SIZE_CLASSNAMES=void 0;const n=i(5093),o=i(1062);t.SELECT_SIZE_CLASSNAMES={[n.SelectSize.MEDIUM]:"ide-select-medium",[n.SelectSize.SMALL]:"ide-select-small",[n.SelectSize.MINIMAL]:"ide-select-minimal"},t.SELECT_SEARCH_CLASSNAMES=new Map([[!0,{search:"ide-select-selector-search",searchInput:"ide-select-selector-search-input"}],["inline",{search:"ide-select-selector-search-inline",searchInput:"ide-select-selector-search-inline-input"}]]),t.SELECT_STATUS_CLASSNAMES=new Map([[o.MessageType.INFO,"ide-select-status-info"],[o.MessageType.WARNING,"ide-select-status-warning"],[o.MessageType.ERROR,"ide-select-status-error"],[o.MessageType.SUCCESS,"ide-select-status-success"]])},308(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ContextView=t.layout=t.LayoutAnchorMode=t.LayoutAnchorPosition=t.AnchorAxisAlignment=t.AnchorPosition=t.AnchorAlignment=void 0;const n=i(9084);var o,s,r,a,l;function d(e,t,i){const n=i.mode===l.ALIGN?i.offset:i.offset+i.size,o=i.mode===l.ALIGN?i.offset+i.size:i.offset;return i.position===a.Before?t<=e-n?n:t<=o?o-t:Math.max(e-t,0):t<=o?o-t:t<=e-n?n:0}!function(e){e[e.LEFT=0]="LEFT",e[e.RIGHT=1]="RIGHT"}(o=t.AnchorAlignment||(t.AnchorAlignment={})),function(e){e[e.BELOW=0]="BELOW",e[e.ABOVE=1]="ABOVE"}(s=t.AnchorPosition||(t.AnchorPosition={})),function(e){e[e.VERTICAL=0]="VERTICAL",e[e.HORIZONTAL=1]="HORIZONTAL"}(r=t.AnchorAxisAlignment||(t.AnchorAxisAlignment={})),function(e){e[e.Before=0]="Before",e[e.After=1]="After"}(a=t.LayoutAnchorPosition||(t.LayoutAnchorPosition={})),function(e){e[e.AVOID=0]="AVOID",e[e.ALIGN=1]="ALIGN"}(l=t.LayoutAnchorMode||(t.LayoutAnchorMode={})),t.layout=d;class c extends n.BaseComponent{constructor(){super(),this.BUBBLE_UP_EVENTS=["click","keydown","focus","blur"],this.BUBBLE_DOWN_EVENTS=["click"],this.ORIGINAL_CONTAINER=document.body,this.container=this.ORIGINAL_CONTAINER,this.customViews=new Map,this.delegate=null,this.delegates=new Map,this.events=new Set,this.useFixedPosition=!1,this.view=document.createElement("div"),this.view.id="context-view",this.view.classList.add("ui-context-view"),this.shadow.appendChild(this.view),this.container.appendChild(this),this.addAllEventListeners()}showContextView(e,t){t?t!==this.container&&this.setContainer(t,!0):this.container!==this.ORIGINAL_CONTAINER&&this.setContainer(this.ORIGINAL_CONTAINER,!1),this.show(e)}setContainer(e,t){this.container&&(this.removeAllEventListeners(),this.customViews.forEach(e=>e.remove()),this.customViews.clear(),this.remove()),this.container=e,this.container.appendChild(this),this.useFixedPosition=t,this.addAllEventListeners()}addAllEventListeners(){this.BUBBLE_UP_EVENTS.forEach(e=>{const t=e=>{this.onDOMEvent(e,!1)};this.container.addEventListener(e,t),this.events.add({element:this.container,type:e,handler:t})}),this.BUBBLE_DOWN_EVENTS.forEach(e=>{const t=e=>{this.onDOMEvent(e,!0)};this.container.addEventListener(e,t),this.events.add({element:this.container,type:e,handler:t})})}removeAllEventListeners(){this.events.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.events.clear()}show(e){const t=e.customViewId;this.delegates.delete(t);const i=t?this.getCustomView(t):this.view;for(;i.firstChild;)i.firstChild.remove();i.style.zIndex=e.zIndex||"2500",e.upperLayer&&(i.style.zIndex="2501"),i.style.top="0px",i.style.left="0px",i.style.position="absolute",i.style.display="",i.removeAttribute("aria-hidden"),e.render(i),this.delegates.set(t,e),this.doLayout(t),e.focus&&e.focus()}getCustomView(e){if(!this.customViews.has(e)){const t=document.createElement("div");t.id=e,this.shadow.append(t),this.customViews.set(e,t)}return this.customViews.get(e)}hideContextView(e,t){const i=this.delegate;if(this.delegates.delete(e),(null==i?void 0:i.onHide)&&i.onHide(t),e&&!this.customViews.has(e))return;const n=e?this.customViews.get(e):this.view;n.style.display="none",n.setAttribute("aria-hidden","true")}getContextViewElement(e){return e?this.getCustomView(e):this.view}layout(e){if(!this.isVisible(e))return;const t=this.delegates.get(e);!1!==(null==t?void 0:t.canRelayout)?((null==t?void 0:t.layout)&&t.layout(),this.doLayout(e)):this.hideContextView(e)}isVisible(e){return!!this.delegates.size&&this.delegates.has(e)}doLayout(e){var t,i,n,c,u,h,p,b,m;if(!this.isVisible(e))return;const g=this.delegates.get(e),v=null==g?void 0:g.getAnchor(),f=this.container===this.ORIGINAL_CONTAINER?document.documentElement:this.container,w=f.getBoundingClientRect();let x;if(v instanceof HTMLElement){const e=this.getDomNodePagePosition(v);let i=1,n=v;do{const e=(null===(t=document.defaultView)||void 0===t?void 0:t.getComputedStyle(n,null)).zoom;null!=e&&"1"!==e&&(i*=e),n=n.parentElement}while(null!==n&&n!==document.documentElement);x={top:e.top*i,left:e.left*i,width:e.width*i,height:e.height*i}}else x={top:(null==v?void 0:v.y)||0,left:(null==v?void 0:v.x)||0,width:(null==v?void 0:v.width)||1,height:(null==v?void 0:v.height)||2};const y=(null==g?void 0:g.customViewId)&&null!==(i=this.customViews.get(g.customViewId))&&void 0!==i?i:this.view,k=null===(n=document.defaultView)||void 0===n?void 0:n.getComputedStyle(y,null),C=y.offsetWidth+parseFloat(null!==(c=null==k?void 0:k.marginLeft)&&void 0!==c?c:"")+parseFloat(null!==(u=null==k?void 0:k.marginRight)&&void 0!==u?u:""),E=y.offsetHeight+parseFloat(null!==(h=null==k?void 0:k.marginTop)&&void 0!==h?h:"")+parseFloat(null!==(p=null==k?void 0:k.marginBottom)&&void 0!==p?p:""),D=null!==(m=null===(b=null==g?void 0:g.anchorPosition)||void 0===b?void 0:b.call(g))&&void 0!==m?m:s.BELOW,S=(null==g?void 0:g.anchorAlignment)||o.LEFT;let A,_;if(((null==g?void 0:g.anchorAxisAlignment)||r.VERTICAL)===r.VERTICAL){const e={offset:x.top-this.getVerticalScrollOffset(x),size:x.height,position:D===s.BELOW?a.Before:a.After};A=d(this.getViewportHeight(),E,e)+this.getVerticalScrollOffset(x);const t=this.hasIntersection(A,A+E,e.offset+this.getVerticalScrollOffset(x),e.offset+e.size+this.getVerticalScrollOffset(x)),i=(I=x.left+x.width-C,B=x.left+x.width,F=window.pageXOffset,L=window.pageXOffset+w.width,I<F&&F<B||I<L&&L<B);let n=a.Before;(S===o.LEFT&&i||S===o.RIGHT&&!i)&&(n=a.After);const r={offset:x.left,size:x.width,position:n,mode:t?l.AVOID:l.ALIGN};_=d(this.getViewportWidth(),C,r)}else{const e={offset:x.left,size:x.width,position:S===o.LEFT?a.Before:a.After};_=d(this.getViewportWidth(),C,e);const t=this.hasIntersection(_,_+C,e.offset,e.offset+e.size),i={offset:x.top,size:x.height,position:D===s.BELOW?a.Before:a.After,mode:t?l.AVOID:l.ALIGN};A=d(this.getViewportHeight(),E,i)+this.getVerticalScrollOffset(x)}var I,B,F,L;y.classList.remove("top","bottom","left","right"),y.classList.add(D===s.BELOW?"bottom":"top"),y.classList.add(S===o.LEFT?"left":"right"),y.classList.toggle("fixed",this.useFixedPosition);const T=this.getDomNodePagePosition(f);y.style.top=A-(this.useFixedPosition?this.getDomNodePagePosition(y).top:T.top)+"px",y.style.left=_-(this.useFixedPosition?this.getDomNodePagePosition(y).left:T.left)+"px",y.style.width="initial"}getDomNodePagePosition(e){const t=e.getBoundingClientRect();let i,n;return this.container===this.ORIGINAL_CONTAINER?(i="number"==typeof window.scrollX?window.scrollX:document.body.scrollLeft+document.documentElement.scrollLeft,n="number"==typeof window.scrollY?window.scrollY:document.body.scrollTop+document.documentElement.scrollTop):(i=this.container.scrollLeft,n=this.container.scrollTop),{left:t.left+i,top:t.top+n,width:t.width,height:t.height}}getVerticalScrollOffset(e){return this.container===this.ORIGINAL_CONTAINER?window.pageYOffset:e.top+this.container.clientHeight-this.container.scrollHeight}hasIntersection(e,t,i,n){if(e>=n||i>=t)return!1;const o=Math.max(e,i);return Math.min(t,n)-o>=0}onDOMEvent(e,t){this.delegate&&(this.delegate.onDOMEvent?this.delegate.onDOMEvent(e,document.activeElement):t&&!this.isAncestor(e.target,this.container)&&this.hideContextView())}isAncestor(e,t){for(;e;){if(e===t)return!0;e=e.parentNode}return!1}getViewportHeight(){return this.container===this.ORIGINAL_CONTAINER?document.documentElement.clientHeight:this.container.scrollHeight}getViewportWidth(){return this.container===this.ORIGINAL_CONTAINER?document.documentElement.clientWidth:this.container.scrollWidth}dispose(){this.removeAllEventListeners()}}class u{static getInstance(){return this.contextView||(this.contextView=new c),u.contextView}static showContextView(e,t){this.getInstance().showContextView(e,t)}static hideContextView(e,t){this.getInstance().hideContextView(e,t)}static getContextViewElement(e){return this.getInstance().getContextViewElement(e)}static layout(e){this.getInstance().layout(e)}}t.ContextView=u,(0,n.defineCustomElement)("ide-context-view",c)},359(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getSelectItemStyle=t.getSelectOptionsPaneStyle=t.getSelectOptionsStyle=t.getSelectStyle=void 0;const n=i(6199);t.getSelectStyle=e=>`\n:host {\n    display: block;\n    outline: none;\n    border-radius: ${n.radius.normal};\n    --user-highlighted-span-container-overflow: hidden;\n    --user-highlighted-span-container-display: block;\n    --user-highlighted-span-container-width: 100%;\n    --user-highlighted-span-container-text-overflow: ellipsis;\n    --user-highlighted-span-container-white-space: nowrap;\n}\n\n:host ide-highlighted-label {\n    width: 100%;\n}\n\n.ide-select {\n    position: relative;\n    min-width: var(--user-ide-select-min-width, 200px);\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    box-sizing: border-box;\n    outline: none;\n}\n\n.ide-select.auto-width {\n    min-width: 64px;\n}\n\n.ide-select:hover {\n    cursor: pointer;\n}\n\n.ide-select-selector {\n    position: relative;\n    display: flex;\n    align-items: center;\n    width: var(--user-select-width, 100%);\n    padding: 0 8px;\n    background-color: ${e?"var(--vscode-select-optionsBackground)":n.selectBackground};\n    border: 1px solid;\n    border-color: ${e?"var(--vscode-dropdown-border)":n.selectBorderColor};\n    border-radius: ${n.radius.normal};\n    box-sizing: border-box;\n    color: ${e?"var(--vscode-dropdown-foreground)":n.primaryFontColor};\n    outline: none;\n    padding-inline-end: 20px;\n}\n\n.ide-select.ide-select-single.ide-select-medium .ide-select-selector,\n.ide-select.ide-select-medium .ide-select-selector-placeholder {\n    height: 28px;\n}\n\n.ide-select.ide-select-single.ide-select-small .ide-select-selector,\n.ide-select.ide-select-small .ide-select-selector-placeholder {\n    height: 24px;\n}\n\n.ide-select.ide-select-single.ide-select-minimal .ide-select-selector,\n.ide-select.ide-select-minimal .ide-select-selector-placeholder {\n    height: 20px;\n}\n\n.ide-select.ide-select-multiple.ide-select-medium .ide-select-selector {\n    min-height: 28px;\n}\n\n.ide-select.ide-select-multiple.ide-select-small .ide-select-selector {\n    min-height: 24px;\n}\n\n.ide-select.ide-select-multiple.ide-select-minimal .ide-select-selector {\n    min-height: 20px;\n}\n\n.ide-select.ide-select-disabled .ide-select-selector,\n.ide-select.ide-select-disabled {\n    background-color: ${e?"var(--vscode-select-optionsBackground)":n.disabledBackgroundColorCode};\n    border-color: ${e?"var(--vscode-dropdown-border, transparent)":n.optionBorderColor};\n    cursor: not-allowed;\n}\n\n.ide-select.ide-select-disabled .ide-select-arrow {\n    cursor: not-allowed;\n}\n\n.ide-select:not(.ide-select-disabled):hover .ide-select-selector {\n    border-color: ${e?"var(--vscode-focusBorder)":n.selectHoverBorderColor};\n}\n\n.ide-select-drop-down .ide-select-selector,\n.ide-select:not(.ide-select-disabled).focused .ide-select-selector,\n.ide-select:not(.ide-select-disabled) .ide-select-selector.ide-select-selector-focused {\n    border-color: ${e?"var(--vscode-focusBorder)":n.processingBackgroundColor};\n}\n.ide-select.ide-select-status-info:not(.ide-select-disabled) .ide-select-selector {\n    border-color: ${n.inputBoxBorderFocusColor};\n}\n.ide-select.ide-select-status-warning:not(.ide-select-disabled) .ide-select-selector {\n    border-color: ${n.inputBoxWarningBorderColor};\n}\n.ide-select.ide-select-status-error:not(.ide-select-disabled) .ide-select-selector {\n    border-color: ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.inputBoxErrorBorderColor};\n}\n.ide-select.ide-select-status-success:not(.ide-select-disabled) .ide-select-selector {\n    border-color: ${n.inputBoxSuccessBorderColor};\n}\n\n.ide-select-drop-down .ide-select-selector.ide-select-selector-focused .ide-select-selector-placeholder,\n.ide-select-disabled .ide-select-selector .ide-select-selector-placeholder,\n.ide-select-selector-placeholder.no-value {\n    color: var(--user-view-select-placeholder-disabled, ${n.disabledFontColor});\n}\n\n.ide-select-selector-placeholder {\n    display: flex;\n    align-items: center;\n    height: 100%;\n    padding-right: 12px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    pointer-events: none;\n    -moz-user-select:none;\n    -webkit-user-select:none;\n    -ms-user-select:none;\n    use-select: none;\n    --user-highlighted-span-container-color: ${e?"var(--vscode-foreground)":""}\n}\n\n.ide-select-multiple .ide-select-selector-placeholder  {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    inset-inline: 12px 12px;\n}\n\n.ide-select-multiple .ide-select-selector {\n    padding-inline-start: 3px;\n}\n\n.ide-select-selector-placeholder.hidden {\n    display: none;\n}\n\n.ide-select-selector-placeholder .ide-select-item-option-detail {\n    margin-left: 4px;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n}\n\n.ide-select-arrow {\n    position: absolute;\n    top: 50%;\n    right: 8px;\n    width: 12px;\n    height: 12px;\n    transform: translateY(-50%) rotate(0);\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: hidden;\n    transition: transform .1s;\n    will-change: transform;\n}\n\n.ide-select-arrow .codicon {\n    font-size: 16px;\n    color: #ACACAD;\n    line-height: 16px;\n}\n\n.ide-select-clear {\n    position: absolute;\n    top: 50%;\n    right: 8px;\n    background-color: ${e?"var(--vscode-select-optionsBackground)":n.selectBackground};\n    color: ${n.selectClearColor};\n    transform: translateY(-50%);\n}\n\n.ide-select-clear .codicon.codicon-stop {\n    font-size: ${n.fontSize.mainText};\n    width: ${n.fontSize.mainText};\n    height: ${n.fontSize.mainText}\n}\n\n.ide-select .ide-select-clear {\n    display: none;\n}\n\n.ide-select:not(.ide-select-disabled) .ide-select-clear.visible {\n    display: flex;\n}\n\n.ide-select-clear:hover {\n    color: ${n.selectClearHoverColor};\n}\n\n.ide-select-arrow-up {\n    transform: translateY(-50%) rotate(180deg);\n}\n\n.ide-select-selector-search {\n    position: absolute;\n    top: 0;\n    right: 20px;\n    min-width: 15px;\n    height: 100%;\n    inset: 0 30px 0 8px;\n}\n\n.ide-select-selector-search-input {\n    width: 100%;\n    height: 100%;\n    margin: 0;\n    padding: 0;\n    background: 0 0;\n    border: none;\n    outline: none;\n    color: ${e?"var(--vscode-foreground)":n.highLightedColor};\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    text-shadow: 0px 0px 0px ${n.primaryFontColor};\n    -webkit-text-fill-color: transparent;\n}\n\n.ide-select-selector-search-input-multiple {\n    top: 0;\n    width: 100%;\n    max-width: 200px;\n    height: 100%;\n    margin: 0;\n    padding: 0;\n    background: 0 0;\n    border: none;\n    outline: none;\n    color: ${n.primaryFontColor};\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-select-selection-multiple {\n    position: relative;\n    display: flex;\n    flex-wrap: wrap;\n    max-width: 100%;\n    height: 100%;\n    box-sizing: border-box;\n}\n\n.ide-select-show-search .ide-select-selection-multiple {\n    padding-right: 3px;\n}\n\n.ide-select-selection-multiple .ide-select-selection-multiple-item {\n    flex: none;\n    align-self: center;\n    max-width: 100%;\n    padding: 2px 2px 2px 0;\n}\n\n.ide-select-selection-multiple .ide-select-selection-multiple-item.search {\n    padding: 2px 0;\n    margin-left: 8px;\n}\n\n.ide-select-selection-multiple .ide-select-selection-multiple-item+.ide-select-selection-multiple-item.search {\n    margin-left: 0;\n}\n\n.ide-select-selection-multiple .ide-select-selector-search {\n    position: relative;\n    max-width: 100%;\n    inset: 0;\n    line-height: 20px;\n    height: 20px;\n    overflow: hidden;\n}\n\n.ide-select-selection-multiple .ide-select-selector-search-input {\n    width: 1px;\n    min-width: 1px;\n    max-width: 100%;\n    padding-left: 2px;\n}\n\n.ide-select-selection-multiple .ide-select-selection-search-mirror {\n    position: absolute;\n    top: 0;\n    left: 0;\n    z-index: 999;\n    white-space: pre;\n    visibility: hidden;\n}\n\n.ide-select-selector-search-icon {\n    display: block;\n    position: absolute;\n    top: 50%;\n    right: 8px;\n    width: 12px;\n    height: 12px;\n    transform: translateY(-50%);\n}\n\n.ide-select-selector-search-icon .codicon {\n    font-size: 12px;\n    color: #ACACAD;\n    line-height: 12px;\n}`,t.getSelectOptionsStyle=e=>`\n.ide-select-item-option {\n    border-radius: ${n.radius.bgRadius};\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n    --user-highlighted-span-container-color: ${e?"var(--vscode-foreground)":""}\n}\n\n.ide-select-item-option-disabled {\n    color: ${e?"var(--vscode-foreground)":n.disabledFontColor};\n}\n\n.ide-select-item-option.active {\n    background-color: ${e?"":n.optionHoverBackground};\n}\n\n.ide-select-item-option-disabled:hover {\n    background-color: transparent !important;\n    border: none;\n}\n\n.ide-select-item-option-disabled:hover .ide-select-item-option-content {\n    z-index: 1;\n}\n\n.ide-select-item-option-selected {\n    background-color: ${e?"var(--vscode-quickInputList-focusBackground)":n.secondaryBackgroundColor};\n    color: ${n.processingBackgroundColor};\n}\n\n.ide-select-item-option:hover {\n    background-color: ${e?"var(--vscode-quickInputList-focusBackground)":""};\n    --user-highlighted-span-container-color: ${e?"var(--vscode-quickInputList-focusForeground)":""}\n}\n\n.ide-select-item-option-selected-multiple {\n    background-color: ${e?"var(--vscode-quickInputList-focusBackground)":n.secondaryBackgroundColor};\n}\n\n.ide-select-item-option-selected-multiple.ide-select-item-option,\n.ide-select-item-option-selected.ide-select-item-option {\n    --user-highlighted-span-container-color: ${e?"var(--vscode-quickInputList-focusForeground)":""}\n}\n\n.ide-select-item-option-multiple {\n    display: flex;\n}\n\n.ide-select-item-option-container {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    z-index: -1;\n}\n\n.ide-select-item-option-content {\n    display: flex;\n    align-items: center;\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    letter-spacing: 0;\n    line-height: 20px;\n    min-height: 20px;\n    border-radius: ${n.radius.bgRadius};\n    padding: 3px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.ide-select-item-option-content ide-highlighted-label {\n    --user-highlighted-span-container-display: auto;\n    --user-highlighted-span-container-overflow: hidden;\n    --user-highlighted-span-container-text-overflow: ellipsis;\n    --user-highlighted-span-container-white-space: nowrap;\n}\n\n.ide-select-item-option-detail {\n    margin-left: 4px;\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n    letter-spacing: 0;\n    line-height: 18px;\n}\n\n.ide-select-item-option-detail-puredetail {\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n    letter-spacing: 0;\n    line-height: 18px;\n}\n\n.ide-select-item-option-detail-divider {\n    height: 1px;\n    border-top: 1px solid ${n.secondaryFontColor};\n    opacity: 0.4;\n    margin-top: 1px;\n    margin-left: 4px;\n    width:100%;\n}\n\n.ide-select-item-option-detail-divider-pureline {\n    height: 1px;\n    border-top: 1px solid ${n.secondaryFontColor};\n    opacity: 0.4;\n    margin-top: 1px;\n    width:100%;\n}\n\n.ide-select-item-option-disabled .ide-select-item-option-detail {\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n}\n\n.ide-select-item-option-defaults {\n    width: max-content;\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n    padding: 5px 4px 5px 0;\n    z-index: -1;\n}\n\n.ide-select-disabled .ide-select-selector-search, .ide-select-item-option-hidden {\n    display: none;\n}\n\n.ide-select-checkbox {\n    position: relative;\n    display: flex;\n    width: 100%;\n    align-items: center;\n    height: 28px;\n}\n\n.ide-select-checkbox .ide-select-checkbox-active-cover {\n    position: absolute;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    background-color: ${n.optionHoverBackground};\n    opacity: 0;\n    pointer-event: none;\n}\n\n.ide-select-checkbox.active .ide-select-checkbox-active-cover {\n    opacity: 1;\n}\n\n.ide-select-checkbox ide-checkbox {\n    width: 100%;\n    margin-left: 4px;\n}\n\n.ide-select-checkbox[disable='true']:hover,\n.ide-select-checkbox[disable='true'].active {\n    background: ${n.optionBackground};\n}\n\n.ide-select-checkbox[checked='true'] {\n    background: ${n.secondaryBackgroundColor};\n    border-radius: ${n.radius.bgRadius};\n}\n\n.ide-select-checkbox:hover {\n    background: ${n.optionHoverBackground};\n    border-radius: ${n.radius.bgRadius};\n}`,t.getSelectOptionsPaneStyle=e=>`\n.ide-select-item-options-pane {\n    display: flex;\n    flex-direction: column;\n    border-radius: ${n.radius.normal};\n    background-color: var(--user-view-select-background, ${e?"var(--vscode-dropdown-listBackground, var(--vscode-dropdown-background))":n.optionBackground});\n    box-shadow: 0 4px 16px 0 rgb(0 0 0 / 32%);\n    border: 1px solid var(--vscode-dropdown-listFocusBorder);\n}\n\n.ide-select-item-options {\n    overflow-y: auto;\n    box-sizing: border-box;\n    padding: 4px;\n    z-index: 1;\n    cursor: pointer;\n}\n\n.ide-select-item-options::-webkit-scrollbar {\n    width: 8px;\n    transform: translate3d(0px, 0px, 0px);\n    contain: strict;\n    background-color: ${e?"var(--vscode-dropdown-listBackground, var(--vscode-dropdown-background))":n.optionBackground};\n}\n\n.ide-select-item-options::-webkit-scrollbar-thumb {\n    border-radius: 10px;\n    background-color: ${n.optionScrollbarBackground}\n}\n\n.ide-select-selector-search-inline {\n    padding: 4px 2px 0;\n}\n\n.ide-select-selector-search-inline-input {\n    display: flex;\n    background-color: ${e?"var(--vscode-settings-textInputBackground)":n.optionBackground};\n    border: 1px solid ${e?"var(--vscode-settings-textInputBorder, transparent)":n.borderColor};\n    border-radius: ${n.radius.normal};\n    height: 28px;\n    width: 100%;\n    padding: 4px 6px;\n    box-sizing: border-box;\n    font-size: ${n.fontSize.mainText};\n    font-family: ${n.fontFamily};\n    color: ${e?"var(--vscode-settings-textInputForeground)":n.highLightedColor};\n    outline: none;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    text-shadow: 0px 0px 0px ${n.disabledFontColor};\n    -webkit-text-fill-color: transparent;\n}\n\n.ide-select-selector-search-inline-input:hover {\n    border: 1px solid ${n.secondaryBackgroundColor};\n}\n\n.ide-select-no-data-pane {\n    padding: 20px 0;\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n    font-size: ${n.fontSize.mainText};\n}\n\n.ide-select-no-data-span {\n    margin-top: ${n.fontSize.mainText};\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n}\n\n.ide-select-details-pane {\n    box-sizing: border-box;\n    padding: 5px 4px;\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n    word-break: break-word;\n    letter-space: 0;\n    line-height: 1.5;\n    cursor: default;\n}\n\n.ide-select-details-pane.below {\n    border-top: 1px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n}\n\n.ide-select-details-pane.above {\n    border-bottom: 1px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n}\n\n.ide-select-details-pane p {\n    margin: 0;\n}\n\n.ide-select-description-markdown code {\n    font-family: ${n.fontFamily};\n    color: ${n.codeColor};\n}\n\n.ide-select-description-markdown pre {\n\tmargin: 0;\n\twhite-space: pre-wrap;\n}\n\n.ide-select-description-markdown hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n    border-bottom: 0px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n\tborder-top: 1px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n\theight: 1px;\n}\n\n.ide-select-description-markdown a {\n    color: ${e?"var(--vscode-textLink-foreground)":n.hoverLinkColor};\n    text-decoration: none;\n}\n\n.ide-select-loadmore {\n    display: flex;\n    align-items: center;\n    font-family: 'Inter', 'Segoe UI', 'Arial', 'Microsoft YaHei', 'Microsoft Jhenghei';\n    font-size: 12px;\n    letter-spacing: 0;\n    line-height: 20px;\n    min-height: 20px;\n    padding: 3px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n    border-radius: 4px;\n    background-color: var(--user-view-select-background, var(--ide-ui-option-background));\n    box-shadow: 0 4px 16px 0 rgb(0 0 0 / 32%);\n    border: 1px solid var(--vscode-dropdown-listFocusBorder);\n    color: var(--ide-ui-primary-font-color);\n    user-select: none;\n    margin-top: 1px;\n    padding-left: 6px;\n    cursor: pointer;\n}\n\n.ide-select-loadmore:active,\n.ide-select-loadmore:hover {\n    background-color: var(--ide-ui-option-Hover-background);\n}\n`,t.getSelectItemStyle=e=>`\n.ide-select-item.ide-select-status-info .ide-select-item-status-message {\n    color: ${e?"var(--vscode-inputValidation-infoBorder)":n.inputBoxTextColor};\n}\n\n.ide-select-item.ide-select-status-warning .ide-select-item-status-message {\n    color: ${e?"var(--vscode-inputValidation-warningBorder)":n.inputBoxWarningBorderColor};\n}\n\n.ide-select-item.ide-select-status-error .ide-select-item-status-message {\n    color: ${e?"var(--vscode-inputValidation-errorBorder)":n.inputBoxErrorBorderColor};\n}\n\n.ide-select-item.ide-select-status-success .ide-select-item-status-message {\n    color: ${e?"var(--vscode-testing-iconPassed)":n.inputBoxSuccessBorderColor};\n}\n\n.ide-select-item-status-message {\n    display: inline-block;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    font-size: 12px;\n    line-height: 18px;\n    margin: 4px 0;\n    text-align: left;\n}\n`},437(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.styleMenu=void 0;const n=i(6199),o=i(5754);t.styleMenu=`\n.menu-container {\n    background-color: ${n.optionBackground};\n    border-radius: 4px;\n    border: 1px solid ${n.optionBorderColor};\n    box-shadow: 0 4px 16px ${n.menuShadowColor};\n    outline: none;\n    z-index: 2500;\n}\n\n.ide-dropdown{\n    position: relative;\n}\n\n.menu-container-position {\n    position: absolute;\n    right: 0px;\n    top: 30px;\n}\n\n.menu-container > .actions-container {\n    display: block;\n    margin: 0;\n    padding: 4px;\n    list-style: none;\n}\n\n.menu-container::-webkit-scrollbar {\n    width: 8px;\n}\n\n.menu-container::-webkit-scrollbar-thumb {\n    border-radius: 8px;  \n    background-color: ${n.scrollbarSliderBackground}; \n}  \n\n.menu-container > .actions-container .action-item {\n    display:block;\n    box-size: border-box;\n    width: auto;\n    user-select: none;\n    cursor: pointer;\n    color: ${n.primaryFontColor};\n    font-size: ${n.fontSize.buttonText};\n    line-height: 20px;\n    font-family: ${n.fontFamily};\n}\n\n.menu-container > .actions-container .action-item.disabled {\n    color: ${n.disabledFontColor};\n    cursor: not-allowed;\n}\n\n.menu-container > .actions-container .action-item.disabled  .action-menu-item {\n    color: ${n.disabledFontColor};\n    pointer-events:none;\n    padding: 4px;\n}\n\n.menu-container > .actions-container .action-item:not(.disabled) .action-menu-item:hover {\n    background-color: ${n.optionHoverBackground};\n    border-radius: 2px;\n}\n\n.menu-container > .actions-container .action-item  .action-menu-item {\n    display: flex;\n    justify-content: space-between;\n    align-items: center;\n    padding: 4px;\n    width: auto;\n    height: 20px;\n}\n\n.menu-container > .actions-container .action-item.collapse .action-item {\n    display: none;\n}\n\n.menu-container > .actions-container  .action-item  .action-menu-item.root-node {\n    justify-content: start;\n}\n\n.menu-container > .actions-container  .action-item  .action-menu-item.leaf-node {\n    justify-content: start;\n}\n\n.menu-container > .actions-container  .action-item  .action-menu-item.root-node .icon-container {\n    display: flex;\n    align-items: center;\n}\n\n.menu-container > .actions-container  .action-item  .action-menu-item.root-node .icon {\n    height: 16px;\n    line-height: 16px;\n}\n\n.menu-container > .actions-container  .action-item  .action-menu-item  .action-label {\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    flex-grow: 1;\n}\n\n.menu-container > .actions-container  .action-item.active  .action-menu-item {\n    background-color: ${n.optionHoverBackground};\n}\n\n.context-view-mask{\n    position: fixed;\n    cursor: initial;\n    left: 0px;\n    top: 0px;\n    width: 100%;\n    height: 100%;\n    z-index: -1;\n}\n\n.leaf-pre {\n    width: 16px;\n    flex-shrink: 0;\n}\n\n.action-menu-item .action-label.menu-icon {\n    display: inline-block;\n    box-sizing: border-box;\n    padding: 0 2em;\n    width: calc(100% - 18px);\n}\n.action-menu-item .action-label.menu-icon.remove-right-padding {\n    padding-right: 4px;\n}\n.action-menu-item .menu-icon.codicon {\n    padding: 5px;\n    position: absolute !important;\n}\n.action-menu-item .menu-icon.codicon.disabled:before,\n.action-menu-item .menu-icon.codicon.disabled:after {\n    color: ${n.disabledIconColor};\n}\n.action-menu-item .menu-icon.codicon.codicon-check {\n    font: normal normal normal 13px/1 codicon;\n}\n${o.CODICON};\n`},471(e){for(var t=[],i=0;i<256;++i)t[i]=(i+256).toString(16).substr(1);e.exports=function(e,i){var n=i||0,o=t;return[o[e[n++]],o[e[n++]],o[e[n++]],o[e[n++]],"-",o[e[n++]],o[e[n++]],"-",o[e[n++]],o[e[n++]],"-",o[e[n++]],o[e[n++]],"-",o[e[n++]],o[e[n++]],o[e[n++]],o[e[n++]],o[e[n++]],o[e[n++]]].join("")}},519(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.EventStore=t.DomListener=t.EventFlowAssister=t.EventEmitter=void 0,t.EventEmitter=class{addEventListener(e,t){this.listeners||(this.listeners=new Map);let i=this.listeners.get(e);i?i.push(t):(i=[],i.push(t),this.listeners.set(e,i))}removeEventListener(e,t){if(!this.listeners)return;const i=this.listeners.get(e);if(!i)return;let n=-1;for(let e=i.length-1;e>=0;e--)if(i[e]===t){n=e;break}n<0||i.splice(n,1)}asSubscriber(e){return t=>{this.on(e,t)}}on(e,t){this.addEventListener(e,t)}once(e,t){const i=(...n)=>{let o=!1;o||(this.removeEventListener(e,i),o=!0,t.call(this,...n))};this.addEventListener(e,i)}emit(e,...t){if(!this.listeners)return;const i=this.listeners.get(e);if(!i||0===i.length)return;const[...n]=i;for(let e=0;e<n.length;e++)try{n[e].call(this,...t)}catch(e){}}clear(e){if(this.listeners)return e?void this.listeners.delete(e):(this.listeners.clear(),void(this.listeners=void 0))}},t.EventFlowAssister={stop(e,t){var i,n;null===(i=e.preventDefault)||void 0===i||i.call(e),t&&(null===(n=e.stopPropagation)||void 0===n||n.call(e))}};class i{constructor({element:e,type:t,handler:i,options:n}){this._element=e,this._type=t,this._handler=i,this._options=n||!1,this._element.addEventListener(this._type,this._handler,this._options)}unbind(){var e;this._handler&&(null===(e=this._element)||void 0===e||e.removeEventListener(this._type,this._handler,this._options),this._element=null,this._handler=null)}}t.DomListener=i,t.EventStore=class{constructor(){this._store=new Map,this._id=0}get store(){return this._store}add(e,t,n,o){const s=new i({element:e,type:t,handler:n,options:o});return this._store.set(this._id++,s),this._id}removeById(e){var t;if(!this._store.has(e))return!1;null===(t=this._store.get(e))||void 0===t||t.unbind(),this._store.delete(e)}clear(){this._store.forEach(e=>{e.unbind()}),this._id=0,this._store.clear()}}},613(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.resolveOptions=void 0;const n=i(5731);t.resolveOptions=function(e){const t={lazyRender:void 0!==e.lazyRender&&e.lazyRender,className:void 0!==e.className?e.className:"",useShadows:void 0===e.useShadows||e.useShadows,handleMouseWheel:void 0===e.handleMouseWheel||e.handleMouseWheel,consumeMouseWheelIfScrollbarIsNeeded:void 0!==e.consumeMouseWheelIfScrollbarIsNeeded&&e.consumeMouseWheelIfScrollbarIsNeeded,alwaysConsumeMouseWheel:void 0!==e.alwaysConsumeMouseWheel&&e.alwaysConsumeMouseWheel,scrollYToX:void 0!==e.scrollYToX&&e.scrollYToX,mouseWheelScrollSensitivity:void 0!==e.mouseWheelScrollSensitivity?e.mouseWheelScrollSensitivity:1,fastScrollSensitivity:void 0!==e.fastScrollSensitivity?e.fastScrollSensitivity:5,scrollPredominantAxis:void 0===e.scrollPredominantAxis||e.scrollPredominantAxis,mouseWheelSmoothScroll:void 0===e.mouseWheelSmoothScroll||e.mouseWheelSmoothScroll,listenOnDomNode:void 0!==e.listenOnDomNode?e.listenOnDomNode:null,horizontal:void 0!==e.horizontal?e.horizontal:n.ScrollbarVisibility.Auto,horizontalScrollbarSize:void 0!==e.horizontalScrollbarSize?e.horizontalScrollbarSize:8,horizontalSliderSize:void 0!==e.horizontalSliderSize?e.horizontalSliderSize:8,vertical:void 0!==e.vertical?e.vertical:n.ScrollbarVisibility.Auto,verticalScrollbarSize:void 0!==e.verticalScrollbarSize?e.verticalScrollbarSize:8,verticalSliderSize:void 0!==e.verticalSliderSize?e.verticalSliderSize:8,scrollByPage:void 0!==e.scrollByPage&&e.scrollByPage};return t.horizontalSliderSize=Math.min(t.horizontalScrollbarSize,t.horizontalSliderSize),t.verticalSliderSize=Math.min(t.verticalScrollbarSize,t.verticalSliderSize),t}},845(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getDividerStyle=void 0;const n=i(6199);t.getDividerStyle=e=>` \n\n.ui-divider {\n    display: flex;\n    width: 100%;\n    min-width: 300px;\n    align-items: center;\n    text-align: center;\n    color: ${e?"var(--vscode-foreground)":n.labelColor};\n    user-select: none;\n}\n\n.ui-divider.expandable-divider {\n    cursor: pointer;\n}\n\n.ui-divider.common-divider {\n    cursor: default;\n}\n\n.ui-divider::after {\n    content: "";\n    border-top: 1px solid ${e?"var(--vscode-hrHoverWidget-border)":n.lineColor};\n    flex: 1;\n}\n\n.ui-divider.small {\n    font-size: ${n.commonFontSize.small};\n}\n\n.ui-divider.medium {\n    font-size: ${n.commonFontSize.medium};\n}\n\n.ui-divider.large {\n    font-size: ${n.commonFontSize.large};\n}\n\n.expandable-divider::before {\n    content: "";\n    display: block;\n    box-sizing: border-box;\n    width: 7px;\n    height: 7px;\n    border-bottom: 2px solid;\n    border-right: 2px solid;\n    border-radius: 1px;\n    transform: rotate(-45deg);\n    left: 4px;\n    top: 1px;\n    color: ${e?"var(--vscode-foreground)":n.labelColor};\n    margin: 0 8px -2px 0;\n}\n\n.expandable-divider.small::before {\n    margin: 0 8px -1px 0;\n}\n\n.ui-divider-active::before {\n    content: "";\n    display: block;\n    box-sizing: border-box;\n    width: 7px;\n    height: 7px;\n    border-bottom: 2px solid;\n    border-right: 2px solid;\n    border-radius: 1px;\n    transform: rotate(45deg);\n    left: 4px;\n    top: 2px;\n    color: ${e?"var(--vscode-foreground)":n.labelColor};\n    margin: 0 8px 2px 0;\n}\n\n.expandable-divider.small.ui-divider-active::before {\n    margin: 0 8px 2px 0;\n}\n\n.ui-divider:not(:empty)::after {\n    margin-top: 3px;\n    margin-left: 4px;\n}\n\n`},995(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getTabsStyle=void 0;const n=i(6199);t.getTabsStyle=e=>`\n\n.ui-tabs {\n    position: relative;\n    display: flex;\n    align-items: center;\n}\n\n.ui-tabs .sideRow-tabs {\n    flex-direction: row;\n    display: inline-flex;\n}\n.line-tabs, .editable-tabs {\n    flex-direction: row;\n}\n\n.side-tabs {\n    flex-direction: column;\n}\n\n:host .ui-tab.stretchable {\n    width: 100%;\n}\n\n.ui-tab {\n    height: 28px;\n    position: relative;\n    display: flex;\n    white-space: nowrap;\n    cursor: pointer;\n    color: ${n.primaryFontColor};\n    font-size: 12px;\n    line-height: 18px;\n    font-family: ${n.fontFamily};\n    box-sizing: border-box;\n    align-items: center;\n    text-align: center;\n}\n\n.ui-tab:focus {\n    outline: none;\n}\n\n.ui-tab-active {\n    font-family: ${n.fontFamily};\n    color: ${n.titleFontColor};\n}\n\n.ui-tab-label-container {\n    height: 100%;\n    margin-top: auto;\n    margin-bottom: auto;\n    white-space: nowrap;\n    flex: 1;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    align-items: center;\n    justify-content: center;\n    display: flex;\n    box-sizing: border-box;\n}\n\n.ui-tab-label {\n    overflow: hidden;\n    text-overflow: ellipsis;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.ui-tab-label-text {\n    overflow: hidden;\n    text-overflow: ellipsis;\n}\n\n.ui-tab-label-icon {\n    vertical-align: middle;\n    padding-right: 4px;\n}\n\n.ui-tab-label-url-icon::before {\n    content: ' ';\n    display: block;\n    width: 16px;\n    height: 16px;\n}\n\n.ui-tab-action {\n    margin-top: auto;\n    margin-bottom: auto;\n    text-align: center;\n    display: none;\n    color: ${e?"var(--vscode-button-foreground)":n.primaryFontColor};\n}\n\n.ui-tab:not(.ui-tab-disabled):hover .ui-tab-action {\n    display: flex;\n}\n\n\n.ui-tab-disabled {\n    color: ${n.disabledFontColor};\n    cursor: not-allowed !important;\n    opacity: 0.5;\n}\n\n.ui-tab-action-upper-right {\n    top: 0;\n    right: 0;\n    transform: translate(50%,-50%);\n    background: ${n.suspendedBackgroundColorCode};\n    border-radius: 50%;\n    z-index: 1\n}\n\n:host .line-tabs .ui-tab-badge {\n    margin-left: 4px;\n}\n\n.line-tabs .ui-tab {\n    margin-left: 20px;\n}\n\n.line-tabs .ui-tab-label-container {\n    border-bottom: 3px solid transparent;\n    padding-bottom: 8px;\n}\n\n.line-tabs .ui-tab-active .ui-tab-label-container {\n    font-size: 14px;\n    line-height: 20px;\n    border-color: ${n.primaryColor};\n}\n\n.line-tabs .ui-tab:not(.ui-tab-disabled):hover,\n.line-tabs .ui-tab:not(.ui-tab-disabled):focus {\n    color: ${n.titleFontColor};\n}\n\n:host .side-tabs .ui-tab-badge {\n    margin-left: auto;\n}\n\n.side-tabs .ui-tab {\n    border-radius: 2px;\n    width: 120px;\n    padding: 0 8px;\n}\n\n.side-tabs .ui-tab-label-container {\n    justify-content: flex-start;\n}\n\n.side-tabs .ui-tab-label {\n    justify-content: flex-start;\n    width: 100%;\n}\n\n.side-tabs .ui-tab-active {\n    color: ${e?"var(--vscode-button-foreground)":n.primaryFontColor};\n\tbackground: ${e?"var(--vscode-button-background)":n.tabActiveColor} !important;\n}\n\n.side-tabs > .ui-tab+.ui-tab {\n    margin-top: 4px;\n}\n\n.sideRow-tabs .ui-tab {\n    border-top: 1px solid ${n.tabBorderColor};\n    border-bottom: 1px solid ${n.tabBorderColor};\n    color: ${e?n.tabFontColor:""};\n    height: 28px;\n    font-size: 13px;\n    text-align: center;\n    line-height: 28px;\n    flex: 1;\n    box-sizing: border-box;\n}\n\n.sideRow-tabs .ui-tab.small {\n    height: 24px;\n    line-height: 24px;\n}\n.sideRow-tabs .ui-tab.minimal {\n    height: 20px;\n    line-height: 20px;\n}\n\n.sideRow-tabs .ui-tab .ui-tab-label-container {\n    display: inline-block;\n    margin: 0 auto;\n}\n\n.sideRow-tabs .ui-tab .ui-tab-label-container .ui-tab-label .ui-tab-label-text {\n    height: 25px;\n    line-height: 25px;\n}\n.sideRow-tabs .ui-tab .ui-tab-label-container .ui-tab-label .ui-tab-label-text.small {\n    height: 21px;\n    line-height: 21px;\n}\n.sideRow-tabs .ui-tab .ui-tab-label-container .ui-tab-label .ui-tab-label-text.minimal {\n    height: 17px;\n    line-height: 17px;\n}\n\n.sideRow-tabs .ui-tab:last-child {\n    border-radius: 0 4px 4px 0;\n    border-right: 1px solid ${n.tabBorderColor};\n}\n\n.sideRow-tabs .ui-tab:first-child {\n    border-radius: 4px 0 0 4px;\n    border-left: 1px solid ${n.tabBorderColor};\n}\n\n.sideRow-tabs .ui-tab-label-container {\n    justify-content: center;\n}\n\n.sideRow-tabs .ui-tab-active {\n    background: ${e?"var(--vscode-button-background)":n.tabActiveColor};\n    color: ${e?"var(--vscode-button-foreground)":""};\n}\n\n.editable-tabs .ui-tab-active {\n    color: #FFFFFF;\n    background: ${e?"var(--vscode-button-background)":n.primaryColorGradation} !important;\n}\n\n.editable-tabs .ui-tab {\n    height: 24px;\n    border-radius: 4px;\n    padding: 0 10px;\n    min-width: 40px;\n    max-width: 140px;\n    background: ${e?"var(--vscode-button-background)":n.tabsDefaultBackground};\n    margin: 0 8px 8px 0;\n}\n\n.editable-tabs .ui-tab-action {\n    position: absolute;\n}\n\n.editable-tabs .ui-tab-add {\n    height: 24px;\n    border-radius: 4px;\n    padding: 0 10px;\n    min-width: 40px;\n    max-width: 100px;\n    margin: 0 8px 8px 0;\n    cursor: pointer;\n    color: ${n.primaryFontColor};\n    box-sizing: border-box;\n    align-items: center;\n    justify-content: center;\n    display: flex;\n    background: none;\n    border: 1px dashed ${n.suspendedBackgroundColorCode};\n}\n\n.editable-tabs .ui-tab-add:hover {\n    border-color: ${e?"var(--vscode-button-background)":n.primaryColor};\n    color: ${e?"var(--vscode-button-foreground)":n.primaryColor};\n}\n\n.editable-tabs .ui-tab-add:focus {\n    outline: none;\n    border-color: ${e?"var(--vscode-button-background)":n.primaryColor};\n    color: ${e?"var(--vscode-button-background)":n.primaryColor};\n}\n\n.side-tabs .ui-tab:not(.ui-tab-disabled):hover,\n.side-tabs .ui-tab:not(.ui-tab-disabled):focus {\n    background: ${e?"var(--vscode-button-background)":n.suspendedBackgroundColorCode};\n    color: ${e?"#fff":""};\n}\n\n.editable-tabs .ui-tab:not(.ui-tab-disabled):hover,\n.editable-tabs .ui-tab:not(.ui-tab-disabled):focus {\n    background: ${e?"var(--vscode-button-background)":n.suspendedBackgroundColorCode};\n    color: ${e?"var(--vscode-button-foreground)":""};\n}\n\n.editable-tabs .ui-tab .codicon.codicon-close {\n    color: ${n.primaryFontColor};\n}\n\n.sideRow-tabs .ui-tab:not(.ui-tab-disabled):hover,\n.sideRow-tabs .ui-tab:not(.ui-tab-disabled):focus {\n    background: ${e?"var(--vscode-button-background)":n.suspendedBackgroundColorCode};\n    color: ${e?"var(--vscode-button-foreground)":""};\n}\n\n`},1003(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.MenuService=t.ContextMenuService=t.PREFIX=t.CloseScope=t.MenuSize=void 0;const n=i(4295),o=i(437),s=i(6199),r=i(308),a=i(79),l=i(8653),d=i(5754);var c,u;!function(e){e.MIDDLE="172px",e.SMALL="101px",e.AUTO="auto"}(c=t.MenuSize||(t.MenuSize={})),function(e){e.ALL="all",e.BLANK="blank"}(u=t.CloseScope||(t.CloseScope={})),t.PREFIX="ui-menu",t.ContextMenuService=class{constructor(e){this._menu=new h(e)}provider(){const e=this._menu;return{showContextMenu(t){e.showContextMenu(t),r.ContextView.showContextView(Object.assign(Object.assign({},t),{render:t=>{t.appendChild(e.element)}}))}}}get menu(){return this._menu}};class h{constructor(e){this.domId="menu_id_"+ ++h.InstanceCount,this.eventStore=new Set,this._options=e,this.isShowMenuIcon=null==e?void 0:e.isShowMenuIcon,this.menuSize=(null==e?void 0:e.menuSize)||c.MIDDLE,this.element=document.createElement("div"),this.contextMenuMask=document.createElement("div"),this.contextMenuMask.classList.add("context-view-mask"),this.MenuActionItems=[],this.isMouseOverMenuContainer=!1,this.activeIndex=-1,this._options?!(null==e?void 0:e.closeScope)&&(this._options.closeScope=u.ALL):this._options={closeScope:u.ALL}}showContextMenu(e){var t,i,o,s,r;switch(this.menuContainer&&this.element.contains(this.menuContainer)&&this.element.removeChild(this.menuContainer),this.menuContainer=document.createElement("div"),this.menuContainer.classList.add("menu-container"),(null===(t=this._options)||void 0===t?void 0:t.menuSize)!==c.AUTO&&(this.menuContainer.style.width=(null===(i=this._options)||void 0===i?void 0:i.menuSize)?null===(o=this._options)||void 0===o?void 0:o.menuSize:c.MIDDLE),this.actions=e.getActions(),this.menu=document.createElement("ul"),this.menu.classList.add("actions-container"),this.render(),(null===(s=this._options)||void 0===s?void 0:s.maxHeight)&&(this.menuContainer.style.maxHeight=this._options.maxHeight,this.menuContainer.style.overflowY="auto"),this.menuContainer.append(this.menu),this.element.append(b),this.element.append(this.menuContainer),this.menuContainer.tabIndex=-1,setTimeout(()=>{var e;null===(e=this.menuContainer)||void 0===e||e.focus()},0),this.eventStore.add({element:this.menuContainer,type:"blur",handler:()=>{var t,i;!1===this.isMouseOverMenuContainer?(this.hideMenu(),null===(t=e.onHide)||void 0===t||t.call(e,!0)):null===(i=this.menuContainer)||void 0===i||i.focus()}}),this.eventStore.add({element:this.menuContainer,type:"mouseenter",handler:e=>{this.isMouseOverMenuContainer=!0,e.stopPropagation()}}),this.eventStore.add({element:this.menuContainer,type:"mouseleave",handler:()=>{this.isMouseOverMenuContainer=!1}}),this.eventStore.add({element:this.menuContainer,type:"keydown",handler:t=>{var i,o,s,r;const a=null===(o=null===(i=this.MenuActionItems[this.activeIndex])||void 0===i?void 0:i.checkBoxItem)||void 0===o?void 0:o.isChecked;switch(t.key){case"ArrowDown":for(this.activeIndex++;this.activeIndex<this.MenuActionItems.length&&this.MenuActionItems[this.activeIndex].id===n.SEPARATOR_ID;)this.activeIndex++;this.activeIndex>=this.MenuActionItems.length&&(this.activeIndex=0);break;case"ArrowUp":for(this.activeIndex--;this.activeIndex>0&&this.MenuActionItems[this.activeIndex].id===n.SEPARATOR_ID;)this.activeIndex--;this.activeIndex<0&&(this.activeIndex=this.MenuActionItems.length-1);break;case" ":case"Enter":case"NumpadEnter":if(-1===this.activeIndex)return;null===(s=this.MenuActionItems[this.activeIndex].checkBoxItem)||void 0===s||s.setChecked(!a),this.actions&&this.actions[this.activeIndex].enabled&&!this.actions[this.activeIndex].customActionViewItemFlag&&this.actions[this.activeIndex].run(this);break;case"Escape":this.hideMenu(),null===(r=e.onHide)||void 0===r||r.call(e,!0)}this.activeMenuActionItem(this.activeIndex,this.MenuActionItems)}}),null===(r=this._options)||void 0===r?void 0:r.closeScope){case u.ALL:this.element.append(this.contextMenuMask),this.element.onclick=()=>{var t;null===(t=e.onHide)||void 0===t||t.call(e,!0),this.hideMenu()};break;case u.BLANK:this.element.append(this.contextMenuMask),this.contextMenuMask.onclick=()=>{var t;null===(t=e.onHide)||void 0===t||t.call(e,!0),this.hideMenu()}}this.addEvent()}activeMenuActionItem(e,t){for(let i=0;i<t.length;i++)i===e?t[i].element.classList.add("active"):t[i].element.classList.remove("active")}render(){if(this.actions&&this.menu)for(let e=0;e<this.actions.length;e++){const t=new p(this.actions[e],this);this.MenuActionItems.push(t),t.render(this.menu)}}hideMenu(){var e;this.MenuActionItems=[],null===(e=this.menuContainer)||void 0===e||e.remove(),this.element.contains(b)&&this.element.removeChild(b),this.menuContainer&&this.element.contains(this.menuContainer)&&this.element.removeChild(this.menuContainer),this.menu&&this.menu.remove(),this.removeEvent(),this.activeIndex=-1}getItemById(e){for(let t=0;t<this.MenuActionItems.length;t++)if(this.MenuActionItems[t].id===e)return this.MenuActionItems[t]}getItemAll(){return this.MenuActionItems}getItemHTMLElementById(e){var t;if(this.menu)for(let i=0;i<(null===(t=this.menu)||void 0===t?void 0:t.children.length);i++)if(this.menu.children[i].getAttribute("data-action-id")===e)return this.menu.children[i]}getItemHTMLElementAll(){if(this.menu)return this.menu.children}addEvent(){this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}removeEvent(){this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler))}dispose(){this.hideMenu()}}t.MenuService=h,h.InstanceCount=0;class p{constructor(e,t,i){var n;this.id=e.id;const o=document.createElement("li");if(this.element=o,o.classList.add("action-item"),o.setAttribute("data-action-id",e.id),!0===e.customActionViewItemFlag){const i=null==e?void 0:e.actionViewitem;i&&!i.element&&i.render();const s=null==i?void 0:i.label;if(i&&s){s.style.padding="unset",i.classList.add("action-menu-item");const r=s.getElementsByClassName("action-name")[0];if(r){const i=r;i.style.whiteSpace="nowrap",i.style.overflow="hidden",i.style.textOverflow="ellipsis",i.style.fontSize="13px",i.style.margin="unset",i.style.color="var(--ide-ui-primary-font-color)";const o=null===(n=t.menuContainer)||void 0===n?void 0:n.style.width,s=16,a=14;o&&(i.style.width=Number.parseInt(o)-s-(e.class?a:0)+"px")}return void o.append(i)}if(i)return void o.append(i)}this.createActionMenuItem(o,e,t,i)}createActionMenuItem(e,t,i,n){this.createItem(e,t,i,n)}createItem(e,t,i,o){const s=document.createElement("a");if(s.classList.add("action-menu-item"),e.append(s),i.isShowMenuIcon&&(this.iconElement=document.createElement("span"),this.iconElement.classList.add("menu-icon"),this.iconElement.classList.toggle("disabled",!t.enabled),s.append(this.iconElement),this.styleElement=document.createElement("style"),this.updateIcon(t),e.append(this.styleElement)),o&&o>0&&s.classList.add("leaf-node"),o)for(let e=0;e<o;e++){const e=document.createElement("span");e.classList.add("leaf-pre"),s.appendChild(e)}if(t.treeNodes&&this._renderTreeNode(t,s,e,i,o),void 0!==t.checkBoxOptions)this._renderCheckboxAction(t,s,i);else{const n=document.createElement("span");n.innerText=t.label,n.classList.add("action-label"),n.classList.toggle("menu-icon",!!i.isShowMenuIcon),n.classList.toggle("remove-right-padding",i.menuSize!==c.AUTO),e.title=t.tooltip,this._renderDisabled(t,e,s,n),e.id=t.id,s.append(n)}void 0!==t.badgeOptions&&t.id!==n.SEPARATOR_ID&&(this.badgeItem=new l.Badge(t.badgeOptions),this.badgeItem.style.display="inline-block",s.append(this.badgeItem)),s.addEventListener("click",()=>{i.actions&&!1!==t.enabled&&t.run(i)})}updateIcon(e){if(!this.iconElement||!this.styleElement)return;let t="",i="";e.checked?(this.iconElement.classList.add("codicon","codicon-check"),t="codicon codicon-check",i="check"):(this.iconElement.classList.remove("codicon","codicon-check"),e.class&&(t=e.class,i=t.split("codicon-")[1],this.iconElement.classList.add(...t.split(" ")),(0,d.isDoubleIcon)(i)&&this.iconElement.classList.add("double-icon"))),t&&i&&(0,d.addStyle)(this.styleElement,i)}_renderTreeNode(e,t,i,n,o){var s;if(!e.treeNodes)return;const r=document.createElement("span");r.classList.add("icon-container"),this.icon=new d.IDEIcon({id:"chevron-right"}),this.icon.classList.add("icon"),r.appendChild(this.icon),t.appendChild(r),t.classList.add("root-node"),i.classList.add("collapse"),o?o++:o=1;for(let t=0;t<(null===(s=e.treeNodes)||void 0===s?void 0:s.length);t++)new p(e.treeNodes[t],n,o).render(i);t.onclick=e=>{e.stopPropagation(),this.icon&&r.removeChild(this.icon),i.classList.toggle("collapse"),i.classList.contains("collapse")?(this.icon=new d.IDEIcon({id:"chevron-right"}),this.icon.classList.add("icon"),r.appendChild(this.icon)):(this.icon=new d.IDEIcon({id:"chevron-down"}),this.icon.classList.add("icon"),r.appendChild(this.icon))}}_renderCheckboxAction(e,t,i){var n,o;if(!e.checkBoxOptions)return;const s=e.checkBoxOptions;this.checkBoxItem=new a.CheckBox(s),this.checkBoxItem.style.display="inline-block";const r=(null===(n=e.badgeOptions)||void 0===n?void 0:n.maxWidth)||42;this.checkBoxItem.style.width=Number(null===(o=i.menuContainer)||void 0===o?void 0:o.style.width.replace(/[^\d]/g,""))-r+"px",t.append(this.checkBoxItem)}_renderDisabled(e,t,i,o){e.enabled||(t.classList.add("disabled"),e.id===n.SEPARATOR_ID&&(t.style.padding="4px",t.style.cursor="default",t.title="",i.style.height="0",i.style.padding="0",i.style.borderBottom=`1px solid ${s.disabledFontColor}`,o.innerText=""))}render(e){e.append(this.element)}}const b=document.createElement("style");b.appendChild(document.createTextNode(o.styleMenu))},1033(e,t,i){var n,o,s=i(5814),r=i(471),a=0,l=0;e.exports=function(e,t,i){var d=t&&i||0,c=t||[],u=(e=e||{}).node||n,h=void 0!==e.clockseq?e.clockseq:o;if(null==u||null==h){var p=s();null==u&&(u=n=[1|p[0],p[1],p[2],p[3],p[4],p[5]]),null==h&&(h=o=16383&(p[6]<<8|p[7]))}var b=void 0!==e.msecs?e.msecs:(new Date).getTime(),m=void 0!==e.nsecs?e.nsecs:l+1,g=b-a+(m-l)/1e4;if(g<0&&void 0===e.clockseq&&(h=h+1&16383),(g<0||b>a)&&void 0===e.nsecs&&(m=0),m>=1e4)throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");a=b,l=m,o=h;var v=(1e4*(268435455&(b+=122192928e5))+m)%4294967296;c[d++]=v>>>24&255,c[d++]=v>>>16&255,c[d++]=v>>>8&255,c[d++]=255&v;var f=b/4294967296*1e4&268435455;c[d++]=f>>>8&255,c[d++]=255&f,c[d++]=f>>>24&15|16,c[d++]=f>>>16&255,c[d++]=h>>>8|128,c[d++]=255&h;for(var w=0;w<6;++w)c[d+w]=u[w];return t||r(c)}},1062(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.InputBox=t.getTotalHeight=t.getTotalWidth=t.getDimension=t.StateType=t.MessageType=t.SearchIconPosition=t.InputBoxSize=t.InputBoxLayout=void 0;const n=i(519),o=i(9084),s=i(8565),r=i(5754),a=i(308),l=i(8784),d=i(5366),c=i(2925),u=i(6199),h=i(3145),p=i(4835),b=i(5354);var m,g,v,f,w;!function(e){e.VERTICAL="vertical",e.HORIZONTAL="horizontal"}(m=t.InputBoxLayout||(t.InputBoxLayout={})),function(e){e.SMALL="small",e.MEDIUM="medium",e.LARGE="large"}(g=t.InputBoxSize||(t.InputBoxSize={})),function(e){e.PREFIX="prefix",e.SUFFIX="suffix"}(v=t.SearchIconPosition||(t.SearchIconPosition={})),function(e){e[e.INFO=1]="INFO",e[e.WARNING=2]="WARNING",e[e.ERROR=3]="ERROR",e[e.SUCCESS=4]="SUCCESS"}(f=t.MessageType||(t.MessageType={})),function(e){e.IDLE="idle",e.OPEN="open",e.CLOSED="closed"}(w=t.StateType||(t.StateType={}));const x=["KeyA","KeyC","KeyV","KeyX","KeyZ","KeyY","Insert"],y=["ArrowLeft","ArrowRight"];function k(e,t){const i=document.defaultView.getComputedStyle(e,null);let n="0";return i&&(n=i.getPropertyValue(t)),parseFloat(n)||0}function C(e){return e.offsetWidth+k(e,"margin-left")+k(e,"margin-right")}function E(e){return e.offsetHeight+k(e,"margin-top")+k(e,"margin-bottom")}t.getDimension=k,t.getTotalWidth=C,t.getTotalHeight=E;class D extends o.BaseComponent{isCompletionEnabled(){return this._isCompletionEnabled}constructor(e){super(),this._viewId="ide-context-view-inputBox",this.message=null,this.placeholder="",this.tooltip="",this.ariaLabel="",this._state=w.IDLE,this.maxHeight=Number.POSITIVE_INFINITY,this.maxNumber=Number.MAX_SAFE_INTEGER,this.minNumber=0,this.previousInput="",this.mnemonicIndex=void 0,this.isFileType=!1,this.suggestion="",this.disposables=new Set,this._onDidChange=new n.EventEmitter,this.onDidChange=this._onDidChange.asSubscriber("onDidChange"),this._onPressEnter=new n.EventEmitter,this.onPressEnter=this._onPressEnter.asSubscriber("onPressEnter"),this._onDidHeightChange=new n.EventEmitter,this.onDidHeightChange=this._onDidHeightChange.asSubscriber("onDidHeightChange"),this._onDidFilesChange=new n.EventEmitter,this.onDidFilesChange=this._onDidFilesChange.asSubscriber("onDidFilesChange"),this._isCompletionEnabled=!0,this.dispose=()=>{this._onDidChange.clear(),this._onDidHeightChange.clear(),this._onPressEnter.clear(),this._onDidFilesChange.clear(),this.removeListener(),this.disposables.clear(),this._hideMessage(),this.disconnectedCallback(),this.toggleAutoIncrement()},this.options=e||Object.create(null),this.options.size?this._size=this.options.size||g.MEDIUM:this._size=this.getAttribute("size")||g.MEDIUM,this.element=(0,p.createElement)(`.ide-inputbox.${this.options.layout===m.VERTICAL?m.VERTICAL:m.HORIZONTAL}.${this._size}\n            `),this.wrapper=(0,p.createElement)(".input-wrapper"),this.suggestionContainer=(0,p.createElement)(".suggest-container");const t=document.createElement("style");if(t.appendChild(document.createTextNode((0,s.getInputBoxStyles)(b.ideChecker.isIDE))),this.input=this.createInput(),this.initialize(this.options),this.isFileType){const e=this.addIcon("symbol-folder",v.SUFFIX);e&&this.disposables.add({element:e,type:"click",handler:()=>this.selectFile()})}this.options.enableSearch&&!this.isFileType&&"textarea"!==this.input.type&&"inputNumber"!==this.input.type&&this.addIcon("search-save",this.options.searchIconPosition||v.PREFIX),null!==this.getAttribute("disabled")?this.setEnabled(!this.getAttribute("disabled")):"boolean"==typeof this.options.disabled&&this.setEnabled(!this.options.disabled),this.options.passwordVisibilityToggle&&"password"===this.options.type&&this.togglePasswordVisibility(),"inputNumber"===this.options.type&&(this.initInputNumberComponent(),this.toggleAutoIncrement()),this.setLabel(),this.addListener(),this.traverseListener(),this.wrapper.append(this.input,this.suggestionContainer),this.element.appendChild(this.wrapper),this.shadow.appendChild(t),this.shadow.appendChild(this.element),setTimeout(()=>this.updateMirror(),0)}initialize(e){this.message=null,this.placeholder=this.getAttribute("placeholder")||e.placeholder||"",this.tooltip=e.tooltip||"",e.validationOptions&&(this.validation=e.validationOptions.validation),this.getAttribute("mnemonicIndex")?this.mnemonicIndex=Number(this.getAttribute("mnemonicIndex")):void 0!==this.options.mnemonicIndex&&(this.mnemonicIndex=this.options.mnemonicIndex),this.placeholder&&!e.showPlaceholderOnFocus&&this.setPlaceHolder(this.placeholder),this.tooltip&&this.setTooltip(this.tooltip)}setLabel(){var e,t;if(this.getAttribute("label")){this._label=null!==(e=this.getAttribute("label"))&&void 0!==e?e:void 0;const t=this.getAttribute("labelWidth");this._labelWidth=t?parseInt(t):80;const i=this.getAttribute("required");this._required="true"===i,this._requiredSide=this.getAttribute("requiredSide")||v.PREFIX}else this.options.label&&(this._label=this.options.label,this._labelWidth=null!==(t=this.options.labelWidth)&&void 0!==t?t:80,this._required=this.options.required,this._requiredSide=this.options.requiredSide||v.PREFIX);this._label&&(this.label=this._label)}addListener(){this.disposables.add({element:this.input,type:"focus",handler:()=>this.element.classList.add("synthetic-focus")}),this.disposables.add({element:this.input,type:"blur",handler:()=>this.element.classList.remove("synthetic-focus")}),this.disposables.add({element:this.input,type:"input",handler:()=>this.onValueChange()}),this.disposables.add({element:this.input,type:"focus",handler:()=>this.onFocus()}),this.disposables.add({element:this.input,type:"blur",handler:()=>this.onBlur()}),this.disposables.add({element:this.input,type:"keydown",handler:e=>{var t,i,n;if("Enter"===e.key&&(this._onPressEnter.emit("onPressEnter",this.value),this.input.dispatchEvent(new CustomEvent("onPressEnter",{detail:this.value,composed:!0}))),"ArrowRight"===e.code){const e=null===(t=this.isSelectionAtEnd())||void 0===t||t;this.suggestion&&e&&(this.value=this.suggestion)}this.options.resolveCharKeyConflict&&function(e,t){const i=x.concat(t||[]);e.ctrlKey&&i.includes(e.code)&&!e.shiftKey&&e.stopPropagation()}(e,this.options.additionalCharKeys),this.options.resolveFnKeyConflict&&(i=e,n=this.options.additionalFnKeys,y.concat(n||[]).includes(i.code)&&i.stopPropagation()),this._isCompletionEnabled="Backspace"!==e.code}})}togglePasswordVisibility(){this._passwordVisibilityToggle=this.options.passwordVisibilityToggle;const e=this.addIcon("eye-closed",v.SUFFIX),t=this.addIcon("eye",v.SUFFIX);e.style.visibility=this._passwordVisibilityToggle?"visible":"hidden",t.style.visibility=this._passwordVisibilityToggle?"hidden":"visible",[e,t].forEach(i=>{null==i||i.addEventListener("click",i=>{this._passwordVisibilityToggle?(this._passwordVisibilityToggle=!1,this.input.type="text",e.style.visibility="hidden",t.style.visibility="visible"):(this._passwordVisibilityToggle=!0,this.input.type="password",e.style.visibility="visible",t.style.visibility="hidden")})})}processIconStyle(e,t){e.style.color=t?`${u.iconDisabledColor}`:`${u.iconEnabledColor}`,e.style.cursor=t?"not-allowed":"pointer"}initInputNumberComponent(){"number"==typeof this.options.maxNumber&&"number"==typeof this.options.minNumber&&this.options.maxNumber<this.options.minNumber&&(this.options.maxNumber=Number.MAX_SAFE_INTEGER,this.options.minNumber=0),this.maxNumber="number"==typeof this.options.maxNumber?this.options.maxNumber:Number.MAX_SAFE_INTEGER,this.minNumber="number"==typeof this.options.minNumber?this.options.minNumber:0,this.value="",this.previousInput=this.value,this.inputElement.classList.add("inputNumber"),this.inputElement.style.paddingRight="18px",this.iconChevronUp=this.addIcon("chevron-up",v.SUFFIX),this.iconChevronDown=this.addIcon("chevron-down",v.SUFFIX),this.iconChevronDown.classList.add("icon-chevron-down"),this.iconChevronUp.classList.add("icon-chevron-up"),this.iconChevronUp.id="icon-chevron-up",this.iconChevronDown.id="icon-chevron-down",this.processIconStyle(this.iconChevronUp,!0),this.processIconStyle(this.iconChevronDown,!0)}toggleAutoIncrement(){[this.iconChevronUp,this.iconChevronDown].forEach(e=>{null==e||e.addEventListener("click",()=>{if(!this.input.disabled){if(this.iconChevronUp&&this.iconChevronDown&&""===this.value)return this.processIconStyle(this.iconChevronUp,!0),void this.processIconStyle(this.iconChevronDown,!0);parseInt(this.value)<this.maxNumber&&"icon-chevron-up"===e.getAttribute("id")&&(this.value=(parseInt(this.value)+1).toString()),parseInt(this.value)>this.minNumber&&"icon-chevron-down"===e.getAttribute("id")&&(this.value=(parseInt(this.value)-1).toString()),this.iconChevronUp&&this.iconChevronDown&&(this.processIconStyle(this.iconChevronUp,parseInt(this.input.value)>=this.maxNumber),this.processIconStyle(this.iconChevronDown,parseInt(this.input.value)<=this.minNumber)),this.previousInput=this.value}})})}traverseListener(){this.disposables.forEach(e=>e.element.addEventListener(e.type,e.handler))}removeListener(){this.disposables.forEach(e=>e.element.removeEventListener(e.type,e.handler))}createInput(){this._type=this.getAttribute("type")||this.options.type||"text";const e="textarea"===this._type||"multiple"===this._type||this.options.flexibleHeight?"textarea":"input",t=document.createElement(e);return t.classList.add("input-control"),t.setAttribute("autocorrect","off"),t.setAttribute("autocapitalize","off"),t.setAttribute("spellcheck","false"),this._flexibleHeight=this.options.flexibleHeight,this._flexibleWidth=this.options.flexibleWidth,this._flexibleHeight||"textarea"===this._type?(this.maxHeight="number"==typeof this.options.flexibleMaxHeight?this.options.flexibleMaxHeight:Number.POSITIVE_INFINITY,this.options.flexibleMaxHeight&&this.options.flexibleMaxHeight<28&&(this.maxHeight=28),this.mirror=document.createElement("div"),this.mirror.classList.add("mirror"),this.mirror.innerText=" ",this.mirror.style.maxHeight=this.maxHeight+"px",this._flexibleWidth&&(t.setAttribute("wrap","off"),this.mirror.style.whiteSpace="pre",this.mirror.style.wordWrap="initial"),this.wrapper.appendChild(this.mirror)):"multiple"===this._type?this.setMultipleMode(t):(t.type=this.getAttribute("type")||this.options.type||"text","file"===t.type&&(this.isFileType=!0,t.type="text",t.readOnly=!0),t.setAttribute("wrap","off")),this.ariaLabel=this.getAttribute("ariaLabel")||this.options.ariaLabel||"",this.ariaLabel&&t.setAttribute("aria-label",this.ariaLabel),"date"===this.options.type&&t.setAttribute("max","9999-12-31"),t}setMultipleMode(e){e.style.height=`${this.options.multipleHeight||120}px`,this.wrapper.style.height=`${this.options.multipleHeight||120}px`,this.options.multipleMaxLength&&(this.limit=document.createElement("div"),this.limit.classList.add("limit"),this.limit.textContent=`0/${this.options.multipleMaxLength}`,this.element.appendChild(this.limit),e.maxLength=this.options.multipleMaxLength)}setLimit(){this.limit&&(this.limit.textContent=`${this.value.length}/${this.options.multipleMaxLength}`)}createLabelElement(e){this.labelEle=document.createElement("label");const t=document.createElement("span");t.title=e;const i=e;if(void 0!==this.mnemonicIndex&&i){const e=this.mnemonicIndex,n=(0,d.createUnderlineStr)(i,e);t.appendChild(n)}else t.textContent=i;this._labelWidth&&this.options.layout===m.HORIZONTAL&&(this.labelEle.style.width=`${this._labelWidth}px`),void 0!==this._required&&this.labelEle.classList.toggle("required",this._required),this._requiredSide&&this.labelEle.classList.toggle(this._requiredSide),this.labelEle.appendChild(t),this.element.insertBefore(this.labelEle,this.element.firstElementChild)}updateMnemonicIndex(e){var t,i,n;const o=null===(i=null===(t=this.labelEle)||void 0===t?void 0:t.firstElementChild)||void 0===i?void 0:i.textContent,s=(0,d.createUnderlineStr)(null!=o?o:"",e);(null===(n=this.labelEle)||void 0===n?void 0:n.firstElementChild)&&(this.labelEle.firstElementChild.textContent="",this.labelEle.firstElementChild.appendChild(s))}setRequired(e){this.labelEle&&"boolean"==typeof e&&(this.labelEle.classList.toggle("required",e),this.labelEle.classList.add(this.options.requiredSide||"prefix"))}onBlur(){this._hideMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder","")}onFocus(){this._showMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder",this.placeholder||"")}setPlaceHolder(e){this.placeholder=e,this.input.setAttribute("placeholder",e)}setTooltip(e){this.tooltip=e,this.removeListener(),e?this.disposables.add({element:this.input,type:"mouseenter",handler:()=>l.Hover.show({content:e,target:this.input,showPointer:!0,hoverPosition:l.HoverPosition.BELOW})}):this.disposables.forEach(e=>{e.element===this.input&&"mouseenter"===e.type&&this.disposables.delete(e)}),this.traverseListener()}setAriaLabel(e){this.ariaLabel=e,e?this.input.setAttribute("aria-label",this.ariaLabel):this.input.removeAttribute("aria-label")}set label(e){this.options.label=e,this.labelEle?this.labelEle.textContent=e:this.createLabelElement(e)}get label(){return this.options.label||""}set size(e){this.options.size=e,this._size=e,this.element.classList.toggle(e)}get size(){return this._size||g.MEDIUM}set flexibleWidth(e){this.options.flexibleWidth=e,this._flexibleWidth=e,e?(this.input.setAttribute("wrap","off"),this.mirror&&(this.mirror.style.whiteSpace="pre",this.mirror.style.wordWrap="initial")):(this.input.removeAttribute("wrap"),this.mirror&&(this.mirror.style.whiteSpace="normal",this.mirror.style.wordWrap="no-wrap"))}get flexibleWidth(){return!!this._flexibleWidth}set flexibleHeight(e){this.options.flexibleHeight=e,this._flexibleHeight=e,this.mirror&&(this.mirror.remove(),this.mirror=void 0),this.input.remove(),this.input=this.createInput(),this.addListener(),this.removeListener(),this.traverseListener(),this.wrapper.appendChild(this.input)}get flexibleHeight(){return!!this._flexibleHeight}getAriaLabel(){return this.ariaLabel}get inputElement(){return this.input}get labelElement(){return this.labelEle}get value(){return this.input.value}set value(e){this.input.value!==e&&(this.input.value=e||"",this.onValueChange())}get state(){return this._state}get height(){return"number"==typeof this.cachedHeight?this.cachedHeight:E(this.element)}focus(){this.input.focus()}blur(){this.input.blur()}hasFocus(){return document.activeElement===this}select(e=null){this.input.select(),e&&(this.input.setSelectionRange(e.start,e.end),e.end===this.input.value.length&&(this.input.scrollLeft=this.input.scrollWidth))}isSelectionAtEnd(){return this.input.selectionEnd===this.input.value.length&&this.input.selectionStart===this.input.selectionEnd}enable(){this.input.removeAttribute("disabled"),this.wrapper.classList.remove("disabled")}disable(){this.blur(),this.input.disabled=!0,this.input.setAttribute("disabled","true"),this.wrapper.classList.add("disabled"),this._hideMessage()}setEnabled(e){e?this.enable():this.disable()}get width(){return C(this.input)}set width(e){if(this.options.flexibleHeight&&this.options.flexibleWidth){let t=0;this.mirror&&(t=(parseFloat(this.mirror.style.paddingLeft||"")||0)+(parseFloat(this.mirror.style.paddingRight||"")||0)),this.input.style.width=e-t+"px",this.wrapper.style.width=e-t+"px"}else this.input.style.width=e+"px",this.wrapper.style.width=e+"px";this.mirror&&(this.mirror.style.width=e+"px")}get type(){return this.input.type}set paddingRight(e){this.input.style.width=`calc(100% - ${e}px)`,this.mirror&&(this.mirror.style.paddingRight=e+5+"px")}showMessage(e,t){this.message=e,this.removeAllStatusClass(),this.element.classList.add(this.classForType(e.type)),(this.hasFocus()||t)&&this._showMessage()}hideMessage(){this.message=null,this.removeAllStatusClass(),this.element.classList.add("idle"),this._hideMessage()}showStatusMessage(e){this.inputElement.setAttribute("aria-invalid","true"),this.message=e,this.removeAllStatusClass(),this.element.classList.add(this.classForType(e.type)),this._showStatusMessage()}hideStatusMessage(){this.message=null,this.removeAllStatusClass(),this.element.classList.add("idle"),this._hideStatusMessage()}setOnTypeSuggestion(e,t){if(this.suggestion=e,this.suggestionContainer.replaceChildren(),!this.value)return void this.suggestionContainer.replaceChildren();const i=this.value.slice(0,t),n=(0,c.escape)(e).slice(t),o=document.createElement("span");o.classList.add("suggestion-hidden"),o.textContent=i;const s=document.createElement("span");s.classList.add("suggestion-visible"),s.textContent=n,this.suggestionContainer.append(o,s),this.wrapper.classList.toggle("suggest",!!this.suggestion)}clearSuggestion(){this.suggestion="",this.suggestionContainer.replaceChildren()}removeAllStatusClass(){this.element.classList.remove("idle","info","warning","error","success")}isInputValid(){return!!this.validation&&!this.validation(this.value)}validate(){let e=null;return this.validation&&(e=this.validation(this.value),e?(this.inputElement.setAttribute("aria-invalid","true"),this.showMessage(e)):this.inputElement.hasAttribute("aria-invalid")&&(this.inputElement.removeAttribute("aria-invalid"),this.hideMessage(),this.hideStatusMessage())),null==e?void 0:e.type}validateInputNumber(){if(!this.validation)return;let e=this.value.replace(/[^\-\d]/g,"");e=e.replace(/-{2,}/g,"-"),e=e.replace(/(\d)-/g,"$1"),e=e.replace(/-(0+)/g,"0"),e=e.replace(/^0+(\d)/,"$1"),this.value=e,""!==this.value&&(parseInt(this.value)>this.maxNumber||parseInt(this.value)<this.minNumber||parseInt(this.value)!==parseFloat(this.value)&&"+"!==this.value&&"-"!==this.value)?this.value=this.previousInput:this.previousInput=this.value}iconForType(e){switch(e){case f.INFO:return"tip-small";case f.WARNING:return"warning-small";case f.ERROR:return"error-small";case f.SUCCESS:return"pass-filled-small";default:return"tip-small"}}classForType(e){return e?{1:"info",2:"warning",3:"error",4:"success"}[e]:"info"}_showMessage(){if(!this.message)return;if(this.options.enableStatus)return void this._showStatusMessage();this.isFileType||"inputNumber"===this.options.type||"password"===this.options.type||this.removeIcon(v.SUFFIX);const e={inline:!0},t=document.createElement("div"),i=()=>t.style.width=C(this.wrapper)+"px";setTimeout(()=>{a.ContextView.showContextView({getAnchor:()=>this.wrapper,render:n=>{if(!this.message)return null;i(),t.style.position="relative",t.style.top="5px";const o=document.createElement("style");o.appendChild(document.createTextNode((0,s.getMessageStyles)(b.ideChecker.isIDE)));const r=document.createElement("div");r.classList.add("message",this.classForType(this.message.type));const a={value:this.message.content,isTrusted:!0,supportThemeIcons:!1,supportHtml:!1},l=this.message.formatContent?(0,h.renderMarkdown)(a,e):function(e,t={}){const i=document.createElement(t.inline?"span":"div");return i.textContent=e,i}(this.message.content,e),d=document.createElement("i");d.classList.add("pointer"),r.append(d,l),t.append(o,r),n.appendChild(t)},onHide:()=>{this._state=w.CLOSED},layout:i,customViewId:this._viewId},this.options.parentContainer)},0),this._state=w.OPEN}_hideMessage(){"open"===this.state&&a.ContextView.hideContextView(this._viewId),this._state=w.IDLE}_showStatusMessage(){if(this._hideStatusMessage(),!this.message)return;if(this.wrapper.querySelector(".status-message"))return;const e=document.createElement("div");e.classList.add("status-message"),e.textContent=this.message.content,this.wrapper.appendChild(e),this.wrapper.classList.add("has-message"),this.isFileType||"textarea"===this.input.type||this.addIcon(this.iconForType(this.message.type),v.SUFFIX)}_hideStatusMessage(){const e=this.wrapper.querySelector(".status-message");e&&e.remove(),this.isFileType||"inputNumber"===this.options.type||"password"===this.options.type||this.removeIcon(v.SUFFIX),this.wrapper.classList.remove("has-message"),this._state=w.IDLE}onValueChange(){this._onDidChange.emit("onDidChange",this.value),this.input.dispatchEvent(new CustomEvent("onDidChange",{detail:this.value,composed:!0})),this.validate(),"inputNumber"===this.options.type&&this.validateInputNumber(),this.updateMirror(),this.input.classList.toggle("empty",!this.value),"open"===this.state&&a.ContextView.layout(),this.setLimit(),"inputNumber"===this.options.type&&this.iconChevronUp&&this.iconChevronDown&&(""===this.value?(this.processIconStyle(this.iconChevronUp,!0),this.processIconStyle(this.iconChevronDown,!0)):(this.processIconStyle(this.iconChevronUp,parseInt(this.value)>=this.maxNumber),this.processIconStyle(this.iconChevronDown,parseInt(this.value)<=this.minNumber)))}updateMirror(){if(!this.mirror)return;const e=this.value,t=10===e.charCodeAt(e.length-1)?" ":"";(e+t).replace(/\u000c/g,"")?this.mirror.textContent=e+t:this.mirror.innerText=" ",this.layout()}layout(){if(!this.mirror)return;const e=this.cachedContentHeight;this.cachedContentHeight=E(this.mirror),e!==this.cachedContentHeight&&(this.cachedHeight=Math.min(this.cachedContentHeight,this.maxHeight),this.input.style.height=this.cachedHeight+"px",this.wrapper.style.height=this.cachedHeight+"px",this._onDidHeightChange.emit("onDidHeightChange",this.cachedContentHeight),this.input.dispatchEvent(new CustomEvent("onDidHeightChange",{detail:this.cachedContentHeight,composed:!0})))}addIcon(e,t){const i=(0,r.renderIcon)({id:e},this.shadow),n=document.createElement("span");return n.classList.add(`${t}-icon`),n.appendChild(i),this.wrapper.classList.toggle(t),this.wrapper.appendChild(n),n}removeIcon(e){const t=this.wrapper.querySelector(`.${e}-icon`);t&&t.remove()}insertAtCursor(e){const t=this.inputElement,i=t.selectionStart,n=t.selectionEnd,o=t.value;null!==i&&null!==n&&(this.value=o.substr(0,i)+e+o.substr(n),t.setSelectionRange(i+1,i+1),this.layout())}selectFile(){const e=document.createElement("input");e.type="file",e.addEventListener("change",()=>{this._onDidFilesChange.emit("onDidFilesChange",e.files),this.input.dispatchEvent(new CustomEvent("onDidFilesChange",{detail:e.files,composed:!0})),this.value=Array.from(e.files||[]).map(e=>e.name).toString()}),e.click()}disconnectedCallback(){this._hideMessage(),this.message=null,super.disconnectedCallback()}}t.InputBox=D,(0,o.defineCustomElement)("ide-inputbox",D)},1609(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.IdeSelectOption=void 0;const n=i(4835),o=i(9084),s=i(519),r=i(79),a=i(3814),l=i(359),d=i(5354);class c extends o.BaseComponent{constructor(e,t,i=!1,o=!1){var r,a;super(),this.options=e,this.index=t,this.multiple=i,this.widthAdaptive=o,this.eventStore=new s.EventStore,this.eventEmit=new s.EventEmitter,this.onDidClick=this.eventEmit.asSubscriber("click"),this.onMouseenter=this.eventEmit.asSubscriber("mouseenter"),this._optionItem=Object.assign(Object.assign({},this.options),{value:null!==(a=null===(r=this.options)||void 0===r?void 0:r.value)&&void 0!==a?a:this.index,checkbox:this.multiple,index:this.index,instance:this}),this.multiple?this.renderCheckBox():this.render(),this.eventStore.add(this._domNode,"click",this.handleClick.bind(this)),this.eventStore.add(this._domNode,"mouseenter",this.handleMouseenter.bind(this)),this.eventStore.add(this._domNode,"mousedown",e=>s.EventFlowAssister.stop(e));const c=(0,n.createStyles)((0,l.getSelectOptionsStyle)(d.ideChecker.isIDE));this.shadow.append(c,this._domNode)}get disabled(){return!!this._optionItem.isDisabled}set disabled(e){this._optionItem.isDisabled=e,this._domNode.classList.toggle("ide-select-item-option-disabled",e)}get selected(){return!!this._optionItem.isSelected}set selected(e){var t;this.setAttribute("selected",e?"true":"false"),this._optionItem.isSelected=e,this.multiple?null===(t=this._checkboxNode)||void 0===t||t.setChecked(e):this._domNode.classList.toggle("ide-select-item-option-selected",e)}render(){const{text:e,detail:t,detailType:i,iconColor:o,decoratorRight:s,isDisabled:r,isSelected:a}=this._optionItem,l=(0,n.createElement)(".ide-select-item-option-defaults",{},null!=s?s:"");this._iconLabelNode=this.renderIconLabel(e,o);const d=(0,n.createElement)(".ide-select-item-option-content",{},this._iconLabelNode);if(t&&this.widthAdaptive||"divider"===i)if(t){let o;if(o=e?(0,n.createElement)(".ide-select-item-option-detail",{},t):(0,n.createElement)(".ide-select-item-option-detail-puredetail",{},t),d.append(o),"divider"===i){const e=(0,n.createElement)(".ide-select-item-option-detail-divider",{},"");d.append(e),d.style.width="100%"}}else if("divider"===i){const e=(0,n.createElement)(".ide-select-item-option-detail-divider-pureline",{},"");d.append(e),d.style.width="100%"}const c=(0,n.createElement)(".ide-select-item-option-container",{},d,l);this._domNode=(0,n.createElement)(".ide-select-item-option",{},c),this._domNode.setAttribute("title",`${this._iconLabelNode.label}  ${null!=t?t:""}`),r&&this._domNode.classList.add("ide-select-item-option-disabled"),a&&this._domNode.classList.add("ide-select-item-option-selected")}renderCheckBox(){var e,t;const{text:i,isDisabled:o=!1,isSelected:s=!1}=this._optionItem;this._domNode=(0,n.createElement)("div.ide-select-checkbox",{disabled:o?"true":"false"}),this._checkboxNode=new r.CheckBox({label:i,value:i,isEnabled:!o,isChecked:s}),null===(t=null===(e=this._checkboxNode.shadowRoot)||void 0===e?void 0:e.lastElementChild)||void 0===t||t.setAttribute("tabindex","-1");const a=(0,n.createElement)(".ide-select-checkbox-active-cover");this._domNode.setAttribute("title",i),this._domNode.append(this._checkboxNode,a)}renderIconLabel(e,t){return new a.HighlightedLabel({text:e,supportIcons:!0,iconColor:t})}handleClick(e){e.stopPropagation(),this.disabled||(this.multiple?this.selected=!this.selected:this.selected=!0,this.eventEmit.emit("click",this._optionItem))}handleMouseenter(e){e.stopPropagation(),this.setActive(!0),this.eventEmit.emit("mouseenter",this._optionItem)}getLabel(){return this._domNode.getAttribute("title")}getIconLabel(){return this._iconLabelNode}setActive(e){var t,i;Array.from(null!==(i=null===(t=this.parentElement)||void 0===t?void 0:t.children)&&void 0!==i?i:[]).forEach(e=>{var t,i,n,o;(null===(i=null===(t=e.shadowRoot)||void 0===t?void 0:t.lastElementChild)||void 0===i?void 0:i.classList.contains("active"))&&(null===(o=null===(n=e.shadowRoot)||void 0===n?void 0:n.lastElementChild)||void 0===o||o.classList.remove("active"))}),this.selected&&!this._optionItem.checkbox||this._domNode.classList.toggle("active",e)}getOption(){return this._optionItem}dispose(){this.eventStore.clear()}}t.IdeSelectOption=c,c.TAG_NAME="ide-select-option",c.HEIGHT=42,(0,o.defineCustomElement)(c.TAG_NAME,c)},1750(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.IconLabel=void 0;const n=i(9084),o=i(3814),s=i(2994),r=i(5754),a=i(8784),l=i(5366),d=i(4835);class c{constructor(e,t){this.container=e,this.supportIcons=t,this.singleLabel=void 0}setLabel(e,t,i){var n,s,r,a;if(this.options=t,"string"==typeof e){if(!this.singleLabel){this.container.innerText="",this.container.classList.remove("multiple");const e=document.createElement("a");e.classList.add("label-name"),e.setAttribute("id",null!==(s=null===(n=this.options)||void 0===n?void 0:n.domId)&&void 0!==s?s:""),this.singleLabel=new o.HighlightedLabel({supportIcons:this.supportIcons,iconColor:null===(r=this.options)||void 0===r?void 0:r.iconColor}),this.container.append(e,this.singleLabel)}this.singleLabel.set(e,null==t?void 0:t.matches,void 0,null==t?void 0:t.labelEscapeNewLines,i)}else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;const i=(null==t?void 0:t.separator)||"/",n=function(e,t,i){if(!(null==i?void 0:i.length))return;let n=0;return e.map(e=>{const o={start:n,end:n+e.length},s=i.map(e=>{return(t=o).start>=(i=e).end||i.start>=t.end?{start:0,end:0}:{start:Math.max(t.start,i.start),end:Math.min(t.end,i.end)};var t,i}).filter(e=>!(e.end-e.start<=0)).map(({start:e,end:t})=>({start:e-n,end:t-n}));return n=o.end+t.length,s})}(e,i,null==t?void 0:t.matches);for(let s=0;s<e.length;s++){const r=e[s],l=n?n[s]:void 0,d=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${s}`,c=document.createElement("a");c.classList.add("label-name"),c.setAttribute("id",null!=d?d:""),c.setAttribute("data-icon-label-count",String(e.length)),c.setAttribute("data-icon-label-index",String(s)),c.setAttribute("role","treeitem");const u=new o.HighlightedLabel({supportIcons:this.supportIcons,iconColor:null===(a=this.options)||void 0===a?void 0:a.iconColor});if(this.container.append(c,u),u.set(r,l,void 0,null==t?void 0:t.labelEscapeNewLines),s<e.length-1){const e=document.createElement("span");e.classList.add("label-separator"),e.append(...i),c.appendChild(e)}}}}get label(){var e;return this.singleLabel instanceof o.HighlightedLabel&&null!==(e=this.singleLabel.label)&&void 0!==e?e:""}}class u{constructor(e){this.parentNode=e,this.singleLabel=void 0}setLabel(e,t){var i,n;if(this.options=t,"string"==typeof e)this.singleLabel||(this.parentNode.innerText="",this.parentNode.classList.remove("multiple"),this.singleLabel=document.createElement("a"),this.singleLabel.classList.add("label-name"),this.singleLabel.setAttribute("id",null!==(n=null===(i=this.options)||void 0===i?void 0:i.domId)&&void 0!==n?n:""),this.parentNode.appendChild(this.singleLabel)),this.singleLabel.textContent=e;else{this.parentNode.innerText="",this.parentNode.classList.add("multiple"),this.singleLabel=void 0;for(let i=0;i<e.length;i++){const n=e[i],o=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${i}`,s=document.createElement("a");if(s.classList.add("label-name"),s.setAttribute("id",null!=o?o:""),s.setAttribute("data-icon-label-count",String(e.length)),s.setAttribute("data-icon-label-index",String(i)),s.setAttribute("role","treeitem"),s.append(n),this.parentNode.appendChild(s),i<e.length-1){const e=document.createElement("span");e.classList.add("label-separator");const i=(null==t?void 0:t.separator)||"/";e.append(...i),this.parentNode.appendChild(e)}}}}get label(){var e,t;return null!==(t=null===(e=this.singleLabel)||void 0===e?void 0:e.textContent)&&void 0!==t?t:""}}class h{constructor(e){this._element=e}get element(){return this._element}set textContent(e){this.disposed||e===this.labelTextContent||(this.labelTextContent=e,this._element.textContent=e)}set className(e){this.disposed||e===this.labelClassName||(this.labelClassName=e,this._element.className=e)}set empty(e){this.disposed||e===this.labelIsEmpty||(this.labelIsEmpty=e,this._element.style.marginLeft=e?"0":"")}dispose(){this.disposed=!0}}class p extends n.BaseComponent{constructor(e){var t,i;super(),this.customHovers=new Map,this.dispose=()=>{var e;this.customHovers.forEach(e=>{e.dispose()}),this.domNode.dispose(),this.descriptionContainer.dispose(),null===(e=this.labelDescriptionNode)||void 0===e||e.dispose(),this.createLabelDescriptionNode instanceof h&&this.createLabelDescriptionNode.dispose()},this.addStyleSheet(),this.initOptions(e||{}),this.checkHighlightsType(this.options.matches||[]),this.checkHighlightsType(this.options.descriptionMatches||[]),this.createDom();const n={iconColor:this.options.iconColor,title:this.options.title,descriptionTitle:this.options.descriptionTitle,extraClasses:this.options.extraClasses,isItalic:this.options.isItalic,isStrikethrough:this.options.isStrikethrough,matches:this.options.matches,labelEscapeNewLines:this.options.labelEscapeNewLines,descriptionMatches:this.options.descriptionMatches,separator:this.options.separator,domId:this.options.domId};this.setAttribute("style","display: inline-flex;"),this.text=null!==(t=this.options.label)&&void 0!==t?t:"",this.setLabel(null!==(i=this.options.label)&&void 0!==i?i:"",this.options.descriptionTitle,n)}addStyleSheet(){const e=document.createElement("style");e.appendChild(document.createTextNode(s.IconLabelStyle)),this.shadow.appendChild(e)}initOptions(e){const t=e||{},{supportHighlights:i=this.hasAttribute("supportHighlights"),supportDescriptionHighlights:n=this.hasAttribute("supportDescriptionHighlights"),supportIcons:o=this.hasAttribute("supportIcons"),label:s=this.getAttribute("label")||"",iconColor:r=this.getAttribute("iconColor")||"",title:a=this.getAttribute("title")||"",descriptionTitle:l=this.getAttribute("descriptionTitle")||"",extraClasses:d=[],isItalic:c=this.hasAttribute("isItalic"),isStrikethrough:u=this.hasAttribute("isStrikethrough"),matches:h=[],labelEscapeNewLines:p=this.hasAttribute("labelEscapeNewLines"),descriptionMatches:b=[],separator:m=this.getAttribute("separator")||"",domId:g=this.getAttribute("domId")||""}=t;e.label=s,this.options=Object.assign({supportHighlights:i,supportDescriptionHighlights:n,supportIcons:o,iconColor:r,title:a,descriptionTitle:l,extraClasses:d,isItalic:c,isStrikethrough:u,matches:h,labelEscapeNewLines:p,descriptionMatches:b,separator:m,domId:g},e)}checkHighlightsType(e){e&&(0,l.checkHighlightsType)(e)}createDom(){var e,t;const i=document.createElement("div");i.classList.add("ide-icon-label"),this.domNode=new h(i),this.iconLabelContainer=document.createElement("div"),this.iconLabelContainer.classList.add("ide-icon-label-container"),this.domNode.element.appendChild(this.iconLabelContainer);const n=(0,d.createElement)("span.ide-icon-name-container"),o=(0,d.createElement)("span.ide-icon-description-container");this.descriptionContainer=new h(o),this.iconLabelContainer.append(n,this.descriptionContainer.element),this.shadow.appendChild(this.domNode.element),(null===(e=this.options)||void 0===e?void 0:e.supportHighlights)||(null===(t=this.options)||void 0===t?void 0:t.supportIcons)?this.nameNode=new c(n,!!this.options.supportIcons):this.nameNode=new u(n),this.descriptionHighLighted()}descriptionHighLighted(){var e;const t=null===(e=this.options)||void 0===e?void 0:e.supportDescriptionHighlights;this.createLabelDescriptionNode=()=>{const e=document.createElement("span");e.classList.add("label-description");const i=new o.HighlightedLabel({supportIcons:!!this.options.supportIcons});return t?this.descriptionContainer.element.append(e,i):this.descriptionContainer.element.appendChild(e),this.descriptionContainer.element.style.paddingLeft="5px",t?i:this.descriptionContainer}}setupHover(e,t){var i,n;const o=this.customHovers.get(e);if(o&&(o.dispose(),this.customHovers.delete(e)),!t||""===t)return void e.removeAttribute("title");const s=(null===(i=this.options)||void 0===i?void 0:i.getHoverOptions)?Object.assign({content:t,target:e},null===(n=this.options)||void 0===n?void 0:n.getHoverOptions()):{content:t,target:e},r=a.Hover.setupIconLabelHover(s);r&&this.customHovers.set(e,r)}get element(){return this.domNode.element}get label(){return"string"==typeof this.text?this.nameNode.label:""}get iconlabel(){return this.text}setLabel(e,t,i,n){this.text=e;const s=["ide-icon-label"];if(i){if(i.extraClasses){this.className=i.extraClasses.join(" ");const e=this.shadow.querySelector("style");null==e||e.appendChild(document.createTextNode((0,r.getIconStyle)(i.extraClasses))),s.push(...i.extraClasses)}i.isItalic&&s.push("italic"),i.isStrikethrough&&s.push("strikethrough")}this.domNode.className=s.join(" "),this.setupHover((null==i?void 0:i.descriptionTitle)?this.iconLabelContainer:this.element,null==i?void 0:i.title),this.nameNode.setLabel(e,i,n),(t||this.labelDescriptionNode)&&(this.labelDescriptionNode||(this.labelDescriptionNode=this.createLabelDescriptionNode()),this.labelDescriptionNode instanceof o.HighlightedLabel?(this.labelDescriptionNode.set(t||"",i?i.descriptionMatches:void 0),this.setupHover(this.labelDescriptionNode.element,null==i?void 0:i.descriptionTitle)):(this.labelDescriptionNode.textContent=t||"",this.setupHover(this.labelDescriptionNode.element,(null==i?void 0:i.descriptionTitle)||""),this.labelDescriptionNode.empty=!t))}setFontFamily(e){e&&Array.from(this.iconLabelContainer.getElementsByTagName("ide-highlighted-label")).forEach(t=>{t.setFontFamily(e)})}}t.IconLabel=p,(0,n.defineCustomElement)("ide-icon-label",p)},1854(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Radio=t.PREFIX=void 0;const n=i(519),o=i(9084),s=i(8093),r=i(5754),a=i(4835),l=i(8784),d=i(5366),c=i(5354);t.PREFIX="ide-radio";class u extends o.BaseComponent{constructor(e){super(),this.domId="radio_id_"+u.InstanceCount++,this.uiPrefix=t.PREFIX,this.clickEmitter=new n.EventEmitter,this.onChange=this.clickEmitter.asSubscriber("onDidChange"),this.eventStore=new Set,this.radioState=this.getOptions(e,this.getFilterAttributesOptions()),this.radioWrapper=document.createElement("div"),this.radioWrapper.classList.add(`${this.uiPrefix}-wrapper`),this.symbol=document.createElement("div"),this.symbol.classList.add("ide-radio-solid-circle"),this.radio=document.createElement("div"),this.radio.id=this.domId,this.radio.classList.add(`${this.uiPrefix}`),this.labelElement=document.createElement("label"),this.labelElement.setAttribute("for",this.radio.id),this.labelElement.classList.add(`${this.uiPrefix}-label`),this.indicatorIcon=document.createElement("span"),this.descriptionElement=document.createElement("label"),this.descriptionElement.classList.add(`${this.uiPrefix}-description`),this.render()}getOptions(e,t){const i=Object.assign(Object.assign({},t),e);for(const e in i)void 0===i[e]&&(i[e]="isEnabled"===e||"isChecked"!==e&&"");return i}getFilterAttributesOptions(){return{label:(0,d.filterAttribute)(this.getAttribute("label")),secondaryLabel:(0,d.filterAttribute)(this.getAttribute("secondaryLabel")),mnemonicIndex:Number((0,d.filterAttribute)(this.getAttribute("mnemonicIndex"))),value:(0,d.filterAttribute)(this.getAttribute("value")),indicatorIcon:(0,d.filterAttribute)(this.getAttribute("indicatorIcon")),isChecked:(0,d.filterAttribute)(this.getAttribute("checked")),title:(0,d.filterAttribute)(this.getAttribute("title")),isEnabled:(0,d.filterAttribute)(this.getAttribute("enabled")),description:(0,d.filterAttribute)(this.getAttribute("description")),descriptionTitle:(0,d.filterAttribute)(this.getAttribute("descriptionTitle"))}}addEvent(){this.eventStore.add({element:this.radioWrapper,type:"click",handler:()=>{this.isEnabled&&!this.radio.getAttribute("checked")&&this.clickEmitter.emit("onDidChange",this.radioState)}}),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}render(){var e,t;(0,d.updateSpacingFromAttribute)(this.parentElement,this.style),this.radioWrapper.title=this.radioState.title,this.hover&&this.hover.dispose(),this.hover=l.Hover.setupIconLabelHover({content:"string"==typeof this.radioState.title?this.radioState.title:null!==(e=this.labelElement.innerText)&&void 0!==e?e:"",target:this.radioWrapper,hoverPosition:l.HoverPosition.BELOW,showPointer:!1}),this.radioWrapper.removeAttribute("title"),this.shadow.host.removeAttribute("title"),this.hover=l.Hover.setupIconLabelHover({content:"string"==typeof this.radioState.descriptionTitle?this.radioState.descriptionTitle:null!==(t=this.descriptionElement.innerText)&&void 0!==t?t:"",target:this.descriptionElement,hoverPosition:l.HoverPosition.BELOW,showPointer:!1}),this.descriptionElement.removeAttribute("descriptionTitle"),this.shadow.host.removeAttribute("descriptionTitle"),this.radioWrapper.setAttribute("value",this.radioState.value),this.radioWrapper.setAttribute("enabled",this.radioState.isEnabled?"true":"false"),this.radioWrapper.setAttribute("tabindex",this.radioState.isEnabled?"0":"-1"),this.addEvent(),this.updateSymbol();const i=this.radioState.label;if(void 0===this.radioState.mnemonicIndex||isNaN(this.mnemonicIndex))this.labelElement.innerText=i;else{const e=this.radioState.mnemonicIndex,t=(0,d.createUnderlineStr)(i,e);this.labelElement.textContent="",this.labelElement.appendChild(t)}this.renderWidgets(),this.radioState.indicatorIcon&&!this.radioState.isWidgets&&(this.indicatorIcon.appendChild((0,r.renderIcon)({id:`${this.radioState.indicatorIcon}`},this.shadow)),this.labelElement.appendChild(this.indicatorIcon)),this.descriptionElement.innerText=this.radioState.description||"",this.radioWrapper.appendChild(this.descriptionElement),this.radio.appendChild(this.symbol);const n=document.createElement("style");n.appendChild(document.createTextNode((0,s.getRadioStyle)(c.ideChecker.isIDE))),this.shadow.append(n,this.radioWrapper)}renderWidgets(){if(this.radioState.isWidgets){this.radioWrapper.classList.add(`${this.uiPrefix}-wrapper`,`${this.getAttribute("widgets")||this.radioState.isWidgets}`);const e=document.createElement("div");e.classList.add(`${this.uiPrefix}-left-container`);const t=document.createElement("div");t.classList.add(`${this.uiPrefix}-right-container`);const i=document.createElement("label");i.innerText=this.radioState.secondaryLabel,i.setAttribute("for",this.radio.id),i.classList.add(`${this.uiPrefix}-secondary-label`),e.append(this.labelElement,i),t.appendChild(this.radio),this.radioWrapper.append(e,t)}else this.radioWrapper.append(this.radio,this.labelElement)}updateSymbol(){if(this.isChecked)this.radio.setAttribute("checked","true"),this.symbol.style.visibility="visible",this.symbol.style.display="flex",this.radioState.isWidgets&&(this.radioWrapper.classList.toggle(`${this.uiPrefix}-wrapper`,!1),this.radioWrapper.classList.toggle(`${this.uiPrefix}-wrapper-active`,!0));else{if(this.symbol.style.visibility="hidden",!this.radioState.isGroup)return;this.radio.removeAttribute("checked"),this.symbol.style.display="inherit",this.radioState.isWidgets&&(this.radioWrapper.classList.toggle(`${this.uiPrefix}-wrapper`,!0),this.radioWrapper.classList.toggle(`${this.uiPrefix}-wrapper-active`,!1))}}setChecked(e){this.radioState.isChecked=e,this.updateSymbol()}resetChecked(){this.radioState.isChecked=!1,this.updateSymbol()}setEnabled(e){this.radioState.isEnabled=e,this.radioWrapper.setAttribute("enabled",this.radioState.isEnabled?"true":"false")}focus(){this.radio.focus()}hasFocus(){return this.radio===document.activeElement}get options(){return this.radioState}set label(e){this.labelElement.innerText=e,this.radioState.label=e}get label(){return this.radioState.label}set secondaryLabel(e){this.labelElement.innerText=e,this.radioState.secondaryLabel=e}get secondaryLabel(){return this.radioState.secondaryLabel}set mnemonicIndex(e){this.radioState.mnemonicIndex=e}get mnemonicIndex(){return this.radioState.mnemonicIndex}get isChecked(){return this.radioState.isChecked}get isEnabled(){return this.radioState.isEnabled}get value(){return this.radioState.value}set title(e){this.radioState.title=e,this.radioWrapper.title=e}get title(){return this.radioState.title}set descriptionTitle(e){this.radioState.descriptionTitle=e}get descriptionTitle(){return this.radioState.descriptionTitle}set description(e){this.labelElement.innerText=e,this.radioState.description=e}get description(){return this.radioState.description}set icon(e){this.radioState.indicatorIcon=e,(0,a.clearNode)(this.indicatorIcon),e&&this.indicatorIcon.appendChild((0,r.renderIcon)({id:`${this.radioState.indicatorIcon}`},this.shadow))}get icon(){return this.radioState.indicatorIcon}dispose(){this.disconnectedCallback(),this.clickEmitter.clear(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler))}}t.Radio=u,u.InstanceCount=0,(0,o.defineCustomElement)("ide-radio",u)},1922(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Scrollbar=void 0;const n=i(2842),o=i(9165),s=i(3750),r=i(5731),a=i(9084),l=i(4945);class d extends a.BaseComponent{constructor(e,t,i,o){super(),this.disposables=new Set,this._host=i,this._scrollable=e,this._isHorizontal="horizontal"===o,this._isVertical="vertical"===o,this._lazyRender=t.lazyRender,this._scrollByPage=t.scrollByPage,this._scrollbarState=this._createScrollbarState(t),this._visibilityController=this._createVisibilityController(t,o),this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._pointerMoveMonitor=new n.GlobalPointerMoveMonitor,this._shouldRender=!0,this.domNode=document.createElement("div"),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this._visibilityController.setDomNode(this.domNode),this.domNode.style.position="absolute",this.disposables.add({element:this.domNode,type:"pointerdown",handler:e=>this._domNodePointerDown(e)}),this._isHorizontal?this._createSlider(Math.floor((t.horizontalScrollbarSize-t.horizontalSliderSize)/2),0,void 0,8):this._createSlider(0,Math.floor((t.verticalScrollbarSize-t.verticalSliderSize)/2),8,void 0),this.disposables.forEach(e=>e.element.addEventListener(e.type,e.handler))}_createVisibilityController(e,t){return new s.ScrollbarVisibilityController(this._isHorizontal?e.horizontal:e.vertical,"visible scrollbar "+t,"invisible scrollbar "+t)}_createScrollbarState(e){const t=this._scrollable.getScrollDimensions(),i=this._scrollable.getCurrentScrollPosition();return this._isHorizontal?new o.ScrollbarState(e.horizontal===r.ScrollbarVisibility.Hidden?0:e.horizontalScrollbarSize,e.vertical===r.ScrollbarVisibility.Hidden?0:e.verticalScrollbarSize,t.width,t.scrollWidth,i.scrollLeft):new o.ScrollbarState(e.vertical===r.ScrollbarVisibility.Hidden?0:e.verticalScrollbarSize,0,t.height,t.scrollHeight,i.scrollTop)}dispose(){this.disposables.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.disposables.clear()}_createSlider(e,t,i,n){this.slider=document.createElement("div"),this.slider.classList.add("slider"),this.slider.style.position="absolute",this.slider.style.top=`${e}px`,this.slider.style.left=`${t}px`,"number"==typeof i&&(this.slider.style.width=`${i}px`,this.slider.style.borderRadius=`${i}px`),"number"==typeof n&&(this.slider.style.height=`${n}px`,this.slider.style.borderRadius=`${n}px`),this.slider.style.transform="translate3d(0px, 0px, 0px)",this.domNode.style.contain="strict",this.domNode.appendChild(this.slider),this.disposables.add({element:this.slider,type:"pointerdown",handler:e=>{0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}}),this.disposables.add({element:this.slider,type:"click",handler:e=>{0===e.button&&e.stopPropagation()}});const o=document.createElement("style");o.appendChild(document.createTextNode(l.styles)),this.shadow.appendChild(o),this.shadow.appendChild(this.domNode)}_onElementSize(e){return this._scrollbarState.setVisibleSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollSize(e){return this._scrollbarState.setScrollSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollPosition(e){return this._scrollbarState.setScrollPosition(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}beginReveal(){this._visibilityController.setShouldBeVisible(!0)}beginHide(){this._visibilityController.setShouldBeVisible(!1)}render(){this._shouldRender&&(this._shouldRender=!1,this._renderDomNode(this._scrollbarState.getRectangleLargeSize(),this._scrollbarState.getRectangleSmallSize()),this._updateSlider(this._scrollbarState.getSliderSize(),this._scrollbarState.getSliderPosition()))}_domNodePointerDown(e){e.target===this.domNode&&this._onPointerDown(e)}delegatePointerDown(e){var t;const i=null===(t=this.domNode.getClientRects()[0])||void 0===t?void 0:t.top,n=i+this._scrollbarState.getSliderPosition(),o=i+this._scrollbarState.getSliderPosition()+this._scrollbarState.getSliderSize(),s=this._sliderPointerPosition(e);n<=s&&s<=o?0===e.button&&(e.preventDefault(),this._sliderPointerDown(e)):this._onPointerDown(e)}_onPointerDown(e){let t,i;if(e.target===this.domNode&&"number"==typeof e.offsetX&&"number"==typeof e.offsetY)t=e.offsetX,i=e.offsetY;else{const n=this.domNode.getBoundingClientRect();t=e.pageX-(n.left+("number"==typeof window.scrollX?window.scrollX:document.body.scrollLeft+document.documentElement.scrollLeft)),i=e.pageY-(n.top+("number"==typeof window.scrollY?window.scrollY:document.body.scrollTop+document.documentElement.scrollTop))}const n=this._pointerDownRelativePosition(t,i);this._setDesiredScrollPositionNow(this._scrollByPage?this._scrollbarState.getDesiredScrollPositionFromOffsetPaged(n):this._scrollbarState.getDesiredScrollPositionFromOffset(n)),0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}_sliderPointerDown(e){if(!(e.target&&e.target instanceof Element))return;const t=this._sliderPointerPosition(e),i=this._sliderOrthogonalPointerPosition(e),n=this._scrollbarState.clone();this.slider.classList.toggle("active",!0),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,e=>{const o=this._sliderOrthogonalPointerPosition(e);if(Math.abs(o-i)>140)return void this._setDesiredScrollPositionNow(n.getScrollPosition());const s=this._sliderPointerPosition(e)-t;this._setDesiredScrollPositionNow(n.getDesiredScrollPositionFromDelta(s))},()=>{this.slider.classList.toggle("active",!1),this._host.onDragEnd()}),this._host.onDragStart()}_setDesiredScrollPositionNow(e){const t={};this.writeScrollPosition(t,e),this._scrollable.setScrollPositionNow(t)}updateScrollbarSize(e){this._updateScrollbarSize(e),this._scrollbarState.setScrollbarSize(e),this._shouldRender=!0,this._lazyRender||this.render()}isNeeded(){return this._scrollbarState.isNeeded()}_renderDomNode(e,t){const i=`${e}px`,n=`${t}px`;this._isHorizontal?(this.domNode.style.width=i,this.domNode.style.height=n,this.domNode.style.left="0px",this.domNode.style.bottom="0px"):this._isVertical&&(this.domNode.style.width=n,this.domNode.style.height=i,this.domNode.style.right="0px",this.domNode.style.top="0px")}_updateSlider(e,t){const i=`${e}px`,n=`${t}px`;this._isHorizontal?(this.slider.style.width=i,this.slider.style.left=n):this._isVertical&&(this.slider.style.height=i,this.slider.style.top=n)}_pointerDownRelativePosition(e,t){return this._isHorizontal?e:t}_sliderPointerPosition(e){return this._isHorizontal?e.pageX:e.pageY}_sliderOrthogonalPointerPosition(e){return this._isHorizontal?e.pageY:e.pageX}_updateScrollbarSize(e){const t=`${e}px`;this._isHorizontal?this.slider.style.height=t:this._isVertical&&(this.slider.style.width=t)}writeScrollPosition(e,t){this._isHorizontal?e.scrollLeft=t:this._isVertical&&(e.scrollTop=t)}onDidScroll(e){return this._isHorizontal?this._onElementSize(e.width)||this._onElementScrollPosition(e.scrollLeft)||this._onElementScrollSize(e.scrollWidth)||this._shouldRender:this._onElementSize(e.height)||this._onElementScrollPosition(e.scrollTop)||this._onElementScrollSize(e.scrollHeight)||this._shouldRender}updateOptions(e){this._isHorizontal?(this.updateScrollbarSize(e.horizontal===r.ScrollbarVisibility.Hidden?0:e.horizontalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(e.vertical===r.ScrollbarVisibility.Hidden?0:e.verticalScrollbarSize),this._visibilityController.setVisibility(e.horizontal)):this._isVertical&&(this.updateScrollbarSize(e.vertical===r.ScrollbarVisibility.Hidden?0:e.verticalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(0),this._visibilityController.setVisibility(e.vertical)),this._scrollByPage=e.scrollByPage}}t.Scrollbar=d,(0,a.defineCustomElement)("ide-scrollbar",d)},2087(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Divider=t.WordsSize=t.DividerType=void 0;const n=i(519),o=i(9084),s=i(845),r=i(5354);var a,l;!function(e){e.EXPANDABLE="expandable",e.COMMON="common"}(a=t.DividerType||(t.DividerType={})),(l=t.WordsSize||(t.WordsSize={})).SMALL="small",l.MEDIUM="medium",l.LARGE="large";class d extends o.BaseComponent{constructor(e){var t;super(),this._changeDividerDropdownEmitter=new n.EventEmitter,this.onDidChangeDividerDropdown=this._changeDividerDropdownEmitter.asSubscriber("onDidChangeDividerDropdown"),this._emitChangeDividerDropdown=e=>{this._changeDividerDropdownEmitter.emit("onDidChangeDividerDropdown",e)},this.selectDivider=()=>{this._divider.classList.contains("ui-divider-active")?(this._emitChangeDividerDropdown({expand:!1}),this._setDividerInactive()):(this._emitChangeDividerDropdown({expand:!0}),this._setDividerActive())},this._type=null!==(t=this.getAttribute("type"))&&void 0!==t?t:a.EXPANDABLE,this._label=this.getAttribute("label")||void 0,this._size=this.getAttribute("size"),this._defaultExpand=this.hasAttribute("defaultExpand"),this._initOptions(e),this._divider=document.createElement("div"),this._divider.classList.add("ui-divider"),this._renderStyle(),this._renderBody()}_initOptions(e){e&&(this._type=e.type||a.EXPANDABLE,this._defaultExpand=e.defaultExpand||!1,this._label=e.label||void 0,this._size=e.size)}_renderStyle(){const e=document.createElement("style");e.appendChild(document.createTextNode((0,s.getDividerStyle)(r.ideChecker.isIDE))),this.shadow.appendChild(e)}_renderBody(){this._divider.classList.add(`${this._type}-divider`),this._divider.classList.add(`${this._size}`),this._type===a.EXPANDABLE?(this._defaultExpand?this._setDividerActive():this._setDividerInactive(),this._divider.textContent=this._label||"",this._divider.setAttribute("label",this._label),this.shadow.appendChild(this._divider),this._divider.addEventListener("click",this.selectDivider)):(this._divider.textContent=this._label||"",this._divider.setAttribute("label",this._label),this.shadow.appendChild(this._divider))}_setDividerInactive(){this._divider.classList.remove("ui-divider-active")}_setDividerActive(){this._divider.classList.add("ui-divider-active")}get defaultExpand(){return this._defaultExpand}get element(){return this._divider}dispose(){this.disconnectedCallback(),this._changeDividerDropdownEmitter.clear()}}t.Divider=d,(0,o.defineCustomElement)("ide-divider",d)},2541(e,t,i){"use strict";var n=this&&this.__createBinding||(Object.create?function(e,t,i,n){void 0===n&&(n=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,n,o)}:function(e,t,i,n){void 0===n&&(n=i),e[n]=t[i]}),o=this&&this.__exportStar||function(e,t){for(var i in e)"default"===i||Object.prototype.hasOwnProperty.call(t,i)||n(t,e,i)};Object.defineProperty(t,"__esModule",{value:!0}),o(i(9090),t),o(i(8653),t),o(i(1062),t),o(i(7366),t),o(i(5754),t),o(i(7746),t),o(i(2630),t),o(i(3138),t),o(i(8784),t),o(i(1750),t),o(i(3814),t),o(i(9472),t),o(i(4295),t),o(i(7509),t),o(i(3446),t),o(i(7658),t),o(i(3067),t),o(i(9574),t),o(i(5731),t),o(i(9483),t),o(i(613),t),o(i(1003),t),o(i(519),t),o(i(9084),t),o(i(5354),t),o(i(6199),t),o(i(4293),t),o(i(79),t),o(i(7594),t),o(i(308),t),o(i(2087),t),o(i(6482),t)},2550(e,t,i){var n=i(5814),o=i(471);e.exports=function(e,t,i){var s=t&&i||0;"string"==typeof e&&(t="binary"===e?new Array(16):null,e=null);var r=(e=e||{}).random||(e.rng||n)();if(r[6]=15&r[6]|64,r[8]=63&r[8]|128,t)for(var a=0;a<16;++a)t[s+a]=r[a];return t||o(r)}},2630(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Tabs=t.TabsCloseType=t.TabsSize=t.TabsType=void 0;const n=i(519),o=i(9084),s=i(995),r=i(5754),a=i(8653),l=i(8784),d=i(5366),c=i(5354);var u,h,p;!function(e){e.LINE="line",e.SIDE="side",e.EDITABLE="editable",e.SIDEROW="sideRow"}(u=t.TabsType||(t.TabsType={})),(p=t.TabsSize||(t.TabsSize={})).MINIMAL="minimal",p.SMALL="small",p.MEDIUM="medium",function(e){e.NONE="none",e.DEFAULT="default",e.DELETE="delete"}(h=t.TabsCloseType||(t.TabsCloseType={}));class b extends o.BaseComponent{constructor(e){var t,i,o;super(),this._changeActiveTabEmitter=new n.EventEmitter,this.onDidChangeActiveTab=this._changeActiveTabEmitter.asSubscriber("onDidChangeActiveTab"),this._emitChangeActiveTab=e=>{this._changeActiveTabEmitter.emit("onDidChangeActiveTab",e),this._tabs.dispatchEvent(new CustomEvent("onDidChangeActiveTab",{detail:e,composed:!0}))},this._closeTabEmitter=new n.EventEmitter,this.onDidCloseTab=this._closeTabEmitter.asSubscriber("onDidCloseTab"),this._emitCloseTab=e=>{this._closeTabEmitter.emit("onDidCloseTab",e),this._tabs.dispatchEvent(new CustomEvent("onDidCloseTab",{detail:e,composed:!0}))},this._onWillAddTabEmitter=new n.EventEmitter,this.onWillAddTab=this._onWillAddTabEmitter.asSubscriber("onWillAddTab"),this._emitWillAddTab=()=>{this._onWillAddTabEmitter.emit("onWillAddTab"),this._tabs.dispatchEvent(new CustomEvent("onWillAddTab",{composed:!0}))},this._onWillRemoveTabEmitter=new n.EventEmitter,this.onWillRemoveTab=this._onWillRemoveTabEmitter.asSubscriber("onWillRemoveTab"),this._emitWillRemoveTab=e=>{this._onWillRemoveTabEmitter.emit("onWillRemoveTab",e),this._tabs.dispatchEvent(new CustomEvent("onWillRemoveTab",{detail:e,composed:!0}))},this._handleDisableContextmenu=e=>{e.stopPropagation()},this._handleClose=e=>{var t;e.stopPropagation();const i=null===(t=e.currentTarget)||void 0===t?void 0:t.parentElement;if(!i||i.hasAttribute("disabled"))return;const n=this._getIndex(i);if(this._enableOnRemoveTabRequested){const e={id:this._children[n].id,option:this._children[n]};this._emitWillRemoveTab(e)}else this.removeTab(this._children[n].id)},this._handleTabClick=e=>{e.stopPropagation();const t=e.currentTarget;if(!t||t.hasAttribute("disabled"))return;const i=this._getIndex(t),n=this._children[i].id;this.selectTab(n)},this._type=null!==(t=this.getAttribute("type"))&&void 0!==t?t:u.LINE,this._closeType=this._isLineTabs()?h.NONE:null!==(i=this.getAttribute("closeType"))&&void 0!==i?i:h.NONE,this._addable=this._isEditableTabs()&&this.hasAttribute("addable"),this._stretchable=this._isSideTabs()&&this.hasAttribute("stretchable"),this._stretchable=this._isSideRowTabs()&&this.hasAttribute("stretchable"),this._titleForAddAction=this._addable&&this.getAttribute("titleForAddAction")||void 0,this._flexibleMinWidth=(this._isEditableTabs()||this._isSideRowTabs())&&this.hasAttribute("flexibleMinWidth")?Number(this.getAttribute("flexibleMinWidth")):void 0,this._flexibleMaxWidth=(this._isEditableTabs()||this._isSideRowTabs())&&this.hasAttribute("flexibleMaxWidth")?Number(this.getAttribute("flexibleMaxWidth")):void 0,this._disableAutoFocusSwitch=this.hasAttribute("disableAutoFocusSwitch"),this._allowContextMenu=this.hasAttribute("allowContextMenu"),this._enableOnRemoveTabRequested=this.hasAttribute("enableOnRemoveTabRequested"),this._children=this._getChildrenTab(),this._activeId=this.getAttribute("activeId")||(null===(o=this._children[0])||void 0===o?void 0:o.id),this._initOptions(e),this._tabs=document.createElement("div"),this._tabs.classList.add("ui-tabs"),this._renderStyle(),this._renderBody(),this.selectTab(this._activeId),this._isSideRowTabs()&&(this._tabs.style.width=this.getMaxWidth()*this._children.length+"px",this._size=this.getAttribute("size"))}getMaxWidth(){let e=0,t=0;return this._children.forEach(i=>{t=this.getTextWidth(i.label),e=Math.max(t,e)}),e=Math.max(64,e+24),e}getTextWidth(e){const t=document.createElement("span");t.innerText=e,t.style.fontSize="13px",t.style.position="absolute",document.body.appendChild(t);const i=t.offsetWidth;return document.body.removeChild(t),i}_initOptions(e){var t,i,n;e&&(this._activeId=e.activeId||(null===(t=this._children[0])||void 0===t?void 0:t.id),this._type=e.type||u.LINE,this._closeType=this._isLineTabs()?h.NONE:e.closeType||h.NONE,this._addable=this._isEditableTabs()&&!!e.addable,this._stretchable=(this._isSideTabs()||this._isSideRowTabs())&&!!e.stretchable,this._titleForAddAction=this._addable?e.titleForAddAction:void 0,this._flexibleMinWidth=this._isEditableTabs()||this._isSideRowTabs()?e.flexibleMinWidth:void 0,this._flexibleMaxWidth=this._isEditableTabs()||this._isSideRowTabs()?e.flexibleMaxWidth:void 0,this._disableAutoFocusSwitch=!!e.disableAutoFocusSwitch,this._allowContextMenu=null!==(i=e.allowContextMenu)&&void 0!==i&&i,this._enableOnRemoveTabRequested=null!==(n=e.enableOnRemoveTabRequested)&&void 0!==n&&n,this._children=e.children,this._size=e.size)}_renderBody(){var e,t;this._tabs.classList.add(`${this._type}-tabs`),this._isEditableTabs()&&(this._tabs.style.flexWrap="wrap"),this._allowContextMenu||this._tabs.addEventListener("contextmenu",this._handleDisableContextmenu),this._tabs.setAttribute("activeId",null!==(e=this._activeId)&&void 0!==e?e:""),this._tabs.setAttribute("closeType",this._closeType),this._tabs.setAttribute("size",null!==(t=this._size)&&void 0!==t?t:""),this._children.forEach(e=>this._addTab(e)),this._addable&&this._renderAddButton(),this.shadow.appendChild(this._tabs)}_renderStyle(){const e=document.createElement("style");e.appendChild(document.createTextNode((0,s.getTabsStyle)(c.ideChecker.isIDE))),this.shadow.appendChild(e)}_getChildrenTab(){return Array.from(this.getElementsByTagName("ide-tab")).map(e=>{var t,i;return{id:String(e.getAttribute("id")),label:String(e.getAttribute("label")),title:null!==(t=e.getAttribute("title"))&&void 0!==t?t:void 0,icon:null!==(i=e.getAttribute("icon"))&&void 0!==i?i:void 0,disabled:e.hasAttribute("disabled"),badgeCount:e.getAttribute("badgeCount")?Number(e.getAttribute("badgeCount")):void 0,mnemonicIndex:e.getAttribute("mnemonicIndex")?Number(e.getAttribute("mnemonicIndex")):void 0}})}get element(){return this._tabs}get activeId(){return this._activeId}set activeId(e){this.selectTab(e)}get flexibleMinWidth(){return this._flexibleMinWidth}set flexibleMinWidth(e){this._flexibleMinWidth=e,Array.from(this._tabs.getElementsByClassName("ui-tab")).forEach(e=>{e.style.minWidth=this._flexibleMinWidth?`${this._flexibleMinWidth}px`:""})}get flexibleMaxWidth(){return this._flexibleMaxWidth}set flexibleMaxWidth(e){this._flexibleMaxWidth=e,Array.from(this._tabs.getElementsByClassName("ui-tab")).forEach(e=>{e.style.maxWidth=this._flexibleMaxWidth?`${this._flexibleMaxWidth}px`:""})}get tabs(){const e=[...this._children];return e.forEach(e=>{delete e.badge}),e}addTab(e,t){if(this._isIdValid(e.id))return!1;const i=void 0!==(null==t?void 0:t.index)?null==t?void 0:t.index:this._getTabsLength();return this._children.splice(i,0,e),this._addTab(e,null==t?void 0:t.index),(null==t?void 0:t.preserveFocus)||this.selectTab(e.id),!0}selectTab(e,t=!0){if(this._setTabsInactive(),void 0!==e&&this._isIdValid(e)&&!this._isTabDisabled(e)){if(this._setTabActive(e),t){const t={id:e,option:this._children.find(t=>t.id===e)};this._emitChangeActiveTab(t)}}else t&&this._emitChangeActiveTab({id:void 0,option:void 0})}updateTabIcon(e,t){if(!this._isIdValid(e))return;const i=this._getTabElement(e).querySelector(".ui-tab-label"),n=i.querySelector(".ui-tab-label-icon");let o;t&&(o=this._renderIcon(t),o.classList.add("ui-tab-label-icon")),n&&n.remove(),o&&i.prepend(o);const s=this._getIndexById(e);this._children[s].icon=t}updateTab(e,t){var i;if(!this._isIdValid(e))return;const n=this._getTabElement(e),o=this._getIndexById(e),s=n.querySelector(".ui-tab-label");switch(t.label&&(n.querySelector(".ui-tab-label-text").textContent=t.label,n.setAttribute("label",t.label),this._children[o].label=t.label),t.title&&this._showHover(n,t.title),t.disabled){case!0:n.setAttribute("disabled",""),n.classList.contains("ui-tab-disabled")||n.classList.add("ui-tab-disabled");break;case!1:n.removeAttribute("disabled"),n.classList.contains("ui-tab-disabled")&&n.classList.remove("ui-tab-disabled")}if(this._children[o].disabled=t.disabled,!this._isEditableTabs()&&void 0!==t.badgeCount){let e=this._children[o].badge;e||(s.querySelectorAll(".ui-tab-badge").forEach(e=>e.remove()),e=new a.Badge,null===(i=e.shadowRoot)||void 0===i||i.host.classList.add("ui-tab-badge"),s.append(e),this._children[o].badge=e),e.setCount(t.badgeCount),this._children[o].badgeCount=t.badgeCount}}removeTab(e,t=!0){var i;if(!this._isIdValid(e))return;const n=this._activeId===e;this._getTabElement(e).remove();const o=this._getIndexById(e),s=this._children[o];if(this._children.splice(o,1),t){const t={id:e,option:s};this._emitCloseTab(t)}if(0===this._getTabsLength()&&this._setTabsInactive(),n)if(this._disableAutoFocusSwitch)this.selectTab(void 0);else{const e=o?this._children[o-1].id:null===(i=this._children[0])||void 0===i?void 0:i.id;this.selectTab(e)}}updateMnemonicIndex(e,t){const i=this._getTabElement(e).getElementsByClassName("ui-tab-label-text")[0],n=i.textContent,o=(0,d.createUnderlineStr)(null!=n?n:"",t);i.textContent="",i.appendChild(o)}dispose(){this.disconnectedCallback(),this._changeActiveTabEmitter.clear(),this._closeTabEmitter.clear(),this._onWillAddTabEmitter.clear(),this._allowContextMenu||this._tabs.removeEventListener("contextmenu",this._handleDisableContextmenu),Array.from(this._tabs.getElementsByClassName("ui-tab")).forEach(e=>{if(e.removeEventListener("click",this._handleTabClick),this._isClosable()){const t=e.querySelector("ui-tab-action");null==t||t.removeEventListener("click",this._handleClose)}}),Array.from(this._tabs.getElementsByClassName("ui-tab-add")).forEach(e=>{e.removeEventListener("click",this._emitWillAddTab)})}_getIndex(e){return Array.from(this._tabs.getElementsByClassName("ui-tab")).indexOf(e)}_getTabElement(e){const t=this._getIndexById(e);return Array.from(this._tabs.getElementsByClassName("ui-tab"))[t]}_getTabsLength(){return Array.from(this._tabs.getElementsByClassName("ui-tab")).length}_isTabDisabled(e){var t;return!!(null===(t=this._getTabElement(e))||void 0===t?void 0:t.hasAttribute("disabled"))}_isLineTabs(){return this._type===u.LINE}_isSideTabs(){return this._type===u.SIDE}_isEditableTabs(){return this._type===u.EDITABLE}_isSideRowTabs(){return this._type===u.SIDEROW}_getIndexById(e){return this._children.findIndex(t=>t.id===e)}_isIdValid(e){return!!this._children.find(t=>e&&t.id===e)}_renderAddButton(){const e=document.createElement("div");e.classList.add("ui-tab-add"),e.tabIndex=0;const t=(0,r.renderIcon)({id:"add"},this.shadow);e.appendChild(t),e.addEventListener("click",this._emitWillAddTab),e.addEventListener("keydown",e=>{e.stopPropagation();const t=e;"Enter"!==t.code&&"Space"!==t.code||this._emitWillAddTab()}),this._tabs.appendChild(e),this._titleForAddAction&&l.Hover.setupIconLabelHover({content:this._titleForAddAction,target:e,hoverPosition:l.HoverPosition.BELOW,showPointer:!1})}_setTabsInactive(){var e;this._activeId=void 0,this._tabs.setAttribute("activeId",null!==(e=this._activeId)&&void 0!==e?e:""),Array.from(this._tabs.getElementsByClassName("ui-tab")).forEach(e=>{e.classList.remove("ui-tab-active")})}_setTabActive(e){this._activeId=e,this._tabs.setAttribute("activeId",this._activeId),this._getTabElement(this._activeId).classList.add("ui-tab-active")}_isClosable(){return this._closeType!==h.NONE}_addCloseIcon(e){const t=document.createElement("div");if(t.classList.add("ui-tab-action"),this._isClosable()){const e=this._closeType===h.DEFAULT||this._type===u.EDITABLE?"close":"trash",i=(0,r.renderIcon)({id:e},this.shadow);t.addEventListener("click",this._handleClose),this._type===u.EDITABLE&&(t.classList.add("ui-tab-action-upper-right"),i.style.fontSize="12px"),t.appendChild(i)}e.appendChild(t)}_renderIcon(e){let t;return(0,r.isIdeIconExists)(e)?t=(0,r.renderIcon)({id:e},this.shadow):(t=document.createElement("span"),t.classList.add("ui-tab-label-url-icon"),t.style.backgroundImage=`url('${e}')`,t.style.backgroundSize="16px",t.style.backgroundRepeat="no-repeat",t.style.width="16px",t.style.height="16px"),t}_showHover(e,t){e.addEventListener("mouseenter",()=>l.Hover.show({content:t,target:e,hoverPosition:l.HoverPosition.BELOW}))}_addTab(e,t){var i,n;const o=document.createElement("div");let s=this.getAttribute("size")||this._size;void 0===s&&(s="sizeAdapt"),this._isSideRowTabs()?o.classList.add("ui-tab",`${s}`):o.classList.add("ui-tab"),e.id&&o.setAttribute("id",e.id),this._stretchable&&o.classList.add("stretchable"),this._flexibleMinWidth&&(o.style.minWidth=`${this._flexibleMinWidth}px`),this._flexibleMaxWidth&&(o.style.maxWidth=`${this._flexibleMaxWidth}px`);const r=document.createElement("div");r.classList.add("ui-tab-label-container");const l=document.createElement("div");this._isSideRowTabs()?l.classList.add("ui-tab-label",`${s}`):l.classList.add("ui-tab-label");const c=document.createElement("span");if(this._isSideRowTabs()?c.classList.add("ui-tab-label-text",`${s}`):c.classList.add("ui-tab-label-text"),void 0===e.mnemonicIndex||isNaN(e.mnemonicIndex))c.textContent=e.label;else{const t=e.label,i=e.mnemonicIndex,n=(0,d.createUnderlineStr)(t,i);c.textContent="",c.appendChild(n)}if(l.appendChild(c),o.setAttribute("label",e.label),e.icon){const t=this._renderIcon(e.icon);t.classList.add("ui-tab-label-icon"),l.prepend(t)}if(!this._isEditableTabs()&&void 0!==e.badgeCount){const t=new a.Badge({count:e.badgeCount});null===(i=t.shadowRoot)||void 0===i||i.host.classList.add("ui-tab-badge"),l.append(t),this._children[this._children.indexOf(e)].badge=t}r.appendChild(l),o.appendChild(r),this._addCloseIcon(o),e.disabled?(o.setAttribute("disabled",""),o.classList.add("ui-tab-disabled"),o.tabIndex=-1):o.tabIndex=0,e.title&&this._showHover(o,e.title);const u=void 0!==t?Array.from(this._tabs.getElementsByClassName("ui-tab"))[t]:void 0;u||(null===(n=this._tabs.lastElementChild)||void 0===n?void 0:n.classList.contains("ui-tab-add"))?this._tabs.insertBefore(o,null!=u?u:this._tabs.lastElementChild):this._tabs.appendChild(o),o.addEventListener("click",this._handleTabClick)}}t.Tabs=b,(0,o.defineCustomElement)("ide-tabs",b)},2755(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.CheckBoxGroup=t.CheckBoxDirectionType=void 0;const n=i(519),o=i(9302),s=i(9084),r=i(5366);var a;!function(e){e.ROW="row",e.COLUMN="column"}(a=t.CheckBoxDirectionType||(t.CheckBoxDirectionType={}));class l extends s.BaseComponent{constructor(e={}){super(),this.uiPrefix=o.PREFIX,this.curCheckedValueList=[],this.valueArr=[],this.clickGroupEmitter=new n.EventEmitter,this.onDidGroupChange=this.clickGroupEmitter.asSubscriber("onDidGroupChange"),this.checkBoxGroupStates=this.getOptions(e,this.getFilterAttributesOptions()),this.checkBoxGroupWrapper=document.createElement("div"),this.checkBoxArray=[],this.renderCheckBoxItem(),this.checkBoxGroupWrapper.style.flexDirection=this.checkBoxGroupStates.direction,this.checkBoxGroupWrapper.setAttribute("name",this.checkBoxGroupStates.name),this.checkBoxGroupWrapper.classList.add(`${this.uiPrefix}-group`);const t=document.createElement("style");t.appendChild(document.createTextNode(d)),this.shadow.appendChild(t),this.shadow.appendChild(this.checkBoxGroupWrapper)}renderCheckBoxItem(){this.checkBoxGroupStates.optionsArray&&this.checkBoxGroupStates.optionsArray.forEach(e=>{this.valueArr.push(e.value),(0,r.isValueRepeat)(this.valueArr),(0,r.isValueExist)(e.value),this.checkBoxGroupStates.isIndeterminate&&(e.isIndeterminate=!0),void 0===e.isChecked&&void 0!==this.checkBoxGroupStates.groupChecked&&(e.isChecked=this.checkBoxGroupStates.groupChecked),this.checkBoxGroupStates.isWidgets?e.isWidgets=!0:e.isWidgets=!1,this.renderCheckBox(e)})}renderCheckBox(e){const t=new o.CheckBox(e);t.onDidChange(e=>{this.clickGroupEmitter.emit("onDidGroupChange",e)}),this.checkBoxArray.push(t),this.checkBoxGroupWrapper.appendChild(t)}getOptions(e,t){const i=Object.assign(Object.assign({},t),e);return i.direction="row"===i.direction?a.ROW:a.COLUMN,i.name="string"==typeof i.name?i.name:"",i.isWidgets=!!i.isWidgets&&i.isWidgets,i.isIndeterminate=!!i.isIndeterminate&&i.isIndeterminate,i}getFilterAttributesOptions(){return{name:(0,r.filterAttribute)(this.getAttribute("name")),direction:(0,r.filterAttribute)(this.getAttribute("direction")),groupChecked:(0,r.filterAttribute)(this.getAttribute("groupChecked")),isWidgets:(0,r.filterAttribute)(this.getAttribute("isWidgets")),isIndeterminate:(0,r.filterAttribute)(this.getAttribute("isIndeterminate"))}}getItemByValue(e){for(let t=0;t<this.checkBoxArray.length;t++)if(this.checkBoxArray[t].value===e)return this.checkBoxArray[t]}updateMnemonicIndex(e,t){var i,n;const o=this.getItemByValue(e),s=null===(n=null===(i=null==o?void 0:o.shadowRoot)||void 0===i?void 0:i.lastElementChild)||void 0===n?void 0:n.getElementsByClassName("ide-checkbox-label")[0],a=null==s?void 0:s.textContent,l=(0,r.createUnderlineStr)(null!=a?a:"",t);s&&(s.textContent="",s.appendChild(l))}setGroupItemChecked(e){e.length&&(this.checkBoxArray.forEach((t,i)=>{var n,o;const s=null===(o=null===(n=t.shadowRoot)||void 0===n?void 0:n.lastElementChild)||void 0===o?void 0:o.getAttribute("value");s&&-1!==e.indexOf(s)&&this.checkBoxArray[i].setChecked(!0)}),this.curCheckedValueList=e)}setGroupDisable(e){e&&this.checkBoxArray.forEach(e=>{e.setEnabled(!1)})}set disabled(e){this.setGroupDisable(e)}get disabled(){return!this.checkBoxArray.some(e=>e.isEnabled)}set checkedValueList(e){this.setGroupItemChecked(e)}get checkedValueList(){return this.curCheckedValueList||[]}dispose(){this.curCheckedValueList=[],this.valueArr=[],this.clickGroupEmitter.clear()}}t.CheckBoxGroup=l;const d=`\n.${o.PREFIX}-group {\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: flex-start;\n    align-item: flex-start;\n}\n\n.${o.PREFIX}-group[style="flex-direction: row;"] ide-checkbox {\n    margin: 0 20px 8px 0;\n}\n\n.${o.PREFIX}-group[style="flex-direction: column;"] ide-checkbox {\n    margin-bottom: 8px;\n    width: 100%;\n}\n\n.${o.PREFIX}-group ide-checkbox:nth-last-child(1) {\n    margin: 0;\n}`;(0,s.defineCustomElement)(`${o.PREFIX}-group`,l)},2842(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.GlobalPointerMoveMonitor=void 0,t.GlobalPointerMoveMonitor=class{constructor(){this._hooks=new Set,this._pointerMoveCallback=null,this._onStopCallback=null}dispose(){this.stopMonitoring(!1),this._hooks.forEach(e=>{"function"==typeof e&&e()})}stopMonitoring(e,t){if(!this.isMonitoring())return;this._hooks.clear(),this._pointerMoveCallback=null;const i=this._onStopCallback;this._onStopCallback=null,e&&i&&i(t)}isMonitoring(){return!!this._pointerMoveCallback}startMonitoring(e,t,i,n,o){this.isMonitoring()&&this.stopMonitoring(!1),this._pointerMoveCallback=n,this._onStopCallback=o;let s=e;try{e.setPointerCapture(t),this._hooks.add(()=>{e.releasePointerCapture(t)})}catch(e){s=window}this._hooks.add(s.addEventListener("pointermove",e=>{e.buttons===i?(e.preventDefault(),this._pointerMoveCallback(e)):this.stopMonitoring(!0)})),this._hooks.add(s.addEventListener("pointerup",e=>{this.stopMonitoring(!0)}))}}},2925(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.escape=t.format=void 0;const i=/{(\d+)}/g;t.format=function(e,...t){return 0===t.length?e:e.replace(i,(e,i)=>{const n=parseInt(i,10);return isNaN(n)||n<0||n>=t.length?e:t[n]})},t.escape=function(e){return e.replace(/[<>&]/g,e=>{switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";default:return e}})}},2994(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.IconLabelStyle=t.getHightLightedStyle=t.SimpleIconLabelStyle=t.IconLabelModifierStyle=void 0;const n=i(6199);t.IconLabelModifierStyle="\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n\n.codicon-sync.codicon-modifier-spin,\n.codicon-loading.codicon-modifier-spin,\n.codicon-gear.codicon-modifier-spin,\n.codicon-notebook-state-executing.codicon-modifier-spin {\n\tanimation: codicon-spin 1.5s steps(30) infinite;\n}\n\n.codicon-modifier-disabled {\n\topacity: 0.4;\n}\n\n.codicon-loading,\n.codicon-tree-item-loading::before {\n\tanimation-duration: 1s !important;\n\tanimation-timing-function: cubic-bezier(0.53, 0.21, 0.29, 0.67) !important;\n}",t.SimpleIconLabelStyle=`\nspan[class*=codicon] {\n\tmargin: var(--user-simple-icon-label-margin, 0);\n}\n.codicon-wrench-subaction {\n\topacity: 0.5;\n}\n${t.IconLabelModifierStyle}\n`,t.getHightLightedStyle=e=>`\n.highlight {\n    color: ${e?"var(--vscode-list-focusHighlightForeground)":n.highLightedColor};\n    font-weight: var(--user-highlighted-bold, normal);\n    background-color: var(--user-highlighted-bgcolor, transparent);\n}\n\n.ide-highlighted-container {\n\tfont-family: ${n.fontFamily};\n\tvertical-align: text-bottom;\n\tline-height: normal;\n}\n\n.ide-highlighted-container {\n    display: var(--user-highlighted-container-flex, inline-flex);\n\talign-items: center;\n}\n\n.highlighted-start-span {\n    display: var(--user-highlighted-container-flex, inline-flex);\n\talign-items: center;\n}\n\n.highlighted-span-container {\n    display: var(--user-highlighted-span-container-display, inherit);\n    width: var(--user-highlighted-span-container-width, inherit);\n    overflow: var(--user-highlighted-span-container-overflow, unset);\n    text-overflow: var(--user-highlighted-span-container-text-overflow, inherit);\n    white-space: var(--user-highlighted-span-container-white-space, inherit);\n\tcolor: var(--user-highlighted-span-container-color, ${n.primaryFontColor});\n    align-items: center;\n}\n\n.highlighted-span-container span, .highlighted-start-span span {\n    margin: 0 5px;\n\tvertical-align: text-bottom;\n}\n\n.highlighted-span-container span:first-child, .highlighted-start-span span:first-child {\n    margin-left: 0;\n}\n\n.insert {\n    color: ${n.iconLabelColor};\n    background-color: ${n.insertediconLabelBackground};\n}\n\n.remove {\n    color: ${n.iconLabelColor};\n    background-color: ${n.removedIconLabelBackground};\n    text-decoration: line-through;\n}\n${t.IconLabelModifierStyle}\n`,t.IconLabelStyle=`\n.ide-icon-label {\n\tfont-family: ${n.fontFamily};\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.ide-icon-label::before {\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tline-height: inherit !important;\n\tdisplay: inline-block;\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tvertical-align: top;\n\tflex-shrink: 0;\n}\n\n.ide-icon-label .ide-icon-label-container {\n\tmin-width: 0;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tdisplay: flex;\n    align-items: center;\n}\n\n.ide-icon-label .ide-icon-label-container .ide-icon-name-container .label-name {\n\tcolor: inherit;\n\twhite-space: pre;\n}\n\n.ide-icon-label .ide-icon-label-container .ide-icon-name-container .label-name .label-separator {\n\tmargin: 0 2px;\n\topacity: 0.5;\n}\n\n.ide-icon-label.codicon[class*='codicon-'] .ide-icon-name-container ide-highlighted-label {\n\tposition: relative;\n    top: -1px;\n}\n\n.ide-icon-description-container {\n\t--user-highlighted-span-container-fontSize:  var(--user-highlighted-span-container-description-fontSize, 12px);\n\t--user-highlighted-span-container-color: var(--user-highlighted-span-container-description-color, ${n.disabledFontColor});\n}\n\n.ide-icon-label .ide-icon-label-container .ide-icon-description-container {\n\topacity: var(--user-ide-icon-label-description-opacity, 0.95);\n\tfont-size: 12px;\n\twhite-space: pre;\n}\n\n.ide-icon-label.nowrap .ide-icon-label-container .ide-icon-description-container {\n\twhite-space: nowrap\n}\n\n.ide-icon-label.italic .ide-icon-label-container .ide-icon-name-container .label-name,\n.ide-icon-label.italic .ide-icon-label-container .ide-icon-description-container {\n\tfont-style: italic;\n}\n\n.ide-icon-label.deprecated {\n\ttext-decoration: line-through;\n\topacity: 0.66;\n}\n\n.ide-icon-label.italic::after {\n\tfont-style: italic;\n}\n\n.ide-icon-label.strikethrough .ide-icon-label-container .ide-icon-name-container .label-name,\n.ide-icon-label.strikethrough .ide-icon-label-container .ide-icon-description-container {\n\ttext-decoration: line-through;\n}\n\n.ide-icon-label::after {\n\topacity: 0.75;\n\tfont-size: 90%;\n\tfont-weight: 600;\n\tmargin: auto 16px 0 5px;\n\ttext-align: center;\n}\n`},3067(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActionWithDropdownActionViewItem=t.DropdownMenuActionViewItem=void 0;const n=i(9574),o=i(4295),s=i(519),r=i(9084),a=i(5754),l=i(7509),d=i(6199),c=i(1003);class u extends o.BaseActionViewItem{constructor(e,t,i,n=Object.create(null)){if(super(null,e,n),this.actionItem=null,this.isIdeIconExistsFlag=!1,this._onDidChangeVisibility=new s.EventEmitter,this.onDidChangeVisibility=this._onDidChangeVisibility.asSubscriber("onDidChangeVisibility"),i)this.contextMenuProvider=i;else{const e={menuSize:c.MenuSize.AUTO,closeScope:c.CloseScope.ALL},t=new c.ContextMenuService(e);this.contextMenuProvider=t.provider()}this.menuActionsOrProvider=t,this.options=n,this.options.actionRunner&&(this.actionRunner=this.options.actionRunner)}getMenuActions(){const e=this.menuActionsOrProvider;return Array.isArray(e)?e:e.getActions()}render(e){this.actionItem=e;const t=Array.isArray(this.menuActionsOrProvider),i={menuAsChild:this.options.menuAsChild,contextMenuProvider:this.contextMenuProvider,actions:t?this.menuActionsOrProvider:void 0,actionProvider:t?void 0:this.menuActionsOrProvider,labelRenderer:e=>{var t;this.element=document.createElement("a"),this.element.classList.add("action-label"),e.appendChild(this.element);let i=[];"string"==typeof this.options.classNames?i=this.options.classNames.split(/\s+/g).filter(e=>!!e):this.options.classNames&&(i=this.options.classNames),i.find(e=>"codicon"===e)||i.push("codicon");for(const e of i){const t=e.substring(8);if("codicon-"===e.substring(0,8)&&(0,a.isIdeIconExists)(t)){if(this.isIdeIconExistsFlag=!0,(0,a.isDoubleIcon)(t)){const[e,n]=(0,a.getDoubleIconId)(t);i.push("double-icon",`codicon-${e}`,`codicon-${n}`)}break}}this.isIdeIconExistsFlag||this.options.showWithLabel||(this.element.innerText=this._action.label,this.element.style.fontSize=d.fontSize.mainText,this.element.style.fontFamily=d.fontFamily,this.action.linkable&&(this.element.style.color=d.highLightedColor)),this.options.showWithLabel&&(this.element.classList.add("show-with-label"),this._renderDropdownIconLabel(this.element));const n=document.createElement("style");return n.appendChild(document.createTextNode((0,a.getAllIcons)())),e.append(n),this.element.classList.add(...i),this.element.setAttribute("role","button"),this.element.setAttribute("aria-haspopup","true"),this.element.setAttribute("aria-expanded","false"),this.element.ariaLabel=(null===(t=this._action)||void 0===t?void 0:t.label)||"",null}};this.renderDropdownMenu(e,i),e.appendChild(this)}_renderDropdownIconLabel(e){const t=document.createElement("div");t.classList.add("label"),t.innerText=this.action.label,e.append(t)}renderDropdownMenu(e,t){var i,o;if(!e.hasChildNodes()){if(this.dropdownMenu=new n.DropdownMenu(t),e.append(this.dropdownMenu),this.dropdownMenu.onDidChangeVisibility(e=>{var t;null===(t=this.element)||void 0===t||t.setAttribute("aria-expanded",`${e}`),this._onDidChangeVisibility.emit("onDidChangeVisibility",e)}),this.dropdownMenu.menuOptions={actionRunner:this.actionRunner,context:this._context,actionViewItemProvider:this.options.actionViewItemProvider,getKeyBinding:this.options.keybindingProvider},this.options.anchorAlignmentProvider){const e=this;this.dropdownMenu.menuOptions=Object.assign(Object.assign({},this.dropdownMenu.menuOptions),{get anchorAlignment(){return e.options.anchorAlignmentProvider()}})}this.updateEnabled(),this.element&&this.shadow.appendChild(this.dropdownMenu),this.dropdownMenu.toolTip=(null===(i=this._action)||void 0===i?void 0:i.tooltip)||(null===(o=this._action)||void 0===o?void 0:o.label)||""}}show(){this.dropdownMenu&&this.dropdownMenu.show()}hide(){this.dropdownMenu&&this.dropdownMenu.hide()}setActionContext(e){super.setActionContext(e),this.dropdownMenu&&(this.dropdownMenu.menuOptions?this.dropdownMenu.menuOptions.context=e:this.dropdownMenu.menuOptions={context:e})}updateEnabled(){var e,t;const i=!this.getAction().enabled;null===(e=this.actionItem)||void 0===e||e.classList.toggle("disabled",i),null===(t=this.element)||void 0===t||t.classList.toggle("disabled",i)}dispose(){this.disconnectedCallback(),this._onDidChangeVisibility.clear()}}t.DropdownMenuActionViewItem=u;class h extends l.ActionViewItem{constructor(e,t,i,n){super(e,t,i),this.contextMenuProvider=n}blur(){var e;super.blur(),null===(e=this.dropdownMenuActionViewItem)||void 0===e||e.blur()}setFocusable(e){var t;super.setFocusable(e),null===(t=this.dropdownMenuActionViewItem)||void 0===t||t.setFocusable(e)}render(e){if(super.render(e),!this.element)return;this.element.classList.add("action-dropdown-item");const t={getActions:()=>{const e=this.options.menuActionsOrProvider;return Array.isArray(e)?e:e.getActions()}};this.dropdownMenuActionViewItem=new u(new o.Action("dropdownAction",void 0),t,this.contextMenuProvider,{classNames:["dropdown",...(0,a.getIconClassName)("dropdown"),...this.options.menuActionClassNames||[]]}),this.dropdownMenuActionViewItem.render(this.element),this.addEventListener("keydown",e=>{var t,i,n;const o=e;let s=!1;!(null===(t=this.dropdownMenuActionViewItem)||void 0===t?void 0:t.isFocused())||"ArrowLeft"!==o.key&&"15"!==o.code?!this.isFocused()||"ArrowRight"!==o.key&&"17"!==o.code||(this.blur(),null===(n=this.dropdownMenuActionViewItem)||void 0===n||n.focus(),s=!0):(null===(i=this.dropdownMenuActionViewItem)||void 0===i||i.blur(),this.focus(),s=!0),s&&(o.preventDefault(),o.stopPropagation())}),this.shadow.appendChild(this.element),e.append(this)}}t.ActionWithDropdownActionViewItem=h,(0,r.defineCustomElement)("ide-dropdown-menu-action-view-item",u),(0,r.defineCustomElement)("ide-action-with-dropdown-action-view-item",h)},3138(e,t,i){"use strict";var n=this&&this.__createBinding||(Object.create?function(e,t,i,n){void 0===n&&(n=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,n,o)}:function(e,t,i,n){void 0===n&&(n=i),e[n]=t[i]}),o=this&&this.__exportStar||function(e,t){for(var i in e)"default"===i||Object.prototype.hasOwnProperty.call(t,i)||n(t,e,i)};Object.defineProperty(t,"__esModule",{value:!0}),o(i(9016),t),o(i(1609),t),o(i(5093),t)},3145(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.renderMarkdown=void 0;const n=i(6709),o=i(5736),s=i(5754);t.renderMarkdown=function(e,t,i){return e?function(e,t={},i={}){const o=document.createElement(t.inline?"span":"div");if(t.actionHandler){const e=e=>{var i,n;const o=e;if(0!==o.button&&1!==o.button)return;let s=e.target;if(s){if("A"!==s.tagName){if("A"!==(null===(i=s.parentElement)||void 0===i?void 0:i.tagName))return;s=s.parentElement}try{const e=s.dataset.href;e&&(null===(n=t.actionHandler)||void 0===n||n.callback(e,o))}finally{e.preventDefault()}}};o.addEventListener("click",e),o.addEventListener("auxclick",e),t.actionHandler.disposables.add({element:o,type:"click",handler:e}),t.actionHandler.disposables.add({element:o,type:"auxclick",handler:e})}e.supportHtml||(i.sanitizer=t=>(e.isTrusted?t.match(/^(<span[^>]+>)|(<\/\s*span>)$/):void 0)?t:"",i.sanitize=!0,i.silent=!0),i.renderer=function(){const e=new n.marked.Renderer;return e.link=(e,t,i)=>"string"!=typeof e?"":(e===i&&(i=l(i)),t="string"==typeof t?l(t):"",`<a href="${e=(e=l(e)).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}" title="${t||e}">${i}</a>`),e.paragraph=e=>`<p>${e}</p>`,e}();const r=function(e,t,i){var o;let r=null!==(o=e.value)&&void 0!==o?o:"";r.length>1e5&&(r=`${r.substring(0,1e5)}…`),e.supportThemeIcons&&(r=r.replace(a,e=>`\\${e}`));let l=n.marked.parse(r,i);return e.supportThemeIcons&&(l=(0,s.renderLabelWithIcons)(l,t.shadowRoot).map(e=>"string"==typeof e?e:e.outerHTML).join("")),l}(e,t,i);return o.innerHTML=d(e,function(e,t){const i=(new DOMParser).parseFromString(d(e,t),"text/html");return i.body.querySelectorAll("a").forEach(t=>{var i;const n=t.getAttribute("href");if(t.setAttribute("href",""),!n||/^data:|javascript:/i.test(n)||/^command:/i.test(n)&&!e.isTrusted||/^command:(\/\/\/)?_workbench\.downloadResource/i.test(n))t.replaceWith(null!==(i=t.textContent)&&void 0!==i?i:"");else{const i=function(t,i){const n=e.uris&&e.uris[t];return i&&t.startsWith("data:")?t:(null==n?void 0:n._formatted)?t===n._formatted?t:n._formatted:t}(n,!1);t.dataset.href=i}}),i.body.innerHTML}(e,r)),o}(e,t,i):document.createElement("span")};const r=new RegExp(`\\$\\(${s.iconNameExpression}(?:${s.iconModifierExpression})?\\)`,"g"),a=new RegExp(`\\\\${r.source}`,"g");function l(e){return e?e.replace(/\\([\\`*_{}[\]()#+\-.!])/g,"$1"):e}function d(e,t){const{config:i,allowedSchemes:n}=p(e);o.addHook("uponSanitizeAttribute",(e,t)=>{"style"!==t.attrName&&"class"!==t.attrName||("SPAN"===e.tagName?t.keepAttr="class"!==t.attrName||/^codicon codicon-[a-z-]+( codicon-modifier-[a-z-]+)?$/.test(t.attrValue):t.keepAttr=!1)});const s=function(e,t=!1){const i=document.createElement("a");return o.addHook("afterSanitizeAttributes",n=>{for(const o of["href","src"])if(n.hasAttribute(o)){const s=n.getAttribute(o);if("href"===o&&s.startsWith("#"))continue;if(i.href=s,!e.includes(i.protocol.replace(/:$/,""))){if(t&&"src"===o&&i.href.startsWith("data:"))continue;n.removeAttribute(o)}}}),{dispose:()=>{o.removeHook("afterSanitizeAttributes")}}}(n);try{return o.sanitize(t,Object.assign(Object.assign({},i),{RETURN_TRUSTED_TYPE:!0}))}finally{o.removeHook("uponSanitizeAttribute"),s.dispose()}}const c=["http","https","file","mailto","data","vscode-file","vscode-remote","vscode-remote-resource"],u=["ul","li","p","b","i","code","blockquote","ol","h1","h2","h3","h4","h5","h6","hr","em","pre","table","thead","tbody","tr","th","td","div","del","a","strong","br","img","span"],h=["href","data-href","target","title","src","alt","class","style","data-code","width","height","align"];function p(e){return e.isTrusted&&c.push("command"),{config:{ALLOWED_TAGS:u,ALLOWED_ATTR:h,ALLOW_UNKNOWN_PROTOCOLS:!0},allowedSchemes:c}}},3235(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DialogStyle=void 0;const n=i(6199);t.DialogStyle=`\ndiv, p {\n\tmargin: 0;\n\tpadding: 0;\n\tbox-sizing: border-box;\n\tcursor: auto;\n\tuser-select: text;\n}\n\n:host, .ide-dialog-modal-block {\n\tfont-family: ${n.fontFamily};\n\tposition: fixed;\n\theight: 100%;\n\twidth: 100%;\n\tleft:0;\n\ttop:0;\n\tz-index: 1001;\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n\toverflow: hidden;\n}\n\n.ide-dialog-modal-block {\n\tbackground: rgba(0, 0, 0, 0.3);\n}\n\n.ide-dialog-box {\n\tdisplay: flex;\n\tflex-direction: column;\n\twidth: min-content;\n\tborder-radius: 6px;\n\ttransform: translate3d(0px, 0px, 0px);\n\toutline: none !important;\n\tbox-sizing: border-box;\n\tposition: relative;\n\tbox-Shadow: 0 8px 24px 0 rgba(0, 0, 0, 0.50);\n\tcolor: ${n.primaryFontColor};\n\tbackground: ${n.popUpBackgroundColor};\n\tborder: 1px solid ${n.popSplitLineColor};\n}\n\n.ide-dialog-box .dialog-toolbar-row .dialog-toolbar {\n\tfont-size: ${n.fontSize.buttonText}; \n\tcolor: ${n.titleFontColor}; \n\ttext-align: left; \n\theight: 32px;\n\tline-height: 18px;\n\tpadding-left: 20px;\n\tpadding-right: 7px;\n\tdisplay: flex;\n\tjustify-content: space-between;\n\talign-items: center;\n\tbox-sizing: border-box;\n\tborder-bottom: 1px solid ${n.codeBackgroundColor};\n}\n\n.ide-dialog-box .dialog-toolbar-row {\n\theight: 32px;\n}\n\n.ide-dialog-box .dialog-toolbar-row span {\n\tuser-select: none;\n}\n\n.ide-dialog-box .dialog-toolbar-row .actions-container {\n\tjustify-content: flex-end;\n}\n\n.ide-dialog-box .dialog-message-row {\n\tdisplay: flex;\n\tflex: 1;\n\talign-items: flex-start;\n\tmargin: 10px;\n\tpadding: 5px 10px;\n\toverflow: auto;\n}\n\n.ide-dialog-box .dialog-message-row::-webkit-scrollbar {\n\twidth: 8px;\n}\n\n.ide-dialog-box .dialog-message-row::-webkit-scrollbar-thumb {\n\tbackground: ${n.scrollbarSliderBackground};\n\tborder-radius: 4px;\n}\n\n.ide-dialog-box .dialog-message-row > .dialog-icon.codicon {\n\tflex: 0 0 48px;\n\theight: 48px;\n\talign-self: baseline;\n\tfont-size: 48px;\n\tcolor: ${n.primaryColor};\n\tpadding-right: 8px;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container {\n\tdisplay: flex;\n\tflex-direction: column;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tword-wrap: break-word;\n\twhite-space: normal;\n\twidth: 100%;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message {\n\tline-height: 22px;\n\tfont-size: ${n.fontSize.mainText};\n\tflex: 1;\n\twhite-space: normal;\n\tword-wrap: break-word;\n\tmin-height: 48px;\n\tmargin-bottom: 4px;\n\tdisplay: flex;\n\talign-items: center;\n\tword-break: break-word;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message .dialog-message-text {\n\tuser-select: none;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message-body div {\n\tmargin-bottom: 20px;\n\tuser-select: none;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message-body div p {\n\tfont-size: ${n.fontSize.buttonText};\n\tcolor: ${n.primaryFontColor};\n\tletter-spacing: 0;\n\tline-height: 18px;\n\tuser-select: none;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message-detail {\n\tline-height: 22px;\n\tflex: 1;\n\tmargin-bottom: 20px;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message a:focus {\n\toutline-width: 1px;\n\toutline-style: solid;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-checkbox-row {\n\tpadding: 15px 0px 0px;\n\tdisplay: flex;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-checkbox-row .dialog-checkbox-message {\n\tcursor: pointer;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message-input {\n\tpadding: 15px 0px 0px;\n\tdisplay: flex;\n}\n\n.ide-dialog-box .dialog-message-row .dialog-message-container .dialog-message-input .ide-inputbox {\n\tflex: 1;\n}\n\n.ide-dialog-box > .dialog-buttons-row {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding-right: 1px;\n\toverflow: hidden;\n\tmargin-bottom: 10px;\n}\n\n.ide-dialog-box > .dialog-buttons-row {\n\tdisplay: flex;\n\twhite-space: nowrap;\n\tpadding: 0 12px 0;\n}\n\n.ide-dialog-box > .dialog-buttons-row > .dialog-buttons {\n\tdisplay: flex;\n\twidth: 100%;\n\tjustify-content: flex-end;\n\toverflow: hidden;\n\tmargin-left: 67px;\n}\n\n.ide-dialog-box > .dialog-buttons-row > .dialog-buttons > .ide-button {\n\twidth: fit-content;\n\twidth: -moz-fit-content;\n\tpadding: 5px 10px;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tmargin: 4px 5px;\n\toutline-offset: 2px !important;\n}\n\n.dialog-message-container code {\n    font-family: ${n.fontFamily};\n    color: ${n.codeColor};\n}\n\n.dialog-message-container pre {\n\tmargin: 0;\n\twhite-space: pre-wrap;\n}\n\n.dialog-message-container hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n\tborder-bottom: 0px solid ${n.borderColor};\n\tborder-top: 1px solid ${n.borderColor};\n\theight: 1px;\n}\n\n.dialog-message-container a {\n    color: ${n.hoverLinkColor};\n    text-decoration: none;\n}\n\n`},3265(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getTagStyle=void 0;const n=i(6199);t.getTagStyle=e=>`\n.ide-tag-label-common {\n    font-family: ${n.fontFamily};\n    font-size: 12px;\n    padding: 0 8px;\n}\n\n.ide-tag-max-common {\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.ide-tag-inline-block {\n    display: inline-block;\n}\n\n.ide-tag-not-allowed {\n\tcursor: not-allowed;\n}\n\n.ide-tag-default, .ide-tag-closeable {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${n.defaultTagBackground};\n    color: ${n.secondaryFontColor};\n\tborder-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-secondary {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n    background: ${n.secondaryBackgroundColor};\n    color: ${e?"var(--vscode-textLink-foreground)":n.processingBackgroundColor};\n    border-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-success {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${e?"var(--vscode-testing-iconPassed)":n.successStatusColor};\n    color: ${e?"var(--vscode-badge-foreground)":n.labelTypeTagColor};\n\tborder-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-processing {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${e?"var(--vscode-editorInfo-foreground)":n.processingBackgroundColor};\n    color: ${e?"var(--vscode-badge-foreground)":n.labelTypeTagColor};\n\tborder-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-error {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${e?"var(--vscode-testing-iconErrored)":n.errorStatusColor};\n    color: ${e?"var(--vscode-badge-foreground)":n.labelTypeTagColor};\n\tborder-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-warning {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${e?"var(--vscode-editorWarning-foreground)":n.warnStatusColor};\n    color: ${e?"var(--vscode-badge-foreground)":n.labelTypeTagColor};\n\tborder-radius: 2px;\n    text-align: center;\n}\n\n.ide-tag-disable {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    height: 20px;\n    line-height: 20px;\n\tbackground: ${n.tagDisableBackground};\n\tborder-radius: 2px;\n}\n\n.ide-tag-default.small, .ide-tag-closeable.small,\n.ide-tag-secondary.small, .ide-tag-success.small,\n.ide-tag-processing.small, .ide-tag-error.small,\n.ide-tag-warning.small, .ide-tag-disable.small {\n    height: 16px;\n    line-height: 16px;\n}\n\n.ide-tag-default.minimal, .ide-tag-closeable.minimal,\n.ide-tag-secondary.minimal, .ide-tag-success.minimal,\n.ide-tag-processing.minimal, .ide-tag-error.minimal,\n.ide-tag-warning.minimal, .ide-tag-disable.minimal {\n    height: 14px;\n    line-height: 14px;\n}\n\n.ide-tag-disable:hover .codicon-close {\n    color: ${e?"var(--vscode-icon-foreground)":n.disabledFontColor};\n    background: ${n.defaultTagBackground};\n}\n\n.ide-tag-label-disable {\n    color: ${n.disabledFontColor};\n}\n\n.ide-tag-close {\n    display: flex;\n    margin: 4px 8px 4px 0;\n}\n\n.ide-tag-close .codicon.codicon-close {\n    display: flex;\n    font-size: 12px;\n    color: ${n.secondaryFontColor};\n    background: ${n.defaultTagBackground};\n    border-radius: 10px;\n    cursor: pointer;\n}\n\n.ide-tag-disable .ide-tag-close .codicon {\n    cursor: not-allowed;\n}\n\n.ide-tag-disable .codicon-close {\n    color: ${e?"var(--vscode-icon-foreground)":n.disabledFontColor};\n    background: ${n.defaultTagBackground};\n    cursor: not-allowed;\n}\n\n.codicon-close:hover {\n    color: ${e?"var(--vscode-button-secondaryForeground)":n.secondaryButtonColor};\n    background: ${n.pressingTagBackground};\n}\n\n.ide-tag-secondary.ide-tag-closeable .codicon.codicon-close,\n.ide-tag-success.ide-tag-closeable .codicon.codicon-close,\n.ide-tag-processing.ide-tag-closeable .codicon.codicon-close,\n.ide-tag-warning.ide-tag-closeable .codicon.codicon-close,\n.ide-tag-error.ide-tag-closeable .codicon.codicon-close {\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n}\n`},3446(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.isAncestor=t.getActiveElement=t.ActionBar=t.ActionsOrientation=void 0;const o=i(7509),s=i(4523),r=i(4295),a=i(519),l=i(5),d=i(9084),c=i(5754);var u;!function(e){e[e.HORIZONTAL=0]="HORIZONTAL",e[e.VERTICAL=1]="VERTICAL",e[e.VERTICALLEFT=2]="VERTICALLEFT"}(u=t.ActionsOrientation||(t.ActionsOrientation={}));class h extends d.BaseComponent{constructor(e={}){var t,i,n,o,s,d;super(),this.triggerKeyDown=!1,this.focusable=!0,this._onDidBlur=new a.EventEmitter,this.onDidBlur=this._onDidBlur.asSubscriber("onDidBlur"),this._onDidCancel=new a.EventEmitter,this.onDidCancel=this._onDidCancel.asSubscriber("onDidCancel"),this._onDidRun=new a.EventEmitter,this.onDidRun=this._onDidRun.asSubscriber("onDidRun"),this._onBeforeRun=new a.EventEmitter,this.onBeforeRun=this._onBeforeRun.asSubscriber("onDidRun"),this.eventStore=new Set,this.dispose=()=>{this.viewItems.forEach(e=>{e.dispose()}),this.viewItems=[],this.disposableItems=[],this._actionIds=[],this.getContainer().remove(),this._onDidBlur.clear(),this._onDidCancel.clear(),this._onDidRun.clear(),this._onBeforeRun.clear(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.eventStore.clear()},this.options=e,this._context=null!==(t=e.context)&&void 0!==t?t:null,this._orientation=null!==(i=this.options.orientation)&&void 0!==i?i:u.HORIZONTAL,this._triggerKeys={keyDown:null!==(o=null===(n=this.options.triggerKeys)||void 0===n?void 0:n.keyDown)&&void 0!==o&&o,keys:null!==(d=null===(s=this.options.triggerKeys)||void 0===s?void 0:s.keys)&&void 0!==d?d:["Enter","Space"]},this.options.actionRunner?this._actionRunner=this.options.actionRunner:this._actionRunner=new r.ActionRunner,this._actionRunner.onDidRun(e=>this._onDidRun.emit("onDidRun",e)),this._actionRunner.onBeforeRun(e=>this._onBeforeRun.emit("onBeforeRun",e)),this._actionIds=[],this.viewItems=[],this.disposableItems=[],this.viewItemDisposables=new Map,this.focusedItem=void 0;const c=document.createElement("style");c.appendChild(document.createTextNode(l.ActionBarStyle)),this.domNode=document.createElement("div"),this.domNode.className="ide-action-bar",e.sideBarMode&&this.domNode.classList.add("side-bar"),!1!==e.animated&&this.domNode.classList.add("animated"),this._orientation!==u.VERTICAL&&this._orientation!==u.VERTICALLEFT||this.domNode.classList.add("vertical"),this.addKeyboardEventListeners(),this.actionsList=document.createElement("ul"),this.actionsList.className="actions-container",this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"),this.options.ariaLabel&&this.actionsList.setAttribute("aria-label",this.options.ariaLabel),this.domNode.appendChild(this.actionsList),this.shadow.appendChild(c),this.shadow.appendChild(this.domNode)}addKeyboardEventListeners(){const e=this._orientation===u.HORIZONTAL?["ArrowLeft"]:["ArrowUp"],t=this._orientation===u.HORIZONTAL?["ArrowRight"]:["ArrowDown"];this.addKeydownListener(e,t),this.addKeyupListener(),this.addFocusinAndOutListener(),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}addKeydownListener(e,t){this.eventStore.add({element:this.domNode,type:"keydown",handler:i=>{const n=i;let o=!0;e.includes(n.key)?o=this.focusPrevious():t.includes(n.key)?o=this.focusNext():"Escape"===n.key?this._onDidCancel.emit("onDidCancel"):"Home"===n.key?o=this.focusFirst():"End"===n.key?o=this.focusLast():this.isTriggerKeyEvent(n.key)?this._triggerKeys.keyDown?this.doTrigger(n.key,"keydown"):this.triggerKeyDown=!0:o=!1,o&&(i.preventDefault(),i.stopPropagation())}})}addKeyupListener(){this.eventStore.add({element:this.domNode,type:"keyup",handler:e=>{const t=e;this.isTriggerKeyEvent(t.key)?(!this._triggerKeys.keyDown&&this.triggerKeyDown&&(this.triggerKeyDown=!1,this.doTrigger(t.key,"keyup")),e.preventDefault(),e.stopPropagation()):("Tab"===t.key||"Tab"===t.key&&!0===t.shiftKey)&&this.updateFocusedItem()}})}addFocusinAndOutListener(){this.eventStore.add({element:this.domNode,type:"focusout",handler:e=>{if(void 0!==this.previouslyFocusedItem){const t=e.composedPath()[0],i=this.viewItems[this.previouslyFocusedItem];if(t===i.element)return i.blur(),void(this.previouslyFocusedItem=void 0)}this._onDidBlur.emit("onDidBlur"),this.triggerKeyDown=!1,this.focusedItem=void 0}}),this.eventStore.add({element:this.domNode,type:"focusin",handler:()=>{this.updateFocusedItem()}})}refreshRole(){this.length()>=2?this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"):this.actionsList.setAttribute("role","presentation")}setAriaLabel(e){e?this.actionsList.setAttribute("aria-label",e):this.actionsList.removeAttribute("aria-label")}setFocusable(e){if(this.focusable=e,this.focusable){const e=this.viewItems.find(e=>e instanceof r.BaseActionViewItem&&e.isEnabled());e instanceof r.BaseActionViewItem&&e.setFocusable(!0)}else this.viewItems.forEach(e=>{e instanceof r.BaseActionViewItem&&e.setFocusable(!1)})}isTriggerKeyEvent(e){let t=!1;return this._triggerKeys.keys.forEach(i=>{t=t||e===i}),t}updateFocusedItem(){var e;for(let t=0;t<this.actionsList.children.length;t++){const i=null===(e=this.actionsList.children[t].firstElementChild)||void 0===e?void 0:e.shadowRoot;if(b(p(),i)){this.focusedItem=t;break}}}get context(){return this._context}set context(e){this._context=e,this.viewItems.forEach(t=>t.setActionContext(e))}get actionRunner(){return this._actionRunner}set actionRunner(e){e&&(this._actionRunner=e,this.viewItems.forEach(t=>t.actionRunner=e))}getContainer(){return this.domNode}hasAction(e){return this._actionIds.includes(e.id)}getAction(e){return this.viewItems[e].action}push(e,t={}){const i=Array.isArray(e)?e:[e];this.setActionsConfig(i,t),"number"==typeof this.focusedItem&&this.setFocus(this.focusedItem),this.refreshRole()}setActionsConfig(e,t={}){let i=(0,s.isNumber)(t.index)?t.index:null;e.forEach(e=>{const n=document.createElement("li");let s;if(n.className="action-item",n.setAttribute("role","presentation"),e.class&&(0,c.addIconStylebyClass)(e.class,this.shadow),this.options.actionViewItemProvider&&(s=this.options.actionViewItemProvider(e)),s||(s=new o.ActionViewItem(this.context,e,Object.assign({getHoverOptions:this.options.getHoverOptions,verticalMode:this._orientation===u.VERTICAL},t))),!this.options.allowContextMenu){const e={element:n,type:"contextmenu",handler:e=>{e.stopPropagation()}};this.viewItemDisposables.set(s,e),e.element.addEventListener(e.type,e.handler)}s.actionRunner=this._actionRunner,s.setActionContext(this.context),s.render(n),this.focusable&&s instanceof r.BaseActionViewItem&&0===this.viewItems.length&&s.setFocusable(!0),null===i||i<0||i>=this.actionsList.children.length?(this.actionsList.appendChild(n),this.viewItems.push(s),this._actionIds.push(e.id)):(this.actionsList.insertBefore(n,this.actionsList.children[i]),this.viewItems.splice(i,0,s),this._actionIds.splice(i,0,e.id),i++)})}addActionViewItems(e){this.refreshActionList(),e.forEach(e=>{const t=document.createElement("li");t.className=`action-item ${h.ACTION_VIEW_ITEM_CLASS} ${e.id}`,t.setAttribute("role","presentation"),t.appendChild(e);const i=e.order;i>=0&&i<this.actionsList.children.length-1?(this.actionsList.insertBefore(t,this.actionsList.children[i]),this.viewItems.splice(i,0,e),this._actionIds.splice(i,0,e.id)):(this.actionsList.appendChild(t),this.viewItems.push(e),this._actionIds.push(e.id))})}removeActionViewItems(e){e.forEach(e=>{const t=Array.from(this.actionsList.querySelectorAll(".action-item")).findIndex(t=>t.className.includes(e.id));this.deleteActionItem(t)}),this.refreshActionList()}deleteActionItem(e){var t;e>-1&&(this.actionsList.removeChild(this.actionsList.childNodes[e]),null===(t=this.viewItems[e])||void 0===t||t.dispose(),this.viewItems.splice(e,1),this._actionIds.splice(e,1))}refreshActionList(){Array.from(this.actionsList.querySelectorAll(".action-item")).forEach((e,t)=>{e.children.length||this.deleteActionItem(t)})}getWidth(e){if(e>=0&&e<this.actionsList.children.length){const t=this.actionsList.children.item(e);if(t)return t.getBoundingClientRect().width}return 0}getHeight(e){if(e>=0&&e<this.actionsList.children.length){const t=this.actionsList.children.item(e);if(t)return t.clientHeight}return 0}pull(e,t=!0){if(e>=0&&e<this.viewItems.length){this.actionsList.removeChild(this.actionsList.childNodes[e]);const i=this.viewItemDisposables.get(this.viewItems[e]);null==i||i.element.removeEventListener(i.type,i.handler),this.viewItemDisposables.delete(this.viewItems[e]);const n=this.viewItems.splice(e,1);if(this._actionIds.splice(e,1),this.refreshRole(),!t)return this.disposableItems.push(n[0]),n[0];n.forEach(e=>{e.dispose()})}}clear(){for(this.viewItems.forEach(e=>{e.dispose()}),this.viewItemDisposables.forEach(e=>{e.element.removeEventListener(e.type,e.handler)}),this.viewItemDisposables.clear(),this.viewItems=[],this._actionIds=[];this.actionsList.firstChild;)this.actionsList.firstChild.remove();this.refreshRole()}length(){return this.viewItems.length}isEmpty(){return 0===this.viewItems.length}setFocus(e){let t,i=!1;if(void 0===e?i=!0:"number"==typeof e?t=e:"boolean"==typeof e&&(i=e),i&&void 0===this.focusedItem){const e=this.viewItems.findIndex(e=>e.isEnabled());this.focusedItem=-1===e?void 0:e,this.updateFocus(void 0,void 0,!0)}else void 0!==t&&(this.focusedItem=t),this.updateFocus(void 0,void 0,!0)}focusFirst(){return this.focusedItem=this.length()-1,this.focusNext(!0)}focusLast(){return this.focusedItem=0,this.focusPrevious(!0)}focusNext(e){if(void 0===this.focusedItem)this.focusedItem=this.viewItems.length-1;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(!e&&this.options.preventLoopNavigation&&this.focusedItem+1>=this.viewItems.length)return this.focusedItem=t,!1;this.focusedItem=(this.focusedItem+1)%this.viewItems.length,i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===r.SEPARATOR_ID));return this.updateFocus(),!0}focusPrevious(e){if(void 0===this.focusedItem)this.focusedItem=0;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(this.focusedItem=this.focusedItem-1,this.focusedItem<0){if(!e&&this.options.preventLoopNavigation)return this.focusedItem=t,!1;this.focusedItem=this.viewItems.length-1}i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===r.SEPARATOR_ID));return this.updateFocus(!0),!0}updateFocus(e,t,i=!1){var n;void 0===this.focusedItem&&this.actionsList.focus({preventScroll:t}),void 0!==this.previouslyFocusedItem&&this.previouslyFocusedItem!==this.focusedItem&&(null===(n=this.viewItems[this.previouslyFocusedItem])||void 0===n||n.blur());const o=void 0!==this.focusedItem&&this.viewItems[this.focusedItem];if(o){let n=!0;"function"!=typeof o.focus&&(n=!1),this.options.focusOnlyEnabledItems&&"function"==typeof o.isEnabled&&!o.isEnabled()&&(n=!1),o.action.id===r.SEPARATOR_ID&&(n=!1),n?(i||this.previouslyFocusedItem!==this.focusedItem)&&(o.focus(e),this.previouslyFocusedItem=this.focusedItem):(this.actionsList.focus({preventScroll:t}),this.previouslyFocusedItem=void 0)}}doTrigger(e,t){if(void 0===this.focusedItem)return;const i=new KeyboardEvent(t,{key:e}),n=this.viewItems[this.focusedItem],o=null===n._context||void 0===n._context?i:n._context;this.run(n._action,o)}run(e,t){return n(this,void 0,void 0,function*(){yield this._actionRunner.run(e,t)})}}function p(){let e=document.activeElement;for(;null==e?void 0:e.shadowRoot;)e=e.shadowRoot.activeElement;return e}function b(e,t){for(;e;){if(e===t)return!0;e=e.parentNode}return!1}t.ActionBar=h,h.ACTION_VIEW_ITEM_CLASS="extViewItem",t.getActiveElement=p,t.isAncestor=b,(0,d.defineCustomElement)("ide-action-bar",h)},3731(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getLinkStyle=void 0;const n=i(6199);t.getLinkStyle=e=>`\n:host {\n    display: inline-block;\n    line-height: 0;\n}\n.container {\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n}\n.ui-link {\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden; \n\tfont-size: ${n.fontSize.buttonText};\n    text-align: left;\n    line-height: 18px;\n    cursor: pointer;\n} \n.ui-link[linktype=default] {\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n}\n.ui-link[linktype=primary] {\n    color: ${e?"var(--vscode-textLink-foreground)":n.primaryColor};\n}\n.ui-link[linktype=danger] {\n    color: ${e?"var(--vscode-testing-iconErrored)":n.errorStatusColor};\n}\n.ui-link[linktype=primary]:hover,\n.ui-link[linktype=default]:hover {\n    color: ${e?"var(--vscode-textLink-activeForeground)":n.linkFontColorHover};\n    text-decoration: underline;\n}\n.ui-link[linktype=danger]:hover {\n    color: ${e?"var(--vscode-inputValidation-errorForeground)":n.dangerButtonHoverBackground};\n    text-decoration: underline;\n}\n.ui-link[linktype=primary]:focus,\n.ui-link[linktype=default]:focus,\n.ui-link[linktype=primary]:active,\n.ui-link[linktype=default]:active {\n    color: ${e?"var(--vscode-textLink-activeForeground)":n.linkFontColorActive};\n    text-decoration: underline;\n}\n.ui-link[linktype=danger]:focus,\n.ui-link[linktype=danger]:active {\n    color: ${e?"var(--vscode-inputValidation-errorForeground)":n.dangerButtonClickBackground};\n    text-decoration: underline;\n}\n.container .ui-link.disabled-link {\n    cursor: not-allowed;\n}\n.container .ui-link.disabled-link:hover,\n.container .ui-link.disabled-link {\n    text-decoration: none;\n    user-select: none;\n}\n.container .ui-link.disabled-link[linktype=primary] {\n    color: ${e?"var(--vscode-textLink-foreground)":n.primaryColorDisabled};\n    opacity: ${e?"0.4":""};\n}\n.container .ui-link.disabled-link[linktype=default] {\n    color: ${e?"var(--vscode-textLink-foreground)":n.inputBoxPlaceholderTextColor};\n    opacity: ${e?"0.4":""};\n}\n.container .ui-link.disabled-link[linktype=danger] {\n    color: ${e?"var(--vscode-testing-iconErrored)":n.dangerSecondaryButtonDisabledColor};\n    opacity: ${e?"0.4":""};\n}\n.codicon.codicon-chevron-right {\n    margin-left: 8px;\n    color: ${n.diffRemoveUp};\n    align-self: end;\n}\n.codicon.codicon-chevron-right.disabled-link {\n    color: ${n.selectClearHoverColor};\n}\n.ui-link:focus {\n    outline: none;\n}\n`},3750(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ScrollbarVisibilityController=void 0;const n=i(5731);t.ScrollbarVisibilityController=class{constructor(e,t,i){this._revealTimer=void 0,this._visibility=e,this._visibleClassName=t,this._invisibleClassName=i,this._domNode=null,this._isVisible=!1,this._isNeeded=!1,this._rawShouldBeVisible=!1,this._shouldBeVisible=!1}setVisibility(e){this._visibility!==e&&(this._visibility=e,this._updateShouldBeVisible())}setShouldBeVisible(e){this._rawShouldBeVisible=e,this._updateShouldBeVisible()}_applyVisibilitySetting(){return this._visibility!==n.ScrollbarVisibility.Hidden&&(this._visibility===n.ScrollbarVisibility.Visible||this._rawShouldBeVisible)}_updateShouldBeVisible(){const e=this._applyVisibilitySetting();this._shouldBeVisible!==e&&(this._shouldBeVisible=e,this.ensureVisibility())}setIsNeeded(e){this._isNeeded!==e&&(this._isNeeded=e,this.ensureVisibility())}setDomNode(e){this._domNode=e,this._domNode.className=this._invisibleClassName,this.setShouldBeVisible(!1)}ensureVisibility(){this._isNeeded?this._shouldBeVisible?this._reveal():this._hide(!0):this._hide(!1)}_reveal(){this._isVisible||(this._isVisible=!0,this._revealTimer||(this._revealTimer=setTimeout(()=>{this._domNode&&this._domNode.className!==this._visibleClassName&&(this._domNode.className=this._visibleClassName),this._revealTimer=void 0},0)))}_hide(e){if(this._revealTimer&&(clearTimeout(this._revealTimer),this._revealTimer=void 0),!this._isVisible)return;this._isVisible=!1;const t=this._invisibleClassName+(e?" fade":"");this._domNode&&this._domNode.className!==t&&(this._domNode.className=t)}}},3814(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.HighlightedLabel=t.iconStartmarked=void 0;const n=i(4523),o=i(9084),s=i(5754),r=i(2994),a=i(5366),l=i(5354);t.iconStartmarked="$(";class d extends o.BaseComponent{constructor(e){var t;super(),this.text="",this.subTitle="",this.highlights=[],this.everyRendered=!1,this.dispose=()=>{},this.initOptions(e),this.addStyleSheet();const i=document.createElement("span");i.classList.add("ide-highlighted-label"),this.domNode=document.createElement("div"),this.domNode.classList.add("ide-highlighted-container"),this.domNode.appendChild(i),this.shadow.appendChild(this.domNode),this.set(this.options.text,null===(t=this.options)||void 0===t?void 0:t.highlights,this.options.title,this.options.escapeNewLines)}initOptions(e){var t,i,n,o,s;const r=e||{},{supportIcons:a=this.hasAttribute("supportIcons"),text:l=(null!==(t=this.textContent)&&void 0!==t?t:""),title:d=(null!==(i=this.getAttribute("title"))&&void 0!==i?i:""),iconColor:c=(null!==(n=this.getAttribute("iconColor"))&&void 0!==n?n:""),escapeNewLines:u=this.hasAttribute("escapeNewLines")}=r;this.options=Object.assign({supportIcons:a,text:l,title:d,iconColor:c,escapeNewLines:u},e),this.supportIcons=null!==(s=null===(o=this.options)||void 0===o?void 0:o.supportIcons)&&void 0!==s&&s,this.checkHighlightsType()}checkHighlightsType(){const e=this.options.highlights;e&&(0,a.checkHighlightsType)(e)}addStyleSheet(){const e=document.createElement("style");e.appendChild(document.createTextNode((0,r.getHightLightedStyle)(l.ideChecker.isIDE))),this.shadow.appendChild(e)}render(e){const t=[];let i=0;for(const n of this.highlights){if(n.end===n.start)continue;if(i<n.start){const o=this.text.substring(i,n.start),r=document.createElement("span");r.classList.add("highlighted-start-span"),r.append(...this.supportIcons?(0,s.renderLabelWithIcons)(o,this.shadow,this.options.iconColor?this.options.iconColor:e):[o]),t.push(r),i=n.end}const o=this.text.substring(n.start,n.end),r=document.createElement("span");r.classList.add("highlight"),r.append(...this.supportIcons?(0,s.renderLabelWithIcons)(o,this.shadow,this.options.iconColor?this.options.iconColor:e):[o]),n.extraClasses&&r.classList.add(...n.extraClasses),t.push(r),i=n.end}if(i<this.text.length){const n=this.text.substring(i),o=document.createElement("span");o.classList.add("highlighted-span-container"),o.append(...this.supportIcons?(0,s.renderLabelWithIcons)(n,this.shadow,this.options.iconColor?this.options.iconColor:e):[n]),t.push(o)}this.domNode.innerText="",this.domNode.append(...t),this.subTitle?this.domNode.setAttribute("title",this.subTitle):this.domNode.removeAttribute("title"),this.everyRendered=!0}static escapeNewLines(e,t){let i=0,n=0;return e.replace(/\r\n|\r|\n/g,(e,o)=>{n="\r\n"===e?-1:0,o+=i;for(const e of t)e.end<=o||(e.start>=o&&(e.start+=n),e.end>=o&&(e.end+=n));return i+=n,"⏎"})}get element(){return this.domNode}set(e,t=[],i="",o,s){e||(e=""),o&&(e=d.escapeNewLines(e,t)),this.everyRendered&&this.text===e&&this.subTitle===i&&n.isEqual(this.highlights,t)||(this.text=e,this.subTitle=i,this.highlights=t,this.render(s))}setFontFamily(e){e&&(this.domNode.style.fontFamily=e)}get label(){var e,t;return null!==(t=null===(e=this.domNode.textContent)||void 0===e?void 0:e.trim())&&void 0!==t?t:""}get iconlabel(){return this.text}}t.HighlightedLabel=d,(0,o.defineCustomElement)("ide-highlighted-label",d)},4183(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Empty=void 0;const n=i(9084),o=i(4835),s=i(5354),r=i(5754),a=i(7725);class l extends n.BaseComponent{constructor(e){var t,i,n,o;super(),this._customClass="",this._show=!1,this._text=null!==(t=null==e?void 0:e.text)&&void 0!==t?t:"No Related Data",this._icon=null!==(i=null==e?void 0:e.icon)&&void 0!==i?i:{id:"no-data"},this._customClass=null!==(n=null==e?void 0:e.customClass)&&void 0!==n?n:"",this._show=null!==(o=null==e?void 0:e.show)&&void 0!==o&&o,this.render()}get text(){var e;return null!==(e=this.getAttribute("text"))&&void 0!==e?e:this._text}set text(e){this._text=e,this.setAttribute("text",e),this.textElement.textContent=e}get icon(){return this._icon}set icon(e){this._icon=e,this.renderEmptyIcon()}get show(){return this._show}set show(e){this._show=e,this.element.classList.toggle("show",e)}render(){this.iconElement=(0,o.createElement)(".ide-empty-icon",{},(0,r.renderIcon)(this._icon,this.shadow)),this.textElement=(0,o.createElement)(".ide-empty-text",{},this.text),this.element=(0,o.createElement)(`.ide-empty ${this._customClass} ${this.show?"show":""}`,{},this.iconElement,this.textElement);const e=(0,o.createStyles)((0,a.getEmptyStyle)(s.ideChecker.isIDE));this.shadow.append(e,this.element)}renderEmptyIcon(){(0,o.clearNode)(this.iconElement),this.iconElement.append((0,r.renderIcon)(this._icon,this.shadow))}dispose(){}}t.Empty=l,(0,n.defineCustomElement)("ide-empty",l)},4275(e,t,i){"use strict";var n=this&&this.__decorate||function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r},o=this&&this.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},s=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.PluginPage=t.AbstractFrontend=void 0;const r=i(7651),a=i(5483),l=acquireCloudidePluginApi();class d{constructor(e){this.plugin=e}}t.AbstractFrontend=d;class c{constructor(e,t){this.domInitialized=new r.Deferred,this.isReady=new r.Deferred,this.registeredEventHandlers=new Map,this.frontends=new Map,this.registeredContextMenu=new Map,this.pluginPageContext=e,this.cloudidePluginApi=l,this.extensionPath=this.cloudidePluginApi.getExtensionPath(),t=[...new Set(t)];const i=this.pluginPageContext.window.document;i.addEventListener("keydown",e=>{switch(e.key){case"F1":case"F5":e.preventDefault()}}),"loading"===i.readyState?i.addEventListener("DOMContentLoaded",()=>{this.domInitialized.resolve(!0)}):this.domInitialized.resolve(!0),this.initApi(this,t)}ready(){return s(this,void 0,void 0,function*(){return(yield this.domInitialized.promise)&&this.syncInitializedStatus(),this.isReady.promise})}syncInitializedStatus(){return s(this,void 0,void 0,function*(){this._call("plugin.onPageInit",l.getViewType(),!0).then(e=>{this.isReady.resolve(e)}).catch(e=>{console.error(e),this.isReady.resolve(!1)})})}_call(e,...t){return s(this,void 0,void 0,function*(){const i=r.Messaging.getInstance();return!!i&&(e=e.indexOf("::")>=0?e:`backend::${e}`,i.call(e,...t))})}initApi(e,t){return s(this,void 0,void 0,function*(){t.push(h),t.forEach(t=>{if(!this.frontends.get(t)){const i=new t(e);this.frontends.set(t,i)}});const i=[],n=this.frontends.values();let o;for(;o=n.next(),!o.done;)i.push(o.value.init());yield Promise.all(i),yield this.ready(),this.frontends.forEach(e=>{e.run()})})}static create(e){return this.instance&&this.instance.pluginPageContext||(this.instance=new c(new u(window),e)),this.instance}static getInstance(){return this.instance}getFrontend(e){return this.frontends.get(e)}getAllFrontend(){return this.frontends}onEvent(e,t){const i=this.registeredEventHandlers.get(e);i&&i.forEach(i=>{i(e,t)})}localize(e,...t){var i;const n=null===(i=this.cloudidePluginApi.getI18n())||void 0===i?void 0:i.l10n[e];return n?(0,a.format)(n,t):""}call(e,...t){return s(this,void 0,void 0,function*(){let i=e;if("string"!=typeof e&&(i=e.name),i.startsWith("theia.")||i.startsWith("cloudide.")||i.startsWith("codearts.")){const e=i.split(".").slice(1);return e.push(...t),this._call("codearts",...e)}return this._call(i,...t)})}subscribeEvent(e,t){return s(this,void 0,void 0,function*(){yield this.call("plugin.subscribeEvent",e);const i=this.registeredEventHandlers.get(e);if(i)i.push(t);else{const i=[t];this.registeredEventHandlers.set(e,i)}})}unsubscribeEvent(e,t){return s(this,void 0,void 0,function*(){yield this.call("plugin.unsubscribeEvent",e);const i=this.registeredEventHandlers.get(e);i&&i.splice(i.indexOf(t),1)})}unsubscribeAllEvents(){return s(this,void 0,void 0,function*(){for(const e of this.registeredEventHandlers.keys())yield this.call("plugin.unsubscribeEvent",e);this.registeredEventHandlers.clear()})}log(e,t){return s(this,void 0,void 0,function*(){this.call("plugin.log",e.valueOf(),t)})}toWebviewResource(e){return`theia-resource/file${this.extensionPath}/${e}`.split(/\/+/).join("/")}createDynamicWebview(e,t){return s(this,void 0,void 0,function*(){return this.call("plugin.createDynamicWebview",e,t)})}disposeDynamicWebview(e){return s(this,void 0,void 0,function*(){return this.call("plugin.disposeDynamicWebview",e)})}createWebviewPanel(e,t){return s(this,void 0,void 0,function*(){return this.call("plugin.createWebviewPanel",e,t)})}createWebviewViewDialog(e){return s(this,void 0,void 0,function*(){return this.call("plugin.createWebviewViewDialog",e)})}registerProjectWizardProvider(e){return s(this,void 0,void 0,function*(){return this.call("plugin.registerProjectWizardProvider",e)})}disposeWebviewContainer(e){return s(this,void 0,void 0,function*(){return this.call("plugin.disposeWebviewContainer",e)})}executeCommand(e,...t){return s(this,void 0,void 0,function*(){return this.call("cloudide.commands.executeCommand",e,...t)})}registerContextMenu(e,t,i){const n=this.registeredContextMenu.get(e);n&&(e.removeEventListener("contextmenu",n),this.registeredContextMenu.delete(e));const o=e=>{const n=e.menu;e.menu=i?n||t?[...n||[],...t||[]]:n:t};this.registeredContextMenu.set(e,o),e.addEventListener("contextmenu",o)}}t.PluginPage=c;let u=class{constructor(e){this.initialized=new r.Deferred,this.window=e,this.window.onunload=e=>{this.disposedEventHandler&&this.disposedEventHandler(e)},this.vscodeApi=acquireVsCodeApi()}onDispose(e){this.disposedEventHandler=e}registerMessageHandler(e){this.handleMessage=e;const t=this.handleMessage;this.window.addEventListener("message",e=>{t(e.data)})}postMessage(e){this.vscodeApi?this.vscodeApi.postMessage(e):this.window.parent.postMessage(e,"*")}};u=n([(0,r.messaging)(l.getViewType()),o("design:paramtypes",[Window])],u);let h=class extends d{init(){return s(this,void 0,void 0,function*(){})}run(){}stop(){}onEvent(e,t){this.plugin.onEvent(e,t)}};n([(0,r.expose)("plugin.page.onEvent"),o("design:type",Function),o("design:paramtypes",[String,Object]),o("design:returntype",void 0)],h.prototype,"onEvent",null),h=n([r.exposable],h)},4293(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Radio=t.DirectionType=t.RadioGroup=void 0;var n=i(6904);Object.defineProperty(t,"RadioGroup",{enumerable:!0,get:function(){return n.RadioGroup}}),Object.defineProperty(t,"DirectionType",{enumerable:!0,get:function(){return n.DirectionType}});var o=i(1854);Object.defineProperty(t,"Radio",{enumerable:!0,get:function(){return o.Radio}})},4295(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.BaseActionViewItem=t.ActionRunner=t.Action=t.SEPARATOR_ID=void 0;const o=i(519),s=i(9084),r=i(4523);t.SEPARATOR_ID="ide.actions.separator";class a{constructor(e,t="",i="",n=!0,s){this._onDidChange=new o.EventEmitter,this.onDidChange=this._onDidChange.asSubscriber("onDidChange"),this._enabled=!0,this.dispose=()=>{this._onDidChange.clear()},this._id=e,this._label=t,this._cssClass=i,this._enabled=n,this._actionCallback=s}get id(){return this._id}get label(){return this._label}set label(e){this._setLabel(e)}_setLabel(e){this._label!==e&&(this._label=e,this._onDidChange.emit("onDidChange",{label:e}))}get tooltip(){return this._tooltip||""}set tooltip(e){this._setTooltip(e)}_setTooltip(e){this._tooltip!==e&&(this._tooltip=e,this._onDidChange.emit("onDidChange",{tooltip:e}))}get class(){return this._cssClass}set class(e){this._setClass(e)}_setClass(e){this._cssClass!==e&&(this._cssClass=e,this._onDidChange.emit("onDidChange",{class:e}))}get enabled(){return this._enabled}set enabled(e){this._setEnabled(e)}_setEnabled(e){this._enabled!==e&&(this._enabled=e,this._onDidChange.emit("onDidChange",{enabled:e}))}get checked(){return this._checked}set checked(e){this._setChecked(e)}_setChecked(e){this._checked!==e&&(this._checked=e,this._onDidChange.emit("onDidChange",{checked:e}))}run(e){return n(this,void 0,void 0,function*(){this._actionCallback&&(yield this._actionCallback(e))})}}t.Action=a;class l{constructor(){this._onBeforeRun=new o.EventEmitter,this.onBeforeRun=this._onBeforeRun.asSubscriber("onBeforeRun"),this._onDidRun=new o.EventEmitter,this.onDidRun=this._onDidRun.asSubscriber("onDidRun"),this.dispose=()=>{this._onBeforeRun.clear(),this._onDidRun.clear()}}run(e,t){return n(this,void 0,void 0,function*(){if(!e.enabled)return;let i;this._onBeforeRun.emit("onBeforeRun",{action:e});try{yield this.runAction(e,t)}catch(e){i=e}this._onDidRun.emit("onDidRun",{action:e,error:i})})}runAction(e,t){return n(this,void 0,void 0,function*(){yield e.run(t)})}}t.ActionRunner=l;class d extends s.BaseComponent{get action(){return this._action}constructor(e,t,i={}){super(),this.options=i,this.eventStore=new Set,this._context=e||this,this._action=t,t instanceof a&&t.onDidChange(e=>{this.element&&this.handleActionChangeEvent(e)})}handleActionChangeEvent(e){void 0!==e.enabled&&this.updateEnabled(),void 0!==e.checked&&this.updateChecked(),void 0!==e.class&&this.updateClass(),void 0!==e.label&&(this.updateLabel(),this.updateTooltip()),void 0!==e.tooltip&&this.updateTooltip()}get order(){var e;return null!==(e=this._action.order)&&void 0!==e?e:0}get actionRunner(){return this._actionRunner||(this._actionRunner=new l),this._actionRunner}set actionRunner(e){this._actionRunner=e}getAction(){return this._action}isEnabled(){return this._action.enabled}setActionContext(e){this._context=e}render(e){this.element=e;const t=this.element;this.enableDragging=this.options&&this.options.draggable,this.enableDragging&&(e.draggable=!0,this.addDragStartHandler(this.element)),this.addMouseDownHandler(this.element,t),this.addClickHandler(this.element),this.addDoubleClickHandler(this.element),this.addMouseUpAndOutHandler(this.element,t),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}addDragStartHandler(e){this.eventStore.add({element:e,type:"dragstart",handler:e=>{var t;null===(t=e.dataTransfer)||void 0===t||t.setData("text/plain",this._action.label)}})}addMouseDownHandler(e,t){this.eventStore.add({element:e,type:"mousedown",handler:e=>{this.enableDragging||e.stopPropagation(),this._action.enabled&&0===e.button&&t.classList.add("active")}})}addClickHandler(e){this.eventStore.add({element:e,type:"click",handler:e=>{var t;(null===(t=this.options)||void 0===t?void 0:t.isMenu)||this.onClick(e)}})}addDoubleClickHandler(e){this.eventStore.add({element:e,type:"dblclick",handler:e=>{e.stopPropagation()}})}addMouseUpAndOutHandler(e,t){["mouseup","mouseout"].forEach(i=>{e&&this.eventStore.add({element:e,type:i,handler:e=>{e.preventDefault(),t.classList.remove("active")}})})}onClick(e,t=!1){var i;let n;e.stopPropagation(),n=(0,r.isUndefined)(this._context)||null===this._context?(null===(i=this.options)||void 0===i?void 0:i.useEventAsContext)?e:{preserveFocus:t}:this._context,this.actionRunner.run(this._action,n)}focus(){this.element&&(this.element.tabIndex=0,this.element.focus(),this.element.classList.add("focused"))}isFocused(){var e;return!!(null===(e=this.element)||void 0===e?void 0:e.classList.contains("focused"))}blur(){this.element&&(this.element.blur(),this.element.tabIndex=-1,this.element.classList.remove("focused"))}setFocusable(e){this.element&&(this.element.tabIndex=e?0:-1)}updateEnabled(){}updateLabel(){}updateTooltip(){}updateClass(){}updateChecked(){}dispose(){this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.eventStore.clear(),this.disconnectedCallback()}}t.BaseActionViewItem=d},4523(e,t,i){"use strict";i.r(t),i.d(t,{VERSION:()=>o,after:()=>Ot,all:()=>ei,allKeys:()=>ge,any:()=>ti,assign:()=>Oe,before:()=>Mt,bind:()=>kt,bindAll:()=>Dt,chain:()=>ft,chunk:()=>$i,clone:()=>Pe,collect:()=>Xt,compact:()=>Si,compose:()=>Tt,constant:()=>Q,contains:()=>ii,countBy:()=>gi,create:()=>$e,debounce:()=>Bt,default:()=>Wi,defaults:()=>Me,defer:()=>_t,delay:()=>At,detect:()=>jt,difference:()=>_i,drop:()=>Ei,each:()=>qt,escape:()=>rt,every:()=>ei,extend:()=>Te,extendOwn:()=>Oe,filter:()=>Qt,find:()=>jt,findIndex:()=>Rt,findKey:()=>$t,findLastIndex:()=>zt,findWhere:()=>Gt,first:()=>Ci,flatten:()=>Ai,foldl:()=>Yt,foldr:()=>Zt,forEach:()=>qt,functions:()=>Fe,get:()=>Ve,groupBy:()=>bi,has:()=>Ue,head:()=>Ci,identity:()=>je,include:()=>ii,includes:()=>ii,indexBy:()=>mi,indexOf:()=>Vt,initial:()=>ki,inject:()=>Yt,intersection:()=>Li,invert:()=>Be,invoke:()=>ni,isArguments:()=>K,isArray:()=>G,isArrayBuffer:()=>$,isBoolean:()=>_,isDataView:()=>j,isDate:()=>T,isElement:()=>I,isEmpty:()=>le,isEqual:()=>me,isError:()=>M,isFinite:()=>Y,isFunction:()=>z,isMap:()=>Ee,isMatch:()=>de,isNaN:()=>Z,isNull:()=>S,isNumber:()=>L,isObject:()=>D,isRegExp:()=>O,isSet:()=>Se,isString:()=>F,isSymbol:()=>N,isTypedArray:()=>oe,isUndefined:()=>A,isWeakMap:()=>De,isWeakSet:()=>Ae,iteratee:()=>Ye,keys:()=>ae,last:()=>Di,lastIndexOf:()=>Ut,map:()=>Xt,mapObject:()=>Qe,matcher:()=>Ge,matches:()=>Ge,max:()=>ri,memoize:()=>St,methods:()=>Fe,min:()=>ai,mixin:()=>Ri,negate:()=>Lt,noop:()=>Je,now:()=>nt,object:()=>Mi,omit:()=>yi,once:()=>Nt,pairs:()=>Ie,partial:()=>yt,partition:()=>vi,pick:()=>xi,pluck:()=>oi,property:()=>qe,propertyOf:()=>et,random:()=>it,range:()=>Ni,reduce:()=>Yt,reduceRight:()=>Zt,reject:()=>Jt,rest:()=>Ei,restArguments:()=>E,result:()=>mt,sample:()=>ci,select:()=>Qt,shuffle:()=>ui,size:()=>fi,some:()=>ti,sortBy:()=>hi,sortedIndex:()=>Ht,tail:()=>Ei,take:()=>Ci,tap:()=>Re,template:()=>bt,templateSettings:()=>lt,throttle:()=>It,times:()=>tt,toArray:()=>di,toPath:()=>ze,transpose:()=>Ti,unescape:()=>at,union:()=>Fi,uniq:()=>Bi,unique:()=>Bi,uniqueId:()=>vt,unzip:()=>Ti,values:()=>_e,where:()=>si,without:()=>Ii,wrap:()=>Ft,zip:()=>Oi});var n={};i.r(n),i.d(n,{VERSION:()=>o,after:()=>Ot,all:()=>ei,allKeys:()=>ge,any:()=>ti,assign:()=>Oe,before:()=>Mt,bind:()=>kt,bindAll:()=>Dt,chain:()=>ft,chunk:()=>$i,clone:()=>Pe,collect:()=>Xt,compact:()=>Si,compose:()=>Tt,constant:()=>Q,contains:()=>ii,countBy:()=>gi,create:()=>$e,debounce:()=>Bt,default:()=>zi,defaults:()=>Me,defer:()=>_t,delay:()=>At,detect:()=>jt,difference:()=>_i,drop:()=>Ei,each:()=>qt,escape:()=>rt,every:()=>ei,extend:()=>Te,extendOwn:()=>Oe,filter:()=>Qt,find:()=>jt,findIndex:()=>Rt,findKey:()=>$t,findLastIndex:()=>zt,findWhere:()=>Gt,first:()=>Ci,flatten:()=>Ai,foldl:()=>Yt,foldr:()=>Zt,forEach:()=>qt,functions:()=>Fe,get:()=>Ve,groupBy:()=>bi,has:()=>Ue,head:()=>Ci,identity:()=>je,include:()=>ii,includes:()=>ii,indexBy:()=>mi,indexOf:()=>Vt,initial:()=>ki,inject:()=>Yt,intersection:()=>Li,invert:()=>Be,invoke:()=>ni,isArguments:()=>K,isArray:()=>G,isArrayBuffer:()=>$,isBoolean:()=>_,isDataView:()=>j,isDate:()=>T,isElement:()=>I,isEmpty:()=>le,isEqual:()=>me,isError:()=>M,isFinite:()=>Y,isFunction:()=>z,isMap:()=>Ee,isMatch:()=>de,isNaN:()=>Z,isNull:()=>S,isNumber:()=>L,isObject:()=>D,isRegExp:()=>O,isSet:()=>Se,isString:()=>F,isSymbol:()=>N,isTypedArray:()=>oe,isUndefined:()=>A,isWeakMap:()=>De,isWeakSet:()=>Ae,iteratee:()=>Ye,keys:()=>ae,last:()=>Di,lastIndexOf:()=>Ut,map:()=>Xt,mapObject:()=>Qe,matcher:()=>Ge,matches:()=>Ge,max:()=>ri,memoize:()=>St,methods:()=>Fe,min:()=>ai,mixin:()=>Ri,negate:()=>Lt,noop:()=>Je,now:()=>nt,object:()=>Mi,omit:()=>yi,once:()=>Nt,pairs:()=>Ie,partial:()=>yt,partition:()=>vi,pick:()=>xi,pluck:()=>oi,property:()=>qe,propertyOf:()=>et,random:()=>it,range:()=>Ni,reduce:()=>Yt,reduceRight:()=>Zt,reject:()=>Jt,rest:()=>Ei,restArguments:()=>E,result:()=>mt,sample:()=>ci,select:()=>Qt,shuffle:()=>ui,size:()=>fi,some:()=>ti,sortBy:()=>hi,sortedIndex:()=>Ht,tail:()=>Ei,take:()=>Ci,tap:()=>Re,template:()=>bt,templateSettings:()=>lt,throttle:()=>It,times:()=>tt,toArray:()=>di,toPath:()=>ze,transpose:()=>Ti,unescape:()=>at,union:()=>Fi,uniq:()=>Bi,unique:()=>Bi,uniqueId:()=>vt,unzip:()=>Ti,values:()=>_e,where:()=>si,without:()=>Ii,wrap:()=>Ft,zip:()=>Oi});var o="1.13.7",s="object"==typeof self&&self.self===self&&self||"object"==typeof i.g&&i.g.global===i.g&&i.g||Function("return this")()||{},r=Array.prototype,a=Object.prototype,l="undefined"!=typeof Symbol?Symbol.prototype:null,d=r.push,c=r.slice,u=a.toString,h=a.hasOwnProperty,p="undefined"!=typeof ArrayBuffer,b="undefined"!=typeof DataView,m=Array.isArray,g=Object.keys,v=Object.create,f=p&&ArrayBuffer.isView,w=isNaN,x=isFinite,y=!{toString:null}.propertyIsEnumerable("toString"),k=["valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"],C=Math.pow(2,53)-1;function E(e,t){return t=null==t?e.length-1:+t,function(){for(var i=Math.max(arguments.length-t,0),n=Array(i),o=0;o<i;o++)n[o]=arguments[o+t];switch(t){case 0:return e.call(this,n);case 1:return e.call(this,arguments[0],n);case 2:return e.call(this,arguments[0],arguments[1],n)}var s=Array(t+1);for(o=0;o<t;o++)s[o]=arguments[o];return s[t]=n,e.apply(this,s)}}function D(e){var t=typeof e;return"function"===t||"object"===t&&!!e}function S(e){return null===e}function A(e){return void 0===e}function _(e){return!0===e||!1===e||"[object Boolean]"===u.call(e)}function I(e){return!(!e||1!==e.nodeType)}function B(e){var t="[object "+e+"]";return function(e){return u.call(e)===t}}const F=B("String"),L=B("Number"),T=B("Date"),O=B("RegExp"),M=B("Error"),N=B("Symbol"),$=B("ArrayBuffer");var P=B("Function"),R=s.document&&s.document.childNodes;"object"!=typeof Int8Array&&"function"!=typeof R&&(P=function(e){return"function"==typeof e||!1});const z=P,H=B("Object");var W=b&&(!/\[native code\]/.test(String(DataView))||H(new DataView(new ArrayBuffer(8)))),V="undefined"!=typeof Map&&H(new Map),U=B("DataView");const j=W?function(e){return null!=e&&z(e.getInt8)&&$(e.buffer)}:U,G=m||B("Array");function q(e,t){return null!=e&&h.call(e,t)}var X=B("Arguments");!function(){X(arguments)||(X=function(e){return q(e,"callee")})}();const K=X;function Y(e){return!N(e)&&x(e)&&!isNaN(parseFloat(e))}function Z(e){return L(e)&&w(e)}function Q(e){return function(){return e}}function J(e){return function(t){var i=e(t);return"number"==typeof i&&i>=0&&i<=C}}function ee(e){return function(t){return null==t?void 0:t[e]}}const te=ee("byteLength"),ie=J(te);var ne=/\[object ((I|Ui)nt(8|16|32)|Float(32|64)|Uint8Clamped|Big(I|Ui)nt64)Array\]/;const oe=p?function(e){return f?f(e)&&!j(e):ie(e)&&ne.test(u.call(e))}:Q(!1),se=ee("length");function re(e,t){t=function(e){for(var t={},i=e.length,n=0;n<i;++n)t[e[n]]=!0;return{contains:function(e){return!0===t[e]},push:function(i){return t[i]=!0,e.push(i)}}}(t);var i=k.length,n=e.constructor,o=z(n)&&n.prototype||a,s="constructor";for(q(e,s)&&!t.contains(s)&&t.push(s);i--;)(s=k[i])in e&&e[s]!==o[s]&&!t.contains(s)&&t.push(s)}function ae(e){if(!D(e))return[];if(g)return g(e);var t=[];for(var i in e)q(e,i)&&t.push(i);return y&&re(e,t),t}function le(e){if(null==e)return!0;var t=se(e);return"number"==typeof t&&(G(e)||F(e)||K(e))?0===t:0===se(ae(e))}function de(e,t){var i=ae(t),n=i.length;if(null==e)return!n;for(var o=Object(e),s=0;s<n;s++){var r=i[s];if(t[r]!==o[r]||!(r in o))return!1}return!0}function ce(e){return e instanceof ce?e:this instanceof ce?void(this._wrapped=e):new ce(e)}function ue(e){return new Uint8Array(e.buffer||e,e.byteOffset||0,te(e))}ce.VERSION=o,ce.prototype.value=function(){return this._wrapped},ce.prototype.valueOf=ce.prototype.toJSON=ce.prototype.value,ce.prototype.toString=function(){return String(this._wrapped)};var he="[object DataView]";function pe(e,t,i,n){if(e===t)return 0!==e||1/e==1/t;if(null==e||null==t)return!1;if(e!=e)return t!=t;var o=typeof e;return("function"===o||"object"===o||"object"==typeof t)&&be(e,t,i,n)}function be(e,t,i,n){e instanceof ce&&(e=e._wrapped),t instanceof ce&&(t=t._wrapped);var o=u.call(e);if(o!==u.call(t))return!1;if(W&&"[object Object]"==o&&j(e)){if(!j(t))return!1;o=he}switch(o){case"[object RegExp]":case"[object String]":return""+e==""+t;case"[object Number]":return+e!=+e?+t!=+t:0===+e?1/+e==1/t:+e===+t;case"[object Date]":case"[object Boolean]":return+e===+t;case"[object Symbol]":return l.valueOf.call(e)===l.valueOf.call(t);case"[object ArrayBuffer]":case he:return be(ue(e),ue(t),i,n)}var s="[object Array]"===o;if(!s&&oe(e)){if(te(e)!==te(t))return!1;if(e.buffer===t.buffer&&e.byteOffset===t.byteOffset)return!0;s=!0}if(!s){if("object"!=typeof e||"object"!=typeof t)return!1;var r=e.constructor,a=t.constructor;if(r!==a&&!(z(r)&&r instanceof r&&z(a)&&a instanceof a)&&"constructor"in e&&"constructor"in t)return!1}n=n||[];for(var d=(i=i||[]).length;d--;)if(i[d]===e)return n[d]===t;if(i.push(e),n.push(t),s){if((d=e.length)!==t.length)return!1;for(;d--;)if(!pe(e[d],t[d],i,n))return!1}else{var c,h=ae(e);if(d=h.length,ae(t).length!==d)return!1;for(;d--;)if(!q(t,c=h[d])||!pe(e[c],t[c],i,n))return!1}return i.pop(),n.pop(),!0}function me(e,t){return pe(e,t)}function ge(e){if(!D(e))return[];var t=[];for(var i in e)t.push(i);return y&&re(e,t),t}function ve(e){var t=se(e);return function(i){if(null==i)return!1;var n=ge(i);if(se(n))return!1;for(var o=0;o<t;o++)if(!z(i[e[o]]))return!1;return e!==ke||!z(i[fe])}}var fe="forEach",we=["clear","delete"],xe=["get","has","set"],ye=we.concat(fe,xe),ke=we.concat(xe),Ce=["add"].concat(we,fe,"has");const Ee=V?ve(ye):B("Map"),De=V?ve(ke):B("WeakMap"),Se=V?ve(Ce):B("Set"),Ae=B("WeakSet");function _e(e){for(var t=ae(e),i=t.length,n=Array(i),o=0;o<i;o++)n[o]=e[t[o]];return n}function Ie(e){for(var t=ae(e),i=t.length,n=Array(i),o=0;o<i;o++)n[o]=[t[o],e[t[o]]];return n}function Be(e){for(var t={},i=ae(e),n=0,o=i.length;n<o;n++)t[e[i[n]]]=i[n];return t}function Fe(e){var t=[];for(var i in e)z(e[i])&&t.push(i);return t.sort()}function Le(e,t){return function(i){var n=arguments.length;if(t&&(i=Object(i)),n<2||null==i)return i;for(var o=1;o<n;o++)for(var s=arguments[o],r=e(s),a=r.length,l=0;l<a;l++){var d=r[l];t&&void 0!==i[d]||(i[d]=s[d])}return i}}const Te=Le(ge),Oe=Le(ae),Me=Le(ge,!0);function Ne(e){if(!D(e))return{};if(v)return v(e);var t=function(){};t.prototype=e;var i=new t;return t.prototype=null,i}function $e(e,t){var i=Ne(e);return t&&Oe(i,t),i}function Pe(e){return D(e)?G(e)?e.slice():Te({},e):e}function Re(e,t){return t(e),e}function ze(e){return G(e)?e:[e]}function He(e){return ce.toPath(e)}function We(e,t){for(var i=t.length,n=0;n<i;n++){if(null==e)return;e=e[t[n]]}return i?e:void 0}function Ve(e,t,i){var n=We(e,He(t));return A(n)?i:n}function Ue(e,t){for(var i=(t=He(t)).length,n=0;n<i;n++){var o=t[n];if(!q(e,o))return!1;e=e[o]}return!!i}function je(e){return e}function Ge(e){return e=Oe({},e),function(t){return de(t,e)}}function qe(e){return e=He(e),function(t){return We(t,e)}}function Xe(e,t,i){if(void 0===t)return e;switch(null==i?3:i){case 1:return function(i){return e.call(t,i)};case 3:return function(i,n,o){return e.call(t,i,n,o)};case 4:return function(i,n,o,s){return e.call(t,i,n,o,s)}}return function(){return e.apply(t,arguments)}}function Ke(e,t,i){return null==e?je:z(e)?Xe(e,t,i):D(e)&&!G(e)?Ge(e):qe(e)}function Ye(e,t){return Ke(e,t,1/0)}function Ze(e,t,i){return ce.iteratee!==Ye?ce.iteratee(e,t):Ke(e,t,i)}function Qe(e,t,i){t=Ze(t,i);for(var n=ae(e),o=n.length,s={},r=0;r<o;r++){var a=n[r];s[a]=t(e[a],a,e)}return s}function Je(){}function et(e){return null==e?Je:function(t){return Ve(e,t)}}function tt(e,t,i){var n=Array(Math.max(0,e));t=Xe(t,i,1);for(var o=0;o<e;o++)n[o]=t(o);return n}function it(e,t){return null==t&&(t=e,e=0),e+Math.floor(Math.random()*(t-e+1))}ce.toPath=ze,ce.iteratee=Ye;const nt=Date.now||function(){return(new Date).getTime()};function ot(e){var t=function(t){return e[t]},i="(?:"+ae(e).join("|")+")",n=RegExp(i),o=RegExp(i,"g");return function(e){return e=null==e?"":""+e,n.test(e)?e.replace(o,t):e}}const st={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},rt=ot(st),at=ot(Be(st)),lt=ce.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var dt=/(.)^/,ct={"'":"'","\\":"\\","\r":"r","\n":"n","\u2028":"u2028","\u2029":"u2029"},ut=/\\|'|\r|\n|\u2028|\u2029/g;function ht(e){return"\\"+ct[e]}var pt=/^\s*(\w|\$)+\s*$/;function bt(e,t,i){!t&&i&&(t=i),t=Me({},t,ce.templateSettings);var n=RegExp([(t.escape||dt).source,(t.interpolate||dt).source,(t.evaluate||dt).source].join("|")+"|$","g"),o=0,s="__p+='";e.replace(n,function(t,i,n,r,a){return s+=e.slice(o,a).replace(ut,ht),o=a+t.length,i?s+="'+\n((__t=("+i+"))==null?'':_.escape(__t))+\n'":n?s+="'+\n((__t=("+n+"))==null?'':__t)+\n'":r&&(s+="';\n"+r+"\n__p+='"),t}),s+="';\n";var r,a=t.variable;if(a){if(!pt.test(a))throw new Error("variable is not a bare identifier: "+a)}else s="with(obj||{}){\n"+s+"}\n",a="obj";s="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+s+"return __p;\n";try{r=new Function(a,"_",s)}catch(e){throw e.source=s,e}var l=function(e){return r.call(this,e,ce)};return l.source="function("+a+"){\n"+s+"}",l}function mt(e,t,i){var n=(t=He(t)).length;if(!n)return z(i)?i.call(e):i;for(var o=0;o<n;o++){var s=null==e?void 0:e[t[o]];void 0===s&&(s=i,o=n),e=z(s)?s.call(e):s}return e}var gt=0;function vt(e){var t=++gt+"";return e?e+t:t}function ft(e){var t=ce(e);return t._chain=!0,t}function wt(e,t,i,n,o){if(!(n instanceof t))return e.apply(i,o);var s=Ne(e.prototype),r=e.apply(s,o);return D(r)?r:s}var xt=E(function(e,t){var i=xt.placeholder,n=function(){for(var o=0,s=t.length,r=Array(s),a=0;a<s;a++)r[a]=t[a]===i?arguments[o++]:t[a];for(;o<arguments.length;)r.push(arguments[o++]);return wt(e,n,this,this,r)};return n});xt.placeholder=ce;const yt=xt,kt=E(function(e,t,i){if(!z(e))throw new TypeError("Bind must be called on a function");var n=E(function(o){return wt(e,n,t,this,i.concat(o))});return n}),Ct=J(se);function Et(e,t,i,n){if(n=n||[],t||0===t){if(t<=0)return n.concat(e)}else t=1/0;for(var o=n.length,s=0,r=se(e);s<r;s++){var a=e[s];if(Ct(a)&&(G(a)||K(a)))if(t>1)Et(a,t-1,i,n),o=n.length;else for(var l=0,d=a.length;l<d;)n[o++]=a[l++];else i||(n[o++]=a)}return n}const Dt=E(function(e,t){var i=(t=Et(t,!1,!1)).length;if(i<1)throw new Error("bindAll must be passed function names");for(;i--;){var n=t[i];e[n]=kt(e[n],e)}return e});function St(e,t){var i=function(n){var o=i.cache,s=""+(t?t.apply(this,arguments):n);return q(o,s)||(o[s]=e.apply(this,arguments)),o[s]};return i.cache={},i}const At=E(function(e,t,i){return setTimeout(function(){return e.apply(null,i)},t)}),_t=yt(At,ce,1);function It(e,t,i){var n,o,s,r,a=0;i||(i={});var l=function(){a=!1===i.leading?0:nt(),n=null,r=e.apply(o,s),n||(o=s=null)},d=function(){var d=nt();a||!1!==i.leading||(a=d);var c=t-(d-a);return o=this,s=arguments,c<=0||c>t?(n&&(clearTimeout(n),n=null),a=d,r=e.apply(o,s),n||(o=s=null)):n||!1===i.trailing||(n=setTimeout(l,c)),r};return d.cancel=function(){clearTimeout(n),a=0,n=o=s=null},d}function Bt(e,t,i){var n,o,s,r,a,l=function(){var d=nt()-o;t>d?n=setTimeout(l,t-d):(n=null,i||(r=e.apply(a,s)),n||(s=a=null))},d=E(function(d){return a=this,s=d,o=nt(),n||(n=setTimeout(l,t),i&&(r=e.apply(a,s))),r});return d.cancel=function(){clearTimeout(n),n=s=a=null},d}function Ft(e,t){return yt(t,e)}function Lt(e){return function(){return!e.apply(this,arguments)}}function Tt(){var e=arguments,t=e.length-1;return function(){for(var i=t,n=e[t].apply(this,arguments);i--;)n=e[i].call(this,n);return n}}function Ot(e,t){return function(){if(--e<1)return t.apply(this,arguments)}}function Mt(e,t){var i;return function(){return--e>0&&(i=t.apply(this,arguments)),e<=1&&(t=null),i}}const Nt=yt(Mt,2);function $t(e,t,i){t=Ze(t,i);for(var n,o=ae(e),s=0,r=o.length;s<r;s++)if(t(e[n=o[s]],n,e))return n}function Pt(e){return function(t,i,n){i=Ze(i,n);for(var o=se(t),s=e>0?0:o-1;s>=0&&s<o;s+=e)if(i(t[s],s,t))return s;return-1}}const Rt=Pt(1),zt=Pt(-1);function Ht(e,t,i,n){for(var o=(i=Ze(i,n,1))(t),s=0,r=se(e);s<r;){var a=Math.floor((s+r)/2);i(e[a])<o?s=a+1:r=a}return s}function Wt(e,t,i){return function(n,o,s){var r=0,a=se(n);if("number"==typeof s)e>0?r=s>=0?s:Math.max(s+a,r):a=s>=0?Math.min(s+1,a):s+a+1;else if(i&&s&&a)return n[s=i(n,o)]===o?s:-1;if(o!=o)return(s=t(c.call(n,r,a),Z))>=0?s+r:-1;for(s=e>0?r:a-1;s>=0&&s<a;s+=e)if(n[s]===o)return s;return-1}}const Vt=Wt(1,Rt,Ht),Ut=Wt(-1,zt);function jt(e,t,i){var n=(Ct(e)?Rt:$t)(e,t,i);if(void 0!==n&&-1!==n)return e[n]}function Gt(e,t){return jt(e,Ge(t))}function qt(e,t,i){var n,o;if(t=Xe(t,i),Ct(e))for(n=0,o=e.length;n<o;n++)t(e[n],n,e);else{var s=ae(e);for(n=0,o=s.length;n<o;n++)t(e[s[n]],s[n],e)}return e}function Xt(e,t,i){t=Ze(t,i);for(var n=!Ct(e)&&ae(e),o=(n||e).length,s=Array(o),r=0;r<o;r++){var a=n?n[r]:r;s[r]=t(e[a],a,e)}return s}function Kt(e){return function(t,i,n,o){var s=arguments.length>=3;return function(t,i,n,o){var s=!Ct(t)&&ae(t),r=(s||t).length,a=e>0?0:r-1;for(o||(n=t[s?s[a]:a],a+=e);a>=0&&a<r;a+=e){var l=s?s[a]:a;n=i(n,t[l],l,t)}return n}(t,Xe(i,o,4),n,s)}}const Yt=Kt(1),Zt=Kt(-1);function Qt(e,t,i){var n=[];return t=Ze(t,i),qt(e,function(e,i,o){t(e,i,o)&&n.push(e)}),n}function Jt(e,t,i){return Qt(e,Lt(Ze(t)),i)}function ei(e,t,i){t=Ze(t,i);for(var n=!Ct(e)&&ae(e),o=(n||e).length,s=0;s<o;s++){var r=n?n[s]:s;if(!t(e[r],r,e))return!1}return!0}function ti(e,t,i){t=Ze(t,i);for(var n=!Ct(e)&&ae(e),o=(n||e).length,s=0;s<o;s++){var r=n?n[s]:s;if(t(e[r],r,e))return!0}return!1}function ii(e,t,i,n){return Ct(e)||(e=_e(e)),("number"!=typeof i||n)&&(i=0),Vt(e,t,i)>=0}const ni=E(function(e,t,i){var n,o;return z(t)?o=t:(t=He(t),n=t.slice(0,-1),t=t[t.length-1]),Xt(e,function(e){var s=o;if(!s){if(n&&n.length&&(e=We(e,n)),null==e)return;s=e[t]}return null==s?s:s.apply(e,i)})});function oi(e,t){return Xt(e,qe(t))}function si(e,t){return Qt(e,Ge(t))}function ri(e,t,i){var n,o,s=-1/0,r=-1/0;if(null==t||"number"==typeof t&&"object"!=typeof e[0]&&null!=e)for(var a=0,l=(e=Ct(e)?e:_e(e)).length;a<l;a++)null!=(n=e[a])&&n>s&&(s=n);else t=Ze(t,i),qt(e,function(e,i,n){((o=t(e,i,n))>r||o===-1/0&&s===-1/0)&&(s=e,r=o)});return s}function ai(e,t,i){var n,o,s=1/0,r=1/0;if(null==t||"number"==typeof t&&"object"!=typeof e[0]&&null!=e)for(var a=0,l=(e=Ct(e)?e:_e(e)).length;a<l;a++)null!=(n=e[a])&&n<s&&(s=n);else t=Ze(t,i),qt(e,function(e,i,n){((o=t(e,i,n))<r||o===1/0&&s===1/0)&&(s=e,r=o)});return s}var li=/[^\ud800-\udfff]|[\ud800-\udbff][\udc00-\udfff]|[\ud800-\udfff]/g;function di(e){return e?G(e)?c.call(e):F(e)?e.match(li):Ct(e)?Xt(e,je):_e(e):[]}function ci(e,t,i){if(null==t||i)return Ct(e)||(e=_e(e)),e[it(e.length-1)];var n=di(e),o=se(n);t=Math.max(Math.min(t,o),0);for(var s=o-1,r=0;r<t;r++){var a=it(r,s),l=n[r];n[r]=n[a],n[a]=l}return n.slice(0,t)}function ui(e){return ci(e,1/0)}function hi(e,t,i){var n=0;return t=Ze(t,i),oi(Xt(e,function(e,i,o){return{value:e,index:n++,criteria:t(e,i,o)}}).sort(function(e,t){var i=e.criteria,n=t.criteria;if(i!==n){if(i>n||void 0===i)return 1;if(i<n||void 0===n)return-1}return e.index-t.index}),"value")}function pi(e,t){return function(i,n,o){var s=t?[[],[]]:{};return n=Ze(n,o),qt(i,function(t,o){var r=n(t,o,i);e(s,t,r)}),s}}const bi=pi(function(e,t,i){q(e,i)?e[i].push(t):e[i]=[t]}),mi=pi(function(e,t,i){e[i]=t}),gi=pi(function(e,t,i){q(e,i)?e[i]++:e[i]=1}),vi=pi(function(e,t,i){e[i?0:1].push(t)},!0);function fi(e){return null==e?0:Ct(e)?e.length:ae(e).length}function wi(e,t,i){return t in i}const xi=E(function(e,t){var i={},n=t[0];if(null==e)return i;z(n)?(t.length>1&&(n=Xe(n,t[1])),t=ge(e)):(n=wi,t=Et(t,!1,!1),e=Object(e));for(var o=0,s=t.length;o<s;o++){var r=t[o],a=e[r];n(a,r,e)&&(i[r]=a)}return i}),yi=E(function(e,t){var i,n=t[0];return z(n)?(n=Lt(n),t.length>1&&(i=t[1])):(t=Xt(Et(t,!1,!1),String),n=function(e,i){return!ii(t,i)}),xi(e,n,i)});function ki(e,t,i){return c.call(e,0,Math.max(0,e.length-(null==t||i?1:t)))}function Ci(e,t,i){return null==e||e.length<1?null==t||i?void 0:[]:null==t||i?e[0]:ki(e,e.length-t)}function Ei(e,t,i){return c.call(e,null==t||i?1:t)}function Di(e,t,i){return null==e||e.length<1?null==t||i?void 0:[]:null==t||i?e[e.length-1]:Ei(e,Math.max(0,e.length-t))}function Si(e){return Qt(e,Boolean)}function Ai(e,t){return Et(e,t,!1)}const _i=E(function(e,t){return t=Et(t,!0,!0),Qt(e,function(e){return!ii(t,e)})}),Ii=E(function(e,t){return _i(e,t)});function Bi(e,t,i,n){_(t)||(n=i,i=t,t=!1),null!=i&&(i=Ze(i,n));for(var o=[],s=[],r=0,a=se(e);r<a;r++){var l=e[r],d=i?i(l,r,e):l;t&&!i?(r&&s===d||o.push(l),s=d):i?ii(s,d)||(s.push(d),o.push(l)):ii(o,l)||o.push(l)}return o}const Fi=E(function(e){return Bi(Et(e,!0,!0))});function Li(e){for(var t=[],i=arguments.length,n=0,o=se(e);n<o;n++){var s=e[n];if(!ii(t,s)){var r;for(r=1;r<i&&ii(arguments[r],s);r++);r===i&&t.push(s)}}return t}function Ti(e){for(var t=e&&ri(e,se).length||0,i=Array(t),n=0;n<t;n++)i[n]=oi(e,n);return i}const Oi=E(Ti);function Mi(e,t){for(var i={},n=0,o=se(e);n<o;n++)t?i[e[n]]=t[n]:i[e[n][0]]=e[n][1];return i}function Ni(e,t,i){null==t&&(t=e||0,e=0),i||(i=t<e?-1:1);for(var n=Math.max(Math.ceil((t-e)/i),0),o=Array(n),s=0;s<n;s++,e+=i)o[s]=e;return o}function $i(e,t){if(null==t||t<1)return[];for(var i=[],n=0,o=e.length;n<o;)i.push(c.call(e,n,n+=t));return i}function Pi(e,t){return e._chain?ce(t).chain():t}function Ri(e){return qt(Fe(e),function(t){var i=ce[t]=e[t];ce.prototype[t]=function(){var e=[this._wrapped];return d.apply(e,arguments),Pi(this,i.apply(ce,e))}}),ce}qt(["pop","push","reverse","shift","sort","splice","unshift"],function(e){var t=r[e];ce.prototype[e]=function(){var i=this._wrapped;return null!=i&&(t.apply(i,arguments),"shift"!==e&&"splice"!==e||0!==i.length||delete i[0]),Pi(this,i)}}),qt(["concat","join","slice"],function(e){var t=r[e];ce.prototype[e]=function(){var e=this._wrapped;return null!=e&&(e=t.apply(e,arguments)),Pi(this,e)}});const zi=ce;var Hi=Ri(n);Hi._=Hi;const Wi=Hi},4741(e,t,i){var n;!function(e){!function(){var t="object"==typeof i.g?i.g:"object"==typeof self?self:"object"==typeof this?this:Function("return this;")(),n=o(e);function o(e,t){return function(i,n){"function"!=typeof e[i]&&Object.defineProperty(e,i,{configurable:!0,writable:!0,value:n}),t&&t(i,n)}}void 0===t.Reflect?t.Reflect=e:n=o(t.Reflect,n),function(e){var t=Object.prototype.hasOwnProperty,i="function"==typeof Symbol,n=i&&void 0!==Symbol.toPrimitive?Symbol.toPrimitive:"@@toPrimitive",o=i&&void 0!==Symbol.iterator?Symbol.iterator:"@@iterator",s="function"==typeof Object.create,r={__proto__:[]}instanceof Array,a=!s&&!r,l={create:s?function(){return N(Object.create(null))}:r?function(){return N({__proto__:null})}:function(){return N({})},has:a?function(e,i){return t.call(e,i)}:function(e,t){return t in e},get:a?function(e,i){return t.call(e,i)?e[i]:void 0}:function(e,t){return e[t]}},d=Object.getPrototypeOf(Function),c="object"==typeof process&&process.env&&"true"===process.env.REFLECT_METADATA_USE_MAP_POLYFILL,u=c||"function"!=typeof Map||"function"!=typeof Map.prototype.entries?function(){var e={},t=[],i=function(){function e(e,t,i){this._index=0,this._keys=e,this._values=t,this._selector=i}return e.prototype["@@iterator"]=function(){return this},e.prototype[o]=function(){return this},e.prototype.next=function(){var e=this._index;if(e>=0&&e<this._keys.length){var i=this._selector(this._keys[e],this._values[e]);return e+1>=this._keys.length?(this._index=-1,this._keys=t,this._values=t):this._index++,{value:i,done:!1}}return{value:void 0,done:!0}},e.prototype.throw=function(e){throw this._index>=0&&(this._index=-1,this._keys=t,this._values=t),e},e.prototype.return=function(e){return this._index>=0&&(this._index=-1,this._keys=t,this._values=t),{value:e,done:!0}},e}();return function(){function t(){this._keys=[],this._values=[],this._cacheKey=e,this._cacheIndex=-2}return Object.defineProperty(t.prototype,"size",{get:function(){return this._keys.length},enumerable:!0,configurable:!0}),t.prototype.has=function(e){return this._find(e,!1)>=0},t.prototype.get=function(e){var t=this._find(e,!1);return t>=0?this._values[t]:void 0},t.prototype.set=function(e,t){var i=this._find(e,!0);return this._values[i]=t,this},t.prototype.delete=function(t){var i=this._find(t,!1);if(i>=0){for(var n=this._keys.length,o=i+1;o<n;o++)this._keys[o-1]=this._keys[o],this._values[o-1]=this._values[o];return this._keys.length--,this._values.length--,t===this._cacheKey&&(this._cacheKey=e,this._cacheIndex=-2),!0}return!1},t.prototype.clear=function(){this._keys.length=0,this._values.length=0,this._cacheKey=e,this._cacheIndex=-2},t.prototype.keys=function(){return new i(this._keys,this._values,n)},t.prototype.values=function(){return new i(this._keys,this._values,s)},t.prototype.entries=function(){return new i(this._keys,this._values,r)},t.prototype["@@iterator"]=function(){return this.entries()},t.prototype[o]=function(){return this.entries()},t.prototype._find=function(e,t){return this._cacheKey!==e&&(this._cacheIndex=this._keys.indexOf(this._cacheKey=e)),this._cacheIndex<0&&t&&(this._cacheIndex=this._keys.length,this._keys.push(e),this._values.push(void 0)),this._cacheIndex},t}();function n(e,t){return e}function s(e,t){return t}function r(e,t){return[e,t]}}():Map,h=c||"function"!=typeof Set||"function"!=typeof Set.prototype.entries?function(){function e(){this._map=new u}return Object.defineProperty(e.prototype,"size",{get:function(){return this._map.size},enumerable:!0,configurable:!0}),e.prototype.has=function(e){return this._map.has(e)},e.prototype.add=function(e){return this._map.set(e,e),this},e.prototype.delete=function(e){return this._map.delete(e)},e.prototype.clear=function(){this._map.clear()},e.prototype.keys=function(){return this._map.keys()},e.prototype.values=function(){return this._map.values()},e.prototype.entries=function(){return this._map.entries()},e.prototype["@@iterator"]=function(){return this.keys()},e.prototype[o]=function(){return this.keys()},e}():Set,p=new(c||"function"!=typeof WeakMap?function(){var e=l.create(),i=n();return function(){function e(){this._key=n()}return e.prototype.has=function(e){var t=o(e,!1);return void 0!==t&&l.has(t,this._key)},e.prototype.get=function(e){var t=o(e,!1);return void 0!==t?l.get(t,this._key):void 0},e.prototype.set=function(e,t){return o(e,!0)[this._key]=t,this},e.prototype.delete=function(e){var t=o(e,!1);return void 0!==t&&delete t[this._key]},e.prototype.clear=function(){this._key=n()},e}();function n(){var t;do{t="@@WeakMap@@"+r()}while(l.has(e,t));return e[t]=!0,t}function o(e,n){if(!t.call(e,i)){if(!n)return;Object.defineProperty(e,i,{value:l.create()})}return e[i]}function s(e,t){for(var i=0;i<t;++i)e[i]=255*Math.random()|0;return e}function r(){var e,t=(e=16,"function"==typeof Uint8Array?"undefined"!=typeof crypto?crypto.getRandomValues(new Uint8Array(e)):"undefined"!=typeof msCrypto?msCrypto.getRandomValues(new Uint8Array(e)):s(new Uint8Array(e),e):s(new Array(e),e));t[6]=79&t[6]|64,t[8]=191&t[8]|128;for(var i="",n=0;n<16;++n){var o=t[n];4!==n&&6!==n&&8!==n||(i+="-"),o<16&&(i+="0"),i+=o.toString(16).toLowerCase()}return i}}():WeakMap);function b(e,t,i){var n=p.get(e);if(C(n)){if(!i)return;n=new u,p.set(e,n)}var o=n.get(t);if(C(o)){if(!i)return;o=new u,n.set(t,o)}return o}function m(e,t,i){if(g(e,t,i))return!0;var n=M(t);return!E(n)&&m(e,n,i)}function g(e,t,i){var n=b(t,i,!1);return!C(n)&&!!n.has(e)}function v(e,t,i){if(g(e,t,i))return f(e,t,i);var n=M(t);return E(n)?void 0:v(e,n,i)}function f(e,t,i){var n=b(t,i,!1);if(!C(n))return n.get(e)}function w(e,t,i,n){b(i,n,!0).set(e,t)}function x(e,t){var i=y(e,t),n=M(e);if(null===n)return i;var o=x(n,t);if(o.length<=0)return i;if(i.length<=0)return o;for(var s=new h,r=[],a=0,l=i;a<l.length;a++){var d=l[a];s.has(d)||(s.add(d),r.push(d))}for(var c=0,u=o;c<u.length;c++)d=u[c],s.has(d)||(s.add(d),r.push(d));return r}function y(e,t){var i=[],n=b(e,t,!1);if(C(n))return i;for(var s=function(e){var t=F(e,o);if(!I(t))throw new TypeError;var i=t.call(e);if(!D(i))throw new TypeError;return i}(n.keys()),r=0;;){var a=T(s);if(!a)return i.length=r,i;var l=L(a);try{i[r]=l}catch(e){try{O(s)}finally{throw e}}r++}}function k(e){if(null===e)return 1;switch(typeof e){case"undefined":return 0;case"boolean":return 2;case"string":return 3;case"symbol":return 4;case"number":return 5;case"object":return null===e?1:6;default:return 6}}function C(e){return void 0===e}function E(e){return null===e}function D(e){return"object"==typeof e?null!==e:"function"==typeof e}function S(e,t){switch(k(e)){case 0:case 1:case 2:case 3:case 4:case 5:return e}var i=3===t?"string":5===t?"number":"default",o=F(e,n);if(void 0!==o){var s=o.call(e,i);if(D(s))throw new TypeError;return s}return function(e,t){if("string"===t){var i=e.toString;if(I(i)&&!D(o=i.call(e)))return o;if(I(n=e.valueOf)&&!D(o=n.call(e)))return o}else{var n;if(I(n=e.valueOf)&&!D(o=n.call(e)))return o;var o,s=e.toString;if(I(s)&&!D(o=s.call(e)))return o}throw new TypeError}(e,"default"===i?"number":i)}function A(e){var t=S(e,3);return"symbol"==typeof t?t:function(e){return""+e}(t)}function _(e){return Array.isArray?Array.isArray(e):e instanceof Object?e instanceof Array:"[object Array]"===Object.prototype.toString.call(e)}function I(e){return"function"==typeof e}function B(e){return"function"==typeof e}function F(e,t){var i=e[t];if(null!=i){if(!I(i))throw new TypeError;return i}}function L(e){return e.value}function T(e){var t=e.next();return!t.done&&t}function O(e){var t=e.return;t&&t.call(e)}function M(e){var t=Object.getPrototypeOf(e);if("function"!=typeof e||e===d)return t;if(t!==d)return t;var i=e.prototype,n=i&&Object.getPrototypeOf(i);if(null==n||n===Object.prototype)return t;var o=n.constructor;return"function"!=typeof o||o===e?t:o}function N(e){return e.__=void 0,delete e.__,e}e("decorate",function(e,t,i,n){if(C(i)){if(!_(e))throw new TypeError;if(!B(t))throw new TypeError;return function(e,t){for(var i=e.length-1;i>=0;--i){var n=(0,e[i])(t);if(!C(n)&&!E(n)){if(!B(n))throw new TypeError;t=n}}return t}(e,t)}if(!_(e))throw new TypeError;if(!D(t))throw new TypeError;if(!D(n)&&!C(n)&&!E(n))throw new TypeError;return E(n)&&(n=void 0),function(e,t,i,n){for(var o=e.length-1;o>=0;--o){var s=(0,e[o])(t,i,n);if(!C(s)&&!E(s)){if(!D(s))throw new TypeError;n=s}}return n}(e,t,i=A(i),n)}),e("metadata",function(e,t){return function(i,n){if(!D(i))throw new TypeError;if(!C(n)&&!function(e){switch(k(e)){case 3:case 4:return!0;default:return!1}}(n))throw new TypeError;w(e,t,i,n)}}),e("defineMetadata",function(e,t,i,n){if(!D(i))throw new TypeError;return C(n)||(n=A(n)),w(e,t,i,n)}),e("hasMetadata",function(e,t,i){if(!D(t))throw new TypeError;return C(i)||(i=A(i)),m(e,t,i)}),e("hasOwnMetadata",function(e,t,i){if(!D(t))throw new TypeError;return C(i)||(i=A(i)),g(e,t,i)}),e("getMetadata",function(e,t,i){if(!D(t))throw new TypeError;return C(i)||(i=A(i)),v(e,t,i)}),e("getOwnMetadata",function(e,t,i){if(!D(t))throw new TypeError;return C(i)||(i=A(i)),f(e,t,i)}),e("getMetadataKeys",function(e,t){if(!D(e))throw new TypeError;return C(t)||(t=A(t)),x(e,t)}),e("getOwnMetadataKeys",function(e,t){if(!D(e))throw new TypeError;return C(t)||(t=A(t)),y(e,t)}),e("deleteMetadata",function(e,t,i){if(!D(t))throw new TypeError;C(i)||(i=A(i));var n=b(t,i,!1);if(C(n))return!1;if(!n.delete(e))return!1;if(n.size>0)return!0;var o=p.get(t);return o.delete(i),o.size>0||p.delete(t),!0})}(n)}()}(n||(n={}))},4835(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.createStyles=t.createElement=t.clearNode=void 0,t.clearNode=e=>{for(;e.lastChild;)e.lastChild.remove()};const i=/(?<tagName>[\w\\-]+)?(?<id>#([\w\\-]+))?(?<className>(\.([\w\\-]+))*)/;t.createElement=(e,t,...n)=>{const o=i.exec(e);if(!o||!o.groups)return document.createElement("div");const{tagName:s="div",id:r,className:a}=o.groups,l=document.createElement(s);return r&&(l.id=r),a&&(l.className=a.replace(/\./g," ").trim()),Object.entries(null!=t?t:{}).forEach(([e,t])=>{void 0===t||/^on\w+$/.test(e)||l.setAttribute(e,t)}),l.append(...n),l},t.createStyles=(...e)=>{const t=document.createElement("style");return t.appendChild(document.createTextNode(e.join(" "))),t}},4846(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.iconTheme=void 0;const n=i(6199);t.iconTheme={"symbol-array":n.symbolIconColor,"symbol-boolean":n.symbolIconColor,"symbol-class":n.symbolIconEventColor,"symbol-method":n.symbolIconMethodColor,"symbol-color":n.symbolIconColor,"symbol-constant":n.symbolIconColor,"symbol-constructor":n.symbolIconColor,"symbol-value":n.symbolIconValueColor,"symbol-abstract-class":n.symbolIconAbstractClassColor,"symbol-enum":n.symbolIconValueColor,"symbol-enummember":n.symbolIconValueColor,"symbol-event":n.symbolIconEventColor,"symbol-field":n.symbolIconValueColor,"symbol-file":n.symbolIconColor,"symbol-folder":n.symbolIconColor,"symbol-function":n.symbolIconColor,"symbol-interface":n.symbolIconValueColor,"symbol-key":n.symbolIconColor,"symbol-keyword":n.symbolIconColor,"symbol-module":n.symbolIconColor,"symbol-namespace":n.symbolIconColor,"symbol-null":n.symbolIconColor,"symbol-number":n.symbolIconColor,"symbol-object":n.symbolIconColor,"symbol-operator":n.symbolIconColor,"symbol-package":n.symbolIconColor,"symbol-property":n.symbolIconColor,"symbol-reference":n.symbolIconColor,"symbol-snippet":n.symbolIconColor,"symbol-parameter":n.symbolIconColor,"symbol-user":n.symbolIconColor,"symbol-string":n.symbolIconColor,"symbol-struct":n.symbolIconColor,"symbol-text":n.symbolIconColor,"symbol-structure":n.symbolIconColor,"symbol-issue":n.symbolIconColor,"symbol-unit":n.symbolIconColor,"symbol-type-parameter":n.symbolIconColor,"symbol-symbol-unit":n.symbolIconColor,"symbol-variable":n.symbolIconValueColor,"debug-pause":n.debugPause,"debug-continue":n.debugPause,"debug-step-back":n.symbolIconEnumMemberColor,"debug-step-out":n.symbolIconEnumMemberColor,"debug-step-into":n.debugPause,"debug-step-over":n.debugPause,"debug-restart-frame":n.apk,"debug-disconnect":n.debugIconDisconnectForeground,"debug-stop":n.stop,"debug-start":n.debugAll,"debug-restart":n.debugAll,"debug-breakpoint":n.debugIconBreakpointForeground,"breakpoint-disabled":n.debugIconBreakpointUnverifiedForeground,"debug-breakpoint-disabled":n.debugIconBreakpointUnverifiedForeground,"debug-breakpoint-unverified":n.debugIconBreakpointUnverifiedForeground,"debug-hint":n.breakpointEnabledUp,"terminal-up":n.siderbarIconUpDefault,"terminal-down":n.siderbarIconDownDefault,"extensions-up":n.siderbarIconUpDefault,"extensions-down":n.siderbarIconDownDefault,"API-panorama-up":n.siderbarIconUpDefault,"API-panorama-down":n.siderbarIconDownDefault,"terminal-up-active":n.siderbarIconUpActive,"terminal-down-active":n.siderbarIconDownActive,"extensions-up-active":n.siderbarIconUpActive,"extensions-down-active":n.siderbarIconDownActive,"API-panorama-up-active":n.siderbarIconUpActive,"API-panorama-down-active":n.siderbarIconDownActive,"source-code-manage-up":n.siderbarIconUpDefault,"source-code-manage-up-active":n.siderbarIconUpActive,"source-code-manage-down":n.siderbarIconDownDefault,"source-code-manage-down-active":n.siderbarIconDownActive,"references-up-active":n.siderbarIconUpActive,"references-down":n.siderbarIconDownDefault,"references-down-active":n.siderbarIconDownActive,"references-up":n.siderbarIconUpDefault,"running-up-active":n.siderbarIconUpActive,"running-down":n.siderbarIconDownDefault,"running-down-active":n.siderbarIconDownActive,"running-up":n.siderbarIconUpDefault,"remote-dev-up-active":n.siderbarIconUpActive,"remote-dev-down":n.siderbarIconDownDefault,"remote-dev-down-active":n.siderbarIconDownActive,"remote-dev-up":n.siderbarIconUpDefault,"bill-of-lading-down":n.siderbarIconDownDefault,"bill-of-lading-down-active":n.siderbarIconDownActive,"bill-of-lading-up":n.siderbarIconUpDefault,"bill-of-lading-up-active":n.siderbarIconUpActive,"issue-down":n.siderbarIconDownDefault,"issue-down-active":n.siderbarIconDownActive,"issue-up":n.siderbarIconUpDefault,"issue-up-active":n.siderbarIconUpActive,"search-down":n.siderbarIconDownDefault,"search-down-active":n.siderbarIconDownActive,"search-up":n.siderbarIconUpDefault,"search-up-active":n.siderbarIconUpActive,"property-up":n.siderbarIconUpDefault,"property-up-active":n.siderbarIconUpActive,"property-down":n.siderbarIconDownDefault,"property-down-active":n.siderbarIconDownActive,"output-down":n.siderbarIconDownDefault,"output-down-active":n.siderbarIconDownActive,"output-up":n.siderbarIconUpDefault,"output-up-active":n.siderbarIconUpActive,"event-center-down":n.siderbarIconDownDefault,"event-center-down-active":n.siderbarIconDownActive,"event-center-up":n.siderbarIconUpDefault,"event-center-up-active":n.siderbarIconUpActive,"setting-down":n.siderbarIconDownDefault,"setting-down-active":n.siderbarIconDownActive,"setting-up":n.siderbarIconUpDefault,"setting-up-active":n.siderbarIconUpActive,"timeline-up-active":n.siderbarIconUpActive,"timeline-down":n.siderbarIconDownDefault,"timeline-down-active":n.siderbarIconDownActive,"timeline-up":n.siderbarIconUpDefault,"type-hierarchy-up-active":n.siderbarIconUpActive,"type-hierarchy-down":n.siderbarIconDownDefault,"type-hierarchy-down-active":n.siderbarIconDownActive,"type-hierarchy-up":n.siderbarIconUpDefault,"dev-kit-down":n.siderbarIconDownDefault,"dev-kit-down-active":n.siderbarIconDownActive,"dev-kit-up":n.siderbarIconUpDefault,"dev-kit-up-active":n.siderbarIconUpActive,"port-access-up":n.siderbarIconUpDefault,"port-access-up-active":n.siderbarIconUpActive,"port-access-down":n.siderbarIconDownDefault,"port-access-down-active":n.siderbarIconDownActive,"build-down":n.siderbarIconDownDefault,"build-down-active":n.siderbarIconDownActive,"build-up":n.siderbarIconUpDefault,"build-up-active":n.siderbarIconUpActive,"tool-down":n.siderbarIconDownDefault,"tool-down-active":n.siderbarIconDownActive,"tool-up":n.siderbarIconUpDefault,"tool-up-active":n.siderbarIconUpActive,"project-up-active":n.siderbarIconUpActive,"project-down":n.siderbarIconDownDefault,"project-down-active":n.siderbarIconDownActive,"project-up":n.siderbarIconUpDefault,"test-down":n.siderbarIconDownDefault,"test-down-active":n.siderbarIconDownActive,"test-up":n.siderbarIconUpDefault,"test-up-active":n.siderbarIconUpActive,"outline-down":n.siderbarIconDownDefault,"outline-down-active":n.siderbarIconDownActive,"outline-up":n.siderbarIconUpDefault,"outline-up-active":n.siderbarIconUpActive,"reference-info-down":n.siderbarIconDownDefault,"reference-info-down-active":n.siderbarIconDownActive,"reference-info-up":n.siderbarIconUpDefault,"reference-info-up-active":n.siderbarIconUpActive,"debug-console-down":n.siderbarIconDownDefault,"debug-console-down-active":n.siderbarIconDownActive,"debug-console-up":n.siderbarIconUpDefault,"debug-console-up-active":n.siderbarIconUpActive,"invoking-level-down":n.siderbarIconDownDefault,"invoking-level-down-active":n.siderbarIconDownActive,"invoking-level-up":n.siderbarIconUpDefault,"invoking-level-up-active":n.siderbarIconUpActive,unlock:n.unlock,"heart-filled":n.favorites,rating:n.rating,apk:n.apk,msg:n.msg,"run-all":n.debugAll,folder:n.debugPause,"folder-opened":n.debugPause,"root-folder":n.debugPause,"build-single":n.debugAll,xml:n.apk,manifest:n.manifest,"file-zip":n.zip,"error-small":n.errorStatusColor,error:n.errorStatusColor,"pass-filled-small":n.successStatusColor,"pass-filled":n.successStatusColor,"warning-small":n.warnStatusColor,warning:n.warnStatusColor,tip:n.infoStatusColor,"tip-small":n.infoStatusColor,"running-middle":n.infoStatusColor,"running-small":n.infoStatusColor,loading:n.infoStatusColor,"stop-middle":n.stopMiddle,"jump-small":n.jumpSmall,"running-no-middle":n.jumpSmall,"rating-grey":n.jumpSmall,"debug-stackframe-disabled":n.jumpSmall,file:n.file,"run-here-down":n.debugStackframeDown,"run-here-up":n.debugStackframeUp,"bracket-error-up":n.errorStatusColor,"letter-positive-order-up":n.iconActive,"letter-reverse-order-up":n.iconActive,"time-taken-positive-sort-up":n.iconActive,"time-taken-reverse-sort-up":n.iconActive,"container-content-up":n.unlock,"excluded-content-up":n.errorStatusColor,"filter-up-active":n.iconActive,favorited:n.favorites,star:n.warnStatusColor,"run-above":n.apk,pinned:n.pined,markdown:n.markdown,flame:n.errorStatusColor,"debug-continue-small":n.debugPause,"debug-reverse-continue":n.debugPause,"compass-down-active":n.compassActive,"folder-down-active":n.compassActive,"layers-down-active":n.compassActive,"code-unfolding-up":n.codeCollapseUp,"code-collapse-down":n.codeCollapseDown,"code-collapse-up":n.codeCollapseUp,"code-unfolding-down":n.codeCollapseDown,"session-management-up":n.siderbarIconUpDefault,"session-management-down":n.siderbarIconDownDefault,"session-management-up-active":n.siderbarIconUpActive,"session-management-down-active":n.siderbarIconDownActive,"remote-file-system-up":n.siderbarIconUpDefault,"remote-file-system-down":n.siderbarIconDownDefault,"remote-file-system-up-active":n.siderbarIconUpActive,"remote-file-system-down-active":n.siderbarIconDownActive,"read-access-up":n.apk,"write-access-up":n.errorStatusColor,"read-access-down":n.secondaryFontColor,"write-access-down":n.secondaryFontColor,"huawei-logo-up":`${n.huaweiLogo} !important`,"huawei-logo-up-active":`${n.huaweiLogo} !important`,"huawei-logo-down":`${n.huaweiLogoName} !important`,"huawei-logo-down-active":`${n.huaweiLogoName} !important`,region:n.region,"non-cloud-server":n.region,"cloud-server":n.region,"cloud-server-active":n.apk,"non-cloud-server-active":n.apk,"cloud-server-accessible":n.accessible,"diff-remove-down":n.diffRemoveDown,"diff-insert-down":n.diffRemoveDown,"diff-remove-up":n.diffRemoveUp,"diff-insert-up":n.diffRemoveUp,"star-half":n.warnStatusColor,resetting:n.jumpSmall,"warn-large-up":n.warnStatusColor,"warn-large-down":n.warnDown,"problem-up":n.problemUp,"problem-down":n.problemDown,"no-data-up":n.noDataUp,"no-data-down":n.noDatadown,"error-large-up":n.errorStatusColor,"error-large-down":n.errorDown,"success-large-up":n.successUp,"success-large-down":n.successDown,"tip-large-up":n.tipUp,"tip-large-down":n.tipDown,"vm-up-active":n.successStatusColor,lightning:n.lightning,"step-over-start":n.debugPause,"debug-filled":n.debugAll,"step-over-end":n.debugPause,"step-over-solid":n.debugPause,"debug-breakpoint-conditional-disabled":n.jumpSmall,"debug-breakpoint-conditional":n.debugStackframeUp,"jdk-up":n.jdkUp,"jdk-down":n.jdkDown,"c-sharp":n.cSharp,c:n.jdkUp,plugin:n.jdkDown,java:n.java,python:n.python,cpp:n.jdkUp,"devops-up":n.siderbarIconUpDefault,"devops-down":n.siderbarIconDownDefault,"devops-up-active":n.siderbarIconUpActive,"devops-down-active":n.siderbarIconDownActive,"extension-disabled-up":n.inputBoxPlaceholderTextColor,"extension-disabled-down":n.popUpBackgroundColor,"extension-error-up":n.inputBoxPlaceholderTextColor,"extension-error-down":n.popUpBackgroundColor,"cpp-source-file-up":n.cppSourceFileUp,"cpp-source-file-down":n.noDataUp,"cpp-header-file-up":n.cppHeaderFileUp,"cpp-header-file-down":n.noDataUp,"cpp-class-file":n.cppSourceFileUp,wrap:n.region,"class-breakpoint-default":n.breakpointEnabledUp,"class-breakpoint-both-up":n.breakpointEnabledUp,"class-breakpoint-conditional-up":n.breakpointEnabledUp,"class-breakpoint-log-up":n.breakpointEnabledUp,"class-breakpoint-both-down":n.breakpointEnabledDown,"class-breakpoint-conditional-down":n.breakpointEnabledDown,"class-breakpoint-log-down":n.breakpointEnabledDown,"class-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"class-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"class-breakpoint-log-disabled-up":n.breakpointDisabledUp,"class-breakpoint-log-disabled-down":n.breakpointDisabledDown,"class-breakpoint-both-disabled-up":n.breakpointDisabledUp,"class-breakpoint-both-disabled-down":n.breakpointDisabledDown,"class-breakpoint-default-disabled":n.breakpointDisabledUp,"exception-breakpoint-default":n.breakpointEnabledUp,"exception-breakpoint-both-up":n.breakpointEnabledUp,"exception-breakpoint-conditional-up":n.breakpointEnabledUp,"exception-breakpoint-log-up":n.breakpointEnabledUp,"exception-breakpoint-both-down":n.breakpointEnabledDown,"exception-breakpoint-conditional-down":n.breakpointEnabledDown,"exception-breakpoint-log-down":n.breakpointEnabledDown,"exception-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"exception-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"exception-breakpoint-log-disabled-up":n.breakpointDisabledUp,"exception-breakpoint-log-disabled-down":n.breakpointDisabledDown,"exception-breakpoint-both-disabled-up":n.breakpointDisabledUp,"exception-breakpoint-both-disabled-down":n.breakpointDisabledDown,"exception-breakpoint-default-disabled":n.breakpointDisabledUp,"watch-breakpoint-default":n.breakpointEnabledUp,"watch-breakpoint-both-up":n.breakpointEnabledUp,"watch-breakpoint-conditional-up":n.breakpointEnabledUp,"watch-breakpoint-log-up":n.breakpointEnabledUp,"watch-breakpoint-both-down":n.breakpointEnabledDown,"watch-breakpoint-conditional-down":n.breakpointEnabledDown,"watch-breakpoint-log-down":n.breakpointEnabledDown,"watch-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"watch-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"watch-breakpoint-log-disabled-up":n.breakpointDisabledUp,"watch-breakpoint-log-disabled-down":n.breakpointDisabledDown,"watch-breakpoint-both-disabled-up":n.breakpointDisabledUp,"watch-breakpoint-both-disabled-down":n.breakpointDisabledDown,"watch-breakpoint-default-disabled":n.breakpointDisabledUp,"watch-breakpoint-default-unverified":n.breakpointDisabledUp,"watch-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"watch-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"watch-breakpoint-log-unverified-up":n.breakpointDisabledUp,"watch-breakpoint-log-unverified-down":n.breakpointDisabledDown,"watch-breakpoint-both-unverified-up":n.breakpointDisabledUp,"watch-breakpoint-both-unverified-down":n.breakpointDisabledDown,"function-breakpoint-default":n.breakpointEnabledUp,"function-breakpoint-conditional-up":n.breakpointEnabledUp,"function-breakpoint-conditional-down":n.breakpointEnabledDown,"function-breakpoint-log-up":n.breakpointEnabledUp,"function-breakpoint-log-down":n.breakpointEnabledDown,"function-breakpoint-both-up":n.breakpointEnabledUp,"function-breakpoint-both-down":n.breakpointEnabledDown,"function-breakpoint-default-disabled":n.breakpointDisabledUp,"function-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"function-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"function-breakpoint-log-disabled-up":n.breakpointDisabledUp,"function-breakpoint-log-disabled-down":n.breakpointDisabledDown,"function-breakpoint-both-disabled-up":n.breakpointDisabledUp,"function-breakpoint-both-disabled-down":n.breakpointDisabledDown,"function-breakpoint-default-unverified":n.breakpointDisabledUp,"function-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"function-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"function-breakpoint-log-unverified-up":n.breakpointDisabledUp,"function-breakpoint-log-unverified-down":n.breakpointDisabledDown,"function-breakpoint-both-unverified-up":n.breakpointDisabledUp,"function-breakpoint-both-unverified-down":n.breakpointDisabledDown,"line-breakpoint-default":n.breakpointEnabledUp,"line-breakpoint-conditional-up":n.breakpointEnabledUp,"line-breakpoint-conditional-down":n.breakpointEnabledDown,"line-breakpoint-log-up":n.breakpointEnabledUp,"line-breakpoint-log-down":n.breakpointEnabledDown,"line-breakpoint-both-up":n.breakpointEnabledUp,"line-breakpoint-both-down":n.breakpointEnabledDown,"line-breakpoint-default-disabled":n.breakpointDisabledUp,"line-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"line-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"line-breakpoint-log-disabled-up":n.breakpointDisabledUp,"line-breakpoint-log-disabled-down":n.breakpointDisabledDown,"line-breakpoint-both-disabled-up":n.breakpointDisabledUp,"line-breakpoint-both-disabled-down":n.breakpointDisabledDown,"line-breakpoint-default-unverified":n.breakpointDisabledUp,"line-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"line-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"line-breakpoint-log-unverified-up":n.breakpointDisabledUp,"line-breakpoint-log-unverified-down":n.breakpointDisabledDown,"line-breakpoint-both-unverified-up":n.breakpointDisabledUp,"line-breakpoint-both-unverified-down":n.breakpointDisabledDown,"small-class-breakpoint-default":n.breakpointEnabledUp,"small-class-breakpoint-conditional-up":n.breakpointEnabledUp,"small-class-breakpoint-conditional-down":n.breakpointEnabledDown,"small-class-breakpoint-log-up":n.breakpointEnabledUp,"small-class-breakpoint-log-down":n.breakpointEnabledDown,"small-class-breakpoint-both-up":n.breakpointEnabledUp,"small-class-breakpoint-both-down":n.breakpointEnabledDown,"small-class-breakpoint-default-disabled":n.breakpointDisabledUp,"small-class-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"small-class-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"small-class-breakpoint-log-disabled-up":n.breakpointDisabledUp,"small-class-breakpoint-log-disabled-down":n.breakpointDisabledDown,"small-class-breakpoint-both-disabled-up":n.breakpointDisabledUp,"small-class-breakpoint-both-disabled-down":n.breakpointDisabledDown,"small-exception-breakpoint-default":n.breakpointEnabledUp,"small-exception-breakpoint-conditional-up":n.breakpointEnabledUp,"small-exception-breakpoint-conditional-down":n.breakpointEnabledDown,"small-exception-breakpoint-log-up":n.breakpointEnabledUp,"small-exception-breakpoint-log-down":n.breakpointEnabledDown,"small-exception-breakpoint-both-up":n.breakpointEnabledUp,"small-exception-breakpoint-both-down":n.breakpointEnabledDown,"small-exception-breakpoint-default-disabled":n.breakpointDisabledUp,"small-exception-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"small-exception-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"small-exception-breakpoint-log-disabled-up":n.breakpointDisabledUp,"small-exception-breakpoint-log-disabled-down":n.breakpointDisabledDown,"small-exception-breakpoint-both-disabled-up":n.breakpointDisabledUp,"small-exception-breakpoint-both-disabled-down":n.breakpointDisabledDown,"small-watch-breakpoint-default":n.breakpointEnabledUp,"small-watch-breakpoint-conditional-up":n.breakpointEnabledUp,"small-watch-breakpoint-conditional-down":n.breakpointEnabledDown,"small-watch-breakpoint-log-up":n.breakpointEnabledUp,"small-watch-breakpoint-log-down":n.breakpointEnabledDown,"small-watch-breakpoint-both-up":n.breakpointEnabledUp,"small-watch-breakpoint-both-down":n.breakpointEnabledDown,"small-watch-breakpoint-default-disabled":n.breakpointDisabledUp,"small-watch-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"small-watch-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"small-watch-breakpoint-log-disabled-up":n.breakpointDisabledUp,"small-watch-breakpoint-log-disabled-down":n.breakpointDisabledUp,"small-watch-breakpoint-both-disabled-up":n.breakpointDisabledUp,"small-watch-breakpoint-both-disabled-down":n.breakpointDisabledDown,"small-watch-breakpoint-default-unverified":n.breakpointDisabledUp,"small-watch-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"small-watch-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"small-watch-breakpoint-log-unverified-up":n.breakpointDisabledUp,"small-watch-breakpoint-log-unverified-down":n.breakpointDisabledDown,"small-watch-breakpoint-both-unverified-up":n.breakpointDisabledUp,"small-watch-breakpoint-both-unverified-down":n.breakpointDisabledDown,"small-function-breakpoint-default":n.breakpointEnabledUp,"small-function-breakpoint-conditional-up":n.breakpointEnabledUp,"small-function-breakpoint-conditional-down":n.breakpointEnabledDown,"small-function-breakpoint-log-up":n.breakpointEnabledUp,"small-function-breakpoint-log-down":n.breakpointEnabledDown,"small-function-breakpoint-both-up":n.breakpointEnabledUp,"small-function-breakpoint-both-down":n.breakpointEnabledDown,"small-function-breakpoint-default-disabled":n.breakpointDisabledUp,"small-function-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"small-function-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"small-function-breakpoint-log-disabled-up":n.breakpointDisabledUp,"small-function-breakpoint-log-disabled-down":n.breakpointDisabledDown,"small-function-breakpoint-both-disabled-up":n.breakpointDisabledUp,"small-function-breakpoint-both-disabled-down":n.breakpointDisabledDown,"small-function-breakpoint-default-unverified":n.breakpointDisabledUp,"small-function-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"small-function-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"small-function-breakpoint-log-unverified-up":n.breakpointDisabledUp,"small-function-breakpoint-log-unverified-down":n.breakpointDisabledDown,"small-function-breakpoint-both-unverified-up":n.breakpointDisabledUp,"small-function-breakpoint-both-unverified-down":n.breakpointDisabledDown,"small-line-breakpoint-default":n.breakpointEnabledUp,"small-line-breakpoint-conditional-up":n.breakpointEnabledUp,"small-line-breakpoint-conditional-down":n.breakpointEnabledDown,"small-line-breakpoint-log-up":n.breakpointEnabledUp,"small-line-breakpoint-log-down":n.breakpointEnabledDown,"small-line-breakpoint-both-up":n.breakpointEnabledUp,"small-line-breakpoint-both-down":n.breakpointEnabledDown,"small-line-breakpoint-default-disabled":n.breakpointDisabledUp,"small-line-breakpoint-conditional-disabled-up":n.breakpointDisabledUp,"small-line-breakpoint-conditional-disabled-down":n.breakpointDisabledDown,"small-line-breakpoint-log-disabled-up":n.breakpointDisabledUp,"small-line-breakpoint-log-disabled-down":n.breakpointDisabledDown,"small-line-breakpoint-both-disabled-up":n.breakpointDisabledUp,"small-line-breakpoint-both-disabled-down":n.breakpointDisabledDown,"small-line-breakpoint-default-unverified":n.breakpointDisabledUp,"small-line-breakpoint-conditional-unverified-up":n.breakpointDisabledUp,"small-line-breakpoint-conditional-unverified-down":n.breakpointDisabledDown,"small-line-breakpoint-log-unverified-up":n.breakpointDisabledUp,"small-line-breakpoint-log-unverified-down":n.breakpointDisabledDown,"small-line-breakpoint-both-unverified-up":n.breakpointDisabledUp,"small-line-breakpoint-both-unverified-down":n.breakpointDisabledDown,"multiple-breakpoints-default":n.breakpointEnabledUp,"multiple-breakpoints-toggle":n.breakpointEnabledUp,"multiple-breakpoints-number-2-up":n.breakpointEnabledUp,"multiple-breakpoints-number-2-down":n.breakpointEnabledDown,"multiple-breakpoints-number-3-up":n.breakpointEnabledUp,"multiple-breakpoints-number-3-down":n.breakpointEnabledDown,"multiple-breakpoints-number-4-up":n.breakpointEnabledUp,"multiple-breakpoints-number-4-down":n.breakpointEnabledDown,"multiple-breakpoints-number-5-up":n.breakpointEnabledUp,"multiple-breakpoints-number-5-down":n.breakpointEnabledDown,"multiple-breakpoints-number-6-up":n.breakpointEnabledUp,"multiple-breakpoints-number-6-down":n.breakpointEnabledDown,"multiple-breakpoints-number-7-up":n.breakpointEnabledUp,"multiple-breakpoints-number-7-down":n.breakpointEnabledDown,"multiple-breakpoints-number-8-up":n.breakpointEnabledUp,"multiple-breakpoints-number-8-down":n.breakpointEnabledDown,"multiple-breakpoints-number-9-up":n.breakpointEnabledUp,"multiple-breakpoints-number-9-down":n.breakpointEnabledDown,"multiple-breakpoints-number-alot-up":n.breakpointEnabledUp,"multiple-breakpoints-number-alot-down":n.breakpointEnabledDown,"multiple-breakpoints-default-disabled":n.breakpointDisabledUp,"multiple-breakpoints-toggle-disabled":n.breakpointDisabledUp,"multiple-breakpoints-number-2-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-2-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-3-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-3-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-4-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-4-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-5-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-5-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-6-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-6-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-7-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-7-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-8-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-8-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-9-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-9-disabled-down":n.breakpointDisabledDown,"multiple-breakpoints-number-alot-disabled-up":n.breakpointDisabledUp,"multiple-breakpoints-number-alot-disabled-down":n.breakpointDisabledDown,"mute-breakpoints-up":n.breakpointEnabledUp,"mute-breakpoints-down":n.breakpointDisabledUp,"multiple-breakpoints-number-2-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-2-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-3-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-3-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-4-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-4-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-5-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-5-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-6-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-6-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-7-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-7-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-8-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-8-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-9-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-9-unverified-down":n.breakpointMultipleUverifiedDown,"multiple-breakpoints-number-alot-unverified-up":n.breakpointMultipleUverifiedUp,"multiple-breakpoints-number-alot-unverified-down":n.breakpointMultipleUverifiedDown,"breakpoint-add":n.breakpointDisabledUp,"breakpoint-remove":n.breakpointDisabledUp,"breakpoint-collapse-all":n.breakpointDisabledUp,"breakpoint-expand-all":n.breakpointDisabledUp,"breakpoint-group-by-class-up":n.breakpointDisabledUp,"breakpoint-group-by-class-down":n.iconActive,"breakpoint-group-by-file":n.breakpointDisabledUp,"breakpoint-group-by-package":n.breakpointDisabledUp,"tools-breakpoint-view-up":n.iconActive,"tools-breakpoint-view-down":n.iconEnabledColor,"tools-breakpoint-view-not-up-active":n.breakpointToolsViewNotActiveUp,"tools-breakpoint-view-not-down-active":n.breakpointDisabledDown,"debug-all":n.debugAll,"last-executed-down":n.actionViewItemColor,"last-executed-up":n.debugAll,success:n.actionViewItemColor,fail:n.actionViewItemColor,refresh:n.actionViewItemColor,"color-mode":n.jdkDown,copy:n.jdkDown,cut:n.jdkDown,"debug-rerun-up":n.debugRerunDowm,"debug-rerun-down":n.debugAll,debug:n.debugAll,"folder-open":n.jdkDown,gear:n.jdkDown,"keyboard-keys":n.jdkDown,redo:n.jdkDown,run:n.debugAll,save:n.jdkDown,undo:n.jdkDown,"run-failed-down":n.errorStatusColor,"run-failed-up":n.debugAll,"run-passed":n.debugAll,warn:n.actionViewItemColor,"run-failed-editor-up":n.errorStatusColor,"run-failed-editor-down":n.debugAll,"run-failed-outdated-editor-up":n.failOutdatedColor,"run-failed-outdated-editor-down":n.debugAll,"run-passed-editor":n.debugAll,"run-passed-outdated-editor-up":n.failOutdatedColor,"run-passed-outdated-editor-down":n.debugAll,important:n.errorStatusColor,"git-graph-up":n.siderbarIconUpDefault,"git-graph-down":n.siderbarIconDownDefault,"git-graph-up-active":n.siderbarIconUpActive,"git-graph-down-active":n.siderbarIconDownActive,maven:n.siderbarIconDownDefault,"maven-active":n.siderbarIconDownActive,gradle:n.siderbarIconDownDefault,"gradle-active":n.siderbarIconDownActive,"debug-run-to-cursor":n.debugPause,"breakpoints-up":n.javaToolsIconDefaultUp,"breakpoints-down":n.javaToolsIconDefaultDown,"breakpoints-up-active":n.javaToolsIconActiveUp,"breakpoints-down-active":n.javaToolsIconActiveDown,"application-servers-up":n.javaToolsIconDefaultUp,"application-servers-down":n.javaToolsIconDefaultDown,"application-servers-up-active":n.javaToolsIconActiveUp,"application-servers-down-active":n.javaToolsIconActiveDown,"call-hierarchy-up":n.javaToolsIconDefaultDown,"call-hierarchy-down":n.javaToolsIconDefaultUp,"call-hierarchy-up-active":n.javaToolsIconActiveDown,"call-hierarchy-down-active":n.javaToolsIconActiveUp,"connections-up":n.javaToolsIconDefaultUp,"connections-down":n.javaToolsIconDefaultDown,"connections-up-active":n.javaToolsIconActiveUp,"connections-down-active":n.javaToolsIconActiveDown,"dependencies-up":n.javaToolsIconDefaultUp,"dependencies-down":n.javaToolsIconDefaultDown,"dependencies-up-active":n.javaToolsIconActiveUp,"dependencies-down-active":n.javaToolsIconActiveDown,"explorer-up":n.javaToolsIconDefaultUp,"explorer-down":n.javaToolsIconDefaultDown,"explorer-up-active":n.javaToolsIconActiveUp,"explorer-down-active":n.javaToolsIconActiveDown,"find-usages-up":n.javaToolsIconDefaultDown,"find-usages-down":n.javaToolsIconDefaultUp,"find-usages-up-active":n.javaToolsIconActiveDown,"find-usages-down-active":n.javaToolsIconActiveUp,"run-debug-up":n.javaToolsIconDefaultUp,"run-debug-down":n.javaToolsIconDefaultDown,"run-debug-up-active":n.javaToolsIconActiveUp,"run-debug-down-active":n.javaToolsIconActiveDown,"structures-up":n.javaToolsIconDefaultDown,"structures-down":n.javaToolsIconDefaultUp,"structures-up-active":n.javaToolsIconActiveDown,"structures-down-active":n.javaToolsIconActiveUp,"tools-type-hierarchy-up":n.javaToolsIconDefaultDown,"tools-type-hierarchy-down":n.javaToolsIconDefaultUp,"tools-type-hierarchy-up-active":n.javaToolsIconActiveDown,"tools-type-hierarchy-down-active":n.javaToolsIconActiveUp,"circle-filled-ansiMediumTurquoise":n.terminalAnsiMediumTurquoise,"circle-filled-ansiChocolate":n.terminalAnsiChocolate,"circle-filled-ansiMediumOrchid":n.terminalAnsiMediumOrchid,"circle-filled-ansiRoyalBlue":n.terminalAnsiRoyalBlue,"circle-filled-ansiNavajoWhite":n.terminalAnsiNavajoWhite,"circle-filled-ansiDarkSeaGreen":n.terminalAnsiDarkSeaGreen,"circle-filled-ansiMediumSlateBlue":n.terminalAnsiMediumSlateBlue,"circle-filled-ansiPaleVioletRed":n.terminalAnsiPaleVioletRed,"circle-filled-ansiSpringGreen":n.terminalAnsiSpringGreen,"circle-filled-ansiLightSkyBlue":n.terminalAnsiLightSkyBlue,"step-into-target":n.noDataUp,gitcode:n.gitcode,"spring-gutter-run-controller-down":n.failOutdatedColor,"spring-gutter-run-controller-up":n.compassActive,"spring-explorer-down":n.springExplorerDown,"spring-explorer-up":n.springExplorerUp}},4945(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.styles=void 0;const n=i(6199);t.styles=`\n\n.scrollbar.visible {\n\topacity: 1;\n\ttransition: opacity 100ms linear;\n}\n.scrollbar.invisible {\n\topacity: 0;\n\tpointer-events: none;\n}\n.scrollbar.invisible.fade {\n\ttransition: opacity 800ms linear;\n}\n\n/* Scrollable Content Inset Shadow */\n.shadow {\n\tposition: absolute;\n\tdisplay: none;\n}\n.shadow.top {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 3px;\n\theight: 3px;\n\twidth: 100%;\n}\n.shadow.left {\n\tdisplay: block;\n\ttop: 3px;\n\tleft: 0;\n\theight: 100%;\n\twidth: 3px;\n}\n.shadow.top-left-corner {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 0;\n\theight: 3px;\n\twidth: 3px;\n}\n.shadow.top {\n\tbox-shadow: ${n.scrollbarShadow} 0 6px 6px -6px inset;\n}\n\n.shadow.left {\n\tbox-shadow: ${n.scrollbarShadow} 6px 0 6px -6px inset;\n}\n\n.shadow.top.left {\n\tbox-shadow: ${n.scrollbarShadow} 6px 6px 6px -6px inset;\n}\n.scrollbar > .slider {\n\tbackground: ${n.scrollbarSliderBackground};\n}\n.scrollbar > .slider:hover {\n\tbackground: ${n.scrollbarSliderHoverBackground};\n}\n.scrollbar > .slider.active {\n\tbackground: ${n.scrollbarSliderActiveBackground};\n}\n`},5079(e,t,i){"use strict";var n=this&&this.__decorate||function(e,t,i,n){var o,s=arguments.length,r=s<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(r=(s<3?o(r):s>3?o(t,i,r):o(t,i))||r);return s>3&&r&&Object.defineProperty(t,i,r),r},o=this&&this.__metadata||function(e,t){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(e,t)},s=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0});const r=i(4275),a=i(7651),l=i(9603);let d=class extends r.AbstractFrontend{constructor(){super(...arguments),this.pluginBody=document.querySelector(".plugin-body"),this.HIDE_CLASS_NAME="hide-element",this.OTHER_REASON_ID="5",this.title={titleBar:void 0,closeContainer:void 0},this.suggestion={input:void 0,unsatisfiedInput:void 0,title:void 0,container:void 0,description:void 0,errorTips:void 0},this.button={buttonElement:void 0,okButton:void 0,cancelButton:void 0,loading:void 0},this.satisfied={reasonContainer:void 0,reasonInput:void 0,checkboxList:void 0,reasonErrorTips:void 0,reasonInputErrorTips:void 0},this.unsatisfied={reasonContainer:void 0,reasonInput:void 0,checkboxList:void 0,reasonErrorTips:void 0,reasonInputErrorTips:void 0},this.disposables=[],this.handleContextMenu=e=>{e.target!==this.suggestion.input&&e.target!==this.unsatisfied.reasonInput&&e.target!==this.satisfied.reasonInput&&e.preventDefault()},this.handleSuggestionInputChange=e=>{null==e||e.onDidChange(e=>{this.formData.otherSuggestion=e;const t=e===this.plugin.localize("suggestion.default.value")&&Number(this.formData.score)<8;this.toggleErrorTip(this.suggestion.errorTips,t),this.updateDialogSize()})},this.handleOkButtonClick=e=>{e.currentTarget.classList.contains("disabled")||this.checkBeforeCreate()&&(this.formData.reasonsKeys=Array.from(this.formData.reasons.keys()).join(","),this.formData.reasonsValues=Array.from(this.formData.reasons.values()).join(","),this.plugin.call("submit",this.formData))},this.handleCloseClick=()=>{this.formData=l.Util.formData,this.plugin.call("close.dialog")},this.handleRateClick=e=>{const t=e.target,i=t.id;if(!i)return;t.classList.add("selected"),this.ratesContainer.querySelectorAll(".rate").forEach(e=>{e.id!==i&&e.classList.remove("selected")});const n=Number(i)>8;""!==this.formData.score&&this.isSatisfied===n||(this.formData=l.Util.formData,this.updateElementStatus(i),this.clearComponentStatus(n)),this.formData.score=i}}init(){return s(this,void 0,void 0,function*(){this.container=document.createElement("div"),this.container.classList.add("container"),this.pluginBody.append(this.container),this.formData=l.Util.formData,this.container.addEventListener("contextmenu",this.handleContextMenu)})}run(){this.initTemplate(),this.registerEvent()}getActiveElements(){return this.isSatisfied?this.satisfied:this.unsatisfied}hideElement(e){null==e||e.classList.add(this.HIDE_CLASS_NAME)}showElement(e){null==e||e.classList.remove(this.HIDE_CLASS_NAME)}updateElementStatus(e){if(!e)return;const t=Number(e)>8,i=t?this.satisfied:this.unsatisfied,n=t?this.unsatisfied:this.satisfied;this.hideElement(n.reasonContainer),this.showElement(i.reasonContainer),this.suggestion.title&&(this.suggestion.title.textContent=t?this.plugin.localize("suggestion.title"):this.plugin.localize("suggestion.unsatisfactory.title")),t?(this.showElement(this.suggestion.description),this.showElement(this.suggestion.input),this.hideElement(this.suggestion.unsatisfiedInput)):(this.hideElement(this.suggestion.description),this.showElement(this.suggestion.unsatisfiedInput),this.hideElement(this.suggestion.input)),this.showElement(this.suggestion.container),this.showElement(this.button.buttonElement),this.updateDialogSize(t),this.formData.reasons.clear()}initTemplate(){this.title=l.Util.renderTitleBar(this.plugin.localize("dialog.title")),this.ratesContainer=l.Util.renderRatesContainer(this.plugin.localize("unsatisfactory"),this.plugin.localize("satisfied")),this.unsatisfied=l.Util.renderReasonContainer(this.plugin.localize("reason.unsatisfactory.title"),this.plugin.localize("reason.description"),l.Util.reasonsList.map(e=>this.plugin.localize(e)),this.plugin.localize("reason.tips"),this.plugin.localize("reason.placeholder"),this.plugin.localize("suggestion.tips")),this.satisfied=l.Util.renderReasonContainer(this.plugin.localize("reason.title"),this.plugin.localize("reason.description"),l.Util.satisfiedReasonsList.map(e=>this.plugin.localize(e)),this.plugin.localize("reason.tips"),this.plugin.localize("reason.placeholder"),this.plugin.localize("suggestion.tips")),this.suggestion=l.Util.renderOtherSuggestion(this.plugin.localize("suggestion.title"),this.plugin.localize("suggestion.description"),this.plugin.localize("suggestion.default.value"),this.plugin.localize("suggestion.tips")),this.button=l.Util.renderButtonContainer(this.plugin.localize("button.ok"),this.plugin.localize("button.cacel")),this.container.append(this.title.titleBar,this.ratesContainer,this.unsatisfied.reasonContainer,this.satisfied.reasonContainer,this.suggestion.container,this.button.buttonElement),this.disposables.push(this.unsatisfied.reasonInput,this.suggestion.input)}registerEvent(){this.ratesContainer.addEventListener("click",this.handleRateClick),this.registerCheckboxEvents(this.unsatisfied.checkboxList),this.registerCheckboxEvents(this.satisfied.checkboxList),this.title.closeContainer.addEventListener("click",this.handleCloseClick),this.registerReasonInputEvent(this.unsatisfied.reasonInput,this.unsatisfied.reasonInputErrorTips),this.registerReasonInputEvent(this.satisfied.reasonInput,this.satisfied.reasonInputErrorTips),this.handleSuggestionInputChange(this.suggestion.input),this.handleSuggestionInputChange(this.suggestion.unsatisfiedInput),this.button.okButton.addEventListener("click",this.handleOkButtonClick),this.button.cancelButton.addEventListener("click",this.handleCloseClick)}registerCheckboxEvents(e){null==e||e.forEach((e,t)=>{e.onDidChange(e=>this.onDidCheckboxChange(e,t.toString()))})}registerReasonInputEvent(e,t){null==e||e.onDidChange(e=>{this.formData.otherReason=e,this.toggleErrorTip(t,!e),this.updateDialogSize()})}toggleErrorTip(e,t){t?this.showElement(e):this.hideElement(e)}isElementVisible(e){return!!e&&!e.classList.contains(this.HIDE_CLASS_NAME)}calculateErrorTipsHeight(...e){let t=0;return e.forEach(e=>{this.isElementVisible(e)&&(t+=l.Util.ERROR_TIP_HEIGHT)}),t}updateDialogSize(e){let t=l.Util.DEFAULT_HEIGHT;const i=this.formData.reasons.has(this.OTHER_REASON_ID),n=this.getActiveElements();i&&(t+=l.Util.INPUT_HEIGHT),t+=this.calculateErrorTipsHeight(n.reasonErrorTips,n.reasonInputErrorTips),this.plugin.call("update.dialog.size",t,null!=e?e:this.isSatisfied)}get isSatisfied(){return Number(this.formData.score)>8}checkBeforeCreate(){const{reasons:e,otherReason:t,otherSuggestion:i}=this.formData,n=this.getActiveElements();let o=!0;return 0===e.size&&(this.showElement(n.reasonErrorTips),o=!1),e.has(this.OTHER_REASON_ID)&&!t&&(this.showElement(n.reasonInputErrorTips),o=!1),this.isSatisfied||i!==this.plugin.localize("suggestion.default.value")||(this.showElement(this.suggestion.errorTips),o=!1),this.updateDialogSize(),o}onDidCheckboxChange(e,t){const i=this.getActiveElements();this.hideElement(i.reasonErrorTips),this.hideElement(i.reasonInputErrorTips),e.isChecked?this.formData.reasons.set(t,e.label):this.formData.reasons.delete(t);const n=this.formData.reasons;n.has(this.OTHER_REASON_ID)?this.showElement(i.reasonInput):this.hideElement(i.reasonInput),this.updateDialogSize(),this.updateCheckboxState(i.checkboxList,n.size)}updateCheckboxState(e,t){const i=t>=3;null==e||e.forEach(e=>{e.isChecked||e.setEnabled(!i)})}clearComponentStatus(e){var t;this.hideAllErrorTips();const i=e?this.satisfied:this.unsatisfied;this.formData.otherReason=i.reasonInput.value,null===(t=i.checkboxList)||void 0===t||t.forEach(e=>{e.isChecked&&(this.formData.reasons.set(e.value,e.label),e.setEnabled(!0))}),this.formData.otherSuggestion=e?this.suggestion.input.value:this.suggestion.unsatisfiedInput.value}hideAllErrorTips(){this.hideElement(this.unsatisfied.reasonErrorTips),this.hideElement(this.satisfied.reasonErrorTips),this.hideElement(this.unsatisfied.reasonInputErrorTips),this.hideElement(this.satisfied.reasonInputErrorTips),this.hideElement(this.suggestion.errorTips)}updateLoadingStatus(e){var t,i;e?(this.showElement(this.button.loading),null===(t=this.button.okButton)||void 0===t||t.classList.add("disabled")):(this.hideElement(this.button.loading),null===(i=this.button.okButton)||void 0===i||i.classList.remove("disabled"))}stop(){this.disposables.forEach(e=>e.dispose()),l.Util.disposables.forEach(e=>e.dispose()),this.container.removeEventListener("contextmenu",this.handleContextMenu),this.ratesContainer.removeEventListener("click",this.handleRateClick),this.title.closeContainer.removeEventListener("click",this.handleCloseClick),this.button.okButton.removeEventListener("click",this.handleOkButtonClick),this.button.cancelButton.removeEventListener("click",this.handleCloseClick)}};n([(0,a.expose)("updateLoadingStatus"),o("design:type",Function),o("design:paramtypes",[Boolean]),o("design:returntype",void 0)],d.prototype,"updateLoadingStatus",null),d=n([a.exposable],d),document.addEventListener("DOMContentLoaded",()=>{r.PluginPage.create([d])})},5093(e,t){"use strict";var i,n,o;Object.defineProperty(t,"__esModule",{value:!0}),t.SelectPosition=t.SelectAlignment=t.SelectSize=void 0,(o=t.SelectSize||(t.SelectSize={})).MINIMAL="minimal",o.SMALL="small",o.MEDIUM="medium",(n=t.SelectAlignment||(t.SelectAlignment={})).LEFT="left",n.RIGHT="right",(i=t.SelectPosition||(t.SelectPosition={})).TOP="top",i.BOTTOM="bottom"},5354(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.applyTheme=t.getTheme=t.addThemeObserver=t.workbenchObserver=t.initThemeChangeListener=t.ideChecker=t.register=t.getQueryVariable=void 0;const i=[],n=[];let o,s=!1;function r(e){const t=window.location.search.substring(1).split("&");for(let i=0;i<t.length;i++){const n=t[i].split("=");if(n[0]===e)return n[1]}return""}function a(){new Promise((e,t)=>{"complete"===document.readyState?e():window.addEventListener("load",()=>e()),setTimeout(()=>t(),9e4)}).then(()=>{u(),l()}).catch(()=>{console.error("IDEUI apply theme error.")})}function l(){const e=new MutationObserver(()=>{if(!document)return;const i=document.querySelector(".monaco-workbench.windows")||document.querySelector(".monaco-workbench.linux")||document.body;i&&(t.ideChecker.isCodeArtsIDE(),d(i),e.disconnect())});e.observe(document,{childList:!0,subtree:!0})}function d(e){new MutationObserver(()=>{u(),t.ideChecker.isCodeArtsIDE()}).observe(e,{attributes:!0,attributeFilter:["class"]})}function c(){const e=(null===document||void 0===document?void 0:document.querySelector(".monaco-workbench.windows"))||(null===document||void 0===document?void 0:document.querySelector(".monaco-workbench.linux"));if(e)return e.classList.contains("vs-dark")?"dark":"light";if(document.body&&document.body.classList.contains("vscode-dark"))return"dark";if(document.body&&document.body.classList.contains("vscode-light"))return"light";if(r("globals")&&r("globals").startsWith("backgrounds.value"))return r("globals").endsWith("hex(1e1e1e)")?"dark":"light";const t=document.getElementById("monaco-parts-splash");return(null==t?void 0:t.classList.contains("vs"))?"light":"dark"}function u(e){const t=e||c();if(o===t||"dark"!==t&&"light"!==t)return;o=t,document.documentElement.setAttribute("data-theme",o);const s=document.createElement("style"),r=`:root[data-theme='dark']{${i.join(";")}}`,a=`:root[data-theme='light']{${n.join(";")}}`;s.innerText=r+a,document.head.appendChild(s)}t.getQueryVariable=r,t.register=function(e,t){const o=`--ide-ui-${e}`;return i.push(`${o}: ${"object"==typeof t?t.dark:t}`),n.push(`${o}: ${"object"==typeof t?t.light:t}`),s||(a(),s=!0),`var(${o})`},t.ideChecker=new class{constructor(){this._isIDE=!1,this.isCodeArtsIDE()}isCodeArtsIDE(){var e;const t=document.querySelector(".monaco-workbench"),i=document.documentElement,n=window.getComputedStyle(i).getPropertyValue("--vscode-font-family"),o=!("false"===(null===(e=t||i)||void 0===e?void 0:e.getAttribute("is-ide-ui-theme-compatible")));this.isIDE=o&&(!!t||!!n)}get isIDE(){return this._isIDE}set isIDE(e){this._isIDE=e}},t.initThemeChangeListener=a,t.workbenchObserver=l,t.addThemeObserver=d,t.getTheme=c,t.applyTheme=u},5366(e,t){"use strict";function i(e){if("[object Object]"!==Object.prototype.toString.call(e))throw new Error("The type of parameter 'highlights' should include Object elements.");if(!Object.keys(e).includes("start")||!Object.keys(e).includes("end"))throw new Error("The element of 'highlights' should contain parameters 'start' & 'end'.");if("[object Number]"!==Object.prototype.toString.call(e.start)||"[object Number]"!==Object.prototype.toString.call(e.end))throw new Error("The start and end parameters in the highlights element must be of type number.")}Object.defineProperty(t,"__esModule",{value:!0}),t.deepClone=t.checkEveryElementType=t.checkHighlightsType=t.isValueExist=t.isValueRepeat=t.filterAttribute=t.updateSpacingFromAttribute=t.createUnderlineStr=void 0,t.createUnderlineStr=function(e,t){const i=null==e?void 0:e.charAt(t),n=null==e?void 0:e.substring(0,t),o=null==e?void 0:e.substring(t+1),s=document.createElement("span");s.textContent=n;const r=document.createElement("span");r.textContent=o;const a=document.createElement("span");a.classList.add("ide-replacement"),a.style.textDecoration="underline",a.textContent=`${i}`;const l=document.createElement("span");return l.append(s,a,r),l},t.updateSpacingFromAttribute=function(e,t){if(e){const i=e.getAttribute("rowSpacing"),n=e.getAttribute("columnSpacing");t.paddingRight=`${null===i?"":i}px`,t.paddingBottom=`${null===n?"":n}px`}},t.filterAttribute=function(e){if(null!==e)return"true"===e||"false"!==e&&e},t.isValueRepeat=function(e){if(new Set(e).size!==e.length)throw new Error("Duplicate value exist.")},t.isValueExist=function(e){if(!e)throw new Error("Value is Mandatory.")},t.checkHighlightsType=function(e){if("[object Array]"!==Object.prototype.toString.call(e))throw new Error("The type of parameter 'highlights' is incorrect.");if(e.length)for(let t=0;t<e.length;t++)i(e[t])},t.checkEveryElementType=i,t.deepClone=function e(t){if("object"!=typeof t||null===t)return t;const i=Array.isArray(t)?[]:{};for(const n in t)Object.prototype.hasOwnProperty.call(t,n)&&("object"==typeof t[n]&&null!==t[n]?i[n]=e(t[n]):i[n]=t[n]);return i}},5483(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.format=void 0,t.format=function(e,t){let i=e;return i=0===t.length?e:e.replace(/\{(\d+)\}/g,(e,i)=>{const n=i[0],o=t[n];let s=e;return"string"==typeof o?s=o:"number"!=typeof o&&"boolean"!=typeof o&&null!=o||(s=String(o)),s}),i}},5574(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.iconConversionMapping=t.doubleIconMapping=t.codiconMapping=t.mapping=void 0,t.mapping={add:6e4,plus:6e4,"gist-new":6e4,"repo-create":6e4,lightbulb:60001,"light-bulb":60001,repo:60002,"repo-delete":60002,"gist-fork":60003,"repo-forked":60003,"git-pull-request":60004,"git-pull-request-abandoned":60004,"record-keys":60005,keyboard:60005,tag:60006,"tag-add":60006,"tag-remove":60006,person:60007,"person-follow":60007,"person-outline":60007,"person-filled":60007,"git-branch":60008,"git-branch-create":60008,"git-branch-delete":60008,"source-control":60008,mirror:60009,"mirror-public":60009,star:60010,"star-add":60010,"star-delete":60010,"star-empty":60010,comment:60011,"comment-add":60011,warning:60012,alert:60012,search:60013,"search-save":60013,"log-out":60014,"sign-out":60014,"log-in":60015,"sign-in":60015,eye:60016,"eye-unwatch":60016,"eye-watch":60016,"circle-filled":60017,"primitive-dot":60017,"close-dirty":60017,"debug-breakpoint":63598,"debug-breakpoint-disabled":63598,"debug-hint":63598,"primitive-square":60018,edit:60019,pencil:60019,info:60020,"issue-opened":60020,"gist-private":60021,"git-fork-private":60021,lock:60021,"mirror-private":60021,close:60022,"remove-close":60022,x:60022,"repo-sync":60023,sync:60023,clone:60024,"desktop-download":60024,beaker:60025,microscope:60025,vm:60026,"device-desktop":60026,file:60027,"file-text":60027,more:60028,ellipsis:60028,"kebab-horizontal":60028,"mail-reply":60029,reply:60029,organization:63583,"organization-filled":63583,"organization-outline":63583,"new-file":60031,"file-add":60031,"new-folder":60032,"file-directory-create":60032,trash:60033,trashcan:60033,history:60433,clock:60034,folder:60035,"file-directory":60035,"symbol-folder":60035,"logo-github":60036,"mark-github":60036,github:60036,terminal:60037,console:60037,repl:60037,zap:60038,"symbol-event":60038,error:60039,stop:60039,variable:60040,"symbol-variable":60040,array:60042,"symbol-array":60042,"symbol-module":60043,"symbol-package":60043,"symbol-namespace":60043,"symbol-object":60043,"symbol-method":60044,"symbol-function":60045,"symbol-constructor":60046,"symbol-boolean":60047,"symbol-null":60047,"symbol-numeric":60048,"symbol-number":60048,"symbol-structure":60049,"symbol-struct":60049,"symbol-parameter":60050,"symbol-key":60051,"go-to-file":60052,"symbol-enum":60053,"symbol-ruler":60054,"activate-breakpoints":60055,archive:60056,"arrow-both":60057,"arrow-down":60058,"arrow-left":60059,"arrow-right":60060,"arrow-small-down":60061,"arrow-small-left":60062,"arrow-small-right":60063,"arrow-small-up":60064,"arrow-up":60065,bell:60066,bold:60067,book:60068,bookmark:60069,"debug-breakpoint-conditional-unverified":60070,"debug-breakpoint-conditional":60071,"debug-breakpoint-conditional-disabled":60071,"debug-breakpoint-data-unverified":60072,"debug-breakpoint-data":60073,"debug-breakpoint-data-disabled":60073,"debug-breakpoint-log-unverified":60074,"debug-breakpoint-log":60075,"debug-breakpoint-log-disabled":60075,briefcase:60076,broadcast:60077,browser:60078,bug:60079,calendar:60080,"case-sensitive":60081,check:60082,checklist:60083,"chevron-down":60084,"chevron-left":60085,"chevron-right":60086,"chevron-up":60087,"chrome-close":60088,"chrome-maximize":60089,"chrome-minimize":60090,"chrome-restore":60091,"circle-outline":60092,"debug-breakpoint-unverified":60092,"circle-slash":60093,"circuit-board":60094,"clear-all":60095,clippy:60096,"close-all":60097,"cloud-download":60098,"cloud-upload":60099,code:60100,"collapse-all":60101,"color-mode":60102,"comment-discussion":60103,"credit-card":60105,dash:60108,dashboard:60109,database:60110,"debug-continue":60111,"debug-disconnect":60112,"debug-pause":60113,"debug-restart":60114,"debug-start":60115,"debug-step-into":60116,"debug-step-out":60117,"debug-step-over":60118,"debug-stop":60119,debug:60120,"device-camera-video":60121,"device-camera":60122,"device-mobile":60123,"diff-added":60124,"diff-ignored":60125,"diff-modified":60126,"diff-removed":60127,"diff-renamed":60128,diff:60129,discard:60130,"editor-layout":60131,"empty-window":60132,exclude:60133,extensions:60134,"eye-closed":60135,"file-binary":60136,"file-code":60137,"file-media":60138,"file-pdf":60139,"file-submodule":60140,"file-symlink-directory":60141,"file-symlink-file":60142,"file-zip":60143,files:60144,filter:60145,flame:60146,"fold-down":60147,"fold-up":60148,fold:60149,"folder-default":60150,"folder-opened":60151,gear:60152,gift:60153,"gist-secret":60154,gist:60155,"git-commit":60156,"git-compare":60157,"compare-changes":60157,"git-merge":60158,"github-action":60159,"github-alt":60160,globe:60161,grabber:60162,graph:60163,gripper:60164,heart:63451,home:60166,"horizontal-rule":60167,hubot:60168,inbox:60169,"issue-reopened":60171,issues:60172,italic:60173,jersey:60174,json:60175,"kebab-vertical":60176,key:60177,law:60178,"lightbulb-autofix":60179,"link-external":60180,link:60181,"list-ordered":60182,"list-unordered":60183,"live-share":60184,loading:60185,location:60186,"mail-read":60187,mail:60188,markdown:60189,megaphone:60190,mention:60191,milestone:60192,"mortar-board":60193,move:60194,"multiple-windows":60195,mute:60196,"no-newline":60197,note:60198,octoface:60199,"open-preview":60200,package:60201,paintcan:60202,pin:60203,play:60204,run:60204,plug:60205,"preserve-case":60206,preview:60207,project:60208,pulse:60209,question:60210,quote:60211,"radio-tower":60212,reactions:60213,references:60214,refresh:60215,regex:60216,"remote-explorer":60217,remote:60218,remove:60219,"replace-all":60220,replace:60221,"repo-clone":60222,"repo-force-push":60223,"repo-pull":60224,"repo-push":60225,report:60226,"request-changes":60227,rocket:60228,"root-folder-opened":60229,"root-folder":60230,rss:60231,ruby:60232,"save-all":60233,"save-as":60234,save:60235,"screen-full":60236,"screen-normal":60237,"search-stop":60238,server:60240,"settings-gear":60241,settings:60242,shield:60243,smiley:60244,"sort-precedence":60245,"split-horizontal":60246,"split-vertical":60247,squirrel:60248,"star-full":60249,"star-half":60250,"symbol-class":60251,"symbol-color":60252,"symbol-constant":60253,"symbol-enum-member":60254,"symbol-field":60255,"symbol-file":60256,"symbol-interface":60257,"symbol-keyword":60258,"symbol-misc":60259,"symbol-operator":60260,"symbol-property":60261,wrench:60261,"wrench-subaction":60261,"symbol-snippet":60262,tasklist:60263,telescope:60264,"text-size":60265,"three-bars":60266,thumbsdown:60267,thumbsup:60268,tools:60269,"triangle-down":60270,"triangle-left":60271,"triangle-right":60272,"triangle-up":60273,twitter:60274,unfold:60275,unlock:60276,unmute:60277,unverified:60278,verified:60279,versions:60280,"vm-active":60281,"vm-outline":60282,"vm-running":60283,watch:60284,whitespace:60285,"whole-word":60286,window:60287,"word-wrap":60288,"zoom-in":60289,"zoom-out":60290,"list-filter":60291,"list-flat":60292,"list-selection":60293,selection:60293,"list-tree":60294,"debug-breakpoint-function-unverified":60295,"debug-breakpoint-function":60296,"debug-breakpoint-function-disabled":60296,"circle-small-filled":60298,"debug-stackframe-dot":60298,"debug-stackframe":60299,"debug-stackframe-focused":60299,"debug-breakpoint-unsupported":60300,"symbol-string":60301,"debug-reverse-continue":60302,"debug-step-back":60303,"debug-restart-frame":60304,"debug-alt":60305,"call-incoming":60306,"call-outgoing":60307,menu:60308,"expand-all":60309,feedback:60310,"group-by-ref-type":60311,"ungroup-by-ref-type":60312,account:60313,"bell-dot":60314,"debug-console":60315,library:60316,output:60317,"run-all":60318,"sync-ignored":60319,pinned:60320,"github-inverted":60321,"server-process":60322,"server-environment":60323,pass:60324,"issue-closed":60324,"stop-circle":60325,"play-circle":60326,record:60327,"debug-alt-small":60328,"vm-connect":60329,cloud:60330,merge:60331,export:60332,"graph-left":60333,magnet:60334,notebook:60335,redo:60336,"check-all":60337,"pinned-dirty":60338,"pass-filled":60339,"circle-large-filled":60340,"circle-large-outline":60341,combine:60342,gather:60342,table:60343,"variable-group":60344,"type-hierarchy":60345,"type-hierarchy-sub":60346,"type-hierarchy-super":60347,"git-pull-request-create":60348,"run-above":60349,"run-below":60350,"notebook-template":60351,"workspace-trusted":60353,"workspace-untrusted":60354,"workspace-unknown":60355,"terminal-cmd":60356,"terminal-debian":60357,"terminal-linux":60358,"terminal-powershell":60359,"terminal-tmux":60360,"terminal-ubuntu":60361,"terminal-bash":60362,"arrow-swap":60363,copy:60364,"person-add":60365,"filter-filled":60366,wand:60367,"debug-line-by-line":60368,inspect:60369,layers:60370,"layers-dot":60371,"layers-active":60372,compass:60373,"compass-dot":60374,"compass-active":60375,azure:60376,"issue-draft":60377,"git-pull-request-closed":60378,"git-pull-request-draft":60379,"debug-coverage":60381,"run-errors":60382,"folder-library":60383,"debug-continue-small":60384,"beaker-stop":60385,"graph-line":60386,"graph-scatter":60387,"pie-chart":60388,bracket:60175,"bracket-dot":60389,"bracket-error":60390,"lock-small":60391,"azure-devops":60392,"verified-filled":60393,newline:60394,layout:60395,"layout-activitybar-left":60396,"layout-activitybar-right":60397,"layout-panel-left":60398,"layout-panel-center":60399,"layout-panel-justify":60400,"layout-panel-right":60401,"layout-panel":60402,"layout-sidebar-left":60403,"layout-sidebar-right":60404,"layout-statusbar":60405,"layout-menubar":60406,"layout-centered":60407,target:60408,indent:60409,"record-small":60410,"error-small":60411,"arrow-circle-down":60412,"arrow-circle-left":60413,"arrow-circle-right":60414,"arrow-circle-up":60415,"layout-sidebar-right-off":60416,"layout-panel-off":60417,"layout-sidebar-left-off":60418,blank:60419,"heart-filled":63451,map:60421,"map-filled":60422,"circle-small":60423,"bell-slash":60424,"bell-slash-dot":60425,"comment-unresolved":60426,"git-pull-request-go-to-changes":60427,"git-pull-request-new-changes":60428,"fold-right":60429,"breadcrumb-separator":60430,separator:60431,"search-test-cases":60432,clear:60434,protected:60435,"package-local":60436,"api-panoramic-view":60437,"connect-left":60438,"connect-right":60439,ticket:60440,"close-the-instance":60441,"burger-menu":60442,"previous-step":60443,"next-step":63444,"packing-logs":63445,"letters-sort":63446,"symbol-abstract-class":63449,"time-taken-sort":63450,favorites:63452,"radio-selected":63453,"radio-remove":63454,screening:63455,"screening-active":63456,"fold-all":63457,jump:63458,apk:63462,msg:63463,breakpoint:63464,"breakpoint-disabled":63464,"build-single":63466,"open-folder":63467,manifest:63468,xml:63469,"warning-small":63470,"tip-small":63471,"pass-filled-small":63472,"running-small":63473,"jump-small":63474,"running-no-small":63475,"loading-small":63476,tip:63477,"running-middle":63478,"stop-middle":63479,"running-no-middle":63480,"symbol-type-parameter":63486,"symbol-enummember":63487,"symbol-issue":63488,"symbol-user":63489,"symbol-value":63490,"symbol-unit":63491,"symbol-reference":63492,"symbol-text":63493,"debug-stackframe-disabled":63598,favorited:63602,import:63633,region:63636,"non-cloud-server":63637,"cloud-server-active":63638,"cloud-server":63639,"non-cloud-server-active":63640,"cloud-server-accessible":63641,print:63652,resetting:63654,cce:63668,namespace:63669,"turbo-cce":63670,"step-over-start":63671,"debug-filled":63672,lightning:63673,"step-over-end":63674,"step-over-solid":63675,java:63676,download:63679,plugin:63680,cpp:63681,python:63682,c:63684,"c-sharp":63685,wrap:63691,"cpp-class-file":63692,"folder-open":60151,"class-breakpoint-default":63696,"class-breakpoint-default-disabled":63696,"exception-breakpoint-default":63703,"exception-breakpoint-default-disabled":63703,"watch-breakpoint-default":63710,"watch-breakpoint-default-disabled":63710,"watch-breakpoint-default-unverified":63717,"function-breakpoint-default":63724,"function-breakpoint-default-disabled":63724,"function-breakpoint-default-unverified":63731,"line-breakpoint-default":63738,"line-breakpoint-default-disabled":63738,"line-breakpoint-default-unverified":63745,"small-class-breakpoint-default":63752,"small-class-breakpoint-default-disabled":63752,"small-exception-breakpoint-default":63759,"small-exception-breakpoint-default-disabled":63759,"small-watch-breakpoint-default":63766,"small-watch-breakpoint-default-disabled":63766,"small-watch-breakpoint-default-unverified":63773,"small-function-breakpoint-default":63780,"small-function-breakpoint-default-disabled":63780,"small-function-breakpoint-default-unverified":63787,"small-line-breakpoint-default":63794,"small-line-breakpoint-default-disabled":63794,"small-line-breakpoint-default-unverified":63801,"multiple-breakpoints-default":63808,"multiple-breakpoints-default-disabled":63808,"multiple-breakpoints-toggle":63809,"multiple-breakpoints-toggle-disabled":63809,"breakpoint-add":63848,"breakpoint-remove":63849,"breakpoint-collapse-all":63850,"breakpoint-expand-all":63851,"breakpoint-group-by-file":63854,"breakpoint-group-by-package":63855,fail:63860,success:63861,"debug-all":63862,cut:63864,"keyboard-keys":63867,undo:63868,"run-passed":63869,warn:63872,important:63872,paste:63873,"run-passed-editor":63877,maven:63880,"maven-active":63880,gradle:63881,"gradle-active":63881,"circle-filled-ansiMediumTurquoise":60017,"circle-filled-ansiChocolate":60017,"circle-filled-ansiMediumOrchid":60017,"circle-filled-ansiRoyalBlue":60017,"circle-filled-ansiNavajoWhite":60017,"circle-filled-ansiDarkSeaGreen":60017,"circle-filled-ansiMediumSlateBlue":60017,"circle-filled-ansiPaleVioletRed":60017,"circle-filled-ansiSpringGreen":60017,"circle-filled-ansiLightSkyBlue":60017,"debug-run-to-cursor":63902,"reveal-in-explorer":63903,"step-into-target":63904,vscode:63905,"vscode-insiders":63906,circle:63908,"circle-large":63909,copilot:63910,"lightbulb-sparkle":63911,"search-fuzzy":63912,"comment-draft":63646,send:63914,sparkle:63915,insert:63916,mic:63917,"mic-filled":63918,"git-fetch":63919,robot:63920,"thumbsdown-filled":63921,"thumbsup-filled":63922,coffee:63923,snake:63924,game:63925,vr:63926,chip:63927,piano:63928,music:63929,"sparkle-filled":63930,"diff-single":63931,"diff-multiple":63932,"layout-activitybar-bottom":63933,"run-coverage":63934,"run-all-coverage":63935,gitcode:63956,switch:63957},t.codiconMapping={"dialog-error":60039,"dialog-warning":60012,"dialog-info":60020,"dialog-close":60022,"tree-item-expanded":60270,"tree-filter-on-type-on":60291,"tree-filter-on-type-off":60293,"tree-filter-clear":60022,"tree-item-loading":60185,"menu-selection":60082,"menu-submenu":60086,"menubar-more":60028,"scrollbar-button-left":60271,"scrollbar-button-right":60272,"scrollbar-button-up":60273,"scrollbar-button-down":60270,"toolbar-more":60028,"quick-input-back":60059},t.doubleIconMapping={"devops-up":63686,"devops-down":63687,"devops-up-active":63686,"devops-down-active":63687,"terminal-up":63494,"terminal-down":63495,"terminal-up-active":63494,"terminal-down-active":63495,"extensions-up":63496,"extensions-down":63497,"extensions-up-active":63496,"extensions-down-active":63497,"API-panorama-up":63498,"API-panorama-down":63499,"API-panorama-up-active":63498,"API-panorama-down-active":63499,"source-code-manage-up":63506,"source-code-manage-up-active":63506,"source-code-manage-down":63508,"source-code-manage-down-active":63508,"references-up-active":63513,"references-down":63511,"references-down-active":63511,"references-up":63513,"running-up-active":63517,"running-down":63515,"running-down-active":63515,"running-up":63517,"remote-dev-up-active":63521,"remote-dev-down":63519,"remote-dev-down-active":63519,"remote-dev-up":63521,"bill-of-lading-down":63522,"bill-of-lading-down-active":63522,"bill-of-lading-up":63524,"bill-of-lading-up-active":63524,"issue-down":63526,"issue-down-active":63526,"issue-up":63528,"issue-up-active":63528,"search-down":63530,"search-down-active":63530,"search-up":63532,"search-up-active":63532,"property-up":63534,"property-up-active":63534,"property-down":63536,"property-down-active":63536,"output-down":63538,"output-down-active":63538,"output-up":63540,"output-up-active":63540,"event-center-down":63542,"event-center-down-active":63542,"event-center-up":63544,"event-center-up-active":63544,"setting-down":63546,"setting-down-active":63546,"setting-up":63548,"setting-up-active":63548,"timeline-up-active":63553,"timeline-down":63551,"timeline-down-active":63551,"timeline-up":63553,"type-hierarchy-up-active":63557,"type-hierarchy-down":63555,"type-hierarchy-down-active":63555,"type-hierarchy-up":63557,"dev-kit-down":63558,"dev-kit-down-active":63558,"dev-kit-up":63560,"dev-kit-up-active":63560,"port-access-up":63562,"port-access-up-active":63562,"port-access-down":63564,"port-access-down-active":63564,"build-down":63566,"build-down-active":63566,"build-up":63568,"build-up-active":63568,"tool-down":63570,"tool-down-active":63570,"tool-up":63572,"tool-up-active":63572,"project-up-active":63577,"project-down":63575,"project-down-active":63575,"project-up":63577,"test-down":63578,"test-down-active":63578,"test-up":63580,"test-up-active":63580,"outline-down":63582,"outline-down-active":63582,"outline-up":63584,"outline-up-active":63584,"reference-info-down":63586,"reference-info-down-active":63586,"reference-info-up":63588,"reference-info-up-active":63588,"debug-console-down":63590,"debug-console-down-active":63590,"debug-console-up":63592,"debug-console-up-active":63592,"invoking-level-down":63594,"invoking-level-down-active":63594,"invoking-level-up":63596,"invoking-level-up-active":63596,"run-here-up":63464,"run-here-down":63599,"filter-up-active":63603,"filter-down-active":63604,"filter-up":63603,"filter-down":63604,"letter-positive-order-down":63609,"letter-positive-order-up":63608,"letter-reverse-order-down":63609,"letter-reverse-order-up":63610,"time-taken-positive-sort-down":63613,"time-taken-positive-sort-up":63612,"time-taken-reverse-sort-down":63613,"time-taken-reverse-sort-up":63614,"container-content-down":63615,"container-content-up":63616,"excluded-content-down":63617,"excluded-content-up":63618,"bracket-error-down":63600,"bracket-error-up":63601,"compass-up-active":63619,"compass-down-active":63620,"code-unfolding-up":63621,"code-collapse-down":63622,"code-collapse-up":63623,"code-unfolding-down":63624,"session-management-up":63626,"session-management-down":63627,"session-management-up-active":63626,"session-management-down-active":63627,"remote-file-system-up":63628,"remote-file-system-down":63629,"remote-file-system-up-active":63628,"remote-file-system-down-active":63629,"read-access-down":63630,"write-access-down":63630,"read-access-up":63631,"write-access-up":63632,"huawei-logo-up":63634,"huawei-logo-down":63635,"huawei-logo-up-active":63634,"huawei-logo-down-active":63635,"diff-remove-down":63642,"diff-insert-down":63642,"diff-remove-up":63643,"diff-insert-up":63644,"layers-down-active":63648,"layers-up-active":63649,"folder-up-active":63650,"folder-down-active":63651,"warn-large-up":63655,"warn-large-down":63656,"problem-up":63657,"problem-down":63658,"no-data-up":63659,"no-data-down":63660,"error-large-up":63661,"error-large-down":63662,"success-large-up":63663,"success-large-down":63664,"tip-large-up":63665,"tip-large-down":63666,"vm-up-active":63667,"vm-down-active":63937,"jdk-up":63677,"jdk-down":63678,"extension-disabled-down":63688,"extension-disabled-up":63689,"extension-error-down":63688,"extension-error-up":63690,"cpp-source-file-up":63693,"cpp-source-file-down":63694,"cpp-header-file-up":63695,"cpp-header-file-down":63694,"class-breakpoint-conditional-up":63697,"class-breakpoint-conditional-down":63698,"class-breakpoint-log-up":63699,"class-breakpoint-log-down":63700,"class-breakpoint-both-up":63701,"class-breakpoint-both-down":63702,"class-breakpoint-conditional-disabled-up":63697,"class-breakpoint-conditional-disabled-down":63698,"class-breakpoint-log-disabled-up":63699,"class-breakpoint-log-disabled-down":63700,"class-breakpoint-both-disabled-up":63701,"class-breakpoint-both-disabled-down":63702,"exception-breakpoint-conditional-up":63704,"exception-breakpoint-conditional-down":63705,"exception-breakpoint-log-up":63706,"exception-breakpoint-log-down":63707,"exception-breakpoint-both-up":63708,"exception-breakpoint-both-down":63709,"exception-breakpoint-conditional-disabled-up":63704,"exception-breakpoint-conditional-disabled-down":63705,"exception-breakpoint-log-disabled-up":63706,"exception-breakpoint-log-disabled-down":63707,"exception-breakpoint-both-disabled-up":63708,"exception-breakpoint-both-disabled-down":63709,"watch-breakpoint-conditional-up":63711,"watch-breakpoint-conditional-down":63712,"watch-breakpoint-log-up":63713,"watch-breakpoint-log-down":63714,"watch-breakpoint-both-up":63715,"watch-breakpoint-both-down":63716,"watch-breakpoint-conditional-disabled-up":63711,"watch-breakpoint-conditional-disabled-down":63712,"watch-breakpoint-log-disabled-up":63713,"watch-breakpoint-log-disabled-down":63714,"watch-breakpoint-both-disabled-up":63715,"watch-breakpoint-both-disabled-down":63716,"watch-breakpoint-conditional-unverified-up":63718,"watch-breakpoint-conditional-unverified-down":63719,"watch-breakpoint-log-unverified-up":63720,"watch-breakpoint-log-unverified-down":63721,"watch-breakpoint-both-unverified-up":63722,"watch-breakpoint-both-unverified-down":63723,"function-breakpoint-conditional-up":63725,"function-breakpoint-conditional-down":63726,"function-breakpoint-log-up":63727,"function-breakpoint-log-down":63728,"function-breakpoint-both-up":63729,"function-breakpoint-both-down":63730,"function-breakpoint-conditional-disabled-up":63725,"function-breakpoint-conditional-disabled-down":63726,"function-breakpoint-log-disabled-up":63727,"function-breakpoint-log-disabled-down":63728,"function-breakpoint-both-disabled-up":63729,"function-breakpoint-both-disabled-down":63730,"function-breakpoint-conditional-unverified-up":63732,"function-breakpoint-conditional-unverified-down":63733,"function-breakpoint-log-unverified-up":63734,"function-breakpoint-log-unverified-down":63735,"function-breakpoint-both-unverified-up":63736,"function-breakpoint-both-unverified-down":63737,"line-breakpoint-conditional-up":63739,"line-breakpoint-conditional-down":63740,"line-breakpoint-log-up":63741,"line-breakpoint-log-down":63742,"line-breakpoint-both-up":63743,"line-breakpoint-both-down":63744,"line-breakpoint-conditional-disabled-up":63739,"line-breakpoint-conditional-disabled-down":63740,"line-breakpoint-log-disabled-up":63741,"line-breakpoint-log-disabled-down":63742,"line-breakpoint-both-disabled-up":63743,"line-breakpoint-both-disabled-down":63744,"line-breakpoint-conditional-unverified-up":63746,"line-breakpoint-conditional-unverified-down":63747,"line-breakpoint-log-unverified-up":63748,"line-breakpoint-log-unverified-down":63749,"line-breakpoint-both-unverified-up":63750,"line-breakpoint-both-unverified-down":63751,"small-class-breakpoint-conditional-up":63753,"small-class-breakpoint-conditional-down":63754,"small-class-breakpoint-log-up":63755,"small-class-breakpoint-log-down":63756,"small-class-breakpoint-both-up":63757,"small-class-breakpoint-both-down":63758,"small-class-breakpoint-conditional-disabled-up":63753,"small-class-breakpoint-conditional-disabled-down":63754,"small-class-breakpoint-log-disabled-up":63755,"small-class-breakpoint-log-disabled-down":63756,"small-class-breakpoint-both-disabled-up":63757,"small-class-breakpoint-both-disabled-down":63758,"small-exception-breakpoint-conditional-up":63760,"small-exception-breakpoint-conditional-down":63761,"small-exception-breakpoint-log-up":63762,"small-exception-breakpoint-log-down":63763,"small-exception-breakpoint-both-up":63764,"small-exception-breakpoint-both-down":63765,"small-exception-breakpoint-conditional-disabled-up":63760,"small-exception-breakpoint-conditional-disabled-down":63761,"small-exception-breakpoint-log-disabled-up":63762,"small-exception-breakpoint-log-disabled-down":63763,"small-exception-breakpoint-both-disabled-up":63764,"small-exception-breakpoint-both-disabled-down":63765,"small-watch-breakpoint-conditional-up":63767,"small-watch-breakpoint-conditional-down":63768,"small-watch-breakpoint-log-up":63769,"small-watch-breakpoint-log-down":63770,"small-watch-breakpoint-both-up":63771,"small-watch-breakpoint-both-down":63772,"small-watch-breakpoint-conditional-disabled-up":63767,"small-watch-breakpoint-conditional-disabled-down":63768,"small-watch-breakpoint-log-disabled-up":63769,"small-watch-breakpoint-log-disabled-down":63770,"small-watch-breakpoint-both-disabled-up":63771,"small-watch-breakpoint-both-disabled-down":63772,"small-watch-breakpoint-conditional-unverified-up":63774,"small-watch-breakpoint-conditional-unverified-down":63775,"small-watch-breakpoint-log-unverified-up":63776,"small-watch-breakpoint-log-unverified-down":63777,"small-watch-breakpoint-both-unverified-up":63778,"small-watch-breakpoint-both-unverified-down":63779,"small-function-breakpoint-conditional-up":63781,"small-function-breakpoint-conditional-down":63782,"small-function-breakpoint-log-up":63783,"small-function-breakpoint-log-down":63784,"small-function-breakpoint-both-up":63785,"small-function-breakpoint-both-down":63786,"small-function-breakpoint-conditional-disabled-up":63781,"small-function-breakpoint-conditional-disabled-down":63782,"small-function-breakpoint-log-disabled-up":63783,"small-function-breakpoint-log-disabled-down":63784,"small-function-breakpoint-both-disabled-up":63785,"small-function-breakpoint-both-disabled-down":63786,"small-function-breakpoint-conditional-unverified-up":63788,"small-function-breakpoint-conditional-unverified-down":63789,"small-function-breakpoint-log-unverified-up":63790,"small-function-breakpoint-log-unverified-down":63791,"small-function-breakpoint-both-unverified-up":63792,"small-function-breakpoint-both-unverified-down":63793,"small-line-breakpoint-conditional-up":63795,"small-line-breakpoint-conditional-down":63796,"small-line-breakpoint-log-up":63797,"small-line-breakpoint-log-down":63798,"small-line-breakpoint-both-up":63799,"small-line-breakpoint-both-down":63800,"small-line-breakpoint-default-disabled":63794,"small-line-breakpoint-conditional-disabled-up":63795,"small-line-breakpoint-conditional-disabled-down":63796,"small-line-breakpoint-log-disabled-up":63797,"small-line-breakpoint-log-disabled-down":63798,"small-line-breakpoint-both-disabled-up":63799,"small-line-breakpoint-both-disabled-down":63800,"small-line-breakpoint-default-unverified":63801,"small-line-breakpoint-conditional-unverified-up":63802,"small-line-breakpoint-conditional-unverified-down":63803,"small-line-breakpoint-log-unverified-up":63804,"small-line-breakpoint-log-unverified-down":63805,"small-line-breakpoint-both-unverified-up":63806,"small-line-breakpoint-both-unverified-down":63807,"multiple-breakpoints-number-2-up":63810,"multiple-breakpoints-number-2-down":63811,"multiple-breakpoints-number-3-up":63812,"multiple-breakpoints-number-3-down":63813,"multiple-breakpoints-number-4-up":63814,"multiple-breakpoints-number-4-down":63815,"multiple-breakpoints-number-5-up":63816,"multiple-breakpoints-number-5-down":63817,"multiple-breakpoints-number-6-up":63818,"multiple-breakpoints-number-6-down":63819,"multiple-breakpoints-number-7-up":63820,"multiple-breakpoints-number-7-down":63821,"multiple-breakpoints-number-8-up":63822,"multiple-breakpoints-number-8-down":63823,"multiple-breakpoints-number-9-up":63824,"multiple-breakpoints-number-9-down":63825,"multiple-breakpoints-number-alot-up":63826,"multiple-breakpoints-number-alot-down":63827,"multiple-breakpoints-default-disabled":63808,"multiple-breakpoints-toggle-disabled":63809,"multiple-breakpoints-number-2-disabled-up":63810,"multiple-breakpoints-number-2-disabled-down":63811,"multiple-breakpoints-number-3-disabled-up":63812,"multiple-breakpoints-number-3-disabled-down":63813,"multiple-breakpoints-number-4-disabled-up":63814,"multiple-breakpoints-number-4-disabled-down":63815,"multiple-breakpoints-number-5-disabled-up":63816,"multiple-breakpoints-number-5-disabled-down":63817,"multiple-breakpoints-number-6-disabled-up":63818,"multiple-breakpoints-number-6-disabled-down":63819,"multiple-breakpoints-number-7-disabled-up":63820,"multiple-breakpoints-number-7-disabled-down":63821,"multiple-breakpoints-number-8-disabled-up":63822,"multiple-breakpoints-number-8-disabled-down":63823,"multiple-breakpoints-number-9-disabled-up":63824,"multiple-breakpoints-number-9-disabled-down":63825,"multiple-breakpoints-number-alot-disabled-up":63826,"multiple-breakpoints-number-alot-disabled-down":63827,"mute-breakpoints-up":63828,"mute-breakpoints-down":63829,"multiple-breakpoints-number-2-unverified-up":63830,"multiple-breakpoints-number-2-unverified-down":63831,"multiple-breakpoints-number-3-unverified-up":63832,"multiple-breakpoints-number-3-unverified-down":63833,"multiple-breakpoints-number-4-unverified-up":63834,"multiple-breakpoints-number-4-unverified-down":63835,"multiple-breakpoints-number-5-unverified-up":63836,"multiple-breakpoints-number-5-unverified-down":63837,"multiple-breakpoints-number-6-unverified-up":63838,"multiple-breakpoints-number-6-unverified-down":63839,"multiple-breakpoints-number-7-unverified-up":63840,"multiple-breakpoints-number-7-unverified-down":63841,"multiple-breakpoints-number-8-unverified-up":63842,"multiple-breakpoints-number-8-unverified-down":63843,"multiple-breakpoints-number-9-unverified-up":63844,"multiple-breakpoints-number-9-unverified-down":63845,"multiple-breakpoints-number-alot-unverified-up":63846,"multiple-breakpoints-number-alot-unverified-down":63847,"breakpoint-group-by-class-up":63852,"breakpoint-group-by-class-down":63853,"last-executed-down":63858,"last-executed-up":63859,"debug-rerun-up":63865,"debug-rerun-down":63866,"run-failed-up":63870,"run-failed-down":63871,"run-failed-editor-up":63874,"run-failed-editor-down":63875,"run-failed-outdated-editor-up":63874,"run-failed-outdated-editor-down":63875,"run-passed-outdated-editor-up":63876,"run-passed-outdated-editor-down":63875,"git-graph-up":63879,"git-graph-down":63878,"git-graph-up-active":63879,"git-graph-down-active":63878,"breakpoints-up":63882,"breakpoints-down":63883,"breakpoints-up-active":63882,"breakpoints-down-active":63883,"application-servers-up":63884,"application-servers-down":63885,"application-servers-up-active":63884,"application-servers-down-active":63885,"call-hierarchy-up":63886,"call-hierarchy-down":63887,"call-hierarchy-up-active":63886,"call-hierarchy-down-active":63887,"connections-up":63888,"connections-down":63889,"connections-up-active":63888,"connections-down-active":63889,"dependencies-up":63890,"dependencies-down":63891,"dependencies-up-active":63890,"dependencies-down-active":63891,"explorer-up":63892,"explorer-down":63893,"explorer-up-active":63892,"explorer-down-active":63893,"find-usages-up":63894,"find-usages-down":63895,"find-usages-up-active":63894,"find-usages-down-active":63895,"run-debug-up":63896,"run-debug-down":63897,"run-debug-up-active":63896,"run-debug-down-active":63897,"structures-up":63898,"structures-down":63899,"structures-up-active":63898,"structures-down-active":63899,"tools-type-hierarchy-up":63900,"tools-type-hierarchy-down":63901,"tools-type-hierarchy-up-active":63900,"tools-type-hierarchy-down-active":63901,"spring-explorer-up":63953,"spring-explorer-down":63952,"spring-gutter-run-controller-up":63954,"spring-gutter-run-controller-down":63955},t.iconConversionMapping={"timeline-view-icon":"history","test-view-icon":"test","terminal-view-icon":"terminal","search-view-icon":"search","source-control-view-icon":"source-code-manage","output-view-icon":"output","outline-view-icon":"outline","markers-view-icon":"issue","explorer-view-icon":"project","extensions-view-icon":"extensions","events-view-icon":"event-center","debug-console-view-icon":"debug-console","run-view-icon":"running","settings-view-bar-icon":"setting","folding-expanded":"code-collapse","folding-collapsed":"code-unfolding","build-view-icon":"build",maven:"maven",gradle:"gradle"}},5731(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SmoothScrollingOperation=t.SmoothScrollingUpdate=t.Scrollable=t.ScrollState=t.ScrollbarVisibility=void 0;const n=i(519);var o;(o=t.ScrollbarVisibility||(t.ScrollbarVisibility={}))[o.Auto=1]="Auto",o[o.Hidden=2]="Hidden",o[o.Visible=3]="Visible";class s{constructor(e,t,i,n,o,s,r){this._forceIntegerValues=e,this._scrollStateBrand=void 0,this._forceIntegerValues&&(t|=0,i|=0,n|=0,o|=0,s|=0,r|=0),this.rawScrollLeft=n,this.rawScrollTop=r,t<0&&(t=0),n+t>i&&(n=i-t),n<0&&(n=0),o<0&&(o=0),r+o>s&&(r=s-o),r<0&&(r=0),this.width=t,this.scrollWidth=i,this.scrollLeft=n,this.height=o,this.scrollHeight=s,this.scrollTop=r}equals(e){return this.rawScrollLeft===e.rawScrollLeft&&this.rawScrollTop===e.rawScrollTop&&this.width===e.width&&this.scrollWidth===e.scrollWidth&&this.scrollLeft===e.scrollLeft&&this.height===e.height&&this.scrollHeight===e.scrollHeight&&this.scrollTop===e.scrollTop}withScrollDimensions(e,t){return new s(this._forceIntegerValues,void 0!==e.width?e.width:this.width,void 0!==e.scrollWidth?e.scrollWidth:this.scrollWidth,t?this.rawScrollLeft:this.scrollLeft,void 0!==e.height?e.height:this.height,void 0!==e.scrollHeight?e.scrollHeight:this.scrollHeight,t?this.rawScrollTop:this.scrollTop)}withScrollPosition(e){return new s(this._forceIntegerValues,this.width,this.scrollWidth,void 0!==e.scrollLeft?e.scrollLeft:this.rawScrollLeft,this.height,this.scrollHeight,void 0!==e.scrollTop?e.scrollTop:this.rawScrollTop)}createScrollEvent(e,t){const i=this.width!==e.width,n=this.scrollWidth!==e.scrollWidth,o=this.scrollLeft!==e.scrollLeft,s=this.height!==e.height,r=this.scrollHeight!==e.scrollHeight,a=this.scrollTop!==e.scrollTop;return{inSmoothScrolling:t,oldWidth:e.width,oldScrollWidth:e.scrollWidth,oldScrollLeft:e.scrollLeft,width:this.width,scrollWidth:this.scrollWidth,scrollLeft:this.scrollLeft,oldHeight:e.height,oldScrollHeight:e.scrollHeight,oldScrollTop:e.scrollTop,height:this.height,scrollHeight:this.scrollHeight,scrollTop:this.scrollTop,widthChanged:i,scrollWidthChanged:n,scrollLeftChanged:o,heightChanged:s,scrollHeightChanged:r,scrollTopChanged:a}}}t.ScrollState=s,t.Scrollable=class{constructor(e){this._scrollableBrand=void 0,this._onScroll=new n.EventEmitter,this.onScroll=this._onScroll.asSubscriber("onScroll"),this._smoothScrollDuration=e.smoothScrollDuration,this._scheduleAtNextAnimationFrame=e.scheduleAtNextAnimationFrame,this._state=new s(e.forceIntegerValues,0,0,0,0,0,0),this._smoothScrolling=null}dispose(){this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null)}setSmoothScrollDuration(e){this._smoothScrollDuration=e}validateScrollPosition(e){return this._state.withScrollPosition(e)}getScrollDimensions(){return this._state}setScrollDimensions(e,t){var i;const n=this._state.withScrollDimensions(e,t);this._setState(n,Boolean(this._smoothScrolling)),null===(i=this._smoothScrolling)||void 0===i||i.acceptScrollDimensions(this._state)}getFutureScrollPosition(){return this._smoothScrolling?this._smoothScrolling.to:this._state}getCurrentScrollPosition(){return this._state}setScrollPositionNow(e){const t=this._state.withScrollPosition(e);this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),this._setState(t,!1)}setScrollPositionSmooth(e,t){if(0!==this._smoothScrollDuration){if(this._smoothScrolling){e={scrollLeft:void 0===e.scrollLeft?this._smoothScrolling.to.scrollLeft:e.scrollLeft,scrollTop:void 0===e.scrollTop?this._smoothScrolling.to.scrollTop:e.scrollTop};const i=this._state.withScrollPosition(e);if(this._smoothScrolling.to.scrollLeft===i.scrollLeft&&this._smoothScrolling.to.scrollTop===i.scrollTop)return;let n;n=t?new l(this._smoothScrolling.from,i,this._smoothScrolling.startTime,this._smoothScrolling.duration):this._smoothScrolling.combine(this._state,i,this._smoothScrollDuration),this._smoothScrolling.dispose(),this._smoothScrolling=n}else{const t=this._state.withScrollPosition(e);this._smoothScrolling=l.start(this._state,t,this._smoothScrollDuration)}this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame(()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this.performSmoothScrolling())})}else this.setScrollPositionNow(e)}performSmoothScrolling(){if(!this._smoothScrolling)return;const e=this._smoothScrolling.tick(),t=this._state.withScrollPosition(e);return this._setState(t,!0),this._smoothScrolling?e.isDone?(this._smoothScrolling.dispose(),void(this._smoothScrolling=null)):void(this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame(()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this.performSmoothScrolling())})):void 0}_setState(e,t){const i=this._state;i.equals(e)||(this._state=e,this._onScroll.emit("onScroll",this._state.createScrollEvent(i,t)))}};class r{constructor(e,t,i){this.scrollLeft=e,this.scrollTop=t,this.isDone=i}}function a(e,t){const i=t-e;return function(t){return e+i*(1-(n=1-t,Math.pow(n,3)));var n}}t.SmoothScrollingUpdate=r;class l{constructor(e,t,i,n){this.from=e,this.to=t,this.duration=n,this.startTime=i,this.animationFrameDisposable=null,this._initAnimations()}_initAnimations(){this.scrollLeft=this._initAnimation(this.from.scrollLeft,this.to.scrollLeft,this.to.width),this.scrollTop=this._initAnimation(this.from.scrollTop,this.to.scrollTop,this.to.height)}_initAnimation(e,t,i){if(Math.abs(e-t)>2.5*i){let r,l;return e<t?(r=e+.75*i,l=t-.75*i):(r=e-.75*i,l=t+.75*i),n=a(e,r),o=a(l,t),s=.33,function(e){return e<s?n(e/s):o((e-s)/(1-s))}}var n,o,s;return a(e,t)}dispose(){null!==this.animationFrameDisposable&&(this.animationFrameDisposable=null)}acceptScrollDimensions(e){this.to=e.withScrollPosition(this.to),this._initAnimations()}tick(){return this._tick(Date.now())}_tick(e){const t=(e-this.startTime)/this.duration;if(t<1){const e=this.scrollLeft(t),i=this.scrollTop(t);return new r(e,i,!1)}return new r(this.to.scrollLeft,this.to.scrollTop,!0)}combine(e,t,i){return l.start(e,t,i)}static start(e,t,i){i+=10;const n=Date.now()-10;return new l(e,t,n,i)}}t.SmoothScrollingOperation=l},5736(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.removeHook=t.addHook=t.sanitize=void 0;var i=Object.hasOwnProperty,n=Object.setPrototypeOf,o=Object.isFrozen,s=Object.getPrototypeOf,r=Object.getOwnPropertyDescriptor,a=Object.freeze,l=Object.seal,d=Object.create,c="undefined"!=typeof Reflect&&Reflect,u=c.apply,h=c.construct;u||(u=function(e,t,i){return e.apply(t,i)}),a||(a=function(e){return e}),l||(l=function(e){return e}),h||(h=function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}(t))))});var p,b=E(Array.prototype.forEach),m=E(Array.prototype.pop),g=E(Array.prototype.push),v=E(String.prototype.toLowerCase),f=E(String.prototype.match),w=E(String.prototype.replace),x=E(String.prototype.indexOf),y=E(String.prototype.trim),k=E(RegExp.prototype.test),C=(p=TypeError,function(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];return h(p,t)});function E(e){return function(t){for(var i=arguments.length,n=Array(i>1?i-1:0),o=1;o<i;o++)n[o-1]=arguments[o];return u(e,t,n)}}function D(e,t){n&&n(e,null);for(var i=t.length;i--;){var s=t[i];if("string"==typeof s){var r=v(s);r!==s&&(o(t)||(t[i]=r),s=r)}e[s]=!0}return e}function S(e){var t=d(null),n=void 0;for(n in e)u(i,e,[n])&&(t[n]=e[n]);return t}function A(e,t){for(;null!==e;){var i=r(e,t);if(i){if(i.get)return E(i.get);if("function"==typeof i.value)return E(i.value)}e=s(e)}return function(e){return console.warn("fallback value for",e),null}}var _=a(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),I=a(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),B=a(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),F=a(["animate","color-profile","cursor","discard","fedropshadow","feimage","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),L=a(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),T=a(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),O=a(["#text"]),M=a(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),N=a(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),$=a(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),P=a(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),R=l(/\{\{[\s\S]*|[\s\S]*\}\}/gm),z=l(/<%[\s\S]*|[\s\S]*%>/gm),H=l(/^data-[\-\w.\u00B7-\uFFFF]/),W=l(/^aria-[\-\w]+$/),V=l(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),U=l(/^(?:\w+script|data):/i),j=l(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),G="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function q(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var X=function(){return"undefined"==typeof window?null:window},K=function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:X(),i=function(t){return e(t)};if(i.version="2.3.1",i.removed=[],!t||!t.document||9!==t.document.nodeType)return i.isSupported=!1,i;var n=t.document,o=t.document,s=t.DocumentFragment,r=t.HTMLTemplateElement,l=t.Node,d=t.Element,c=t.NodeFilter,u=t.NamedNodeMap,h=void 0===u?t.NamedNodeMap||t.MozNamedAttrMap:u,p=t.Text,E=t.Comment,K=t.DOMParser,Y=t.trustedTypes,Z=d.prototype,Q=A(Z,"cloneNode"),J=A(Z,"nextSibling"),ee=A(Z,"childNodes"),te=A(Z,"parentNode");if("function"==typeof r){var ie=o.createElement("template");ie.content&&ie.content.ownerDocument&&(o=ie.content.ownerDocument)}var ne=function(e,t){if("object"!==(void 0===e?"undefined":G(e))||"function"!=typeof e.createPolicy)return null;var i=null,n="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(n)&&(i=t.currentScript.getAttribute(n));var o="dompurify"+(i?"#"+i:"");try{return e.createPolicy(o,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+o+" could not be created."),null}}(Y,n),oe=ne&&Ne?ne.createHTML(""):"",se=o,re=se.implementation,ae=se.createNodeIterator,le=se.createDocumentFragment,de=se.getElementsByTagName,ce=n.importNode,ue={};try{ue=S(o).documentMode?o.documentMode:{}}catch(e){}var he={};i.isSupported="function"==typeof te&&re&&void 0!==re.createHTMLDocument&&9!==ue;var pe=R,be=z,me=H,ge=W,ve=U,fe=j,we=V,xe=null,ye=D({},[].concat(q(_),q(I),q(B),q(L),q(O))),ke=null,Ce=D({},[].concat(q(M),q(N),q($),q(P))),Ee=null,De=null,Se=!0,Ae=!0,_e=!1,Ie=!1,Be=!1,Fe=!1,Le=!1,Te=!1,Oe=!1,Me=!0,Ne=!1,$e=!0,Pe=!0,Re=!1,ze={},He=null,We=D({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),Ve=null,Ue=D({},["audio","video","img","source","image","track"]),je=null,Ge=D({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),qe="http://www.w3.org/1998/Math/MathML",Xe="http://www.w3.org/2000/svg",Ke="http://www.w3.org/1999/xhtml",Ye=Ke,Ze=!1,Qe=null,Je=o.createElement("form"),et=function(e){Qe&&Qe===e||(e&&"object"===(void 0===e?"undefined":G(e))||(e={}),e=S(e),xe="ALLOWED_TAGS"in e?D({},e.ALLOWED_TAGS):ye,ke="ALLOWED_ATTR"in e?D({},e.ALLOWED_ATTR):Ce,je="ADD_URI_SAFE_ATTR"in e?D(S(Ge),e.ADD_URI_SAFE_ATTR):Ge,Ve="ADD_DATA_URI_TAGS"in e?D(S(Ue),e.ADD_DATA_URI_TAGS):Ue,He="FORBID_CONTENTS"in e?D({},e.FORBID_CONTENTS):We,Ee="FORBID_TAGS"in e?D({},e.FORBID_TAGS):{},De="FORBID_ATTR"in e?D({},e.FORBID_ATTR):{},ze="USE_PROFILES"in e&&e.USE_PROFILES,Se=!1!==e.ALLOW_ARIA_ATTR,Ae=!1!==e.ALLOW_DATA_ATTR,_e=e.ALLOW_UNKNOWN_PROTOCOLS||!1,Ie=e.SAFE_FOR_TEMPLATES||!1,Be=e.WHOLE_DOCUMENT||!1,Te=e.RETURN_DOM||!1,Oe=e.RETURN_DOM_FRAGMENT||!1,Me=!1!==e.RETURN_DOM_IMPORT,Ne=e.RETURN_TRUSTED_TYPE||!1,Le=e.FORCE_BODY||!1,$e=!1!==e.SANITIZE_DOM,Pe=!1!==e.KEEP_CONTENT,Re=e.IN_PLACE||!1,we=e.ALLOWED_URI_REGEXP||we,Ye=e.NAMESPACE||Ke,Ie&&(Ae=!1),Oe&&(Te=!0),ze&&(xe=D({},[].concat(q(O))),ke=[],!0===ze.html&&(D(xe,_),D(ke,M)),!0===ze.svg&&(D(xe,I),D(ke,N),D(ke,P)),!0===ze.svgFilters&&(D(xe,B),D(ke,N),D(ke,P)),!0===ze.mathMl&&(D(xe,L),D(ke,$),D(ke,P))),e.ADD_TAGS&&(xe===ye&&(xe=S(xe)),D(xe,e.ADD_TAGS)),e.ADD_ATTR&&(ke===Ce&&(ke=S(ke)),D(ke,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&D(je,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&(He===We&&(He=S(He)),D(He,e.FORBID_CONTENTS)),Pe&&(xe["#text"]=!0),Be&&D(xe,["html","head","body"]),xe.table&&(D(xe,["tbody"]),delete Ee.tbody),a&&a(e),Qe=e)},tt=D({},["mi","mo","mn","ms","mtext"]),it=D({},["foreignobject","desc","title","annotation-xml"]),nt=D({},I);D(nt,B),D(nt,F);var ot=D({},L);D(ot,T);var st=function(e){g(i.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=oe}catch(t){e.remove()}}},rt=function(e,t){try{g(i.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){g(i.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!ke[e])if(Te||Oe)try{st(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},at=function(e){var t=void 0,i=void 0;if(Le)e="<remove></remove>"+e;else{var n=f(e,/^[\r\n\t ]+/);i=n&&n[0]}var s=ne?ne.createHTML(e):e;if(Ye===Ke)try{t=(new K).parseFromString(s,"text/html")}catch(e){}if(!t||!t.documentElement){t=re.createDocument(Ye,"template",null);try{t.documentElement.innerHTML=Ze?"":s}catch(e){}}var r=t.body||t.documentElement;return e&&i&&r.insertBefore(o.createTextNode(i),r.childNodes[0]||null),Ye===Ke?de.call(t,Be?"html":"body")[0]:Be?t.documentElement:r},lt=function(e){return ae.call(e.ownerDocument||e,e,c.SHOW_ELEMENT|c.SHOW_COMMENT|c.SHOW_TEXT,null,!1)},dt=function(e){return"object"===(void 0===l?"undefined":G(l))?e instanceof l:e&&"object"===(void 0===e?"undefined":G(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},ct=function(e,t,n){he[e]&&b(he[e],function(e){e.call(i,t,n,Qe)})},ut=function(e){var t,n=void 0;if(ct("beforeSanitizeElements",e,null),!((t=e)instanceof p||t instanceof E||"string"==typeof t.nodeName&&"string"==typeof t.textContent&&"function"==typeof t.removeChild&&t.attributes instanceof h&&"function"==typeof t.removeAttribute&&"function"==typeof t.setAttribute&&"string"==typeof t.namespaceURI&&"function"==typeof t.insertBefore))return st(e),!0;if(f(e.nodeName,/[\u0080-\uFFFF]/))return st(e),!0;var o=v(e.nodeName);if(ct("uponSanitizeElement",e,{tagName:o,allowedTags:xe}),!dt(e.firstElementChild)&&(!dt(e.content)||!dt(e.content.firstElementChild))&&k(/<[/\w]/g,e.innerHTML)&&k(/<[/\w]/g,e.textContent))return st(e),!0;if("select"===o&&k(/<template/i,e.innerHTML))return st(e),!0;if(!xe[o]||Ee[o]){if(Pe&&!He[o]){var s=te(e)||e.parentNode,r=ee(e)||e.childNodes;if(r&&s)for(var a=r.length-1;a>=0;--a)s.insertBefore(Q(r[a],!0),J(e))}return st(e),!0}return e instanceof d&&!function(e){var t=te(e);t&&t.tagName||(t={namespaceURI:Ke,tagName:"template"});var i=v(e.tagName),n=v(t.tagName);if(e.namespaceURI===Xe)return t.namespaceURI===Ke?"svg"===i:t.namespaceURI===qe?"svg"===i&&("annotation-xml"===n||tt[n]):Boolean(nt[i]);if(e.namespaceURI===qe)return t.namespaceURI===Ke?"math"===i:t.namespaceURI===Xe?"math"===i&&it[n]:Boolean(ot[i]);if(e.namespaceURI===Ke){if(t.namespaceURI===Xe&&!it[n])return!1;if(t.namespaceURI===qe&&!tt[n])return!1;var o=D({},["title","style","font","a","script"]);return!ot[i]&&(o[i]||!nt[i])}return!1}(e)?(st(e),!0):"noscript"!==o&&"noembed"!==o||!k(/<\/no(script|embed)/i,e.innerHTML)?(Ie&&3===e.nodeType&&(n=e.textContent,n=w(n,pe," "),n=w(n,be," "),e.textContent!==n&&(g(i.removed,{element:e.cloneNode()}),e.textContent=n)),ct("afterSanitizeElements",e,null),!1):(st(e),!0)},ht=function(e,t,i){if($e&&("id"===t||"name"===t)&&(i in o||i in Je))return!1;if(Ae&&!De[t]&&k(me,t));else if(Se&&k(ge,t));else{if(!ke[t]||De[t])return!1;if(je[t]);else if(k(we,w(i,fe,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==x(i,"data:")||!Ve[e])if(_e&&!k(ve,w(i,fe,"")));else if(i)return!1}return!0},pt=function(e){var t=void 0,n=void 0,o=void 0,s=void 0;ct("beforeSanitizeAttributes",e,null);var r=e.attributes;if(r){var a={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:ke};for(s=r.length;s--;){var l=t=r[s],d=l.name,c=l.namespaceURI;if(n=y(t.value),o=v(d),a.attrName=o,a.attrValue=n,a.keepAttr=!0,a.forceKeepAttr=void 0,ct("uponSanitizeAttribute",e,a),n=a.attrValue,!a.forceKeepAttr&&(rt(d,e),a.keepAttr))if(k(/\/>/i,n))rt(d,e);else{Ie&&(n=w(n,pe," "),n=w(n,be," "));var u=e.nodeName.toLowerCase();if(ht(u,o,n))try{c?e.setAttributeNS(c,d,n):e.setAttribute(d,n),m(i.removed)}catch(e){}}}ct("afterSanitizeAttributes",e,null)}},bt=function e(t){var i=void 0,n=lt(t);for(ct("beforeSanitizeShadowDOM",t,null);i=n.nextNode();)ct("uponSanitizeShadowNode",i,null),ut(i)||(i.content instanceof s&&e(i.content),pt(i));ct("afterSanitizeShadowDOM",t,null)};return i.sanitize=function(e,o){var r=void 0,a=void 0,d=void 0,c=void 0,u=void 0;if((Ze=!e)&&(e="\x3c!--\x3e"),"string"!=typeof e&&!dt(e)){if("function"!=typeof e.toString)throw C("toString is not a function");if("string"!=typeof(e=e.toString()))throw C("dirty is not a string, aborting")}if(!i.isSupported){if("object"===G(t.toStaticHTML)||"function"==typeof t.toStaticHTML){if("string"==typeof e)return t.toStaticHTML(e);if(dt(e))return t.toStaticHTML(e.outerHTML)}return e}if(Fe||et(o),i.removed=[],"string"==typeof e&&(Re=!1),Re);else if(e instanceof l)1===(a=(r=at("\x3c!----\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===a.nodeName||"HTML"===a.nodeName?r=a:r.appendChild(a);else{if(!Te&&!Ie&&!Be&&-1===e.indexOf("<"))return ne&&Ne?ne.createHTML(e):e;if(!(r=at(e)))return Te?null:oe}r&&Le&&st(r.firstChild);for(var h=lt(Re?e:r);d=h.nextNode();)3===d.nodeType&&d===c||ut(d)||(d.content instanceof s&&bt(d.content),pt(d),c=d);if(c=null,Re)return e;if(Te){if(Oe)for(u=le.call(r.ownerDocument);r.firstChild;)u.appendChild(r.firstChild);else u=r;return Me&&(u=ce.call(n,u,!0)),u}var p=Be?r.outerHTML:r.innerHTML;return Ie&&(p=w(p,pe," "),p=w(p,be," ")),ne&&Ne?ne.createHTML(p):p},i.setConfig=function(e){et(e),Fe=!0},i.clearConfig=function(){Qe=null,Fe=!1},i.isValidAttribute=function(e,t,i){Qe||et({});var n=v(e),o=v(t);return ht(n,o,i)},i.addHook=function(e,t){"function"==typeof t&&(he[e]=he[e]||[],g(he[e],t))},i.removeHook=function(e){he[e]&&m(he[e])},i.removeHooks=function(e){he[e]&&(he[e]=[])},i.removeAllHooks=function(){he={}},i}();t.default=K,t.sanitize=K.sanitize,t.addHook=K.addHook,t.removeHook=K.removeHook},5754(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.IDEIcon=t.doubleIconCssList=t.ideExtIconStyleElement=t.ideIconStyleElement=t.ideUIRegisterIcon=t.getAllIcons=t.renderLabelWithIcons=t.renderIcon=t.getDoubleIconId=t.getSigleActivatedIcon=t.getConvertedIconId=t.isDoubleIcon=t.isIdeIconExists=t.addIconStylebyClass=t.getIconStyle=t.getIconClassName=t.addStyle=t.ICONSTHEMES=t.cssIconIdRegex=t.iconModifierExpression=t.iconNameExpression=t.ICONCONVERSIONMAPPING=t.DOUBLEICONMAPPINGKEYS=t.CODICON=t.CODEICON_ANIMATION_CLASS_NAME=t.ICON_CLASS_PREFIX=t.IconType=void 0;const n=i(5574),o=i(4846),s=i(9084);var r;!function(e){e.doubleIcon="doubleIcon",e.singleIcon="singleIcon"}(r=t.IconType||(t.IconType={})),t.ICON_CLASS_PREFIX="codicon",t.CODEICON_ANIMATION_CLASS_NAME="codicon-animation-spin",t.CODICON=`\n.codicon[class*='codicon-'] {\n\tfont: normal normal normal 16px/1 pi-codearts;\n    font-family: 'pi-codearts', 'codicon';\n    display: inline-block;\n    text-decoration: none;\n    text-rendering: auto;\n    text-align: center;\n    -webkit-font-smoothing: antialiased;\n    -moz-osx-font-smoothing: grayscale;\n    user-select: none;\n    -webkit-user-select: none;\n    -ms-user-select: none;\n}\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n.${t.CODEICON_ANIMATION_CLASS_NAME} {\n\tanimation: codicon-spin 1.5s steps(30) infinite\n}\n.double-icon.codicon[class*='codicon-'] {\n    position: relative;\n    font-size: 16px;\n    width: 16px;\n    height: 16px;\n}\n.double-icon.codicon[class*='codicon-']::after,\n.double-icon.codicon[class*='codicon-']::before {\n    display: block;\n}\n`,t.DOUBLEICONMAPPINGKEYS=Object.keys(n.doubleIconMapping),t.ICONCONVERSIONMAPPING=n.iconConversionMapping,t.iconNameExpression="[A-Za-z0-9-]+",t.iconModifierExpression="~[A-Za-z]+";const a=new RegExp(`(\\\\)?\\$\\((${t.iconNameExpression}(?:${t.iconModifierExpression})?)\\)`,"g");t.cssIconIdRegex=new RegExp(`^(${t.iconNameExpression})(${t.iconModifierExpression})?$`);const l=n.mapping,d=n.codiconMapping;t.ICONSTHEMES=o.iconTheme;const c=n.doubleIconMapping,u=new Map,h=new Map,p=Object.assign(Object.assign(Object.assign({},d),l),c),b=(e,i)=>{const n=h.get(e);if(n&&!p[e])return m(e,n);const o=function(e){const t="2-active",i=e.endsWith("-active");let n="",o="";const[s,a]=v(e);e.endsWith("2")||e.endsWith(t)?(n=i?e.replace(t,"-up-active"):`${e.slice(0,-1)}-up`,o=i?e.replace(t,"-down-active"):`${e.slice(0,-1)}-down`):(n=s,o=a);const l=c[n],d=c[o];if(l&&d){const t={description:r.doubleIcon,definition:{fontCharacter:"\\"+l.toString(16),secondFontCharacter:"\\"+d.toString(16)},colors:{color:n,secondColor:o}};return m(e,t)}return""}(e);return o||function(e,i){var n;const o=t.ICONSTHEMES[e],s=i||o,r=s?`color: ${s}`:"",a=null!==(n=p[e])&&void 0!==n?n:u.get(e);if(!a)return"";if("number"==typeof a){const t=a.toString(16);return Object.keys(c).includes(e)?(null==e?void 0:e.indexOf("down"))>-1?`.double-icon.codicon-${e}::after {\n                    content: '\\${t}';\n                    position: absolute;\n                    ${r};\n                    --user-view-icon-color: ${null!=o?o:i};\n                }`:`.double-icon.codicon-${e}::before {\n                    content: '\\${t}';\n                    position: absolute;\n                    z-index: 1;\n                    ${r};\n                    --user-view-icon-color: ${null!=o?o:i};\n                }`:`.codicon-${e}::before {\n        content: '\\${t}';\n        ${r};\n        --user-view-icon-content: '\\${t}';\n        --user-view-icon-color: ${null!=o?o:i};\n        }`}return`.codicon-${e}::before {\n        content: '${a.fontCharacter}';\n        font-family: '${a.fontFamily}';\n        }`}(e,i)};t.addStyle=(e,t,i)=>{const n=b(t,i);e.appendChild(document.createTextNode(n))},t.getIconClassName=e=>{if(e in p)return["codicon",`codicon-${e}`];const i=t.cssIconIdRegex.exec(e);if(!i)return(0,t.getIconClassName)("error");const[,n,o]=i,s=["codicon",`codicon-${n}`];return o&&s.push(`codicon-modifier-${o.substring(1)}`),s},t.getIconStyle=(e,i=!1,n)=>{const o=Array.isArray(e)?e:[e];let s=i?"":t.CODICON;return o.forEach(e=>{s+="\n"+b(e,n)}),s};const m=(e,i)=>{var n,o,s,a,l;const d=null===(n=i.colors)||void 0===n?void 0:n.color,c=null===(o=i.colors)||void 0===o?void 0:o.secondColor,u=(null===(s=i.definition)||void 0===s?void 0:s.fontCharacter)||i.fontCharacter,h=(null===(a=i.definition)||void 0===a?void 0:a.secondFontCharacter)||i.secondFontCharacter,p=d?`color: ${t.ICONSTHEMES[d]}; --user-view-icon-color: ${t.ICONSTHEMES[d]};`:"",b=c?`color: ${t.ICONSTHEMES[c]}; --user-view-icon-color: ${t.ICONSTHEMES[d]};`:"",m=u?`content: '${u}'; --user-view-icon-content: '${u}';`:"",g=h?`content: '${h}'; --user-view-icon-content: '${h}';`:"",v=(null===(l=i.font)||void 0===l?void 0:l.id)?`font-family: '${i.font.id}';`:"";return(null==i?void 0:i.description)===r.doubleIcon?`\n        .double-icon.codicon-${e}::before {\n           ${m}\n            position: absolute;\n            ${p}\n            z-index: 1;\n        }\n        .double-icon.codicon-${e}::after {\n            ${g}\n            ${b}\n            position: absolute;\n    }`:`.codicon-${e}::before {\n            ${m}\n            ${p}\n            ${v}\n        }`};function g(e){if(!e)return!1;const i=e.endsWith("-active")?e.replace("-active","-up-active"):`${e}-up`;return!!t.DOUBLEICONMAPPINGKEYS.includes(i)}function v(e){const t=e.endsWith("-active");return[t?e.replace("-active","-up-active"):`${e}-up`,t?e.replace("-active","-down-active"):`${e}-down`]}function f(e,i){var n;const[,o]=null!==(n=t.cssIconIdRegex.exec(e.id))&&void 0!==n?n:[],s=o||e.id,r=g(s);let a=[],l=[];if(r?(a=v(s),l=Array.isArray(e.color)?e.color:[]):l="string"==typeof e.color?[e.color]:[],i){let e=i.querySelector("style");e||(e=document.createElement("style"),i.appendChild(e));const n=e.childNodes.item(0),o=(null==n?void 0:n.wholeText.indexOf("codicon[class*='codicon-']"))>-1;r?(null==e||e.appendChild(document.createTextNode((0,t.getIconStyle)(a[0],o,l[0]))),null==e||e.appendChild(document.createTextNode((0,t.getIconStyle)(a[1],o,l[1])))):null==e||e.appendChild(document.createTextNode((0,t.getIconStyle)(s,o,l[0])))}const d=document.createElement("span"),c=a[1]?(0,t.getIconClassName)(a[1]):[],u=r?["double-icon"]:[];return d.classList.add(...(0,t.getIconClassName)(r?a[0]:e.id),...c,...u),(null==e?void 0:e.additionalClass)&&d.classList.add(e.additionalClass),d}t.addIconStylebyClass=(e,i)=>{let n,o="";const s=[];if(!e)return;n=i.querySelector("style"),n||(n=document.createElement("style"),i.appendChild(n));const r=null==n?void 0:n.childNodes.item(0),a=(null==r?void 0:r.textContent)||"";if(e.split(" ").forEach(e=>{if(e.startsWith("codicon-")){const t=e.substring(8),i=".codicon-"+t+":before";a.includes(i)||s.push(t)}}),s.forEach(e=>{o+="\n"+b(e)}),null==r?void 0:r.wholeText.includes(o))return;let l=(null==r?void 0:r.wholeText.includes("codicon[class*='codicon-']"))?"":t.CODICON;l+=o,null==n||n.appendChild(document.createTextNode(l))},t.isIdeIconExists=e=>!!(Object.assign(Object.assign({},d),l)[e]||u.get(e)||g(e)),t.isDoubleIcon=g,t.getConvertedIconId=function(e){let i=t.ICONCONVERSIONMAPPING[e];const n=g(e);return i||(i=n?e:""),i},t.getSigleActivatedIcon=function(e){const i=t.ICONCONVERSIONMAPPING[e];return l[`${e}-active`]?i:""},t.getDoubleIconId=v,t.renderIcon=f,t.renderLabelWithIcons=function(e,t,i){const n=new Array;let o,s=0,r=0;for(;null!==(o=a.exec(e));){r=o.index||0,n.push(e.substring(s,r)),s=(o.index||0)+o[0].length;const[,a,l]=o;n.push(a?`$(${l})`:f({id:l,color:i},t))}return s<e.length&&n.push(e.substring(s)),n},t.getAllIcons=function(){let e=t.CODICON;for(const t in p)Object.prototype.hasOwnProperty.call(p,t)&&(e+="\n"+b(t));for(const[t]of u)e+="\n"+b(t);return e},t.ideUIRegisterIcon=function(e,t){var i;h.set(e,t);const n=l[t.id];n&&u.set(e,n),t.fontCharacter&&t.font&&u.set(e,{fontCharacter:t.fontCharacter,fontFamily:null===(i=t.font)||void 0===i?void 0:i.id})},t.ideIconStyleElement=function(e,i=!1,n=!1){e.indexOf("active")>-1&&(e=e.replace("-active",""),i=!0);const o=Object.values(t.ICONCONVERSIONMAPPING).includes(e),s=document.createElement("style");if(n)s.appendChild(document.createTextNode(b(e)+b(`${e}-active`)));else{const t=o?".double-icon.codicon::after, .double-icon.codicon::before { top: 3px; }":"",n=`${e}-up${i?"-active":""}`,r=`${e}-down${i?"-active":""}`;s.appendChild(document.createTextNode(b(n)+b(r)+b(`${n}-active`)+b(`${r}-active`)+t))}return s},t.ideExtIconStyleElement=function(e){const t=document.createElement("style");return u.get(e)&&t.appendChild(document.createTextNode(b(e))),t},t.doubleIconCssList=function(e,t=!1,i=!1){return i?["codicon",`codicon-${e}${t?"-active":""}`]:["double-icon","codicon",`codicon-${e}-up${t?"-active":""}`,`codicon-${e}-down${t?"-active":""}`]};class w extends s.BaseComponent{constructor(e){var t;super(),this.iconId=e.id,this.actived=null!==(t=e.actived)&&void 0!==t&&t,this.iconSpan=document.createElement("span"),g(this.iconId)&&this.iconSpan.classList.add("double-icon"),this.styleElement=document.createElement("style"),g(this.iconId)?this.renderDoubleColorIconBody():this.renderDefaultIconBody(),this.changeIconColor(e.color)}changeIconColor(e){if(!e)return;const t=document.createElement("style");let i="";if("string"==typeof e)i=`.codicon::before { color: ${e}}`;else{const[t,n]=e;i=`.double-icon.codicon::before { color: ${t}} .double-icon.codicon::after { color: ${n}};`}t.appendChild(document.createTextNode(i)),this.shadow.appendChild(t)}renderDefaultIconBody(){this.iconSpan.classList.add(...(0,t.getIconClassName)(this.iconId)),this.styleElement.appendChild(document.createTextNode(t.CODICON+b(this.iconId)+this.getCSSStyle())),this.shadow.appendChild(this.styleElement),this.shadow.appendChild(this.iconSpan)}renderDoubleColorIconBody(){this.iconId.indexOf("active")>-1&&(this.iconId=this.iconId.replace("-active",""),this.actived=!0);const e=`${this.iconId}-up${this.actived?"-active":""}`,i=`${this.iconId}-down${this.actived?"-active":""}`;this.actived?this.iconSpan.classList.remove(...(0,t.getIconClassName)(`${this.iconId}-up`),...(0,t.getIconClassName)(`${this.iconId}-down`)):this.iconSpan.classList.remove(...(0,t.getIconClassName)(`${this.iconId}-up-active`),...(0,t.getIconClassName)(`${this.iconId}-down-active`)),this.iconSpan.classList.add(...(0,t.getIconClassName)(e),...(0,t.getIconClassName)(i)),this.deleteChild(this.styleElement),this.styleElement.appendChild(document.createTextNode(t.CODICON+b(e)+b(i)+this.getCSSStyle())),this.shadow.appendChild(this.styleElement),this.shadow.appendChild(this.iconSpan)}deleteChild(e){for(;e.hasChildNodes();)e.removeChild(e.firstChild)}set active(e){this.actived=e,this.renderDoubleColorIconBody()}get active(){var e;return null!==(e=this.actived)&&void 0!==e&&e}get element(){return this.iconSpan}getCSSStyle(e){return e?`\n                .codicon[class*='codicon-'] {\n                    font-size: ${e}px;\n                    height: ${e}px;\n                    width: ${e}px;\n                }\n            `:"\n            :host {\n                display: inline-block;\n                line-height: 0;\n            }\n        "}dispose(){}}t.IDEIcon=w,(0,s.defineCustomElement)("ide-icon",w)},5814(e){var t="undefined"!=typeof crypto&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||"undefined"!=typeof msCrypto&&"function"==typeof window.msCrypto.getRandomValues&&msCrypto.getRandomValues.bind(msCrypto);if(t){var i=new Uint8Array(16);e.exports=function(){return t(i),i}}else{var n=new Array(16);e.exports=function(){for(var e,t=0;t<16;t++)3&t||(e=4294967296*Math.random()),n[t]=e>>>((3&t)<<3)&255;return n}}},6199(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.siderbarIconUpDefault=t.debugIconBreakpointUnverifiedForeground=t.debugIconBreakpointForeground=t.debugIconDisconnectForeground=t.debugIconRestartForeground=t.symbolIconEnumMemberColor=t.symbolIconMethodColor=t.symbolIconValueColor=t.symbolIconAbstractClassColor=t.symbolIconEventColor=t.symbolIconColor=t.infoStatusColor=t.successStatusColor=t.warnStatusColor=t.errorStatusColor=t.outlineColor=t.borderColor=t.popSplitLineColor=t.blockSplitLineColor=t.optionBackground=t.processingBackgroundColor=t.secondaryBackgroundColor=t.disabledBackgroundColorCode=t.selectedBackgroundColorCode=t.suspendedBackgroundColorCode=t.inputBackgroundColor=t.breadcrumBackgroundColor=t.menuBackgroundColor=t.popUpBackgroundColor=t.codeBackgroundColor=t.primaryColorDisabled=t.primaryColorGradation=t.primaryColorClick=t.primaryColorHover=t.primaryColor=t.linkFontColorActive=t.linkFontColorHover=t.disabledFontColor=t.secondaryFontColor=t.primaryFontColor=t.titleFontColor=t.commonFontSize=t.fontLineHeight=t.fontSize=t.fontFamily=t.boxShadow=t.cardShadowColor=t.dropdownShadowColor=t.dialogShadowColor=t.radius=void 0,t.python=t.java=t.cSharp=t.jdkDown=t.jdkUp=t.lightning=t.warnDown=t.tipDown=t.tipUp=t.successDown=t.successUp=t.errorDown=t.problemDown=t.problemUp=t.compassActive=t.accessible=t.region=t.huaweiLogo=t.markdown=t.pined=t.iconActive=t.file=t.jumpSmall=t.stopMiddle=t.zip=t.manifest=t.stop=t.debugPause=t.msg=t.apk=t.rating=t.favorites=t.unlock=t.debugStackframeUp=t.debugStackframeDown=t.javaToolsIconActiveUp=t.javaToolsIconActiveDown=t.javaToolsIconDefaultUp=t.javaToolsIconDefaultDown=t.cppHeaderFileUp=t.cppSourceFileUp=t.noDatadown=t.noDataUp=t.diffRemoveUp=t.diffRemoveDown=t.codeCollapseDown=t.codeCollapseUp=t.siderbarIconDownActive=t.siderbarIconUpActive=t.siderbarIconDownDefault=void 0,t.dangerSecondaryButtonDisabledBackground=t.dangerSecondaryButtonClickBackground=t.dangerSecondaryButtonBackHoverground=t.dangerSecondaryButtonBackground=t.dangerButtonDisabledColor=t.dangerButtonDisabledBackground=t.dangerButtonClickBackground=t.dangerButtonHoverBackground=t.dangerButtonBackgroundImage=t.disbaledButtonColor=t.secondaryButtonActiveColor=t.secondaryButtonActiveBackgroundImage=t.secondaryButtonActiveBackground=t.secondaryButtonHoverColor=t.secondaryButtonHoverBackgroundColor=t.secondaryButtonHoverBackgroundImage=t.secondaryButtonHoverShadow=t.secondaryButtonBorder=t.secondaryButtonColor=t.secondaryButtonBackgroundImage=t.secondaryButtonBackground=t.primaryButtonBorder=t.primaryButtonFocusBorderColor=t.buttonBackgroundImage=t.terminalAnsiLightSkyBlue=t.terminalAnsiSpringGreen=t.terminalAnsiPaleVioletRed=t.terminalAnsiMediumSlateBlue=t.terminalAnsiDarkSeaGreen=t.terminalAnsiNavajoWhite=t.terminalAnsiRoyalBlue=t.terminalAnsiMediumOrchid=t.terminalAnsiChocolate=t.terminalAnsiMediumTurquoise=t.springExplorerDown=t.springExplorerUp=t.gitcode=t.failOutdatedColor=t.disabledIconColor=t.breakpointToolsViewNotActiveUp=t.breakpointMultipleUverifiedDown=t.breakpointMultipleUverifiedUp=t.breakpointDisabledDown=t.breakpointDisabledUp=t.breakpointEnabledDown=t.breakpointEnabledUp=t.iconColor=t.huaweiLogoName=t.debugRerunDowm=t.debugAll=void 0,t.actionViewItemChecked=t.actionViewItemHover=t.actionViewItemColor=t.actionViewItemBackgroundColor=t.inputMessageErrorBgColor=t.inputMessageWarnBgColor=t.inputMessageBgColor=t.inputBoxDisabledBorderColor=t.inputBoxErrorBorderColor=t.inputBoxWarningBorderColor=t.inputBoxSuccessBorderColor=t.inputBoxBorderFocusColor=t.inputBoxBorderHoverColor=t.inputBoxBorderColor=t.inputBoxPlaceholderTextColor=t.inputBoxLabelColor=t.inputBoxTextColor=t.inputBoxDisabledBackground=t.inputBoxBackground=t.removedIconLabelBackground=t.insertediconLabelBackground=t.iconLabelColor=t.highLightedColor=t.hoverBorderColor=t.hoverShadowColor=t.hoverLinkColor=t.errorHoverBackground=t.warnHoverBackground=t.hoverBackground=t.hoverFontColor=t.optionScrollbarBackground=t.optionHoverBackground=t.optionBorderColor=t.selectClearHoverColor=t.selectClearColor=t.selectHoverBorderColor=t.selectBorderColor=t.selectBackground=t.tagDisableBackground=t.pressingTagBackground=t.defaultTagBackground=t.labelTypeTagColor=t.badgeBackground=t.dangerSecondaryButtonDisabledBorder=t.dangerSecondaryButtonClickBorder=t.dangerSecondaryButtonHoverBorder=t.dangerSecondaryButtonBorder=t.dangerSecondaryButtonDisabledColor=t.dangerSecondaryButtonClickColor=t.dangerSecondaryButtonHoverColor=void 0,t.iconEnabledColor=t.iconDisabledColor=t.labelColor=t.lineColor=t.codeColor=t.disbaledradioBackgroundColor=t.radioBackgroundColor=t.radioColor=t.tabsSelectForeground=t.tabFontColor=t.tabActiveColor=t.tabBorderColor=t.tabsDefaultBackground=t.menuShadowColor=t.scrollbarSliderActiveBackground=t.scrollbarSliderHoverBackground=t.scrollbarSliderBackground=t.scrollbarShadow=t.actionSeparatorColor=t.actionSideBarHoverBackground=t.actionSideBarCheckBackground=t.actionSideBarRemoveHoverBackground=t.actionSideBarMovingBackground=t.actionSideBarCheckedRemoveBoxShadow=t.actionSideBarCheckedBoxShadow=t.actionSideBarCheckedBoxLeftShadow=t.actionSideBarHoverBoxLeftShadow=t.actionSideBarHoverRemoveBoxShadow=t.actionSideBarHoverBoxShadow=t.actionSideBarNameColor=t.actionViewItemIconColor=void 0;const n=i(5354);t.radius={cardRadius:"6px",normal:"4px",bgRadius:"2px"},t.dialogShadowColor=(0,n.register)("dialog-shadow-color",{dark:"#808080",light:"#333"}),t.dropdownShadowColor=(0,n.register)("dropdown-shadow-color",{dark:"#525252",light:"#292929"}),t.cardShadowColor=(0,n.register)("card-shadow-color",{dark:"#3d3d3d",light:"#1f1f1f"}),t.boxShadow={dialogShadow:`0px 8px 24px ${t.dialogShadowColor}`,dropdownShadow:`0px 8px 24px ${t.dropdownShadowColor}`,cardShadow:`0px 8px 24px ${t.cardShadowColor}`},t.fontFamily="'Inter', 'Segoe UI', 'Arial','Microsoft YaHei', 'Microsoft Jhenghei'",t.fontSize={mainText:"12px",buttonText:"13px",titleText:"14px",dialogText:"16px"},t.fontLineHeight={mainText:"18px",buttonText:"20px",titleText:"20px",dialogText:"22px"},t.commonFontSize={small:"11px",medium:"13px",large:"16px"},t.titleFontColor=(0,n.register)("title-font-color",{dark:"#FFFFFF",light:"#262729"}),t.primaryFontColor=(0,n.register)("primary-font-color",{dark:"#D3D3D4",light:"#45474D"}),t.secondaryFontColor=(0,n.register)("secondary-font-color",{dark:"#ACACAD",light:"#676C75"}),t.disabledFontColor=(0,n.register)("disabled-font-color",{dark:"#838385",light:"#878D99"}),t.linkFontColorHover=(0,n.register)("link-font-color-hover",{dark:"#4294FF",light:"#6BAEFF"}),t.linkFontColorActive=(0,n.register)("link-font-color-active",{dark:"#1E4F9E",light:"#6BAEFF"}),t.primaryColor=(0,n.register)("primary-color",{dark:"#4287FF",light:"#246BFD"}),t.primaryColorHover=(0,n.register)("primary-color-hover",{dark:"#5C9DFF",light:"#4287FF"}),t.primaryColorClick=(0,n.register)("primary-color-click",{dark:"#246BFD",light:"#1653E0"}),t.primaryColorGradation=(0,n.register)("primary-color-gradation",{dark:"linear-gradient(0deg, #4287FF 0%, #246BFD 100%)",light:"linear-gradient(0deg, #246BFD 100%, #1653E0 100%)"}),t.primaryColorDisabled=(0,n.register)("primary-color-disabled",{dark:"#2A4D8A",light:"#91B5FE"}),t.codeBackgroundColor=(0,n.register)("code-background-color",{dark:"#131415",light:"#FFFFFF"}),t.popUpBackgroundColor=(0,n.register)("pop-up-background-color",{dark:"#262729",light:"#F6F8FA"}),t.menuBackgroundColor=(0,n.register)("menu-background-color",{dark:"#303133",light:"#E6EBF0"}),t.breadcrumBackgroundColor=(0,n.register)("breadcrumb-background-color",{dark:"#3A3B3D",light:"#F1F3F5"}),t.inputBackgroundColor=(0,n.register)("input-background-color",{dark:"#1A1B1D",light:"#246BFD"}),t.suspendedBackgroundColorCode=(0,n.register)("suspended-background-color",{dark:"rgba(255, 255, 255, 0.08)",light:"rgba(38, 39, 41, 0.08)"}),t.selectedBackgroundColorCode=(0,n.register)("selected-background-color",{dark:"rgba(66, 135, 255, 0.12)",light:"rgba(66, 135, 255, 0.12)"}),t.disabledBackgroundColorCode=(0,n.register)("disabled-background-color",{dark:"#2F3033",light:"#EDEEF0"}),t.secondaryBackgroundColor=(0,n.register)("secondary-background-color",{dark:"rgba(66, 135, 255, 0.12)",light:"rgba(36, 107, 253, 0.12)"}),t.processingBackgroundColor=(0,n.register)("processing-background-color",{dark:"#4287FF",light:"#246BFD"}),t.optionBackground=(0,n.register)("option-background",{dark:"#353638",light:"#FFFFFF"}),t.blockSplitLineColor=(0,n.register)("block-split-line-color",{dark:"#131415",light:"#D5DCE1"}),t.popSplitLineColor=(0,n.register)("pop-split-line-color",{dark:"#353638",light:"#EDEDED"}),t.borderColor=(0,n.register)("border-color",{dark:"#424447",light:"#DCDFE6"}),t.outlineColor=(0,n.register)("outline-color",{dark:"rgba(66, 135, 255, 0.4)",light:"rgba(36, 135, 253, 0.4)"}),t.errorStatusColor="#F66F6A",t.warnStatusColor="#FA9841",t.successStatusColor="#26BD84",t.infoStatusColor="#4287ff",t.symbolIconColor=(0,n.register)("symbol-icon-array-color",{dark:"#ACACAD",light:"#686C75"}),t.symbolIconEventColor=(0,n.register)("symbol-icon-event-color",{dark:"#E99550",light:"#E87E26"}),t.symbolIconAbstractClassColor=(0,n.register)("symbol-icon-abstract-class-color",{dark:"#929DFF",light:"#616CD3"}),t.symbolIconValueColor=(0,n.register)("symbol-icon-value-color",{dark:"#6CBFFF",light:"#3096E5"}),t.symbolIconMethodColor=(0,n.register)("symbol-icon-method-color",{dark:"#D490EB",light:"#AC4ECC"}),t.symbolIconEnumMemberColor=(0,n.register)("symbol-icon-enum-menber-color",{dark:"#75BEFF",light:"#007ACC"}),t.debugIconRestartForeground=(0,n.register)("debug-icon-restart-foreground",{dark:"#89D185",light:"#388A34"}),t.debugIconDisconnectForeground=(0,n.register)("debug-disconnect-foreground",{dark:"#F48771",light:"#A1260D"}),t.debugIconBreakpointForeground="#E51400",t.debugIconBreakpointUnverifiedForeground="#848484",t.siderbarIconUpDefault=(0,n.register)("siderbar-icon-up-default",{dark:"#B1B1BD",light:"#7B7B80"}),t.siderbarIconDownDefault=(0,n.register)("siderbar-icon-down-default",{dark:"#6C6C70",light:"#BCBCC2"}),t.siderbarIconUpActive=(0,n.register)("siderbar-icon-up-active",{dark:"#B0CCF4",light:"#20539E"}),t.siderbarIconDownActive=(0,n.register)("siderbar-icon-down-active",{dark:"#367FE5",light:"#3A87F0"}),t.codeCollapseUp=(0,n.register)("code-collapse-up",{dark:"#747474",light:"#D5DCE1"}),t.codeCollapseDown=(0,n.register)("code-collapse-down",{dark:"#262629",light:"#F1F3F5"}),t.diffRemoveDown=(0,n.register)("diff-remove-down",{dark:"#454545",light:"#A4A7AC"}),t.diffRemoveUp=(0,n.register)("diff-remove-up",{dark:"#ACACAD",light:"#45474D"}),t.noDataUp=(0,n.register)("no-data-up",{dark:"#ACACAD",light:"#676C75"}),t.noDatadown=(0,n.register)("no-data-down",{dark:"rgba(172,172,173,0.24)",light:"rgba(103,108,117,0.24)"}),t.cppSourceFileUp=(0,n.register)("cpp-source-file-up",{dark:"#B180D7",light:"#652D90"}),t.cppHeaderFileUp=(0,n.register)("cpp-header-file-up",{dark:"#C49E49",light:"#95711F"}),t.javaToolsIconDefaultDown=(0,n.register)("java-tools-icon-default-down",{dark:"#676c75",light:"#BCBCC3"}),t.javaToolsIconDefaultUp=(0,n.register)("java-tools-icon-default-up",{dark:"#bfbec1",light:"#7B7B80"}),t.javaToolsIconActiveDown=(0,n.register)("java-tools-icon-active-down",{dark:"#1D89FF",light:"#006DFF"}),t.javaToolsIconActiveUp=(0,n.register)("java-tools-icon-active-up",{dark:"#fff",light:"#262729"}),t.debugStackframeDown="#2867C7",t.debugStackframeUp="#D63C48",t.unlock="#26BD84",t.favorites="#FECC55",t.rating="#FEA055",t.apk="#24B286",t.msg="#6CBFFF",t.debugPause="#60B9E5",t.stop="#E66A70",t.manifest="#FA9841",t.zip="#AFB42B",t.stopMiddle="#FFC53D",t.jumpSmall="#838385",t.file="#BABBC0",t.iconActive="#4287FF",t.pined="#4A86EF",t.markdown="#42A5F5",t.huaweiLogo="#CE0E2D",t.region="#ACACAC",t.accessible="#7ABB8E",t.compassActive="#26BD84",t.problemUp="#FAC20B",t.problemDown="rgba(255,194,11,0.2)",t.errorDown="rgba(246,111,106,0.2)",t.successUp="#3DCCA6",t.successDown="rgba(61,204,166,0.2)",t.tipUp="#54A9F9",t.tipDown="rgba(84,169,249,0.2)",t.warnDown="rgba(250,152,65,0.2)",t.lightning="#F3A600",t.jdkUp="#6CBAE1",t.jdkDown="#ACACAD",t.cSharp="#B76AED",t.java="#DE5258",t.python="#6cbae1",t.debugAll="#73C991",t.debugRerunDowm="#D8D8D8",t.huaweiLogoName=(0,n.register)("huawei-logo-name",{dark:"#fff",light:"#000"}),t.iconColor=(0,n.register)("icon-color",{dark:"#fff",light:"#333"}),t.breakpointEnabledUp="#F66F6A",t.breakpointEnabledDown=(0,n.register)("breakpoint-enabled-down",{dark:"#FFFFFF",light:"#000000"}),t.breakpointDisabledUp=(0,n.register)("breakpoint-disabled-up",{dark:"#ACACAD",light:"#676C75"}),t.breakpointDisabledDown=(0,n.register)("breakpoint-disabled-down",{dark:"#BFBEC1",light:"#7B7B80"}),t.breakpointMultipleUverifiedUp=(0,n.register)("breakpoint-multiple-uverified-up",{dark:"#D8D8D8",light:"#676C75"}),t.breakpointMultipleUverifiedDown=(0,n.register)("breakpoint-multiple-uverified-down",{dark:"#BFBEC1",light:"#262729"}),t.breakpointToolsViewNotActiveUp=(0,n.register)("breakpoint-tools-view-not-active-up",{dark:"#6C6C70",light:"#BCBCC2"}),t.disabledIconColor=(0,n.register)("disabled-icon-color",{dark:"rgba(204, 204, 204, 0.5)",light:"rgba(97, 97, 97, 0.5)"}),t.failOutdatedColor=(0,n.register)("fail-outdated-color",{dark:"#acacad",light:"#676c75"}),t.gitcode=(0,n.register)("gitcode",{dark:"#DA203E",light:"#DA203E"}),t.springExplorerUp="#c2c2c2",t.springExplorerDown="#808080",t.terminalAnsiMediumTurquoise=(0,n.register)("terminal-ansiMediumTurquoise",{dark:"#4EB3B1",light:"#31CCC9"}),t.terminalAnsiChocolate=(0,n.register)("terminal-ansiChocolate",{dark:"#B96949",light:"#D96B3F"}),t.terminalAnsiMediumOrchid=(0,n.register)("terminal-ansiMediumOrchid",{dark:"#9F5AB9",light:"#B555D9"}),t.terminalAnsiRoyalBlue=(0,n.register)("terminal-ansiRoyalBlue",{dark:"#4361B6",light:"#3961D4"}),t.terminalAnsiNavajoWhite=(0,n.register)("terminal-ansiNavajoWhite",{dark:"#C49E49",light:"#E3B03D"}),t.terminalAnsiDarkSeaGreen=(0,n.register)("terminal-ansiDarkSeaGreen",{dark:"#618E51",light:"#6AAD51"}),t.terminalAnsiMediumSlateBlue=(0,n.register)("terminal-ansiMediumSlateBlue",{dark:"#634CCD",light:"#6547ED"}),t.terminalAnsiPaleVioletRed=(0,n.register)("terminal-ansiPaleVioletRed",{dark:"#B05362",light:"#CF4C61"}),t.terminalAnsiSpringGreen=(0,n.register)("terminal-ansiSpringGreen",{dark:"#248055",light:"#1C9E62"}),t.terminalAnsiLightSkyBlue=(0,n.register)("terminal-ansiLightSkyBlue",{dark:"#4581B6",light:"#3C8DD6"}),t.buttonBackgroundImage=(0,n.register)("button-background-image",{dark:"linear-gradient(180deg, #4287FF 0%, #246BFD 98%)",light:"linear-gradient(180deg, #246BFD 1%, #1653E0 99%)"}),t.primaryButtonFocusBorderColor=(0,n.register)("button-focus-border-color",{dark:"#4287ff80",light:"#246BFD80"}),t.primaryButtonBorder=(0,n.register)("primary-button-border",{dark:"1px solid transparent",light:"1px solid transparent"}),t.secondaryButtonBackground=(0,n.register)("secondary-button-background",{dark:"#484A4D",light:""}),t.secondaryButtonBackgroundImage=(0,n.register)("secondary-button-background-image",{dark:"#484A4D",light:"linear-gradient(0deg, #F6F7F9 0%, #FFFFFF 100%)"}),t.secondaryButtonColor=t.titleFontColor,t.secondaryButtonBorder=(0,n.register)("secondary-button-border",{dark:"1px solid transparent",light:"1px solid #DCDFE6"}),t.secondaryButtonHoverShadow=(0,n.register)("secondary-button-hover-shadow",{dark:"inset 0 1px 0 0 rgba(255,255,255,0.08)",light:""}),t.secondaryButtonHoverBackgroundImage=(0,n.register)("secondary-button-hover-background-image",{dark:"",light:"linear-gradient(0deg, #F6F7F9 0%, #FFFFFF 100%)"}),t.secondaryButtonHoverBackgroundColor=(0,n.register)("secondary-button-hover-background-color",{dark:"#656769",light:""}),t.secondaryButtonHoverColor=(0,n.register)("secondary-button-hover-color",{dark:"#FFFFFF",light:"#2E7AE6"}),t.secondaryButtonActiveBackground=(0,n.register)("secondary-button-active-background",{dark:"#3C3E40",light:""}),t.secondaryButtonActiveBackgroundImage=(0,n.register)("secondary-button-active-background-image",{dark:"",light:"linear-gradient ( 0deg, #F6F7F9 0%, #FFFFFF 100% )"}),t.secondaryButtonActiveColor=(0,n.register)("secondary-button-active-color",{dark:"#FFFFFF",light:"#2867C7"}),t.disbaledButtonColor=(0,n.register)("disbaled-button-color",{dark:"#838385",light:"#FFFFFF"}),t.dangerButtonBackgroundImage=(0,n.register)("danger-button-background-image",{dark:"linear-gradient(180deg, #F66F6A 0%, #CC4545 100%)",light:"linear-gradient(180deg, #F66F6A 0%, #CC4545 100% )"}),t.dangerButtonHoverBackground=(0,n.register)("danger-button-hover-background",{dark:"#F67D74",light:"#F67D74"}),t.dangerButtonClickBackground=(0,n.register)("danger-button-click-background",{dark:"#CC4545",light:"#CC4545"}),t.dangerButtonDisabledBackground=(0,n.register)("danger-button-disabled-background",{dark:"#643C3C",light:"#FED5D3"}),t.dangerButtonDisabledColor=(0,n.register)("danger-button-disabled-Color",{dark:"#838385",light:"#fff"}),t.dangerSecondaryButtonBackground=(0,n.register)("danger-secondary-button-background",{dark:"#603F3D",light:"#FFFFFF"}),t.dangerSecondaryButtonBackHoverground=(0,n.register)("danger-secondary-button-hover-background",{dark:"#784946",light:"#FFFFFF"}),t.dangerSecondaryButtonClickBackground=(0,n.register)("danger-secondary-button-click-background",{dark:"#463435",light:"#FFFFFF"}),t.dangerSecondaryButtonDisabledBackground=(0,n.register)("danger-secondary-button-disabled-background",{dark:"#372D2E",light:"#FFFFFF"}),t.dangerSecondaryButtonHoverColor=(0,n.register)("danger-secondary-button-hover-Color",{dark:"#F66F6A",light:"#F67D74"}),t.dangerSecondaryButtonClickColor=(0,n.register)("danger-secondary-button-click-Color",{dark:"#F66F6A",light:"#CC4545"}),t.dangerSecondaryButtonDisabledColor=(0,n.register)("danger-secondary-button-disabled-Color",{dark:"#643C3C",light:"#FBC3BF"}),t.dangerSecondaryButtonBorder=(0,n.register)("danger-secondary-button-border",{dark:"1px solid transparent",light:"1px solid #F66F6A"}),t.dangerSecondaryButtonHoverBorder=(0,n.register)("danger-secondary-button-hover-border",{dark:"1px solid transparent",light:"1px solid #F67D74"}),t.dangerSecondaryButtonClickBorder=(0,n.register)("danger-secondary-button-click-border",{dark:"1px solid transparent",light:"1px solid #CC4545"}),t.dangerSecondaryButtonDisabledBorder=(0,n.register)("danger-secondary-button-disabled-border",{dark:"1px solid transparent",light:"1px solid #FBC3BF"}),t.badgeBackground=(0,n.register)("badge-background",{dark:"#404143",light:"#e4e4e5"}),t.labelTypeTagColor=(0,n.register)("label-type-tag-color",{dark:"#FFFFFF",light:"#FFFFFF"}),t.defaultTagBackground=(0,n.register)("default-tag-background",{dark:"rgba(255, 255, 255, 0.12)",light:"rgba(38, 39, 41, 0.12)"}),t.pressingTagBackground=(0,n.register)("pressing-tag-background",{dark:"rgba(255, 255, 255, 0.08)",light:"rgba(38, 39, 41, 0.12)"}),t.tagDisableBackground=(0,n.register)("tag-disable-background",{dark:"rgba(255, 255, 255, 0.06)",light:"rgba(38, 39, 41, 0.12)"}),t.selectBackground=(0,n.register)("select-background",{dark:"#1A1B1D",light:"#FFFFFF"}),t.selectBorderColor=(0,n.register)("select-border-color",{dark:"#1A1B1D",light:"#DCDFE6"}),t.selectHoverBorderColor=(0,n.register)("select-Hover-border-color",{dark:"rgba(66, 135, 255, 0.6)",light:"rgba(36, 107, 253, 0.6)"}),t.selectClearColor=(0,n.register)("select-clear-color",{dark:"rgba(255, 255, 255, 0.2)",light:"#878D99"}),t.selectClearHoverColor=(0,n.register)("select-clear-hover-color",{dark:"#ACACAD",light:"#878D99"}),t.optionBorderColor=(0,n.register)("option-border-background",{dark:"#424447",light:"#FFFFFF"}),t.optionHoverBackground=(0,n.register)("option-Hover-background",{dark:"rgba(255, 255, 255, 0.08)",light:"rgba(38, 39, 41, 0.08)"}),t.optionScrollbarBackground=(0,n.register)("option-scrollbar-background",{dark:"rgba(116, 116, 116, 0.4)",light:"rgba(100, 100, 100, 0.4)"}),t.hoverFontColor=(0,n.register)("hover-font-color",{dark:"#FFFFFF",light:"#FFFFFF"}),t.hoverBackground=(0,n.register)("hover-background",{dark:"#353638",light:"#EDEDED"}),t.warnHoverBackground=(0,n.register)("warn-hover-background",{dark:"#CB7E38",light:"#FA9841"}),t.errorHoverBackground=(0,n.register)("error-hover-background",{dark:"#C85D59",light:"#F66F6A"}),t.hoverLinkColor=(0,n.register)("hover-link-color",{dark:"#4287FF",light:"#246BFD"}),t.hoverShadowColor=(0,n.register)("hover-shadow-color",{dark:"rgba(0,0,0,0.24)",light:"rgba(0,0,0,0.12)"}),t.hoverBorderColor=(0,n.register)("hover-border-color",{dark:"rgba(0,0,0,0.24)",light:"rgba(0,0,0,0.24)"}),t.highLightedColor=(0,n.register)("high-lighted-color",{dark:"#4287FF",light:"#4287FF"}),t.iconLabelColor=(0,n.register)("icon-label-color",{dark:"#cccccc",light:"#cccccc"}),t.insertediconLabelBackground=(0,n.register)("inserted-icon-label-background",{dark:"#9BB95533",light:"#9BB95533"}),t.removedIconLabelBackground=(0,n.register)("removed-icon-label-background",{dark:"#FF000033",light:"#FF000033"}),t.inputBoxBackground=(0,n.register)("inputBox-background",{dark:"#1A1B1D",light:"#fff"}),t.inputBoxDisabledBackground=(0,n.register)("inputBox-disabled-background",{dark:"#2F3033",light:"#EDEEF0"}),t.inputBoxTextColor=(0,n.register)("inputBox-text-color",{dark:"#FFFFFF",light:"#262729"}),t.inputBoxLabelColor=(0,n.register)("inputBox-text-color",{dark:"#D3D3D4",light:"#45474D"}),t.inputBoxPlaceholderTextColor=(0,n.register)("inputBox-placeholder-text-color",{dark:"#838385",light:"#878D99"}),t.inputBoxBorderColor=(0,n.register)("inputBox-border-color",{dark:"transparent",light:"#DCDFE6"}),t.inputBoxBorderHoverColor=(0,n.register)("inputBox-border-hover-color",{dark:"rgba(66,135,255,0.60)",light:"#4287FF"}),t.inputBoxBorderFocusColor=(0,n.register)("inputBox-border-focus-color",{dark:"#4287FF",light:"#246BFD"}),t.inputBoxSuccessBorderColor=(0,n.register)("inputBox-success-border-color",{dark:"#26BD84",light:"#26BD84"}),t.inputBoxWarningBorderColor=(0,n.register)("inputBox-warning-border-color",{dark:"#FA9841",light:"#FA9841"}),t.inputBoxErrorBorderColor=(0,n.register)("inputBox-error-border-color",{dark:"#F66F6A",light:"#F66F6A"}),t.inputBoxDisabledBorderColor=(0,n.register)("inputBox-disabled-border-color",{dark:"#424447",light:"#DCDFE6"}),t.inputMessageBgColor=(0,n.register)("inputBox-message-bg-color",{dark:"#353638",light:"#FFFFFF"}),t.inputMessageWarnBgColor=(0,n.register)("inputBox-message-warn-bg-color",{dark:"#CB7E38",light:"#FA9841"}),t.inputMessageErrorBgColor=(0,n.register)("inputBox-message-error-bg-color",{dark:"#C85D59",light:"#F66F6A"}),t.actionViewItemBackgroundColor=(0,n.register)("action-view-item-background-color",{dark:"#262729",light:"#f6f8fa"}),t.actionViewItemColor=(0,n.register)("action-view-item-color",{dark:"#ACACAD",light:"#676C75"}),t.actionViewItemHover=(0,n.register)("action-view-item-color-hover",{dark:"rgba(255, 255, 255, 0.12)",light:"#b8b8b850"}),t.actionViewItemChecked=(0,n.register)("action-view-item-color-checked",{dark:"rgba(255, 255, 255, 0.08)",light:"#b8b8b850"}),t.actionViewItemIconColor=(0,n.register)("action-view-item-icon-color",{dark:"#ACACAD",light:"#676C75"}),t.actionSideBarNameColor=(0,n.register)("action-side-bar-name-color",{dark:"#FFFFFF",light:"#262729"}),t.actionSideBarHoverBoxShadow=(0,n.register)("action-side-bar-hover-box-shadow",{dark:"2px 2px 2px 0 rgb(0, 0, 0, 0.44)",light:"2px 2px 2px 0 rgb(0, 0, 0, 0.16)"}),t.actionSideBarHoverRemoveBoxShadow=(0,n.register)("action-side-bar-hover-remove-box-shadow",{dark:"0px 0px 0px 0 rgb(0, 0, 0, 0.44)",light:"0px 0px 0px 0 rgb(0, 0, 0, 0.16)"}),t.actionSideBarHoverBoxLeftShadow=(0,n.register)("action-side-bar-hover-box-left-shadow",{dark:"-2px -2px 2px 0 rgb(0, 0, 0, 0.44)",light:"-2px -2px 2px 0 rgb(0, 0, 0, 0.16)"}),t.actionSideBarCheckedBoxLeftShadow=(0,n.register)("action-side-bar-checked-box-left-shadow",{dark:"inset 3px 3px 6px 0 rgba(58, 59, 61, 0.20), inset -2px -2px 4px 0 rgba(0, 0, 0, 0.50)",light:"inset 3px 3px 6px 0 rgba(255, 255, 255, 0.20), inset -2px -2px 4px 0 rgba(0, 0, 0, 0.16)"}),t.actionSideBarCheckedBoxShadow=(0,n.register)("action-side-bar-checked-box-shadow",{dark:"inset -3px -3px 6px 0 rgba(58, 59, 61, 0.20), inset 2px 2px 4px 0 rgba(0, 0, 0, 0.50)",light:"inset -3px -3px 6px 0 rgba(255, 255, 255, 0.20), inset 2px 2px 4px 0 rgba(0, 0, 0, 0.16)"}),t.actionSideBarCheckedRemoveBoxShadow=(0,n.register)("action-side-bar-checked-remove-box-shadow",{dark:"inset 0px 0px 0px 0 rgba(58, 59, 61, 0.20), inset 0px 0px 0px 0 rgba(0, 0, 0, 0.50)",light:"inset 0px 0px 0px 0 rgba(255, 255, 255, 0.20), inset 0px 0px 0px 0 rgba(0, 0, 0, 0.16)"}),t.actionSideBarMovingBackground=(0,n.register)("action-side-bar-moving-background",{dark:"rgba(66, 135, 255, 0.12)",light:"rgba(36, 107, 253, 0.12)"}),t.actionSideBarRemoveHoverBackground=(0,n.register)("action-side-bar-remove-hover-background",{dark:"#303133",light:"#EEF0F2"}),t.actionSideBarCheckBackground=(0,n.register)("action-side-bar-checked-background",{dark:"#282829",light:"#DEDFE0"}),t.actionSideBarHoverBackground=(0,n.register)("action-side-bar-hover-background",{dark:"rgba(90, 93, 94, 0.31)",light:"rgba(184, 184, 184, 0.31)"}),t.actionSeparatorColor=(0,n.register)("action-separator-color",{dark:"#424447",light:"#DCDFE6"}),t.scrollbarShadow=(0,n.register)("scrollbar-shadow",{dark:"#000000",light:"#DDDDDD"}),t.scrollbarSliderBackground=(0,n.register)("scrollbarSlider-background",{dark:"rgba(116, 116, 116, 0.4)",light:"rgba(100, 100, 100, 0.4)"}),t.scrollbarSliderHoverBackground=(0,n.register)("scrollbarSlider-hoverBackground",{dark:"rgba(100, 100, 100, 0.7)",light:"rgba(100, 100, 100, 0.7)"}),t.scrollbarSliderActiveBackground=(0,n.register)("scrollbarSlider.activeBackground",{dark:"rgba(191, 191, 191, 0.4)",light:"rgba(0, 0, 0, 0.6)"}),t.menuShadowColor=(0,n.register)("menu-shadow-color",{dark:"#00000052",light:"#00000029"}),t.tabsDefaultBackground=(0,n.register)("tabs-default-background",{dark:"#3c3c3c",light:"rgba(38, 39, 41, 0.08)"}),t.tabBorderColor=(0,n.register)("tab-border-color",{dark:"#424447",light:"#DCDFE6"}),t.tabActiveColor=(0,n.register)("tab-active-color",{dark:"#37383a",light:"#eeeeee"}),t.tabFontColor=(0,n.register)("tab-font-color",{dark:"#ACACAD",light:"#676C75"}),t.tabsSelectForeground=(0,n.register)("tabs-selectForeground",{dark:"#fff",light:"#262729"}),t.radioColor=(0,n.register)("radio-color",{dark:"#FFFFFF",light:"#FFFFFF"}),t.radioBackgroundColor=(0,n.register)("radio-background-color",{dark:"#262729",light:"#FFFFFF"}),t.disbaledradioBackgroundColor=(0,n.register)("disabled-radio-background-color",{dark:"#2F3033",light:"#F5F7FA"}),t.codeColor=(0,n.register)("code-color",{dark:"#d7ba7d",light:"#d7ba7d"}),t.lineColor=(0,n.register)("line-color",{dark:"#424447",light:"#DCDFE6"}),t.labelColor=(0,n.register)("label-color",{dark:"#ACACAD",light:"#676C75"}),t.iconDisabledColor=(0,n.register)("input-disable-icon-color",{dark:"#424447",light:"#d4d8dd"}),t.iconEnabledColor=(0,n.register)("input-enable-icon-color",{dark:"#FFFFFF",light:"#424447"})},6482(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Link=t.LinkType=t.TargetType=void 0;const n=i(519),o=i(9084),s=i(3731),r=i(8784),a=i(5754),l=i(5354);var d,c;(c=t.TargetType||(t.TargetType={})).blank="_blank",c.self="_self",c.parent="_parent",c.top="_top",function(e){e.default="default",e.primary="primary",e.danger="danger"}(d=t.LinkType||(t.LinkType={}));class u extends o.BaseComponent{constructor(e){super(),this.eventStore=new Set,this.disabled=!1,this.clickEmitter=new n.EventEmitter,this.onDidClick=this.clickEmitter.asSubscriber("onDidClick"),this.emitClick=e=>{this.disabled||this.clickEmitter.emit("onDidClick",e)},this.container=document.createElement("span"),this.container.classList.add("container"),this.link=document.createElement("a"),this.linkText=this.textContent||"",this.linkTitle=this.getAttribute("title")||"",this.linkType=this.getAttribute("linktype")||d.default,this.maxWidth=null!==this.getAttribute("maxWidth")?Number(this.getAttribute("maxWidth")):void 0,this.href=this.getAttribute("href")||"",this.target=this.getAttribute("target")||"",this.type=this.getAttribute("type")||"",this.rel=this.getAttribute("rel")||"",this.showIcon=Boolean(this.getAttribute("showIcon"))||!1,this.iconElement=document.createElement("span"),this.container.append(this.link),this.link.tabIndex=0,this.initOptions(e),this.label=this.linkText;const t=document.createElement("style"),i=(0,a.getIconStyle)("chevron-right",!1);t.appendChild(document.createTextNode((0,s.getLinkStyle)(l.ideChecker.isIDE)+i)),this.renderBody(),this.shadow.appendChild(t),this.shadow.appendChild(this.container),this.renderEvent()}initOptions(e){e&&(this.linkText=(null==e?void 0:e.label)||"",this.linkType=(null==e?void 0:e.linkType)||d.default,this.linkTitle=(null==e?void 0:e.title)||"",this.maxWidth=null==e?void 0:e.maxWidth,this.href=(null==e?void 0:e.href)||"",this.target=(null==e?void 0:e.target)||"",this.type=(null==e?void 0:e.type)||"",this.rel=(null==e?void 0:e.rel)||"",this.showIcon=(null==e?void 0:e.showIcon)||!1)}renderBody(){this.link.classList.add("ui-link"),this.link.setAttribute("linktype",this.linkType),this.type&&this.link.setAttribute("type",this.type),this.href&&this.link.setAttribute("href",this.href),this.target&&this.link.setAttribute("target",this.target),this.rel&&this.link.setAttribute("rel",this.rel),this.maxWidth&&(this.link.style.maxWidth=this.maxWidth+"px"),this.iconElement.classList.add("codicon","codicon-chevron-right")}renderEvent(){this.eventStore.add({element:this.container,type:"click",handler:this.emitClick}),this.eventStore.add({element:this.container,type:"keydown",handler:e=>{const t=e.code;let i=!1;!this.enabled||"Enter"!==t&&"Space"!==t?"Escape"===t&&this.container.blur():(this.emitClick(e),i=!0),i&&(e.stopPropagation(),e.preventDefault())}}),this.eventStore.forEach(e=>this.container.addEventListener(e.type,e.handler))}get element(){return this.container}get label(){return this.linkText}set label(e){this.linkText=e,this.link.textContent=e,this.showIcon&&this.container.append(this.iconElement),this.renderTitle()}renderTitle(){var e;this.linkTitle&&(null===(e=this.hover)||void 0===e||e.dispose(),this.hover=r.Hover.setupIconLabelHover({content:this.linkTitle,target:this.link,hoverPosition:r.HoverPosition.BELOW,showPointer:!1}))}get enabled(){return!this.disabled}set enabled(e){this.disabled=!e,this.link.classList.toggle("disabled-link",this.disabled),this.iconElement.classList.toggle("disabled-link",this.disabled)}focus(){this.link.focus()}hasFocus(){return this.link===document.activeElement}dispose(){var e;this.disconnectedCallback(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.clickEmitter.clear(),null===(e=this.hover)||void 0===e||e.dispose()}}t.Link=u,(0,o.defineCustomElement)("ide-link",u)},6709(e,t){"use strict";function i(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,r(n.key),n)}}function n(){return n=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var i=arguments[t];for(var n in i)Object.prototype.hasOwnProperty.call(i,n)&&(e[n]=i[n])}return e},n.apply(this,arguments)}function o(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function s(e,t){var i="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(i)return(i=i.call(e)).next.bind(i);if(Array.isArray(e)||(i=function(e,t){if(e){if("string"==typeof e)return o(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);return"Object"===i&&e.constructor&&(i=e.constructor.name),"Map"===i||"Set"===i?Array.from(e):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?o(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){i&&(e=i);var n=0;return function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function r(e){var t=function(e){if("object"!=typeof e||null===e)return e;var t=e[Symbol.toPrimitive];if(void 0!==t){var i=t.call(e,"string");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:String(t)}function a(){return{async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,hooks:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1}}t.defaults={async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,hooks:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1};var l=/[&<>"']/,d=new RegExp(l.source,"g"),c=/[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/,u=new RegExp(c.source,"g"),h={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},p=function(e){return h[e]};function b(e,t){if(t){if(l.test(e))return e.replace(d,p)}else if(c.test(e))return e.replace(u,p);return e}var m=/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi;function g(e){return e.replace(m,function(e,t){return"colon"===(t=t.toLowerCase())?":":"#"===t.charAt(0)?"x"===t.charAt(1)?String.fromCharCode(parseInt(t.substring(2),16)):String.fromCharCode(+t.substring(1)):""})}var v=/(^|[^\[])\^/g;function f(e,t){e="string"==typeof e?e:e.source,t=t||"";var i={replace:function(t,n){return n=(n=n.source||n).replace(v,"$1"),e=e.replace(t,n),i},getRegex:function(){return new RegExp(e,t)}};return i}var w=/[^\w:]/g,x=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;function y(e,t,i){if(e){var n;try{n=decodeURIComponent(g(i)).replace(w,"").toLowerCase()}catch(e){return null}if(0===n.indexOf("javascript:")||0===n.indexOf("vbscript:")||0===n.indexOf("data:"))return null}t&&!x.test(i)&&(i=function(e,t){k[" "+e]||(C.test(e)?k[" "+e]=e+"/":k[" "+e]=_(e,"/",!0));var i=-1===(e=k[" "+e]).indexOf(":");return"//"===t.substring(0,2)?i?t:e.replace(E,"$1")+t:"/"===t.charAt(0)?i?t:e.replace(D,"$1")+t:e+t}(t,i));try{i=encodeURI(i).replace(/%25/g,"%")}catch(e){return null}return i}var k={},C=/^[^:]+:\/*[^/]*$/,E=/^([^:]+:)[\s\S]*$/,D=/^([^:]+:\/*[^/]*)[\s\S]*$/,S={exec:function(){}};function A(e,t){var i=e.replace(/\|/g,function(e,t,i){for(var n=!1,o=t;--o>=0&&"\\"===i[o];)n=!n;return n?"|":" |"}).split(/ \|/),n=0;if(i[0].trim()||i.shift(),i.length>0&&!i[i.length-1].trim()&&i.pop(),i.length>t)i.splice(t);else for(;i.length<t;)i.push("");for(;n<i.length;n++)i[n]=i[n].trim().replace(/\\\|/g,"|");return i}function _(e,t,i){var n=e.length;if(0===n)return"";for(var o=0;o<n;){var s=e.charAt(n-o-1);if(s!==t||i){if(s===t||!i)break;o++}else o++}return e.slice(0,n-o)}function I(e,t){if(t<1)return"";for(var i="";t>1;)1&t&&(i+=e),t>>=1,e+=e;return i+e}function B(e,t,i,n){var o=t.href,s=t.title?b(t.title):null,r=e[1].replace(/\\([\[\]])/g,"$1");if("!"!==e[0].charAt(0)){n.state.inLink=!0;var a={type:"link",raw:i,href:o,title:s,text:r,tokens:n.inlineTokens(r)};return n.state.inLink=!1,a}return{type:"image",raw:i,href:o,title:s,text:b(r)}}var F=function(){function e(e){this.options=e||t.defaults}var i=e.prototype;return i.space=function(e){var t=this.rules.block.newline.exec(e);if(t&&t[0].length>0)return{type:"space",raw:t[0]}},i.code=function(e){var t=this.rules.block.code.exec(e);if(t){var i=t[0].replace(/^ {1,4}/gm,"");return{type:"code",raw:t[0],codeBlockStyle:"indented",text:this.options.pedantic?i:_(i,"\n")}}},i.fences=function(e){var t=this.rules.block.fences.exec(e);if(t){var i=t[0],n=function(e,t){var i=e.match(/^(\s+)(?:```)/);if(null===i)return t;var n=i[1];return t.split("\n").map(function(e){var t=e.match(/^\s+/);return null===t?e:t[0].length>=n.length?e.slice(n.length):e}).join("\n")}(i,t[3]||"");return{type:"code",raw:i,lang:t[2]?t[2].trim().replace(this.rules.inline._escapes,"$1"):t[2],text:n}}},i.heading=function(e){var t=this.rules.block.heading.exec(e);if(t){var i=t[2].trim();if(/#$/.test(i)){var n=_(i,"#");this.options.pedantic?i=n.trim():n&&!/ $/.test(n)||(i=n.trim())}return{type:"heading",raw:t[0],depth:t[1].length,text:i,tokens:this.lexer.inline(i)}}},i.hr=function(e){var t=this.rules.block.hr.exec(e);if(t)return{type:"hr",raw:t[0]}},i.blockquote=function(e){var t=this.rules.block.blockquote.exec(e);if(t){var i=t[0].replace(/^ *>[ \t]?/gm,""),n=this.lexer.state.top;this.lexer.state.top=!0;var o=this.lexer.blockTokens(i);return this.lexer.state.top=n,{type:"blockquote",raw:t[0],tokens:o,text:i}}},i.list=function(e){var t=this.rules.block.list.exec(e);if(t){var i,n,o,s,r,a,l,d,c,u,h,p,b=t[1].trim(),m=b.length>1,g={type:"list",raw:"",ordered:m,start:m?+b.slice(0,-1):"",loose:!1,items:[]};b=m?"\\d{1,9}\\"+b.slice(-1):"\\"+b,this.options.pedantic&&(b=m?b:"[*+-]");for(var v=new RegExp("^( {0,3}"+b+")((?:[\t ][^\\n]*)?(?:\\n|$))");e&&(p=!1,t=v.exec(e))&&!this.rules.block.hr.test(e);){if(i=t[0],e=e.substring(i.length),d=t[2].split("\n",1)[0].replace(/^\t+/,function(e){return" ".repeat(3*e.length)}),c=e.split("\n",1)[0],this.options.pedantic?(s=2,h=d.trimLeft()):(s=(s=t[2].search(/[^ ]/))>4?1:s,h=d.slice(s),s+=t[1].length),a=!1,!d&&/^ *$/.test(c)&&(i+=c+"\n",e=e.substring(c.length+1),p=!0),!p)for(var f=new RegExp("^ {0,"+Math.min(3,s-1)+"}(?:[*+-]|\\d{1,9}[.)])((?:[ \t][^\\n]*)?(?:\\n|$))"),w=new RegExp("^ {0,"+Math.min(3,s-1)+"}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)"),x=new RegExp("^ {0,"+Math.min(3,s-1)+"}(?:```|~~~)"),y=new RegExp("^ {0,"+Math.min(3,s-1)+"}#");e&&(c=u=e.split("\n",1)[0],this.options.pedantic&&(c=c.replace(/^ {1,4}(?=( {4})*[^ ])/g,"  ")),!x.test(c))&&!y.test(c)&&!f.test(c)&&!w.test(e);){if(c.search(/[^ ]/)>=s||!c.trim())h+="\n"+c.slice(s);else{if(a)break;if(d.search(/[^ ]/)>=4)break;if(x.test(d))break;if(y.test(d))break;if(w.test(d))break;h+="\n"+c}a||c.trim()||(a=!0),i+=u+"\n",e=e.substring(u.length+1),d=c.slice(s)}g.loose||(l?g.loose=!0:/\n *\n *$/.test(i)&&(l=!0)),this.options.gfm&&(n=/^\[[ xX]\] /.exec(h))&&(o="[ ] "!==n[0],h=h.replace(/^\[[ xX]\] +/,"")),g.items.push({type:"list_item",raw:i,task:!!n,checked:o,loose:!1,text:h}),g.raw+=i}g.items[g.items.length-1].raw=i.trimRight(),g.items[g.items.length-1].text=h.trimRight(),g.raw=g.raw.trimRight();var k=g.items.length;for(r=0;r<k;r++)if(this.lexer.state.top=!1,g.items[r].tokens=this.lexer.blockTokens(g.items[r].text,[]),!g.loose){var C=g.items[r].tokens.filter(function(e){return"space"===e.type}),E=C.length>0&&C.some(function(e){return/\n.*\n/.test(e.raw)});g.loose=E}if(g.loose)for(r=0;r<k;r++)g.items[r].loose=!0;return g}},i.html=function(e){var t=this.rules.block.html.exec(e);if(t){var i={type:"html",raw:t[0],pre:!this.options.sanitizer&&("pre"===t[1]||"script"===t[1]||"style"===t[1]),text:t[0]};if(this.options.sanitize){var n=this.options.sanitizer?this.options.sanitizer(t[0]):b(t[0]);i.type="paragraph",i.text=n,i.tokens=this.lexer.inline(n)}return i}},i.def=function(e){var t=this.rules.block.def.exec(e);if(t){var i=t[1].toLowerCase().replace(/\s+/g," "),n=t[2]?t[2].replace(/^<(.*)>$/,"$1").replace(this.rules.inline._escapes,"$1"):"",o=t[3]?t[3].substring(1,t[3].length-1).replace(this.rules.inline._escapes,"$1"):t[3];return{type:"def",tag:i,raw:t[0],href:n,title:o}}},i.table=function(e){var t=this.rules.block.table.exec(e);if(t){var i={type:"table",header:A(t[1]).map(function(e){return{text:e}}),align:t[2].replace(/^ *|\| *$/g,"").split(/ *\| */),rows:t[3]&&t[3].trim()?t[3].replace(/\n[ \t]*$/,"").split("\n"):[]};if(i.header.length===i.align.length){i.raw=t[0];var n,o,s,r,a=i.align.length;for(n=0;n<a;n++)/^ *-+: *$/.test(i.align[n])?i.align[n]="right":/^ *:-+: *$/.test(i.align[n])?i.align[n]="center":/^ *:-+ *$/.test(i.align[n])?i.align[n]="left":i.align[n]=null;for(a=i.rows.length,n=0;n<a;n++)i.rows[n]=A(i.rows[n],i.header.length).map(function(e){return{text:e}});for(a=i.header.length,o=0;o<a;o++)i.header[o].tokens=this.lexer.inline(i.header[o].text);for(a=i.rows.length,o=0;o<a;o++)for(r=i.rows[o],s=0;s<r.length;s++)r[s].tokens=this.lexer.inline(r[s].text);return i}}},i.lheading=function(e){var t=this.rules.block.lheading.exec(e);if(t)return{type:"heading",raw:t[0],depth:"="===t[2].charAt(0)?1:2,text:t[1],tokens:this.lexer.inline(t[1])}},i.paragraph=function(e){var t=this.rules.block.paragraph.exec(e);if(t){var i="\n"===t[1].charAt(t[1].length-1)?t[1].slice(0,-1):t[1];return{type:"paragraph",raw:t[0],text:i,tokens:this.lexer.inline(i)}}},i.text=function(e){var t=this.rules.block.text.exec(e);if(t)return{type:"text",raw:t[0],text:t[0],tokens:this.lexer.inline(t[0])}},i.escape=function(e){var t=this.rules.inline.escape.exec(e);if(t)return{type:"escape",raw:t[0],text:b(t[1])}},i.tag=function(e){var t=this.rules.inline.tag.exec(e);if(t)return!this.lexer.state.inLink&&/^<a /i.test(t[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&/^<\/a>/i.test(t[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&/^<(pre|code|kbd|script)(\s|>)/i.test(t[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(t[0])&&(this.lexer.state.inRawBlock=!1),{type:this.options.sanitize?"text":"html",raw:t[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,text:this.options.sanitize?this.options.sanitizer?this.options.sanitizer(t[0]):b(t[0]):t[0]}},i.link=function(e){var t=this.rules.inline.link.exec(e);if(t){var i=t[2].trim();if(!this.options.pedantic&&/^</.test(i)){if(!/>$/.test(i))return;var n=_(i.slice(0,-1),"\\");if((i.length-n.length)%2==0)return}else{var o=function(e,t){if(-1===e.indexOf(t[1]))return-1;for(var i=e.length,n=0,o=0;o<i;o++)if("\\"===e[o])o++;else if(e[o]===t[0])n++;else if(e[o]===t[1]&&--n<0)return o;return-1}(t[2],"()");if(o>-1){var s=(0===t[0].indexOf("!")?5:4)+t[1].length+o;t[2]=t[2].substring(0,o),t[0]=t[0].substring(0,s).trim(),t[3]=""}}var r=t[2],a="";if(this.options.pedantic){var l=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(r);l&&(r=l[1],a=l[3])}else a=t[3]?t[3].slice(1,-1):"";return r=r.trim(),/^</.test(r)&&(r=this.options.pedantic&&!/>$/.test(i)?r.slice(1):r.slice(1,-1)),B(t,{href:r?r.replace(this.rules.inline._escapes,"$1"):r,title:a?a.replace(this.rules.inline._escapes,"$1"):a},t[0],this.lexer)}},i.reflink=function(e,t){var i;if((i=this.rules.inline.reflink.exec(e))||(i=this.rules.inline.nolink.exec(e))){var n=(i[2]||i[1]).replace(/\s+/g," ");if(!(n=t[n.toLowerCase()])){var o=i[0].charAt(0);return{type:"text",raw:o,text:o}}return B(i,n,i[0],this.lexer)}},i.emStrong=function(e,t,i){void 0===i&&(i="");var n=this.rules.inline.emStrong.lDelim.exec(e);if(n&&(!n[3]||!i.match(/(?:[0-9A-Za-z\xAA\xB2\xB3\xB5\xB9\xBA\xBC-\xBE\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u0660-\u0669\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0966-\u096F\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09F9\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AE6-\u0AEF\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B6F\u0B71-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0BE6-\u0BF2\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C66-\u0C6F\u0C78-\u0C7E\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D58-\u0D61\u0D66-\u0D78\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DE6-\u0DEF\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F20-\u0F33\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F-\u1049\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u1090-\u1099\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1369-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A20-\u1A54\u1A80-\u1A89\u1A90-\u1A99\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B50-\u1B59\u1B83-\u1BA0\u1BAE-\u1BE5\u1C00-\u1C23\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2070\u2071\u2074-\u2079\u207F-\u2089\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2CFD\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3192-\u3195\u31A0-\u31BF\u31F0-\u31FF\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA830-\uA835\uA840-\uA873\uA882-\uA8B3\uA8D0-\uA8D9\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA900-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF-\uA9D9\uA9E0-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA50-\uAA59\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD07-\uDD33\uDD40-\uDD78\uDD8A\uDD8B\uDE80-\uDE9C\uDEA0-\uDED0\uDEE1-\uDEFB\uDF00-\uDF23\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDD70-\uDD7A\uDD7C-\uDD8A\uDD8C-\uDD92\uDD94\uDD95\uDD97-\uDDA1\uDDA3-\uDDB1\uDDB3-\uDDB9\uDDBB\uDDBC\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67\uDF80-\uDF85\uDF87-\uDFB0\uDFB2-\uDFBA]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC58-\uDC76\uDC79-\uDC9E\uDCA7-\uDCAF\uDCE0-\uDCF2\uDCF4\uDCF5\uDCFB-\uDD1B\uDD20-\uDD39\uDD80-\uDDB7\uDDBC-\uDDCF\uDDD2-\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE40-\uDE48\uDE60-\uDE7E\uDE80-\uDE9F\uDEC0-\uDEC7\uDEC9-\uDEE4\uDEEB-\uDEEF\uDF00-\uDF35\uDF40-\uDF55\uDF58-\uDF72\uDF78-\uDF91\uDFA9-\uDFAF]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDCFA-\uDD23\uDD30-\uDD39\uDE60-\uDE7E\uDE80-\uDEA9\uDEB0\uDEB1\uDF00-\uDF27\uDF30-\uDF45\uDF51-\uDF54\uDF70-\uDF81\uDFB0-\uDFCB\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC52-\uDC6F\uDC71\uDC72\uDC75\uDC83-\uDCAF\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD03-\uDD26\uDD36-\uDD3F\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDD0-\uDDDA\uDDDC\uDDE1-\uDDF4\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDEF0-\uDEF9\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC50-\uDC59\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE50-\uDE59\uDE80-\uDEAA\uDEB8\uDEC0-\uDEC9\uDF00-\uDF1A\uDF30-\uDF3B\uDF40-\uDF46]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCF2\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDD50-\uDD59\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEB0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC50-\uDC6C\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD50-\uDD59\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDDA0-\uDDA9\uDEE0-\uDEF2\uDFB0\uDFC0-\uDFD4]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|\uD80B[\uDF90-\uDFF0]|[\uD80C\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDE70-\uDEBE\uDEC0-\uDEC9\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF50-\uDF59\uDF5B-\uDF61\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDE40-\uDE96\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDD00-\uDD08]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD50-\uDD52\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD834[\uDEE0-\uDEF3\uDF60-\uDF78]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD837[\uDF00-\uDF1E]|\uD838[\uDD00-\uDD2C\uDD37-\uDD3D\uDD40-\uDD49\uDD4E\uDE90-\uDEAD\uDEC0-\uDEEB\uDEF0-\uDEF9]|\uD839[\uDFE0-\uDFE6\uDFE8-\uDFEB\uDFED\uDFEE\uDFF0-\uDFFE]|\uD83A[\uDC00-\uDCC4\uDCC7-\uDCCF\uDD00-\uDD43\uDD4B\uDD50-\uDD59]|\uD83B[\uDC71-\uDCAB\uDCAD-\uDCAF\uDCB1-\uDCB4\uDD01-\uDD2D\uDD2F-\uDD3D\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD83C[\uDD00-\uDD0C]|\uD83E[\uDFF0-\uDFF9]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF38\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A])/))){var o=n[1]||n[2]||"";if(!o||o&&(""===i||this.rules.inline.punctuation.exec(i))){var s,r,a=n[0].length-1,l=a,d=0,c="*"===n[0][0]?this.rules.inline.emStrong.rDelimAst:this.rules.inline.emStrong.rDelimUnd;for(c.lastIndex=0,t=t.slice(-1*e.length+a);null!=(n=c.exec(t));)if(s=n[1]||n[2]||n[3]||n[4]||n[5]||n[6])if(r=s.length,n[3]||n[4])l+=r;else if(!((n[5]||n[6])&&a%3)||(a+r)%3){if(!((l-=r)>0)){r=Math.min(r,r+l+d);var u=e.slice(0,a+n.index+(n[0].length-s.length)+r);if(Math.min(a,r)%2){var h=u.slice(1,-1);return{type:"em",raw:u,text:h,tokens:this.lexer.inlineTokens(h)}}var p=u.slice(2,-2);return{type:"strong",raw:u,text:p,tokens:this.lexer.inlineTokens(p)}}}else d+=r}}},i.codespan=function(e){var t=this.rules.inline.code.exec(e);if(t){var i=t[2].replace(/\n/g," "),n=/[^ ]/.test(i),o=/^ /.test(i)&&/ $/.test(i);return n&&o&&(i=i.substring(1,i.length-1)),i=b(i,!0),{type:"codespan",raw:t[0],text:i}}},i.br=function(e){var t=this.rules.inline.br.exec(e);if(t)return{type:"br",raw:t[0]}},i.del=function(e){var t=this.rules.inline.del.exec(e);if(t)return{type:"del",raw:t[0],text:t[2],tokens:this.lexer.inlineTokens(t[2])}},i.autolink=function(e,t){var i,n,o=this.rules.inline.autolink.exec(e);if(o)return n="@"===o[2]?"mailto:"+(i=b(this.options.mangle?t(o[1]):o[1])):i=b(o[1]),{type:"link",raw:o[0],text:i,href:n,tokens:[{type:"text",raw:i,text:i}]}},i.url=function(e,t){var i;if(i=this.rules.inline.url.exec(e)){var n,o;if("@"===i[2])o="mailto:"+(n=b(this.options.mangle?t(i[0]):i[0]));else{var s;do{s=i[0],i[0]=this.rules.inline._backpedal.exec(i[0])[0]}while(s!==i[0]);n=b(i[0]),o="www."===i[1]?"http://"+i[0]:i[0]}return{type:"link",raw:i[0],text:n,href:o,tokens:[{type:"text",raw:n,text:n}]}}},i.inlineText=function(e,t){var i,n=this.rules.inline.text.exec(e);if(n)return i=this.lexer.state.inRawBlock?this.options.sanitize?this.options.sanitizer?this.options.sanitizer(n[0]):b(n[0]):n[0]:b(this.options.smartypants?t(n[0]):n[0]),{type:"text",raw:n[0],text:i}},e}(),L={newline:/^(?: *(?:\n|$))+/,code:/^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,fences:/^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/,hr:/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/,html:"^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$))",def:/^ {0,3}\[(label)\]: *(?:\n *)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n *)?| *\n *)(title))? *(?:\n+|$)/,table:S,lheading:/^((?:.|\n(?!\n))+?)\n {0,3}(=+|-+) *(?:\n+|$)/,_paragraph:/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,text:/^[^\n]+/,_label:/(?!\s*\])(?:\\.|[^\[\]\\])+/,_title:/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/};L.def=f(L.def).replace("label",L._label).replace("title",L._title).getRegex(),L.bullet=/(?:[*+-]|\d{1,9}[.)])/,L.listItemStart=f(/^( *)(bull) */).replace("bull",L.bullet).getRegex(),L.list=f(L.list).replace(/bull/g,L.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+L.def.source+")").getRegex(),L._tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",L._comment=/<!--(?!-?>)[\s\S]*?(?:-->|$)/,L.html=f(L.html,"i").replace("comment",L._comment).replace("tag",L._tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),L.paragraph=f(L._paragraph).replace("hr",L.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",L._tag).getRegex(),L.blockquote=f(L.blockquote).replace("paragraph",L.paragraph).getRegex(),L.normal=n({},L),L.gfm=n({},L.normal,{table:"^ *([^\\n ].*\\|.*)\\n {0,3}(?:\\| *)?(:?-+:? *(?:\\| *:?-+:? *)*)(?:\\| *)?(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)"}),L.gfm.table=f(L.gfm.table).replace("hr",L.hr).replace("heading"," {0,3}#{1,6} ").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",L._tag).getRegex(),L.gfm.paragraph=f(L._paragraph).replace("hr",L.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("table",L.gfm.table).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",L._tag).getRegex(),L.pedantic=n({},L.normal,{html:f("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",L._comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:S,lheading:/^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/,paragraph:f(L.normal._paragraph).replace("hr",L.hr).replace("heading"," *#{1,6} *[^\n]").replace("lheading",L.lheading).replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").getRegex()});var T={escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:S,tag:"^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>",link:/^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,reflink:/^!?\[(label)\]\[(ref)\]/,nolink:/^!?\[(ref)\](?:\[\])?/,reflinkSearch:"reflink|nolink(?!\\()",emStrong:{lDelim:/^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,rDelimAst:/^(?:[^_*\\]|\\.)*?\_\_(?:[^_*\\]|\\.)*?\*(?:[^_*\\]|\\.)*?(?=\_\_)|(?:[^*\\]|\\.)+(?=[^*])|[punct_](\*+)(?=[\s]|$)|(?:[^punct*_\s\\]|\\.)(\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|(?:[^punct*_\s\\]|\\.)(\*+)(?=[^punct*_\s])/,rDelimUnd:/^(?:[^_*\\]|\\.)*?\*\*(?:[^_*\\]|\\.)*?\_(?:[^_*\\]|\\.)*?(?=\*\*)|(?:[^_\\]|\\.)+(?=[^_])|[punct*](\_+)(?=[\s]|$)|(?:[^punct*_\s\\]|\\.)(\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/},code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,br:/^( {2,}|\\)\n(?!\s*$)/,del:S,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,punctuation:/^([\spunctuation])/};function O(e){return e.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…")}function M(e){var t,i,n="",o=e.length;for(t=0;t<o;t++)i=e.charCodeAt(t),Math.random()>.5&&(i="x"+i.toString(16)),n+="&#"+i+";";return n}T._punctuation="!\"#$%&'()+\\-.,/:;<=>?@\\[\\]`^{|}~",T.punctuation=f(T.punctuation).replace(/punctuation/g,T._punctuation).getRegex(),T.blockSkip=/\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g,T.escapedEmSt=/(?:^|[^\\])(?:\\\\)*\\[*_]/g,T._comment=f(L._comment).replace("(?:--\x3e|$)","--\x3e").getRegex(),T.emStrong.lDelim=f(T.emStrong.lDelim).replace(/punct/g,T._punctuation).getRegex(),T.emStrong.rDelimAst=f(T.emStrong.rDelimAst,"g").replace(/punct/g,T._punctuation).getRegex(),T.emStrong.rDelimUnd=f(T.emStrong.rDelimUnd,"g").replace(/punct/g,T._punctuation).getRegex(),T._escapes=/\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g,T._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,T._email=/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,T.autolink=f(T.autolink).replace("scheme",T._scheme).replace("email",T._email).getRegex(),T._attribute=/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/,T.tag=f(T.tag).replace("comment",T._comment).replace("attribute",T._attribute).getRegex(),T._label=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,T._href=/<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/,T._title=/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/,T.link=f(T.link).replace("label",T._label).replace("href",T._href).replace("title",T._title).getRegex(),T.reflink=f(T.reflink).replace("label",T._label).replace("ref",L._label).getRegex(),T.nolink=f(T.nolink).replace("ref",L._label).getRegex(),T.reflinkSearch=f(T.reflinkSearch,"g").replace("reflink",T.reflink).replace("nolink",T.nolink).getRegex(),T.normal=n({},T),T.pedantic=n({},T.normal,{strong:{start:/^__|\*\*/,middle:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,endAst:/\*\*(?!\*)/g,endUnd:/__(?!_)/g},em:{start:/^_|\*/,middle:/^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,endAst:/\*(?!\*)/g,endUnd:/_(?!_)/g},link:f(/^!?\[(label)\]\((.*?)\)/).replace("label",T._label).getRegex(),reflink:f(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",T._label).getRegex()}),T.gfm=n({},T.normal,{escape:f(T.escape).replace("])","~|])").getRegex(),_extended_email:/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,url:/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,_backpedal:/(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/}),T.gfm.url=f(T.gfm.url,"i").replace("email",T.gfm._extended_email).getRegex(),T.breaks=n({},T.gfm,{br:f(T.br).replace("{2,}","*").getRegex(),text:f(T.gfm.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()});var N=function(){function e(e){this.tokens=[],this.tokens.links=Object.create(null),this.options=e||t.defaults,this.options.tokenizer=this.options.tokenizer||new F,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};var i={block:L.normal,inline:T.normal};this.options.pedantic?(i.block=L.pedantic,i.inline=T.pedantic):this.options.gfm&&(i.block=L.gfm,this.options.breaks?i.inline=T.breaks:i.inline=T.gfm),this.tokenizer.rules=i}e.lex=function(t,i){return new e(i).lex(t)},e.lexInline=function(t,i){return new e(i).inlineTokens(t)};var n,o,s=e.prototype;return s.lex=function(e){var t;for(e=e.replace(/\r\n|\r/g,"\n"),this.blockTokens(e,this.tokens);t=this.inlineQueue.shift();)this.inlineTokens(t.src,t.tokens);return this.tokens},s.blockTokens=function(e,t){var i,n,o,s,r=this;for(void 0===t&&(t=[]),e=this.options.pedantic?e.replace(/\t/g,"    ").replace(/^ +$/gm,""):e.replace(/^( *)(\t+)/gm,function(e,t,i){return t+"    ".repeat(i.length)});e;)if(!(this.options.extensions&&this.options.extensions.block&&this.options.extensions.block.some(function(n){return!!(i=n.call({lexer:r},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)})))if(i=this.tokenizer.space(e))e=e.substring(i.raw.length),1===i.raw.length&&t.length>0?t[t.length-1].raw+="\n":t.push(i);else if(i=this.tokenizer.code(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?t.push(i):(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.fences(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.heading(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.hr(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.blockquote(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.list(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.html(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.def(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?this.tokens.links[i.tag]||(this.tokens.links[i.tag]={href:i.href,title:i.title}):(n.raw+="\n"+i.raw,n.text+="\n"+i.raw,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.table(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.lheading(e))e=e.substring(i.raw.length),t.push(i);else if(o=e,this.options.extensions&&this.options.extensions.startBlock&&function(){var t=1/0,i=e.slice(1),n=void 0;r.options.extensions.startBlock.forEach(function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))}),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),this.state.top&&(i=this.tokenizer.paragraph(o)))n=t[t.length-1],s&&"paragraph"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i),s=o.length!==e.length,e=e.substring(i.raw.length);else if(i=this.tokenizer.text(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i);else if(e){var a="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(a);break}throw new Error(a)}return this.state.top=!0,t},s.inline=function(e,t){return void 0===t&&(t=[]),this.inlineQueue.push({src:e,tokens:t}),t},s.inlineTokens=function(e,t){var i,n,o,s=this;void 0===t&&(t=[]);var r,a,l,d=e;if(this.tokens.links){var c=Object.keys(this.tokens.links);if(c.length>0)for(;null!=(r=this.tokenizer.rules.inline.reflinkSearch.exec(d));)c.includes(r[0].slice(r[0].lastIndexOf("[")+1,-1))&&(d=d.slice(0,r.index)+"["+I("a",r[0].length-2)+"]"+d.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(r=this.tokenizer.rules.inline.blockSkip.exec(d));)d=d.slice(0,r.index)+"["+I("a",r[0].length-2)+"]"+d.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);for(;null!=(r=this.tokenizer.rules.inline.escapedEmSt.exec(d));)d=d.slice(0,r.index+r[0].length-2)+"++"+d.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex),this.tokenizer.rules.inline.escapedEmSt.lastIndex--;for(;e;)if(a||(l=""),a=!1,!(this.options.extensions&&this.options.extensions.inline&&this.options.extensions.inline.some(function(n){return!!(i=n.call({lexer:s},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)})))if(i=this.tokenizer.escape(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.tag(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.link(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.reflink(e,this.tokens.links))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.emStrong(e,d,l))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.codespan(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.br(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.del(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.autolink(e,M))e=e.substring(i.raw.length),t.push(i);else if(this.state.inLink||!(i=this.tokenizer.url(e,M))){if(o=e,this.options.extensions&&this.options.extensions.startInline&&function(){var t=1/0,i=e.slice(1),n=void 0;s.options.extensions.startInline.forEach(function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))}),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),i=this.tokenizer.inlineText(o,O))e=e.substring(i.raw.length),"_"!==i.raw.slice(-1)&&(l=i.raw.slice(-1)),a=!0,(n=t[t.length-1])&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(e){var u="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(u);break}throw new Error(u)}}else e=e.substring(i.raw.length),t.push(i);return t},n=e,o=[{key:"rules",get:function(){return{block:L,inline:T}}}],null&&i(n.prototype,null),o&&i(n,o),Object.defineProperty(n,"prototype",{writable:!1}),e}(),$=function(){function e(e){this.options=e||t.defaults}var i=e.prototype;return i.code=function(e,t,i){var n=(t||"").match(/\S*/)[0];if(this.options.highlight){var o=this.options.highlight(e,n);null!=o&&o!==e&&(i=!0,e=o)}return e=e.replace(/\n$/,"")+"\n",n?'<pre><code class="'+this.options.langPrefix+b(n)+'">'+(i?e:b(e,!0))+"</code></pre>\n":"<pre><code>"+(i?e:b(e,!0))+"</code></pre>\n"},i.blockquote=function(e){return"<blockquote>\n"+e+"</blockquote>\n"},i.html=function(e){return e},i.heading=function(e,t,i,n){return this.options.headerIds?"<h"+t+' id="'+(this.options.headerPrefix+n.slug(i))+'">'+e+"</h"+t+">\n":"<h"+t+">"+e+"</h"+t+">\n"},i.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},i.list=function(e,t,i){var n=t?"ol":"ul";return"<"+n+(t&&1!==i?' start="'+i+'"':"")+">\n"+e+"</"+n+">\n"},i.listitem=function(e){return"<li>"+e+"</li>\n"},i.checkbox=function(e){return"<input "+(e?'checked="" ':"")+'disabled="" type="checkbox"'+(this.options.xhtml?" /":"")+"> "},i.paragraph=function(e){return"<p>"+e+"</p>\n"},i.table=function(e,t){return t&&(t="<tbody>"+t+"</tbody>"),"<table>\n<thead>\n"+e+"</thead>\n"+t+"</table>\n"},i.tablerow=function(e){return"<tr>\n"+e+"</tr>\n"},i.tablecell=function(e,t){var i=t.header?"th":"td";return(t.align?"<"+i+' align="'+t.align+'">':"<"+i+">")+e+"</"+i+">\n"},i.strong=function(e){return"<strong>"+e+"</strong>"},i.em=function(e){return"<em>"+e+"</em>"},i.codespan=function(e){return"<code>"+e+"</code>"},i.br=function(){return this.options.xhtml?"<br/>":"<br>"},i.del=function(e){return"<del>"+e+"</del>"},i.link=function(e,t,i){if(null===(e=y(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<a href="'+e+'"';return t&&(n+=' title="'+t+'"'),n+">"+i+"</a>"},i.image=function(e,t,i){if(null===(e=y(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<img src="'+e+'" alt="'+i+'"';return t&&(n+=' title="'+t+'"'),n+(this.options.xhtml?"/>":">")},i.text=function(e){return e},e}(),P=function(){function e(){}var t=e.prototype;return t.strong=function(e){return e},t.em=function(e){return e},t.codespan=function(e){return e},t.del=function(e){return e},t.html=function(e){return e},t.text=function(e){return e},t.link=function(e,t,i){return""+i},t.image=function(e,t,i){return""+i},t.br=function(){return""},e}(),R=function(){function e(){this.seen={}}var t=e.prototype;return t.serialize=function(e){return e.toLowerCase().trim().replace(/<[!\/a-z].*?>/gi,"").replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g,"").replace(/\s/g,"-")},t.getNextSafeSlug=function(e,t){var i=e,n=0;if(this.seen.hasOwnProperty(i)){n=this.seen[e];do{i=e+"-"+ ++n}while(this.seen.hasOwnProperty(i))}return t||(this.seen[e]=n,this.seen[i]=0),i},t.slug=function(e,t){void 0===t&&(t={});var i=this.serialize(e);return this.getNextSafeSlug(i,t.dryrun)},e}(),z=function(){function e(e){this.options=e||t.defaults,this.options.renderer=this.options.renderer||new $,this.renderer=this.options.renderer,this.renderer.options=this.options,this.textRenderer=new P,this.slugger=new R}e.parse=function(t,i){return new e(i).parse(t)},e.parseInline=function(t,i){return new e(i).parseInline(t)};var i=e.prototype;return i.parse=function(e,t){void 0===t&&(t=!0);var i,n,o,s,r,a,l,d,c,u,h,p,b,m,v,f,w,x,y,k="",C=e.length;for(i=0;i<C;i++)if(u=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[u.type])||!1===(y=this.options.extensions.renderers[u.type].call({parser:this},u))&&["space","hr","heading","code","table","blockquote","list","html","paragraph","text"].includes(u.type))switch(u.type){case"space":continue;case"hr":k+=this.renderer.hr();continue;case"heading":k+=this.renderer.heading(this.parseInline(u.tokens),u.depth,g(this.parseInline(u.tokens,this.textRenderer)),this.slugger);continue;case"code":k+=this.renderer.code(u.text,u.lang,u.escaped);continue;case"table":for(d="",l="",s=u.header.length,n=0;n<s;n++)l+=this.renderer.tablecell(this.parseInline(u.header[n].tokens),{header:!0,align:u.align[n]});for(d+=this.renderer.tablerow(l),c="",s=u.rows.length,n=0;n<s;n++){for(l="",r=(a=u.rows[n]).length,o=0;o<r;o++)l+=this.renderer.tablecell(this.parseInline(a[o].tokens),{header:!1,align:u.align[o]});c+=this.renderer.tablerow(l)}k+=this.renderer.table(d,c);continue;case"blockquote":c=this.parse(u.tokens),k+=this.renderer.blockquote(c);continue;case"list":for(h=u.ordered,p=u.start,b=u.loose,s=u.items.length,c="",n=0;n<s;n++)f=(v=u.items[n]).checked,w=v.task,m="",v.task&&(x=this.renderer.checkbox(f),b?v.tokens.length>0&&"paragraph"===v.tokens[0].type?(v.tokens[0].text=x+" "+v.tokens[0].text,v.tokens[0].tokens&&v.tokens[0].tokens.length>0&&"text"===v.tokens[0].tokens[0].type&&(v.tokens[0].tokens[0].text=x+" "+v.tokens[0].tokens[0].text)):v.tokens.unshift({type:"text",text:x}):m+=x),m+=this.parse(v.tokens,b),c+=this.renderer.listitem(m,w,f);k+=this.renderer.list(c,h,p);continue;case"html":k+=this.renderer.html(u.text);continue;case"paragraph":k+=this.renderer.paragraph(this.parseInline(u.tokens));continue;case"text":for(c=u.tokens?this.parseInline(u.tokens):u.text;i+1<C&&"text"===e[i+1].type;)c+="\n"+((u=e[++i]).tokens?this.parseInline(u.tokens):u.text);k+=t?this.renderer.paragraph(c):c;continue;default:var E='Token with "'+u.type+'" type was not found.';if(this.options.silent)return void console.error(E);throw new Error(E)}else k+=y||"";return k},i.parseInline=function(e,t){t=t||this.renderer;var i,n,o,s="",r=e.length;for(i=0;i<r;i++)if(n=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[n.type])||!1===(o=this.options.extensions.renderers[n.type].call({parser:this},n))&&["escape","html","link","image","strong","em","codespan","br","del","text"].includes(n.type))switch(n.type){case"escape":case"text":s+=t.text(n.text);break;case"html":s+=t.html(n.text);break;case"link":s+=t.link(n.href,n.title,this.parseInline(n.tokens,t));break;case"image":s+=t.image(n.href,n.title,n.text);break;case"strong":s+=t.strong(this.parseInline(n.tokens,t));break;case"em":s+=t.em(this.parseInline(n.tokens,t));break;case"codespan":s+=t.codespan(n.text);break;case"br":s+=t.br();break;case"del":s+=t.del(this.parseInline(n.tokens,t));break;default:var a='Token with "'+n.type+'" type was not found.';if(this.options.silent)return void console.error(a);throw new Error(a)}else s+=o||"";return s},e}(),H=function(){function e(e){this.options=e||t.defaults}var i=e.prototype;return i.preprocess=function(e){return e},i.postprocess=function(e){return e},e}();function W(e,t){return function(i,o,s){"function"==typeof o&&(s=o,o=null);var r=n({},o),a=function(e,t,i){return function(n){if(n.message+="\nPlease report this to https://github.com/markedjs/marked.",e){var o="<p>An error occurred:</p><pre>"+b(n.message+"",!0)+"</pre>";return t?Promise.resolve(o):i?void i(null,o):o}if(t)return Promise.reject(n);if(!i)throw n;i(n)}}((o=n({},V.defaults,r)).silent,o.async,s);if(null==i)return a(new Error("marked(): input parameter is undefined or null"));if("string"!=typeof i)return a(new Error("marked(): input parameter is of type "+Object.prototype.toString.call(i)+", string expected"));if(function(e){e&&e.sanitize&&!e.silent&&console.warn("marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options")}(o),o.hooks&&(o.hooks.options=o),s){var l,d=o.highlight;try{o.hooks&&(i=o.hooks.preprocess(i)),l=e(i,o)}catch(e){return a(e)}var c=function(e){var i;if(!e)try{o.walkTokens&&V.walkTokens(l,o.walkTokens),i=t(l,o),o.hooks&&(i=o.hooks.postprocess(i))}catch(t){e=t}return o.highlight=d,e?a(e):s(null,i)};if(!d||d.length<3)return c();if(delete o.highlight,!l.length)return c();var u=0;return V.walkTokens(l,function(e){"code"===e.type&&(u++,setTimeout(function(){d(e.text,e.lang,function(t,i){if(t)return c(t);null!=i&&i!==e.text&&(e.text=i,e.escaped=!0),0===--u&&c()})},0))}),void(0===u&&c())}if(o.async)return Promise.resolve(o.hooks?o.hooks.preprocess(i):i).then(function(t){return e(t,o)}).then(function(e){return o.walkTokens?Promise.all(V.walkTokens(e,o.walkTokens)).then(function(){return e}):e}).then(function(e){return t(e,o)}).then(function(e){return o.hooks?o.hooks.postprocess(e):e}).catch(a);try{o.hooks&&(i=o.hooks.preprocess(i));var h=e(i,o);o.walkTokens&&V.walkTokens(h,o.walkTokens);var p=t(h,o);return o.hooks&&(p=o.hooks.postprocess(p)),p}catch(e){return a(e)}}}function V(e,t,i){return W(N.lex,z.parse)(e,t,i)}H.passThroughHooks=new Set(["preprocess","postprocess"]),V.options=V.setOptions=function(e){var i;return V.defaults=n({},V.defaults,e),i=V.defaults,t.defaults=i,V},V.getDefaults=a,V.defaults=t.defaults,V.use=function(){for(var e=V.defaults.extensions||{renderers:{},childTokens:{}},t=arguments.length,i=new Array(t),o=0;o<t;o++)i[o]=arguments[o];i.forEach(function(t){var i=n({},t);if(i.async=V.defaults.async||i.async||!1,t.extensions&&(t.extensions.forEach(function(t){if(!t.name)throw new Error("extension name required");if(t.renderer){var i=e.renderers[t.name];e.renderers[t.name]=i?function(){for(var e=arguments.length,n=new Array(e),o=0;o<e;o++)n[o]=arguments[o];var s=t.renderer.apply(this,n);return!1===s&&(s=i.apply(this,n)),s}:t.renderer}if(t.tokenizer){if(!t.level||"block"!==t.level&&"inline"!==t.level)throw new Error("extension level must be 'block' or 'inline'");e[t.level]?e[t.level].unshift(t.tokenizer):e[t.level]=[t.tokenizer],t.start&&("block"===t.level?e.startBlock?e.startBlock.push(t.start):e.startBlock=[t.start]:"inline"===t.level&&(e.startInline?e.startInline.push(t.start):e.startInline=[t.start]))}t.childTokens&&(e.childTokens[t.name]=t.childTokens)}),i.extensions=e),t.renderer&&function(){var e=V.defaults.renderer||new $,n=function(i){var n=e[i];e[i]=function(){for(var o=arguments.length,s=new Array(o),r=0;r<o;r++)s[r]=arguments[r];var a=t.renderer[i].apply(e,s);return!1===a&&(a=n.apply(e,s)),a}};for(var o in t.renderer)n(o);i.renderer=e}(),t.tokenizer&&function(){var e=V.defaults.tokenizer||new F,n=function(i){var n=e[i];e[i]=function(){for(var o=arguments.length,s=new Array(o),r=0;r<o;r++)s[r]=arguments[r];var a=t.tokenizer[i].apply(e,s);return!1===a&&(a=n.apply(e,s)),a}};for(var o in t.tokenizer)n(o);i.tokenizer=e}(),t.hooks&&function(){var e=V.defaults.hooks||new H,n=function(i){var n=e[i];H.passThroughHooks.has(i)?e[i]=function(o){if(V.defaults.async)return Promise.resolve(t.hooks[i].call(e,o)).then(function(t){return n.call(e,t)});var s=t.hooks[i].call(e,o);return n.call(e,s)}:e[i]=function(){for(var o=arguments.length,s=new Array(o),r=0;r<o;r++)s[r]=arguments[r];var a=t.hooks[i].apply(e,s);return!1===a&&(a=n.apply(e,s)),a}};for(var o in t.hooks)n(o);i.hooks=e}(),t.walkTokens){var o=V.defaults.walkTokens;i.walkTokens=function(e){var i=[];return i.push(t.walkTokens.call(this,e)),o&&(i=i.concat(o.call(this,e))),i}}V.setOptions(i)})},V.walkTokens=function(e,t){for(var i,n=[],o=function(){var e=i.value;switch(n=n.concat(t.call(V,e)),e.type){case"table":for(var o,r=s(e.header);!(o=r()).done;){var a=o.value;n=n.concat(V.walkTokens(a.tokens,t))}for(var l,d=s(e.rows);!(l=d()).done;)for(var c,u=s(l.value);!(c=u()).done;){var h=c.value;n=n.concat(V.walkTokens(h.tokens,t))}break;case"list":n=n.concat(V.walkTokens(e.items,t));break;default:V.defaults.extensions&&V.defaults.extensions.childTokens&&V.defaults.extensions.childTokens[e.type]?V.defaults.extensions.childTokens[e.type].forEach(function(i){n=n.concat(V.walkTokens(e[i],t))}):e.tokens&&(n=n.concat(V.walkTokens(e.tokens,t)))}},r=s(e);!(i=r()).done;)o();return n},V.parseInline=W(N.lexInline,z.parseInline),V.Parser=z,V.parser=z.parse,V.Renderer=$,V.TextRenderer=P,V.Lexer=N,V.lexer=N.lex,V.Tokenizer=F,V.Slugger=R,V.Hooks=H,V.parse=V;var U=V.options,j=V.setOptions,G=V.use,q=V.walkTokens,X=V.parseInline,K=V,Y=z.parse,Z=N.lex;t.Hooks=H,t.Lexer=N,t.Parser=z,t.Renderer=$,t.Slugger=R,t.TextRenderer=P,t.Tokenizer=F,t.getDefaults=a,t.lexer=Z,t.marked=V,t.options=U,t.parse=K,t.parseInline=X,t.parser=Y,t.setOptions=j,t.use=G,t.walkTokens=q},6904(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.RadioGroup=t.DirectionType=void 0;const n=i(519),o=i(1854),s=i(9084),r=i(6199),a=i(5366),l=i(5354);var d;!function(e){e.ROW="row",e.COLUMN="column"}(d=t.DirectionType||(t.DirectionType={}));class c extends s.BaseComponent{constructor(e){var t,i;super(),this.uiPrefix=o.PREFIX,this.curCheckedValue="",this.valueArr=[],this.selected=0,this.clickGroupEmitter=new n.EventEmitter,this.onDidGroupChange=this.clickGroupEmitter.asSubscriber("onDidGroupChange"),this.eventStore=new Set,this.radioGroupStates=this.getOptions(e,this.getFilterAttributesOptions()),this.radioGroupWrapper=document.createElement("div"),this.radioArray=[],this.renderRadioItem(),this.addEvent(),this.radioGroupWrapper.style.flexDirection="row"===this.radioGroupStates.direction?d.ROW:d.COLUMN,this.radioGroupWrapper.style.rowGap=`${null!==(t=this.radioGroupStates.rowGap)&&void 0!==t?t:8}px`,this.radioGroupWrapper.style.columnGap=`${null!==(i=this.radioGroupStates.columnGap)&&void 0!==i?i:20}px`,this.radioGroupWrapper.setAttribute("name",this.radioGroupStates.name),this.radioGroupWrapper.classList.add(`${this.uiPrefix}-group`);const s=document.createElement("style");s.appendChild(document.createTextNode(u(l.ideChecker.isIDE))),this.shadow.appendChild(s),this.shadow.appendChild(this.radioGroupWrapper)}addEvent(){this.eventStore.add({element:this.radioGroupWrapper,type:"keydown",handler:e=>{const t=e;"ArrowLeft"!==t.code&&"ArrowUp"!==t.code||this.focusPrevious(e),"ArrowRight"!==t.code&&"ArrowDown"!==t.code||this.focusNext(e),"Space"===t.code&&this.spaceEvent(),"Tab"===t.code&&this.radioArray.forEach((e,t)=>{0!==t&&e.setAttribute("tabindex","-1")})}}),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}renderRadioItem(){this.radioGroupStates.optionsArray&&this.radioGroupStates.optionsArray.forEach(e=>{this.valueArr.push(e.value),(0,a.isValueRepeat)(this.valueArr),(0,a.isValueExist)(e.value),e.isGroup=!0,this.radioGroupStates.isWidgets?e.isWidgets=!0:e.isWidgets=!1;const t=new o.Radio(e);t.onChange(e=>{this.getFocusIndex(e),this.setRadioCheck(),this.curCheckedValue=e.value}),this.radioGroupStates.defaultValue===e.value&&(this.curCheckedValue=this.radioGroupStates.defaultValue,t.setChecked(!0)),this.radioArray.push(t),this.radioGroupWrapper.appendChild(t)})}getFocusIndex(e){Array.from(this.radioGroupWrapper.getElementsByTagName("ide-radio")).forEach((t,i)=>{var n,o;(null===(o=null===(n=t.shadowRoot)||void 0===n?void 0:n.lastElementChild)||void 0===o?void 0:o.getAttribute("value"))===e.value&&(this.selected=i)})}getOptions(e,t){const i=Object.assign(Object.assign({},t),e);return i.direction="row"===i.direction?d.ROW:d.COLUMN,i.name="string"==typeof i.name?i.name:"",i.defaultValue="string"==typeof i.defaultValue?i.defaultValue:"",i.isWidgets=!!i.isWidgets&&i.isWidgets,i}getFilterAttributesOptions(){return{name:(0,a.filterAttribute)(this.getAttribute("name")),direction:(0,a.filterAttribute)(this.getAttribute("direction")),defaultValue:(0,a.filterAttribute)(this.getAttribute("defaultValue")),isWidgets:(0,a.filterAttribute)(this.getAttribute("isWidgets"))}}setGroupItemChecked(e){var t;if(!e)return;const i=null===(t=this.radioGroupStates.optionsArray)||void 0===t?void 0:t.findIndex(t=>t.value===e);void 0!==i&&(this.radioArray[i].setChecked(!0),this.curCheckedValue=e,this.selected=i,this.setCheckedValue())}getItemByValue(e){for(let t=0;t<this.radioArray.length;t++)if(this.radioArray[t].value===e)return this.radioArray[t]}updateMnemonicIndex(e,t){var i,n;const o=this.getItemByValue(e),s=null===(n=null===(i=null==o?void 0:o.shadowRoot)||void 0===i?void 0:i.lastElementChild)||void 0===n?void 0:n.getElementsByClassName("ide-radio-label")[0],r=null==s?void 0:s.textContent,l=(0,a.createUnderlineStr)(null!=r?r:"",t);s&&(s.textContent="",s.appendChild(l))}setGroupDisable(e){e&&this.radioArray.forEach(e=>{e.setEnabled(!1)})}focusPrevious(e){var t,i;(this.selected||0===this.selected)&&this.selected>0&&(e.stopPropagation(),e.preventDefault(),"false"===(null===(i=null===(t=this.radioArray[this.selected-1].shadowRoot)||void 0===t?void 0:t.lastElementChild)||void 0===i?void 0:i.getAttribute("enabled"))?this.selected-=2:this.selected--,this.setRadioCheck())}focusNext(e){var t,i;if(!this.selected&&0!==this.selected)return;const n=this.radioArray.length;this.selected<n-1&&(e.stopPropagation(),e.preventDefault(),"false"===(null===(i=null===(t=this.radioArray[this.selected+1].shadowRoot)||void 0===t?void 0:t.lastElementChild)||void 0===i?void 0:i.getAttribute("enabled"))?this.selected+=2:this.selected++,this.setRadioCheck())}setRadioCheck(){var e;if(l.ideChecker.isIDE)return void this.setCheckedValue();const t=null===(e=this.radioArray[0].shadowRoot)||void 0===e?void 0:e.lastElementChild,i=t.getElementsByClassName("ide-radio")[0],n=t.getElementsByClassName("ide-radio-label")[0];i.style.border=this.selected?`1px solid ${r.borderColor}`:`1px solid ${r.primaryColor}`,0!==this.selected?(t.onmouseover=()=>{i.style.border=`1px solid ${r.primaryColor}`,this.radioGroupStates.isWidgets&&(t.style.border=`1px solid ${r.primaryColor}`,t.style.background=`${r.secondaryBackgroundColor}`,n.style.color=`${r.titleFontColor}`)},t.onmouseout=()=>{i.style.border=`1px solid ${r.borderColor}`,this.radioGroupStates.isWidgets&&(t.style.border=`1px solid ${r.borderColor}`,t.style.background=`${r.defaultTagBackground}`,n.style.color=`${r.primaryFontColor}`)}):(t.onmouseover=null,t.onmouseout=null),this.radioGroupStates.isWidgets&&(t.style.border=this.selected?`1px solid ${r.borderColor}`:`1px solid ${r.primaryColor}`,t.style.background=this.selected?`${r.defaultTagBackground}`:`${r.secondaryBackgroundColor}`,n.style.color=this.selected?`${r.primaryFontColor}`:`${r.titleFontColor}`),this.setCheckedValue()}spaceEvent(){this.selected||this.setCheckedValue()}setCheckedValue(){this.radioArray.forEach(e=>{e.resetChecked()}),this.radioArray[this.selected].setChecked(!0),this.clickGroupEmitter.emit("onDidGroupChange",this.radioArray[this.selected].options),this.curCheckedValue=this.radioArray[this.selected].options.value}set disabled(e){this.setGroupDisable(e)}get disabled(){return this.disabled}set checkedValue(e){this.setGroupItemChecked(e)}get checkedValue(){return this.curCheckedValue||""}dispose(){this.disconnectedCallback(),this.curCheckedValue="",this.valueArr=[],this.clickGroupEmitter.clear()}}t.RadioGroup=c;const u=e=>`\n.ide-radio-group {\n    display: flex;\n    flex-wrap: wrap;\n    justify-content: flex-start;\n    align-item: flex-start;\n    outline: none;\n}\n\n.ide-radio-group[style="flex-direction: column; gap: 8px 20px;"] ide-radio {\n    width: 100%;\n}\n\n${e?"":`.ide-radio-group ide-radio:nth-child(1):focus {\n        --user-radio-border: 1px solid ${r.primaryColor};\n        --user-radio-label-color: ${r.titleFontColor};\n        --user-widgets-radio-background: ${r.secondaryBackgroundColor};\n    }`}\n`;(0,s.defineCustomElement)(`${o.PREFIX}-group`,c)},7157(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.dropdownStyle=void 0;const n=i(6199);t.dropdownStyle=`\n.ide-dropdown {\n\theight: 100%;\n\tpadding: 0;\n}\n\n.ide-dropdown > .dropdown-label {\n\tcursor: pointer;\n\theight: 100%;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin: var(--user-view-action-item-codicon-margin);\n}\n\n.ide-dropdown > .dropdown-label > .action-label.show-with-label:not(.secondary-size) {\n\tpadding: 2px;\n}\n\n.ide-dropdown > .dropdown-label > .action-label.show-with-label > .label {\n\tdisplay: inline-flex;\n\tfont-size: ${n.fontSize.mainText};\n\tfont-family: ${n.fontFamily};\n\tpadding: 1px 3px 0 2px;\n\tvertical-align: top;\n\tcolor: var(--user-view-dropdown-show-with-label-color, ${n.titleFontColor});\n}\n\n.ide-dropdown > .dropdown-label > .action-label.disabled {\n\tcursor: not-allowed;\n}\n\n.ide-dropdown.active > .dropdown-label .action-label:not(.disabled){\n\tborder-radius: 5px;\n\tbackground-color: ${n.actionViewItemHover};\n}\n\n.ide-dropdown > .dropdown-label > .action-label:not(.disabled):hover {\n\tborder-radius: 5px;\n\tbackground-color: ${n.actionViewItemHover};\n}\n\n.ide-dropdown > .dropdown-label > .action-label:not(.secondary-size) {\n\tborder-radius: 5px;\n\tpadding: var(--user-view-action-item-action-label-padding, 3px);\n\tcolor: ${n.actionViewItemIconColor}\n}\n\n.ide-dropdown > .dropdown-label > .action-label:focus {\n\toutline: 1px solid ${n.primaryColorHover};\n\toutline-offset: -1px;\n}\n\n.ide-dropdown > .dropdown-label > .action-label.secondary-size {\n\tpadding: 3px 0;\n}\n\n.ide-dropdown-with-primary {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.ide-dropdown-with-primary > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.ide-dropdown-with-primary > .dropdown-action-container > .ide-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.ide-dropdown-with-primary > .dropdown-action-container > .ide-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n`},7366(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.HistoryInputBox=void 0;const n=i(519),o=i(1062),s=i(8614),r=i(9084),a="for history",l=` or ⇅ ${a}`,d=` (⇅ ${a})`;class c extends o.InputBox{constructor(e){super(e),this._onDidFocus=new n.EventEmitter,this.onDidFocus=this._onDidFocus.asSubscriber("onDidFocus"),this._onDidBlur=new n.EventEmitter,this.onDidBlur=this._onDidBlur.asSubscriber("onDidBlur"),this.history=new s.HistoryNavigator(e.history,100),this.observer=new MutationObserver(t=>{t.forEach(t=>{t.target.textContent||this.addSuffix(e)})}),this.observer.observe(this.input,{attributeFilter:["class"]}),this.input.addEventListener("focus",()=>this.addSuffix(e)),this.input.addEventListener("blur",()=>{this.resetPlaceholder(d,e)||this.resetPlaceholder(l,e)})}addSuffix(e){if(e.showHistoryHint&&e.showHistoryHint()&&!this.placeholder.endsWith(l)&&!this.placeholder.endsWith(d)&&this.history.getHistory().length){const t=this.placeholder.endsWith(")")?l:d,i=this.placeholder+t;e.showPlaceholderOnFocus&&document.activeElement!==this.input?this.placeholder=i:this.setPlaceHolder(i)}}resetPlaceholder(e,t){if(this.placeholder.endsWith(e)){const i=this.placeholder.slice(0,this.placeholder.length-e.length);return t.showPlaceholderOnFocus?this.placeholder=i:this.setPlaceHolder(i),!0}return!1}disconnectedCallback(){super.disconnectedCallback(),this.observer&&(this.observer.disconnect(),this.observer=void 0)}addToHistory(){this.value&&this.value!==this.getCurrentValue()&&this.history.add(this.value)}getHistory(){return this.history.getHistory()}showNextValue(){this.history.has(this.value)||this.addToHistory();let e=this.getNextValue();e&&(e=e===this.value?this.getNextValue():e),e&&(this.value=e)}showPreviousValue(){this.history.has(this.value)||this.addToHistory();let e=this.getPreviousValue();e&&(e=e===this.value?this.getPreviousValue():e),e&&(this.value=e)}clearHistory(){this.history.clear()}onBlur(){super.onBlur(),this._onDidBlur.emit("onDidBlur")}onFocus(){super.onFocus(),this._onDidFocus.emit("onDidFocus")}getCurrentValue(){let e=this.history.current();return e||(e=this.history.last(),this.history.next()),e}getPreviousValue(){return this.history.previous()||this.history.first()}getNextValue(){return this.history.next()||this.history.last()}}t.HistoryInputBox=c,(0,r.defineCustomElement)("ide-history-inputbox",c)},7509(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActionViewItem=void 0;const n=i(194),o=i(4295),s=i(5754),r=i(8784),a=i(9084);class l extends o.BaseActionViewItem{constructor(e,t,i={}){super(e,t,i),this.dispose=()=>{var e;for(super.dispose(),null===(e=this.customHover)||void 0===e||e.dispose();this.shadow.firstChild;)this.shadow.removeChild(this.shadow.firstChild)},this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.options.alwaysVisible=void 0!==i.alwaysVisible&&i.alwaysVisible,this.options.verticalMode=void 0!==i.verticalMode&&i.verticalMode,this.cssClass="",this.setVisiable(this.options.alwaysVisible)}render(e){var t;this.dispose();const i=document.createElement("div");if(super.render(i),this.element){if(this._style=document.createElement("style"),null===(t=this._style)||void 0===t||t.appendChild(document.createTextNode(n.ActionViewItemStyle)),this.shadow.appendChild(this._style),this.element&&(this.label=document.createElement("a"),this.label.classList.add("action-label"),this.element.append(this.label)),this.label&&(this._action.id===o.SEPARATOR_ID?(this.element.classList.add("separator"),this.label.setAttribute("role","presentation")):this.options.isMenu?this.label.setAttribute("role","menuitem"):this.label.setAttribute("role","button")),this.options.label&&this.options.keybinding&&this.element){const e=document.createElement("span");e.classList.add("keybinding"),e.textContent=this.options.keybinding,this.element.append(e)}this.options.verticalMode&&this.element&&this.element.classList.add("vertical"),this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked(),this.element.classList.add("action-element"),this.shadow.appendChild(this.element),null==e||e.append(this)}}focus(){this.label&&(this.label.tabIndex=0,this.label.focus())}isFocused(){var e;return!!this.label&&0===(null===(e=this.label)||void 0===e?void 0:e.tabIndex)}blur(){this.label&&(this.label.tabIndex=-1)}setFocusable(e){this.label&&(this.label.tabIndex=e?0:-1)}updateClass(){var e;if(this.cssClass&&this.label&&this.label.classList.remove(...this.cssClass.split(" "),"double-icon"),this.options.icon){if(this.cssClass=this.getAction().class,this.label&&(this.label.classList.add("codicon"),this.cssClass)){(0,s.addIconStylebyClass)(this.cssClass,this.shadow),this.cssClass.includes("always-visible")&&(this.options.alwaysVisible=!0,this.setVisiable(this.options.alwaysVisible));const e=this.cssClass.split("codicon-")[1];this.label.classList.add(...this.cssClass.split(" ")),(0,s.isDoubleIcon)(e)&&this.label.classList.add("double-icon")}this.updateEnabled()}else null===(e=this.label)||void 0===e||e.classList.remove("codicon")}updateLabel(){if(this.options.label&&this.label){const e=document.createElement("div");e.classList.add("action-name"),this.getAction().label&&(e.textContent=this.getAction().label,this.label.append(e))}}updateTooltip(){let e=null;this.getAction().tooltip?e=this.getAction().tooltip:!this.options.label&&this.getAction().label&&this.options.icon&&(e=this.getAction().label,this.options.keybinding&&(e=e+" ("+this.options.keybinding+")")),this._applyUpdateTooltip(e)}_applyUpdateTooltip(e){if(e&&this.label)if(this.label.title="",this.label.setAttribute("aria-label",e),this.customHover&&this.customHover.dispose(),this.options.getHoverOptions){const t=Object.assign({content:e,target:this.label},this.options.getHoverOptions());this.customHover=r.Hover.setupIconLabelHover(t)}else this.customHover=r.Hover.setupIconLabelHover({content:e,target:this.label,showPointer:!1,customViewId:"ide-context-view-action",upperLayer:!0})}updateEnabled(){var e,t;this.getAction().enabled?(this.label&&(this.label.removeAttribute("aria-disabled"),this.label.classList.remove("disabled")),null===(e=this.element)||void 0===e||e.classList.remove("disabled")):(this.label&&(this.label.setAttribute("aria-disabled","true"),this.label.classList.add("disabled")),null===(t=this.element)||void 0===t||t.classList.add("disabled"))}updateChecked(){this.label&&(this.getAction().checked?this.label.classList.add("checked"):this.label.classList.remove("checked"))}setVisiable(e){e?this.shadow.host.classList.add("always-visible"):this.shadow.host.classList.remove("always-visible")}}t.ActionViewItem=l,(0,a.defineCustomElement)("ide-action-view-item",l)},7594(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.Dialog=t.DialogType=void 0;const o=i(9084),s=i(5754),r=i(9090),a=i(79),l=i(3235),d=i(3446),c=i(4295),u=i(4835);var h;!function(e){e.NONE="none",e.INFO="info",e.QUESTION="question",e.SUCCESS="success",e.ERROR="error",e.WARNING="warning",e.PENDING="pending"}(h=t.DialogType||(t.DialogType={}));class p extends o.BaseComponent{constructor(e,t){super(),this.bodyDiv=document.createElement("div"),this.bodyDiv.classList.add("ide-dialog-body"),this._style=document.createElement("style"),this.shadow.appendChild(this._style),e&&this.bodyDiv.appendChild(e),t&&this.renderStyle(t),this.shadow.appendChild(this.bodyDiv)}renderStyle(e){e&&this._style.appendChild(document.createTextNode(e))}dispose(){this.bodyDiv.remove()}}class b extends o.BaseComponent{constructor(e){var t,i,n,o,s,r,a,l,d,c,u,h,p,b;super(),this.minWidthDefault=520,this.minHeightDefault=130,this.currentIsFullScreen=!1,this.nowWidth=0,this.nowHight=0,this.nowTop=0,this.nowLeft=0,this.eventStore=new Set,this.caption=null!==(t=this.getAttribute("caption"))&&void 0!==t?t:"",this.message=null!==(i=this.getAttribute("message"))&&void 0!==i?i:"",this.detail=null!==(n=this.getAttribute("detail"))&&void 0!==n?n:"",this.minWidth=null!==(o=Number(this.getAttribute("minWidth")))&&void 0!==o?o:this.minWidthDefault,this.minHeight=null!==(s=Number(this.getAttribute("minHeight")))&&void 0!==s?s:this.minHeightDefault,this.hideButtons=null!==(r=this.hasAttribute("hideButtons"))&&void 0!==r&&r,this.showCloseBtn=null!==(a=this.hasAttribute("showCloseBtn"))&&void 0!==a&&a,this.isDraggable=null!==(l=this.hasAttribute("isDraggable"))&&void 0!==l&&l,this.isScalable=null!==(d=this.hasAttribute("isScalable"))&&void 0!==d&&d,this.isFullScreen=null!==(c=this.hasAttribute("isFullScreen"))&&void 0!==c&&c,this.modal=null===(u=this.hasAttribute("modal"))||void 0===u||u,this.modalCloseable=null===(h=this.hasAttribute("modalCloseable"))||void 0===h||h,this.type=null!==(p=this.getAttribute("type"))&&void 0!==p?p:"none";const m=null!==(b=this.getAttribute("icon"))&&void 0!==b?b:"";this.icon={id:m},this.buttons=[],this.renderBody=()=>{},this.keyEventProcessor=()=>{},this.initOptions(e),this.addStyleSheet(),this.renderDialogModal(),this.renderMessageRow(),this.renderButtonRow()}initOptions(e){var t,i,n,o,s,r,a,l,d,c,u,p,b,m,g;e&&(this.caption=null!==(t=null==e?void 0:e.caption)&&void 0!==t?t:"",this.message=null!==(i=null==e?void 0:e.message)&&void 0!==i?i:"",this.detail=null!==(n=null==e?void 0:e.detail)&&void 0!==n?n:"",this.buttons=null!==(o=null==e?void 0:e.buttons)&&void 0!==o?o:[],this.minWidth=null!==(s=null==e?void 0:e.minWidth)&&void 0!==s?s:this.minWidthDefault,this.minHeight=null!==(r=null==e?void 0:e.minHeight)&&void 0!==r?r:this.minHeightDefault,this.hideButtons=null!==(a=null==e?void 0:e.hideButtons)&&void 0!==a&&a,this.showCloseBtn=null!==(l=null==e?void 0:e.showCloseBtn)&&void 0!==l&&l,this.isDraggable=null!==(d=null==e?void 0:e.isDraggable)&&void 0!==d&&d,this.isScalable=null!==(c=null==e?void 0:e.isScalable)&&void 0!==c&&c,this.isFullScreen=null!==(u=null==e?void 0:e.isFullScreen)&&void 0!==u&&u,this.modal=null===(p=null==e?void 0:e.modal)||void 0===p||p,this.modalCloseable=null===(b=null==e?void 0:e.modalCloseable)||void 0===b||b,this.type=null!==(m=null==e?void 0:e.type)&&void 0!==m?m:h.NONE,this.icon=null!==(g=e.icon)&&void 0!==g?g:{id:""},this.renderBody=e.renderBody,this.keyEventProcessor=e.keyEventProcessor,this.hideButtons&&(this.buttons=[]))}dialogHeaderMouse(){this.isDraggable&&(this.toolbarContainer.style.cursor="move",this.toolbarContainer.onmousedown=e=>{const t=window.getComputedStyle(this.element,null),i=e.clientX-this.toolbarContainer.offsetLeft,n=e.clientY-this.toolbarContainer.offsetTop;let o,s;t.left.includes("%")?(o=document.body.clientWidth*(Number.parseInt(t.left)/100),s=document.body.clientHeight*(Number.parseInt(t.top)/100)):(o=Number.parseInt(t.left),s=Number.parseInt(t.top)),document.onmousemove=e=>{const t=e.clientX-i,r=e.clientY-n;this.nowLeft=t+o,this.nowTop=r+s,this.moveInEdge()},document.onmouseup=()=>{document.onmousemove=null,document.onmouseup=null}})}moveInEdge(){const e=this.modal?this.modalElement:this,t=e.offsetWidth/2-this.element.offsetWidth/2,i=this.element.offsetWidth/2-e.offsetWidth/2,n=e.offsetHeight/2-this.element.offsetHeight/2,o=this.element.offsetHeight/2-e.offsetHeight/2;this.topAndBottomLeftCriticality(o,n,i,t),this.leftAndRightCriticality(i,t),this.topAndBottomCriticality(o,n)}leftAndRightCriticality(e,t){this.nowLeft<=e?this.element.style.left=`-${t}px`:this.nowLeft>t?this.element.style.left=`${t}px`:this.element.style.left=`${this.nowLeft}px`}topAndBottomCriticality(e,t){this.nowTop<=e?this.element.style.top=`-${t}px`:this.nowTop>t&&(this.element.style.top=`${t}px`)}topAndBottomLeftCriticality(e,t,i,n){return this.nowLeft<=i&&this.nowTop<=e?(this.element.style.left=`-${n}px`,void(this.element.style.top=`-${t}px`)):this.nowLeft<=i&&this.nowTop>t?(this.element.style.left=`${n}px`,void(this.element.style.top=`${t}px`)):void this.topAndBottomRightCriticality(e,t,n)}topAndBottomRightCriticality(e,t,i){return this.nowLeft>i&&this.nowTop<=e?(this.element.style.left=`${i}px`,void(this.element.style.top=`-${t}px`)):this.nowLeft>i&&this.nowTop>-e?(this.element.style.left=`${i}px`,void(this.element.style.top=`${t}px`)):void(this.element.style.top=`${this.nowTop}px`)}dialogScreen(){this.isFullScreen&&(this.toolbarContainer.ondblclick=()=>{this.currentIsFullScreen?(this.element.style.height=`${this.nowHight}px`,this.element.style.width=`${this.nowWidth}px`,this.isDraggable&&(this.toolbarContainer.style.cursor="move"),this.dialogHeaderMouse(),this.currentIsFullScreen=!1):(this.nowHight=this.element.clientHeight,this.nowWidth=this.element.clientWidth,this.element.style.left="0",this.element.style.top="0",this.element.style.height="100%",this.element.style.width="100%",this.toolbarContainer.style.cursor="initial",this.toolbarContainer.onmousedown=null,this.currentIsFullScreen=!0)})}renderDialogModal(){this.element=document.createElement("div"),this.element.classList.add("ide-dialog-box"),this.element.setAttribute("style",`width: ${this.minWidth}px; height: ${this.minHeight}px`),this.element.setAttribute("role","dialog"),this.element.tabIndex=-1,this.element.style.display="none",this.resizeDialog(),this.element.setAttribute("aria-hidden","true"),this.modal?(this.modalElement=document.createElement("div"),this.modalElement.classList.add("ide-dialog-modal-block"),this.shadow.appendChild(this.modalElement),this.modalElement.appendChild(this.element)):this.shadow.appendChild(this.element)}modelCloseEvent(){this.eventStore.add({element:this,type:"click",handler:e=>{const t=this.element.offsetLeft,i=this.element.offsetWidth,n=this.element.offsetTop,o=this.element.offsetHeight,s=e.x<t||e.x>t+i,r=e.y<n||e.y>n+o;(s||r)&&this.dispose()}})}resizeDialog(){this.isScalable&&(this.element.onmousemove=e=>{const t=this.element,i=e.clientX>=t.offsetLeft+t.clientWidth-10,n=t.offsetLeft+10>=e.clientX,o=t.scrollTop+e.clientY>=t.offsetTop+t.clientHeight-10;!n&&!i||o?n||i||!o?i&&o?t.style.cursor="se-resize":n&&o?t.style.cursor="ne-resize":(t.style.cursor="default",t.onmousedown=null):t.style.cursor="s-resize":t.style.cursor="w-resize",this.dialogBoxMouseDown()})}dialogBoxMouseDown(){this.element.onmousedown=e=>{const t=e.clientX,i=e.clientY,n=this.element.clientWidth,o=this.element.clientHeight,s=this.element.offsetLeft,r=this.element.offsetTop,a=this.element.scrollTop;t>s&&t<s+n&&i>r&&i<r+40||(this.docMouseMove(t,i,n,o,s,r,a),this.docMouseUp())}}leftScalable(e,t,i,n){e>t&&e<=t+10&&(e>n.clientX&&(this.element.style.width=i+(e-n.clientX)+"px",this.element.style.left=this.nowLeft+(n.clientX-e)/2+"px"),e<n.clientX&&i>this.minWidth&&(this.element.style.width=i-(n.clientX-e)+"px",this.element.style.left=this.nowLeft+(n.clientX-e)/2+"px"))}rightScalable(e,t,i,n){e>t+i-10&&e<t+i&&(e>n.clientX&&i>this.minWidth&&(this.element.style.width=i-(e-n.clientX)+"px",this.element.style.left=this.nowLeft+(n.clientX-e)/2+"px"),e<n.clientX&&(this.element.style.width=`${i+(n.clientX-e)}px`,this.element.style.left=this.nowLeft+(n.clientX-e)/2+"px"))}downScalable(e,t,i,n,o){i+e>t+n-20&&i+e<t+n&&(e>o.clientY&&n>this.minHeight&&(this.element.style.height=n-(e-o.clientY)+"px",this.element.style.top=this.nowTop+(o.clientY-e)/2+"px"),e<o.clientY&&(this.element.style.height=n+(o.clientY-e)+"px",this.element.style.top=this.nowTop+(o.clientY-e)/2+"px"))}docMouseMove(e,t,i,n,o,s,r){document.onmousemove=a=>{a.preventDefault(),this.leftScalable(e,o,i,a),this.rightScalable(e,o,i,a),this.downScalable(t,s,r,n,a)}}docMouseUp(){document.onmouseup=()=>{document.onmousemove=null,document.onmouseup=null;const e=this.modal?this.modalElement:this,t=(null==e?void 0:e.offsetWidth)?(null==e?void 0:e.offsetWidth)/2:0,i=this.element.offsetLeft+this.element.offsetWidth/2;this.nowLeft=i-t;const n=(null==e?void 0:e.offsetHeight)?(null==e?void 0:e.offsetHeight)/2:0,o=this.element.offsetTop+this.element.offsetHeight/2;this.nowTop=o-n}}renderMessageRow(){const e=document.createElement("div");e.classList.add("dialog-toolbar-row"),this.toolbarContainer=document.createElement("div"),this.toolbarContainer.classList.add("dialog-toolbar");const t=document.createElement("span");t.textContent=this.caption,this.toolbarContainer.appendChild(t),this.dialogHeaderMouse(),this.dialogScreen(),e.appendChild(this.toolbarContainer);const i=document.createElement("div");i.classList.add("dialog-message-row"),this.showCloseBtn||this.caption?this.element.append(e,i):this.element.appendChild(i),this.iconElement=document.createElement("div"),this.iconElement.classList.add("ide-dialog-icon","dialog-icon"),this.messageContainer=document.createElement("div"),this.messageContainer.classList.add("dialog-message-container"),i.append(this.iconElement,this.messageContainer),this.messageElement=document.createElement("div"),this.messageElement.classList.add("dialog-message"),this.messageTextElement=document.createElement("div"),this.messageTextElement.setAttribute("id","ide-dialog-message-text"),this.messageTextElement.classList.add("dialog-message-text"),this.message&&(this.messageTextElement.innerText=this.message,this.messageElement.appendChild(this.messageTextElement),this.messageContainer.appendChild(this.messageElement)),this.messageDetailElement=document.createElement("div"),this.messageDetailElement.setAttribute("id","ide-dialog-message-detail"),this.messageDetailElement.classList.add("dialog-message-detail"),this.messageContainer.appendChild(this.messageDetailElement),this.messageWidget()}messageWidget(){if(this.detail?this.messageDetailElement.innerText=this.detail:this.messageDetailElement.style.display="none",this.renderBody){const e=document.createElement("div");e.setAttribute("id","ide-dialog-message-body"),e.classList.add("dialog-message-body"),this.messageContainer.appendChild(e),this.renderBody(e),this.messageContainer.querySelectorAll("a").forEach(e=>{e.tabIndex=0})}}renderButtonRow(){const e=document.createElement("div");e.classList.add("dialog-buttons-row"),this.element.appendChild(e),this.buttonsContainer=document.createElement("div"),this.buttonsContainer.classList.add("dialog-buttons"),e.appendChild(this.buttonsContainer)}addStyleSheet(){const e=document.createElement("style");e.appendChild(document.createTextNode(l.DialogStyle)),this.shadow.appendChild(e)}messageBodyChilds(e){const t=[];for(let i=0;i<e.length;i++)e[i].children&&this.messageBodyChilds(e[i].children),t.push(e[i]);return t}formFocus(){setTimeout(()=>{var e;const t=null===(e=this.shadowRoot)||void 0===e?void 0:e.querySelector(".dialog-message-body");if(!t)return;const i=this.messageBodyChilds([t]);for(let e=0;e<i.length;e++){const t=i[e];if(t.tagName.includes("IDE-CHECKBOX")||t.tagName.includes("IDE-INPUTBOX")||t.tagName.includes("IDE-RADIO")||t.tagName.includes("IDE-SELECT")){t.focus();break}}})}renderAriaClass(){this.element.setAttribute("aria-modal","true"),this.element.setAttribute("aria-labelledby","ide-dialog-icon ide-dialog-message-text"),this.element.setAttribute("aria-describedby","ide-dialog-icon ide-dialog-message-text ide-dialog-message-detail ide-dialog-message-body"),this.element.style.display="",this.element.removeAttribute("aria-hidden")}renderCloseIcon(){if(this.showCloseBtn){const e=new d.ActionBar;this.toolbarContainer.append(e),this.insertIconStyle("close"),this.closeAction=new c.Action("dialog.close","Close Dialog","codicon codicon-close",!0,()=>n(this,void 0,void 0,function*(){})),e.push(this.closeAction,{icon:!0,label:!1}),e.onDidRun(()=>{this.dispose()})}}renderIconType(){switch(this.type){case h.INFO:this.insertIconStyle(h.INFO),this.iconElement.classList.add("codicon","codicon-info");break;case h.SUCCESS:this.insertIconStyle("pass-filled"),this.iconElement.classList.add("codicon","codicon-pass-filled");break;case h.ERROR:this.insertIconStyle(h.ERROR),this.iconElement.classList.add("codicon","codicon-error");break;case h.WARNING:this.insertIconStyle(h.WARNING),this.iconElement.classList.add("codicon","codicon-warning");break;case h.PENDING:this.insertIconStyle("loading"),this.iconElement.classList.add("codicon","codicon-loading");break;case h.QUESTION:this.insertIconStyle(h.QUESTION),this.iconElement.classList.add("codicon","codicon-question");break;default:this.iconElement.style.display="none"}}renderIcon(){this.icon.id?(this.insertIconStyle(this.icon.id),this.iconElement.classList.add("codicon",`codicon-${this.icon.id}`)):this.renderIconType()}addWindowEvents(){this.eventStore.add({element:window,type:"keydown",handler:e=>{var t,i,n;const o=e;if(o.altKey&&e.preventDefault(),"Enter"!==o.key)this.keyEventProcessor&&this.keyEventProcessor(e);else if((null===(t=this.shadowRoot)||void 0===t?void 0:t.activeElement)instanceof d.ActionBar&&this.dispose(),(null===(i=this.shadowRoot)||void 0===i?void 0:i.activeElement)instanceof a.CheckBox){const e=null===(n=this.shadowRoot)||void 0===n?void 0:n.activeElement;e.setChecked(!e.isChecked)}}}),this.eventStore.add({element:window,type:"keydown",handler:e=>{const t=e;e.preventDefault(),e.stopPropagation(),this.showCloseBtn&&"Escape"===t.key&&this.dispose()}}),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}insertIconStyle(e){var t;const i=null===(t=this.shadow.querySelector("style"))||void 0===t?void 0:t.childNodes.item(0),n=(null==i?void 0:i.wholeText.indexOf("codicon[class*='codicon-']"))>-1,o=this.shadow.querySelector("style");null==o||o.appendChild(document.createTextNode((0,s.getIconStyle)([e],n)))}customMessageIcon(e){e&&(this.insertIconStyle(e),this.iconElement.style.display="block",this.iconElement.classList.add("codicon",`codicon-${e}`))}customBodyIcon(e){var t,i,n;if(!e)return;const o=null===(i=null===(t=this.dialogBodyInstance)||void 0===t?void 0:t.shadow.querySelector("style"))||void 0===i?void 0:i.childNodes.item(0),r=(null==o?void 0:o.wholeText.indexOf("codicon[class*='codicon-']"))>-1;null===(n=this.dialogBodyInstance)||void 0===n||n.renderStyle((0,s.getIconStyle)(e,r))}getButtons(){return this.buttonsContainer.firstElementChild.buttons}updateButtons(e){this.disposeButtons(),this.buttonBar=new r.ButtonBar;const t=this.buttonBar;this.doUpdateButtons(e,t),this.buttonsContainer.append(this.buttonBar)}doUpdateButtons(e,t){e.forEach(e=>{var i,n;const o=e.description?t.addButtonWithDescription(Object.assign({},e)):t.addButton(Object.assign({},e));o.label=null!==(i=e.label)&&void 0!==i?i:"",o instanceof r.ButtonWithDescription&&(o.description=null!==(n=e.description)&&void 0!==n?n:""),null==o||o.onDidClick(t=>{t&&t.preventDefault(),e.handler&&e.handler()})})}disposeButtons(){const e=this.buttonsContainer.firstElementChild;null==e||e.dispose(),(0,u.clearNode)(this.buttonsContainer)}updateMessage(e){this.message=e,this.messageTextElement.innerText=e}renderCustomBody(e,t){var i;null===(i=this.dialogBodyInstance)||void 0===i||i.dispose();const n=this.messageContainer.getElementsByClassName("dialog-message-body")[0];0!==this.messageContainer.getElementsByClassName("dialog-message-body").length&&(0,u.clearNode)(n),this.dialogBodyInstance=new p(e,t),this.messageContainer.appendChild(this.dialogBodyInstance)}show(){this.buttonBar=new r.ButtonBar;const e=this.buttonBar;this.buttonsContainer.append(this.buttonBar),this.buttons&&this.doUpdateButtons(this.buttons,e),this.hideButtons&&(this.buttonsContainer.style.display="none"),this.renderIcon(),this.renderCloseIcon(),this.renderAriaClass(),this.formFocus(),this.modalCloseable&&this.modelCloseEvent(),this.addWindowEvents()}dispose(){this.modalElement&&(this.modalElement.remove(),this.modalElement=void 0),this.remove(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler))}}t.Dialog=b,(0,o.defineCustomElement)("ide-dialog-body",p),(0,o.defineCustomElement)("ide-dialog",b)},7651(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.call=t.expose=t.exposable=t.messaging=t.Messaging=t.Deferred=void 0;const o=i(8414);i(4741);class s{constructor(){this.isPending=!0,this.isFulfilled=!1,this.isRejected=!1,this.promise=new Promise((e,t)=>{this.resolve=t=>{e(t),this.isFulfilled=!0,this.isPending=!1},this.reject=e=>{t(e),this.isRejected=!0,this.isPending=!1}})}}t.Deferred=s;class r{constructor(e,t){this.exposedFunctions=new Map,this.pendingCalls=new Map,this.executingCalls=new Map,this.iframeContexts=[],e&&this.registerIframeContext(e),this.from=t||o.v4()}static init(e){return r.instance||(r.instance=new r(void 0,e)),r.instance}static bind(e,t){return r.instance?(r.instance.registerIframeContext(e),console.log(`New iframe messaging client added to ${r.instance.from}`)):r.instance=new r(e,t),r.instance}static getInstance(){return r.instance||console.log('Messaging has not been initialized, using "init" or "bind" function to initialize and bind Messaging instance'),r.instance}registerIframeContext(e){e.registerMessageHandler(this.onRemoteCall.bind(this)),e.onDispose(()=>{this.dispose(e)}),this.iframeContexts.push(e)}dispose(e){const t=this.iframeContexts.indexOf(e);t>0&&this.iframeContexts.splice(t,1)}sendRemoteCall(e){if(e.from=this.from,e.notify)return void this.iframeContexts.forEach(t=>{t.postMessage(e)});const t=new s;return this.pendingCalls.set(e.id,t),this.iframeContexts.forEach(t=>{t.postMessage(e)}),t}onRemoteCall(e){if(!e||e.from===this.from)return;if("*"!==e.to&&e.to!==this.from)return;if(e.notify){const t=this.pendingCalls.get(e.id);return void(t&&(delete e.notify,e.success?t.resolve(e.ret):t.reject(e.ret),this.pendingCalls.delete(e.id)))}if(!e.func)return;const t=e.func.indexOf("::")>=0?e.func.substr(e.func.indexOf("::")+2):e.func,i=this.exposedFunctions.get(t);i?(this.executingCalls.set(e.id,e.func),i(...e.args?e.args:[]).then(t=>{this.executingCalls.delete(e.id),this.sendRemoteCall({id:e.id,func:e.func,ret:t,success:!0,notify:!0,to:e.from,from:e.to})}).catch(t=>{const i={};Object.getOwnPropertyNames(t).forEach((e,n)=>{i[e]=t[e]}),this.sendRemoteCall({id:e.id,func:e.func,ret:i,success:!1,notify:!0,to:e.from,from:e.to})})):this.sendRemoteCall({id:e.id,func:e.func,ret:`no function exposed as ${e.func}`,success:!1,notify:!0,to:e.from,from:this.from})}expose(e,t){this.exposedFunctions.set(t||e.name,(...t)=>n(this,void 0,void 0,function*(){return e(...t)}))}call(e,...t){return n(this,void 0,void 0,function*(){return this.sendRemoteCall({id:o.v4(),func:e,args:t,notify:!1,from:this.from,to:e.indexOf("::")>=0?e.substr(0,e.indexOf("::")):"*"}).promise})}getExposedFunctions(){return this.exposedFunctions}}t.Messaging=r;const a=Symbol("expose");t.messaging=function(e){return function(t){const i=function(...i){const n=function(){return new t(...i)};n.prototype=t.prototype;const o=new n(...i);return r.bind(o,e),o};return i.prototype=t.prototype,i}},t.exposable=function(e){const t=function(...t){const i=function(){return new e(...t)};i.prototype=e.prototype;const n=new i(...t),o=Reflect.getMetadata(a,n),s=r.getInstance();return s&&o?(o.forEach((e,t)=>{s.getExposedFunctions().get(t)&&console.log(`warning: identifier "${t}" rebind to [${JSON.stringify(n)}].[${e}] `),s.expose((...t)=>Promise.resolve(e.apply(n,t)),t)}),n):n};return t.prototype=e.prototype,t},t.expose=function(e){return function(t,i,n){const o=n.value;let s=Reflect.getMetadata(a,t);if(s){const t=s.get(e);t&&console.log(`warning: duplicated identifier detected! function identifier '${e}' is rebinded from ${t} to ${o}`),s.set(e,o)}else s=new Map,s.set(e,o);Reflect.defineMetadata(a,s,t)}},t.call=function(e){return function(t,i,n){const o=n.value;n.value=function(...t){const i=r.getInstance();i&&i.call(e,...t),o(...t)}}}},7658(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.SubmenuAction=t.ToggleMenuAction=t.ToolBar=void 0;const o=i(3446),s=i(3067),r=i(4295),a=i(5754),l=i(9084),d=i(519),c=i(4523);class u extends l.BaseComponent{constructor(e,t={orientation:o.ActionsOrientation.HORIZONTAL,toggleMenuTitle:""}){super(),this.submenuActionViewItems=[],this.hasSecondaryActions=!1,this._onDidChangeDropdownVisibility=new d.EventEmitter,this.onDidChangeDropdownVisibility=this._onDidChangeDropdownVisibility.asSubscriber("onDidChangeDropdownVisibility"),this.options=t,this.lookupKeybindings="function"==typeof this.options.getKeyBinding,this.toggleMenuAction=new h(()=>{var e;return null===(e=this.toggleMenuActionViewItem)||void 0===e?void 0:e.show()},t.toggleMenuTitle),this.element=document.createElement("div"),this.element.className="ide-tool-bar",this.actionBar=new o.ActionBar({orientation:t.orientation,ariaLabel:t.ariaLabel,actionRunner:t.actionRunner,allowContextMenu:t.allowContextMenu,actionViewItemProvider:i=>{var n,o;if(i.id===h.ID)return this.toggleMenuActionViewItem=new s.DropdownMenuActionViewItem(i,i.menuActions,e,{actionViewItemProvider:this.options.actionViewItemProvider,actionRunner:this.actionRunner,keybindingProvider:this.options.getKeyBinding,classNames:(0,a.getIconClassName)(null!==(o=null===(n=t.moreIcon)||void 0===n?void 0:n.id)&&void 0!==o?o:"more"),anchorAlignmentProvider:this.options.anchorAlignmentProvider,menuAsChild:!!this.options.renderDropdownAsChildElement}),this.toggleMenuActionViewItem.setActionContext(this.actionBar.context),this.toggleMenuActionViewItem;if(t.actionViewItemProvider){const e=t.actionViewItemProvider(i);if(e)return e}if(i instanceof p){const t=new s.DropdownMenuActionViewItem(i,i.actions,e,{actionViewItemProvider:this.options.actionViewItemProvider,actionRunner:this.actionRunner,keybindingProvider:this.options.getKeyBinding,classNames:i.class,anchorAlignmentProvider:this.options.anchorAlignmentProvider,menuAsChild:!!this.options.renderDropdownAsChildElement});return t.setActionContext(this.actionBar.context),this.submenuActionViewItems.push(t),t}}}),this.element.append(this.actionBar),this.shadow.appendChild(this.element)}set actionRunner(e){this.actionBar.actionRunner=e}get actionRunner(){return this.actionBar.actionRunner}set context(e){var t;this.actionBar.context=e,null===(t=this.toggleMenuActionViewItem)||void 0===t||t.setActionContext(e);for(const t of this.submenuActionViewItems)t.setActionContext(e)}addActionViewItems(e){this.actionBar.addActionViewItems(e)}removeActionViewItems(e){this.actionBar.removeActionViewItems(e)}getElement(){return this.element}getItemsWidth(){let e=0;for(let t=0;t<this.actionBar.length();t++)e+=this.actionBar.getWidth(t);return e}getItemAction(e){return this.actionBar.getAction(e)}getItemWidth(e){return this.actionBar.getWidth(e)}getItemsLength(){return this.actionBar.length()}setAriaLabel(e){this.actionBar.setAriaLabel(e)}setActions(e,t,i){var n;this.clear();const o=e?e.slice(0):[];this.hasSecondaryActions=!!(t&&t.length>0),this.hasSecondaryActions&&t&&(this.toggleMenuAction.menuActions=t.slice(0),o.push(this.toggleMenuAction)),o.forEach(e=>{this.actionBar.push(e,{icon:!0,label:!1,keybinding:this.getKeybindingLabel(e)})}),(null==i?void 0:i.length)&&(null===(n=this.actionBar)||void 0===n||n.addActionViewItems(i))}getKeybindingLabel(e){var t,i;const n=this.lookupKeybindings?null===(i=(t=this.options).getKeyBinding)||void 0===i?void 0:i.call(t,e):void 0;return(0,c.isNull)(null==n?void 0:n.getLabel())||null==n?void 0:n.getLabel()}clear(){this.submenuActionViewItems=[],this.actionBar.clear()}dispose(){this.clear(),this._onDidChangeDropdownVisibility.clear(),this.toggleMenuAction.dispose(),this.actionBar.dispose()}}t.ToolBar=u;class h extends r.Action{constructor(e,t){super(h.ID,t,void 0,!0),this._menuActions=[],this.toggleDropdownMenu=e}run(){return n(this,void 0,void 0,function*(){this.toggleDropdownMenu()})}get menuActions(){return this._menuActions}set menuActions(e){this._menuActions=e}}t.ToggleMenuAction=h,h.ID="toolbar.toggle.more";class p{get actions(){return this._actions}constructor(e,t,i,n){this.tooltip="",this.enabled=!0,this.checked=void 0,this.id=e,this.label=t,this.class=n,this._actions=i}dispose(){}run(){return n(this,void 0,void 0,function*(){})}}t.SubmenuAction=p,(0,l.defineCustomElement)("ide-tool-bar",u)},7725(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getEmptyStyle=void 0;const n=i(6199);t.getEmptyStyle=e=>`\n:host {\n    width: 100%;\n}\n.ide-empty {\n    padding: 20px 0;\n    display: none;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n    font-size: ${n.fontSize.mainText};\n}\n\n.ide-empty.show {\n    display: flex;\n}\n\n.ide-empty-text {\n    margin-top: ${n.fontSize.mainText};\n    font-family: ${n.fontFamily};\n    font-size: ${n.fontSize.mainText};\n    text-align: center;\n}`},7746(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Tag=t.TagSize=t.TagType=void 0;const n=i(519),o=i(9084),s=i(3265),r=i(5754),a=i(8784),l=i(5354);var d,c;!function(e){e.DEFAULT="default",e.SECONDARY="secondary",e.SUCCESS="success",e.PROCESSING="processing",e.ERROR="error",e.WARNING="warning",e.CLOSEABLE="closeable"}(d=t.TagType||(t.TagType={})),function(e){e.MINIMAL="minimal",e.SMALL="small",e.MEDIUM="medium"}(c=t.TagSize||(t.TagSize={}));const u=[d.DEFAULT,d.SECONDARY,d.SUCCESS,d.PROCESSING,d.ERROR,d.WARNING,d.CLOSEABLE];class h extends o.BaseComponent{constructor(e){var t;super(),this.content="",this.tagEmitter=new n.EventEmitter,this.onClose=this.tagEmitter.asSubscriber("onClose"),this.eventStore=new Set,this.disable=null!==(t=null==e?void 0:e.disable)&&void 0!==t&&t,this.tagDiv=document.createElement("div"),this.cur=document.createElement("div"),this.closeDiv=document.createElement("div"),this.closeDiv.classList.add("ide-tag-close");const i=document.createElement("style");i.appendChild(document.createTextNode((0,s.getTagStyle)(l.ideChecker.isIDE))),this.renderTag(e),this.shadow.appendChild(i),this.shadow.appendChild(this.tagDiv)}renderTag(e){var t,i;this.initOptions(e),this.tagDiv.classList.add(`ide-tag-${null===(t=this.options)||void 0===t?void 0:t.type}`,`${this.getAttribute("size")||this.options.size}`),this.cur.setAttribute("class","ide-tag-inline-block ide-tag-label-common ide-tag-max-common"),this.cur.textContent=this.content,this.tagDiv.appendChild(this.cur),"closeable"===this.type&&(this.closeDiv.appendChild((0,r.renderIcon)({id:"close"},this.shadow)),this.tagDiv.appendChild(this.closeDiv),null===(i=this.tagDiv.lastElementChild)||void 0===i||i.setAttribute("disable",String(this.disable)),this.eventStore.add({element:this.tagDiv.lastElementChild,type:"click",handler:e=>{var t;e.stopPropagation();const i=e.target;"true"!==i.getAttribute("disable")&&"true"!==(null===(t=i.parentElement)||void 0===t?void 0:t.getAttribute("disable"))&&this.close()}}),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler)));const n=!!this.options.flexible;this.flexibleRender(n),this.setDisable(this.disable)}initOptions(e){e=e||{};const{label:t=this.getAttribute("label")||"",type:i=this.getAttribute("type")||d.DEFAULT,title:n=this.getAttribute("title")||"",flexible:o=this.hasAttribute("flexible"),maxWidth:s=this.getAttribute("maxWidth")||"",size:r=this.getAttribute("size")||c.MEDIUM}=e;this.options={label:t,type:i,title:n,flexible:o,maxWidth:s,size:r},this.content=this.options.label,this.tagTitle()}tagTitle(){this.hover&&this.hover.dispose(),this.hover=a.Hover.setupIconLabelHover({content:this.options.title&&!this.options.flexible?this.options.title:this.options.label,target:this.cur,hoverPosition:a.HoverPosition.BELOW,showPointer:!1,upperLayer:!0}),this.tagDiv.removeAttribute("title"),this.shadow.host.removeAttribute("title")}flexibleRender(e){e?this.options.maxWidth=this.options.maxWidth?this.options.maxWidth:"100%":(this.options.maxWidth=this.options.maxWidth?this.options.maxWidth:"60",this.tagDiv.style.width=this.options.maxWidth+"px")}close(){this.updateValue(),this.tagDiv.remove(),this.remove()}setDisable(e){var t,i;this.disable=e;e&&"closeable"===this.type?(null===(t=this.tagDiv.lastElementChild)||void 0===t||t.setAttribute("disable",String(this.disable)),this.tagDiv.classList.remove("ide-tag-closeable","medium"),this.tagDiv.classList.add("ide-tag-disable","ide-tag-not-allowed"),this.cur.classList.add("ide-tag-inline-block","ide-tag-label-common","ide-tag-max-common","ide-tag-label-disable")):e||"closeable"!==this.type||(this.tagDiv.classList.remove("ide-tag-disable","ide-tag-not-allowed"),this.tagDiv.classList.add("ide-tag-closeable","medium"),this.cur.classList.remove("ide-tag-label-disable"),null===(i=this.tagDiv.lastElementChild)||void 0===i||i.removeAttribute("disable"))}updateValue(){const e=this.label?this.label:"";this.tagEmitter.emit("onClose",e),this.tagDiv.dispatchEvent(new CustomEvent("onClose",{detail:{label:e,options:this.options},composed:!0}))}get label(){return this.content}set label(e){this.content=e,this.tagDiv.textContent=e}get type(){return this.options.type||d.DEFAULT}set type(e){var t;if(!u.includes(e))return;const i=null!==(t=this.options.type)&&void 0!==t?t:d.DEFAULT;this.options.type=e,this.setAttribute("type",e),i===d.CLOSEABLE||this.tagDiv.classList.remove(`ide-tag-${i}`),this.tagDiv.classList.add(`ide-tag-${e}`)}dispose(){this.disconnectedCallback(),this.tagEmitter.clear(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler))}}t.Tag=h,(0,o.defineCustomElement)("ide-tag",h)},7953(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getHoverStyle=void 0;const n=i(6199);t.getHoverStyle=e=>`\n@keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }\n\n.fade-in {\n\tanimation: fadeIn 300ms linear;\n}\n\n.skip-fade-in {\n\tanimation: unset;\n}\n\n.ide-hover {\n\tcursor: default;\n\tposition: relative;\n\tz-index: 50;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tbox-sizing: initial;\n\tbackground-color: ${e?"var(--vscode-editorHoverWidget-background)":n.hoverBackground};\n\tborder-radius: ${n.radius.bgRadius};\n\tborder: 1px solid ${e?"var(--vscode-editorHoverWidget-border)":n.borderColor};\n\tbox-shadow: 0 2px 8px 0 ${e?"var(--vscode-widget-shadow)":n.hoverShadowColor};\n}\n\n.ide-hover.warning {\n\tbackground-color: ${e?"var(--vscode-inputValidation-warningBackground)":n.warnHoverBackground}; \n\tborder: 1px solid ${e?"var(--vscode-inputValidation-warningBorder, transparent)":n.hoverBorderColor};\n}\n\n.ide-hover.error {\n\tbackground-color: ${e?"var(--vscode-inputValidation-errorBackground)":n.errorHoverBackground}; \n\tborder: 1px solid ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.hoverBorderColor};\n}\n\n.ide-hover p,\n.ide-hover ul,\n.ide-hover .code {\n    margin: 8px 0;\n}\n\n.ide-hover p:first-child,\n.ide-hover ul:first-child,\n.ide-hover .code:first-child {\n\tmargin-top: 0;\n}\n\n.ide-hover p:last-child,\n.ide-hover ul:last-child,\n.ide-hover .code:last-child {\n\tmargin-bottom: 0;\n}\n\n.ide-hover ul {\n\tpadding-left: 20px;\n}\n.ide-hover ol {\n\tpadding-left: 20px;\n}\n\n.ide-hover li > p {\n\tmargin-bottom: 0;\n}\n\n.ide-hover li > ul {\n\tmargin-top: 0;\n}\n\n.ide-hover code {\n\tfont-family: ${n.fontFamily};\n\tfont-size: 11px;\n\tborder-radius: ${n.radius.bgRadius};\n\tpadding: 0 0.4em;\n\tbackground-color: ${e?"var(--vscode-textCodeBlock-background)":n.codeBackgroundColor};\n}\n\n.ide-hover pre {\n\tmargin: 0;\n\twhite-space: pre-wrap;\n}\n\n.ide-hover hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n\tborder-bottom: 0px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n\tborder-top: 1px solid ${e?"var(--vscode-hrHoverWidget-border)":n.borderColor};\n\tmargin-top: 4px;\n\tmargin-bottom: -4px;\n\tmargin-left: -8px;\n\tmargin-right: -8px;\n\theight: 1px;\n}\n\n.ide-hover a {\n    color: ${e?"var(--vscode-textLink-foreground)":n.hoverLinkColor};\n    text-decoration: none;\n}\n\n.monaco-scrollable-element {\n\tmargin: 1px 0;\n\tmax-height: calc(100vh - 4px);\n\tmax-width: calc(100vw - 2px);\n}\n\n.ide-hover-content {\n    color: ${e?"var(--vscode-editorHoverWidget-foreground)":n.titleFontColor};\n    font-size: ${n.fontSize.buttonText};\n    line-height: ${n.fontLineHeight.buttonText};\n}\n\n.ide-hover.warning .ide-hover-content,\n.ide-hover.error .ide-hover-content {\n\tcolor: ${e?"var(--vscode-editorHoverWidget-foreground)":n.hoverFontColor};\n}\n\n.ide-hover-content > .content:not(.html-hover-contents) {\n\tpadding: 0 8px;\n}\n\n.compact {\n\tfont-size: ${n.fontSize.mainText};\n}\n\n.ide-hover-content .codicon {\n\tcolor: inherit;\n\tfont-size: inherit;\n\tvertical-align: middle;\n}\n\n.ide-hover-content.markdown-contents {\n\tpadding: 2px 8px;\n}\n\n.hover-language-status {\n    display: flex;\n    padding: 4px 8px;\n}\n\n.hover-language-status:not(:last-child) {\n    border-bottom: 1px solid ${e?"var(--vscode-editorHoverWidget-border)":n.borderColor};\n}\n\n.hover-language-status>.severity {\n\tpadding-right: 8px;\n\tflex: 1;\n\tmargin: auto;\n\tdisplay: none;\n}\n\n.hover-language-status>.element {\n\tdisplay: flex;\n\tjustify-content: space-between;\n\tvertical-align: middle;\n\tflex-grow: 100;\n}\n\n.hover-language-status>.element>.left>.detail:not(:empty)::before {\n\t/* allow-any-unicode-next-line */\n\tcontent: '–';\n\tpadding: 0 4px;\n\topacity: 0.6;\n}\n\n.hover-language-status>.element>.left>.label:empty {\n\tdisplay: none;\n}\n\n.hover-language-status>.element .left {\n\tmargin: auto 0;\n}\n\n.hover-language-status>.element .right {\n\tmargin: auto 0;\n\tdisplay: flex;\n}\n\n.hover-language-status>.element .right:not(:empty) {\n\tpadding-left: 16px;\n}\n\n.hover-language-status>.element .right .monaco-link {\n\tmargin: auto 0;\n\twhite-space: nowrap;\n}\n\n.hover-language-status>.element .right .monaco-action-bar:not(:first-child) {\n\tpadding-left: 8px;\n}\n\n.ide-hover-pointer {\n    z-index: 51;\n    position: absolute;\n    pointer-events: none;\n}\n\n.ide-hover-pointer:after {\n\tcontent: '';\n\tposition: absolute;\n\twidth: 5px;\n\theight: 5px;\n\tbackground-color: ${e?"var(--vscode-editorHoverWidget-background)":n.hoverBackground};\n\tborder-right: 1px solid ${e?"var(--vscode-editorHoverWidget-border)":n.borderColor};\n\tborder-bottom: 1px solid ${e?"var(--vscode-editorHoverWidget-border)":n.borderColor};\n}\n\n.ide-hover.warning .ide-hover-pointer:after {\n\tbackground-color: ${e?"var(--vscode-inputValidation-warningBackground)":n.warnHoverBackground}; \n\tborder-right: 1px solid ${e?"var(--vscode-inputValidation-warningBorder, transparent)":n.hoverBorderColor};\n    border-bottom: 1px solid ${e?"var(--vscode-inputValidation-warningBorder, transparent)":n.hoverBorderColor};\n}\n\n.ide-hover.error .ide-hover-pointer:after {\n\tbackground-color: ${e?"var(--vscode-inputValidation-errorBackground)":n.errorHoverBackground}; \n\tborder-right: 1px solid ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.hoverBorderColor};\n    border-bottom: 1px solid ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.hoverBorderColor};\n}\n\n.ide-hover-pointer.left   { left: -4px; }\n.ide-hover-pointer.right  { right: 2px; }\n.ide-hover-pointer.top    { top: -4px; }\n.ide-hover-pointer.bottom { bottom: 2px; }\n\n.ide-hover-pointer.left:after {\n\t-moz-transform: rotate(135deg);\n\t-webkit-transform: rotate(135deg);\n\ttransform: rotate(135deg);\n}\n\n.ide-hover-pointer.right:after {\n\t-moz-transform: rotate(315deg);\n\t-webkit-transform: rotate(315deg);\n\ttransform: rotate(315deg);\n}\n\n.ide-hover-pointer.top:after {\n\t-moz-transform: rotate(225deg);\n\t-webkit-transform: rotate(225deg);\n\ttransform: rotate(225deg);\n}\n\n.ide-hover-pointer.bottom:after {\n\t-moz-transform: rotate(45deg);\n\t-webkit-transform: rotate(45deg);\n\ttransform: rotate(45deg);\n}\n\n.hover-row:not(:first-child):not(:empty) {\n\tborder-top: 1px solid ${e?"var(--vscode-editorHoverWidget-border)":n.borderColor};\n}\n\n.hover-row.status-bar {\n\tfont-size: ${n.fontSize.buttonText};\n\tline-height: 26px;\n}\n\n.hover-row.status-bar .actions {\n\tdisplay: flex;\n\tpadding: 0px 8px;\n}\n\n.hover-row.status-bar .actions .action-container {\n\tmargin-right: 16px;\n\tcursor: pointer;\n}\n\n.hover-row.status-bar .actions .action-container .action .icon {\n\tpadding-right: 4px;\n}\n\n.ide-hover.right-aligned .hover-row.status-bar .actions {\n\tflex-direction: row-reverse;\n}\n\n.ide-hover.right-aligned .hover-row.status-bar .actions .action-container {\n\tmargin-right: 0;\n\tmargin-left: 16px;\n}\n\n.ide-hover.right-aligned .hover-row.status-bar .actions.force-left-align {\n\tflex-direction: row;\n}\n\n.ide-hover.right-aligned .hover-row.status-bar .actions.force-left-align .action-container {\n\tmargin-right: 16px;\n\tmargin-left: 0;\n}\n`},8093(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getRadioStyle=void 0;const n=i(6199);t.getRadioStyle=e=>`\n.ide-radio-wrapper {\n    display: flex;\n    font-family: ${n.fontFamily};\n    align-items: center;\n    height: 20px;\n    outline: none;\n}\n \n.ide-radio-wrapper[enabled='false'],\n.ide-radio-wrapper.ture[enabled='false'] {\n    cursor: not-allowed;\n}\n\n.ide-radio-wrapper>.ide-radio {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    box-sizing: border-box;\n    cursor: pointer;\n    border-radius: 50%;\n    margin: 2px 5px 2px 0;\n    color: ${e?"var(--vscode-foreground)":n.radioColor};\n    outline: none;\n    height: 16px;\n    width: 16px;\n}\n \n.ide-radio-wrapper>.ide-radio .codicon {\n    color: ${e?"var(--vscode-foreground)":n.primaryColor};\n}\n\n.ide-radio-solid-circle {\n    width: 8px;\n    height: 8px;\n    background-color: ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 50%;\n}\n\n.ide-radio-wrapper:hover>.ide-radio .codicon {\n    color: ${e?"var(--vscode-foreground)":n.primaryColorHover};\n}\n \n.ide-radio-wrapper[enabled='false']>.ide-radio .codicon,\n.ide-radio-wrapper.ture[enabled='false']>.ide-radio-right-container .codicon {\n    color: ${e?"var(--vscode-foreground)":n.borderColor};\n}\n \n.ide-radio-wrapper[enabled='true']>.ide-radio {\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n}\n\n.ide-radio-wrapper[enabled='true']:hover>.ide-radio,\n.ide-radio-wrapper[enabled='true']>.ide-radio[checked] {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n}\n \n.ide-radio-wrapper[enabled='true']:hover>.ide-radio[checked] {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColorHover};\n}\n\n.ide-radio-wrapper.ture[enabled='true'] {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.borderColor};\n}\n\n.ide-radio-wrapper[enabled='false']>.ide-radio,\n.ide-radio-wrapper.ture[enabled='false']>.ide-radio-right-container .ide-radio {\n    cursor: not-allowed;\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n    background-color: ${e?"var(--vscode-checkbox-background)":n.disbaledradioBackgroundColor};\n}\n \n.ide-radio-wrapper>.ide-radio-label {\n    display: inline-block;\n    font-size: 13px;\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n    line-height: 28px;\n    height: 28px;\n    cursor: pointer;\n    user-select: none;\n    font-weight: 400;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-radio-wrapper>.ide-radio-description {\n    text-align: right;\n    flex-grow: 1;\n    font-size: 13px;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n    line-height: 28px;\n    height: 28px;\n    cursor: pointer;\n    user-select: none;\n    font-weight: 400;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    margin-left: 4px;\n    width: 0%;\n}\n \n.ide-radio-wrapper[enabled='false']>.ide-radio-label,\n.ide-radio-wrapper.ture[enabled='false']>.ide-radio-left-container .ide-radio-label,\n.ide-radio-wrapper-active.true[enabled='false']>.ide-radio-left-container .ide-radio-label,\n.ide-radio-wrapper-active.true[enabled='false']:hover>.ide-radio-left-container .ide-radio-label,\n.ide-radio-wrapper-active.true[enabled='false']>.ide-radio-left-container .ide-radio-secondary-label,\n.ide-radio-wrapper-active.true[enabled='false']:hover>.ide-radio-left-container .ide-radio-secondary-label {\n    cursor:not-allowed;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n}\n\n.ide-radio-wrapper>.ide-radio-label .codicon {\n    line-height: 20px;\n    height: 20px;\n    vertical-align: middle;\n}\n \n.ide-radio-wrapper.true {\n    width: 154px;\n    height: 56px;\n    background: ${e?"var(--vscode-checkbox-background)":n.defaultTagBackground};\n    border: 1px solid rgba(255, 255, 255, 0);\n    border-radius: 8px;\n    justify-content: space-between;\n}\n \n.ide-radio-wrapper.true:hover {\n    background: ${e?"var(--vscode-focusBorder-background)":n.secondaryBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 8px;\n    outline: none;\n}\n\n.ide-radio-wrapper.true[enabled='false']:hover {\n    background: ${e?"var(--vscode-checkbox-background)":n.defaultTagBackground};\n    border: 1px solid rgba(255, 255, 255, 0);\n    border-radius: 8px;\n}\n\n.ide-radio-wrapper.true[enabled='false']>.ide-radio-left-container>.ide-radio-label,\n.ide-radio-wrapper.true[enabled='false']:hover>.ide-radio-left-container>.ide-radio-label {\n    cursor: not-allowed;\n    width: 100px;\n    font-size: 14px;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n    line-height: 20px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-radio-wrapper.true[enabled='false']>.ide-radio-left-container>.ide-radio-secondary-label,\n.ide-radio-wrapper.true[enabled='false']:hover>.ide-radio-left-container>.ide-radio-secondary-label {\n    cursor: not-allowed;\n    width: 100px;\n    font-size: 12px;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n    line-height: 18px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-radio-wrapper.true[enabled='false']:hover>.ide-radio-right-container>.ide-radio {\n    cursor: not-allowed;\n    border: none;\n}\n \n.ide-radio-wrapper-active.true {\n    display: flex;\n    font-family: ${n.fontFamily};\n    width: 154px;\n    height: 56px;\n    background: ${e?"var(--vscode-focusBorder-background)":n.secondaryBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.borderColor};\n    border-radius: 8px;\n    justify-content: space-between;\n    outline: none;\n}\n\n.ide-radio-wrapper-active.true[enabled='false'] {\n    cursor: not-allowed;\n    display: flex;\n    width: 154px;\n    height: 56px;\n    background: ${e?"var(--vscode-checkbox-wrapper-background)":n.disbaledradioBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n    border-radius: 8px;\n    justify-content: space-between;\n}\n\n.ide-radio-wrapper-active.true[enabled='false']>.ide-radio-right-container>.ide-radio[checked] {\n    cursor: not-allowed;\n    color: ${e?"var(--vscode-disabledForeground)":n.borderColor};\n}\n\n.ide-radio-wrapper-active.true[enabled='false']>.ide-radio-right-container>.ide-radio[checked] .codicon{\n    cursor: not-allowed;\n    color: ${e?"var(--vscode-disabledForeground)":n.borderColor};\n}\n\n.ide-radio-left-container {\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    padding: 9px 0 9px 12px;\n}\n \n.ide-radio-wrapper.true>.ide-radio-left-container>.ide-radio-label {\n    width: 100px;\n    font-size: 14px;\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n    line-height: 20px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n \n.ide-radio-wrapper-active.true .ide-radio-left-container .ide-radio-label {\n    width: 100px;\n    font-size: 14px;\n    color: ${e?"var(--vscode-foreground)":n.titleFontColor};\n    line-height: 20px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n \n.ide-radio-wrapper.true:hover .ide-radio-left-container .ide-radio-label,\n.ide-radio-wrapper-active.true:hover .ide-radio-left-container .ide-radio-label {\n    color: ${e?"var(--vscode-foreground)":n.titleFontColor};\n}\n \n.ide-radio-wrapper.true .ide-radio-left-container .ide-radio-secondary-label,\n.ide-radio-wrapper-active.true .ide-radio-left-container .ide-radio-secondary-label {\n    width: 100px;\n    font-size: 12px;\n    color: ${e?"var(--vscode-disabledForeground)":n.secondaryFontColor};\n    line-height: 18px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n \n.ide-radio-wrapper.true>.ide-radio-right-container,\n.ide-radio-wrapper-active.true>.ide-radio-right-container {\n    display: flex;\n    margin: 20px 9px 20px 0;\n}\n \n.ide-radio-wrapper.true:hover .ide-radio-right-container .ide-radio,\n.ide-radio-wrapper-active.true:hover .ide-radio-right-container .ide-radio {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 50%;\n}\n \n.ide-radio-wrapper.true>.ide-radio-right-container>.ide-radio[checked],\n.ide-radio-wrapper-active.true[enabled='false']:hover .ide-radio-right-container .ide-radio[checked],\n.ide-radio-wrapper-active.true>.ide-radio-right-container>.ide-radio[checked] {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 50%;\n}\n\n.ide-radio-wrapper.true>.ide-radio-right-container>.ide-radio[checked] .codicon,\n.ide-radio-wrapper-active.true>.ide-radio-right-container>.ide-radio[checked] .codicon {\n    color: ${e?"var(--vscode-focusBorder)":n.primaryColor};\n}\n\n.ide-radio-wrapper-active.true[enabled='false']:hover {\n    background: ${e?"var(--vscode-checkbox-wrapper-background)":n.disbaledradioBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n}\n \n.ide-radio-wrapper.true>.ide-radio-right-container>.ide-radio,\n.ide-radio-wrapper-active.true>.ide-radio-right-container>.ide-radio {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    box-sizing: border-box;\n    cursor: pointer;\n    border-radius: 50%;\n    color: ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    outline: none;\n    height: 16px;\n    width: 16px;\n    border: none;\n}`},8391(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getButtonDropdownStyle=t.ButtonBarStyle=t.getButtonStyle=void 0;const n=i(6199);t.getButtonStyle=e=>`\n.ui-button {\n    background: ${e?"var(--vscode-button-background)":n.buttonBackgroundImage};\n\tbox-shadow: inset 0 1px 0 0 rgba(255, 255, 255, 0.08);\n\tborder-radius: ${n.radius.normal};\n    min-width: 72px;\n\tcolor: ${e?"var(--vscode-button-foreground)":"#ffffff"};\n\tfont-size: ${n.fontSize.buttonText};\n\tborder: 0;\n    text-align: center;\n    border: ${e?"1px solid var(--vscode-button-border, transparent)":n.primaryButtonBorder};\n}\n.ui-button:hover,\n.ui-button-focus:focus {\n\tbackground: ${e?"var(--vscode-button-hoverBackground)":n.primaryColorHover};\n\tbox-shadow: inset 0 1px 0 0 rgba(255, 255, 255, 0.08);\n}\n.ui-button:focus {\n    background: ${e?"var(--vscode-button-hoverBackground)":n.primaryColorHover};\n    outline-width: 2px;\n\toutline-style: solid;\n\toutline-offset: 2px;\n\toutline-color: ${e?"var(--vscode-button-focusBorder)":n.primaryButtonFocusBorderColor};\n\topacity: 1;\n}\n.ui-button:active {\n\tbackground: ${e?"var(--vscode-button-hoverBackground)":n.primaryColorClick};\n\tbox-shadow: inset 0 1px 0 0 rgba(255, 255, 255, 0.08);\n}\n.ui-button,\n.ui-secondary-button {\n    display: inline-block;\n    vertical-align: middle;\n    cursor: pointer;\n    margin-right: 16px;\n    height: 28px;\n    outline-width: 1px;\n    outline-style: solid;\n    outline-offset: 0px;\n    outline-color: transparent;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    overflow: hidden;\n\tpadding: 0 12px;\n    font-family: ${n.fontFamily};\n}\n.ui-secondary-button {\n    background: ${e?"var(--vscode-button-secondaryBackground)":n.secondaryButtonBackgroundImage};\n\tbox-shadow: inset 0 1px 0 0 rgba(255, 255, 255, 0.08);\n\tborder-radius: ${n.radius.normal};\n    color: ${n.titleFontColor};\n    min-width: 72px;\n\tfont-size: ${n.fontSize.buttonText};\n\tborder: ${e?"1px solid var(--vscode-button-border, transparent)":n.secondaryButtonBorder};\n}\n.ui-secondary-button:focus,\n.ui-secondary-button:hover {\n    background-color: ${e?"var(--vscode-button-secondaryHoverBackground)":n.secondaryButtonHoverBackgroundColor};\n\tbox-shadow: ${n.secondaryButtonHoverShadow};\n    background-image: ${e?"":n.secondaryButtonHoverBackgroundImage};\n    color: ${n.titleFontColor};\n}\n.ui-secondary-button:active {\n\tbackground-color: ${e?"var(--vscode-button-secondaryHoverBackground)":n.secondaryButtonActiveBackground};\n\tbackground-image: ${e?"":n.secondaryButtonActiveBackgroundImage};\n    var(--user-view-secondary-button-background-image-active, ${n.secondaryButtonActiveBackgroundImage});\n    color: ${n.secondaryButtonActiveColor};\n\tbox-shadow: inset 0 1px 0 0 rgba(255, 255, 255, 0.08);\n}\n.ui-button:disabled,\n.ui-button[disabled] {\n    box-shadow: none;\n\tbackground: ${e?"var(--vscode-button-background)":n.primaryColorDisabled};\n\tcolor: ${e?"var(--vscode-button-foreground)":n.disbaledButtonColor};\n\tcursor: not-allowed;\n    opacity: ${e?"0.4 !important":""};\n}\n.ui-secondary-button:disabled,\n.ui-secondary-button[disabled] {\n    box-shadow: none;\n\tbackground: ${e?"var(--vscode-button-secondaryBackground)":n.disabledBackgroundColorCode};\n    color: ${n.disabledFontColor};\n\tcursor: not-allowed;\n    opacity: ${e?"0.4 !important":""};\n}\n.ui-button.ui-danger-button {\n    background: ${e?"var(--vscode-testing-iconErrored)":n.dangerButtonBackgroundImage};\n}\n.ui-button.ui-danger-button:focus,\n.ui-button.ui-danger-button:hover {\n    background: ${n.dangerButtonHoverBackground};\n    box-shadow : inset 0 1px 0 0 rgba ( 255,255,255,0.08 );\n}\n.ui-button.ui-danger-button:active {\n    background: ${n.dangerButtonClickBackground};\n    box-shadow : inset 0 1px 0 0 rgba ( 255,255,255,0.08 );\n}\n.ui-button.ui-danger-button:disabled,\n.ui-button.ui-danger-button[disabled] {\n    box-shadow: none;\n    background: ${e?"var(--vscode-testing-iconErrored)":n.dangerButtonDisabledBackground};\n\tcolor: ${e?"var(--vscode-button-foreground)":n.dangerButtonDisabledColor};\n    opacity: ${e?"0.4 !important":""};\n\tcursor: not-allowed;\n}\n.ui-secondary-button.ui-danger-button {\n    background: ${n.dangerSecondaryButtonBackground};\n    color: #F66F6A;\n    border: ${n.dangerSecondaryButtonBorder};\n}\n.ui-secondary-button.ui-danger-button:focus,\n.ui-secondary-button.ui-danger-button:hover {\n    background: ${n.dangerSecondaryButtonBackHoverground};\n    color: ${n.dangerSecondaryButtonHoverColor};\n    border: ${n.dangerSecondaryButtonHoverBorder};\n    box-shadow : inset 0 1px 0 0 rgba ( 255,255,255,0.08 );\n}\n.ui-secondary-button.ui-danger-button:active {\n    color: ${n.dangerSecondaryButtonClickColor};\n    background: ${n.dangerSecondaryButtonClickBackground};\n    border: ${n.dangerSecondaryButtonClickBorder};\n    box-shadow : inset 0 1px 0 0 rgba ( 255,255,255,0.08 );\n}\n.ui-secondary-button.ui-danger-button:disabled,\n.ui-secondary-button.ui-danger-button[disabled] {\n    box-shadow: none;\n    background: ${n.dangerSecondaryButtonDisabledBackground};\n    color: ${n.dangerSecondaryButtonDisabledColor};\n    border: ${n.dangerSecondaryButtonDisabledBorder};\n\tcursor: not-allowed;\n}\n.ui-button-focus {\n    margin-bottom: 8px;\n}\n.ui-button-label {\n    display: inline-block;\n}\n.ui-button-small.ui-button-focus {\n    margin-bottom: 8px;\n}\n.codicon {\n    margin: 0px 4px 0px 0px;\n    vertical-align: text-bottom;\n}\n.ui-button-description {\n    text-align: center;\n}\n.ui-button-description {\n    font-style: italic;\n    margin-top: 4px;\n}\n.ui-button-dropdown-button {\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n.ui-button-small {\n    padding: 0 8px;\n    min-width: 64px;\n    height: 24px;\n}\n.ui-button-dropdown-icon {\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n    padding-left: 4px;\n    padding-right: 4px;\n    min-width: 0;\n}\n.ui-button-block {\n    width: 100%;\n    margin: 0;\n}\n.ui-button-maxWidth .ui-button-label,\n.ui-button-block .ui-button-label {\n    display: inline;\n}\n.ui-button-description-wrapper {\n    height: 100%;\n}\n.ui-button-dropdown,\n.ui-button-without-margin {\n    margin: 0;\n}\n.clear-margin-right {\n    margin-right: 0;\n}\n`,t.ButtonBarStyle="\n.ui-button-bar {\n    width: 100%;\n    display: flex;\n    justify-content: flex-start;\n    flex-wrap: wrap;\n    overflow: hidden;\n    align-items: center;\n}\n.ui-button-bar.ui-button-not-warp {\n    flex-wrap: nowrap;\n}\n",t.getButtonDropdownStyle=e=>`\n.ui-button-dropdown {\n    display: flex;\n    align-items: flex-end;\n\tborder-radius: ${n.radius.normal};\n}\n.ide-button-dropdown-separator {\n    box-sizing: border-box;\n    display: inline-block;\n    vertical-align: middle;\n    background: ${e?"var(--vscode-button-background)":n.buttonBackgroundImage};\n    padding: 4px 0;\n}\n.ui-secondary-button .ide-button-dropdown-separator {\n    background: ${e?"var(--vscode-button-background)":n.secondaryButtonBackgroundImage};\n    padding: 4px 0;\n}\n.ide-button-dropdown-separator.ide-button-small {\n    height: 24px;\n}\n.ide-button-dropdown-separator.ide-button-default {\n    height: 28px;\n}\n.ide-button-dropdown-separator.disabled {\n    background: ${e?"var(--vscode-button-background)":n.primaryColorDisabled};\n    opacity: ${e?"0.4 !important":""};\n}\n.ui-dropdown-split {\n    width: 1px;\n    height: 100%;\n    background: rgba(255, 255, 255, 0.4);\n}\n.ui-secondary-button .ui-dropdown-split {\n    background: rgba(255, 255, 255, 0.1);\n}\n.ui-button-dropdown-block {\n    flex-grow:1;\n}\n`},8414(e,t,i){var n=i(1033),o=i(2550),s=o;s.v1=n,s.v4=o,e.exports=s},8565(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getMessageStyles=t.getInputBoxStyles=void 0;const n=i(6199);t.getInputBoxStyles=e=>`\n    :host {\n        width: 100%;\n        display: inline-block;\n    }\n    .ide-inputbox,\n    .ide-inputbox * {\n        box-sizing: border-box;\n        font-family: ${n.fontFamily};\n    }\n    \n    .ide-inputbox input[type=number]::-webkit-inner-spin-button, \n    .ide-inputbox input[type=number]::-webkit-outer-spin-button { \n        -webkit-appearance: none;\n        margin: 0; \n    }\n    .ide-inputbox input[type=number] {\n        -moz-appearance: textfield;\n    }\n    \n    .ide-inputbox {\n        display: inline-flex;\n        width: 100%;\n        color: ${e?"var(--vscode-input-foreground)":n.inputBoxLabelColor};\n    }\n    \n    .ide-inputbox.medium {\n        font-size: 12px;\n    }\n    \n    .ide-inputbox.vertical {\n        flex-direction: column;\n    }\n    \n    .ide-inputbox.vertical > label {\n        margin-bottom: 8px;\n    }\n    \n    .ide-inputbox.horizontal > label {\n        margin-right: 8px;\n    }\n    \n    .ide-inputbox > label.required.prefix::before {\n        display: inline-block;\n        margin-right: 4px;\n        color: ${e?"var(--vscode-testing-iconErrored)":n.errorStatusColor};\n        font-size: 12px;\n        font-family: SimSun,sans-serif;\n        line-height: 1;\n        content: "*";\n        position: absolute;\n        left: -10px\n    }\n    \n    .ide-inputbox > label.required.suffix::after {\n        display: inline-block;\n        margin-right: 4px;\n        color: ${e?"var(--vscode-testing-iconErrored)":n.errorStatusColor};\n        font-size: 12px;\n        font-family: SimSun,sans-serif;\n        line-height: 1;\n        content: "*";\n        margin-left: 4px;\n    }\n    \n    .ide-inputbox.horizontal {\n        flex-direction: row;\n        align-items: center;\n    }\n    \n    .ide-inputbox > label {\n        display: inline-flex;\n        align-items: center;\n        position: relative;\n    }\n    \n    .ide-inputbox > label > span {\n        overflow: hidden;\n        text-overflow: ellipsis;\n        white-space: nowrap;\n        display: inline-block;\n\t\tfont-size: 12px;\n    }\n    \n    .ide-inputbox > .input-wrapper {\n        position: relative;\n        width: 100%;\n        color: ${e?"var(--vscode-input-foreground)":""};\n        background-color: ${e?"var(--vscode-input-background)":n.inputBoxBackground};\n        border-radius: ${n.radius.normal};\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-dropdown-border)":n.inputBoxBorderColor};\n    }\n\n    .ide-inputbox.small > .input-wrapper {\n        height: 24px;\n    }\n    \n    .ide-inputbox.medium > .input-wrapper {\n        height: 28px;\n    }\n    \n    .ide-inputbox.large > .input-wrapper {\n        height: 32px;\n    }\n    \n    .ide-inputbox > .input-wrapper > input,\n    .ide-inputbox > .input-wrapper > textarea {\n        width: 100%;\n\t\theight: 100%;\n        padding: 5px;\n        color: ${e?"var(--vscode-input-foreground)":n.inputBoxTextColor};\n        border-radius: ${n.radius.normal};\n        background-color: transparent;\n        border: none;\n\t\tfont-size: 13px;\n\t\toutline: none !important;\n    }\n    \n    .ide-inputbox > .input-wrapper.suggest > input,\n    .ide-inputbox > .input-wrapper.suggest > textarea {\n        position: absolute;\n        top: 0;\n        left: 0;\n        z-index: 99;\n    }\n    \n    .ide-inputbox > .input-wrapper > textarea {\n\t\tline-height: 18px;\n        -ms-overflow-style: none;\n        scrollbar-width: none;\n\t    resize: none;\n    }\n    \n    .ide-inputbox > .input-wrapper > input::placeholder,\n    .ide-inputbox > .input-wrapper > textarea::placeholder {\n        color: ${e?"var(--vscode-input-placeholderForeground)":n.inputBoxPlaceholderTextColor};\n    }\n    \n    .ide-inputbox:not(.synthetic-focus) > .input-wrapper:not(.disabled):hover {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-focusBorder)":n.inputBoxBorderHoverColor};\n    }\n    \n    .ide-inputbox.synthetic-focus > .input-wrapper {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-focusBorder)":n.inputBoxBorderFocusColor};\n    }\n    \n    .ide-inputbox.info > .input-wrapper {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-inputValidation-infoBorder, transparent)":n.inputBoxBorderFocusColor};\n    }\n    \n    .ide-inputbox.error > .input-wrapper,\n    .ide-inputbox.error > .input-wrapper:hover,\n    .ide-inputbox.error:not(.synthetic-focus) > .input-wrapper:hover {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.inputBoxErrorBorderColor};\n    }\n    \n    .ide-inputbox.warning > .input-wrapper,\n    .ide-inputbox.warning > .input-wrapper:hover,\n    .ide-inputbox.warning:not(.synthetic-focus) > .input-wrapper:hover {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-inputValidation-warningBorder, transparent)":n.inputBoxWarningBorderColor};\n    }\n    \n    .ide-inputbox.success > .input-wrapper,\n    .ide-inputbox.success > .input-wrapper:hover,\n    .ide-inputbox.success:not(.synthetic-focus) > .input-wrapper:hover {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-testing-iconPassed, transparent)":n.inputBoxSuccessBorderColor};\n    }\n    \n    .ide-inputbox > .input-wrapper > .status-message {\n        display: inline-block;\n        overflow: hidden;\n        text-overflow: ellipsis;\n        font-size: 12px;\n        line-height: 18px;\n        margin: 4px 0;\n        text-align: left;\n    }\n    \n    .ide-inputbox.info > .input-wrapper > .status-message {\n        color: ${e?"var(--vscode-inputValidation-infoBorder, transparent)":n.inputBoxTextColor};\n    }\n    \n    .ide-inputbox.warning > .input-wrapper > .status-message {\n        color: ${e?"var(--vscode-inputValidation-warningBorder, transparent)":n.inputBoxWarningBorderColor};\n    }\n    \n    .ide-inputbox.error > .input-wrapper > .status-message {\n        color: ${e?"var(--vscode-inputValidation-errorBorder, transparent)":n.inputBoxErrorBorderColor};\n    }\n    \n    .ide-inputbox.success > .input-wrapper > .status-message {\n        color: ${e?"var(--vscode-testing-iconPassed)":n.inputBoxSuccessBorderColor};\n    }\n\n    .ide-inputbox > .input-wrapper .mirror {\n        position: absolute;\n        display: inline-block;\n        width: 100%;\n        padding: 5px;\n        top: 0;\n        left: 0;\n        box-sizing: border-box;\n        white-space: pre-wrap;\n        visibility: hidden;\n        word-wrap: break-word;\n        font-size: 13px;\n        line-height: 18px;\n    }\n\t  \n    .ide-inputbox > .input-wrapper > input.input-control + .suggest-container {\n        padding-top: 6px;\n    }\n\t  \n    .ide-inputbox > .input-wrapper > .suggest-container {\n        position: absolute;\n        display: inline-block;\n        width: 100%;\n        height: 100%;\n        padding: 5px;\n        line-height: 18px;\n        top: 0;\n        left: 0;\n        z-index: -1;\n        font-size: 13px;\n        color: ${e?"var(--vscode-input-foreground)":n.inputBoxLabelColor};\n    }\n\t  \n    .ide-inputbox > .input-wrapper.suggest > .suggest-container {\n        z-index: 98;\n    }\n    \n    .ide-inputbox > .input-wrapper > .suggest-container > .suggestion-hidden {\n        opacity: 0;\n    }\n    \n    .ide-inputbox > .input-wrapper > .suggest-container > .suggestion-visible {\n        opacity: 0.6;\n    }\n\n    .ide-inputbox > .input-wrapper > textarea::-webkit-scrollbar {\n        display: none;\n    }\n    \n    .ide-inputbox > .input-wrapper.disabled {\n        outline-width: 1px;\n        outline-style: solid;\n        outline-offset: -1px;\n        outline-color: ${e?"var(--vscode-dropdown-border)":n.inputBoxDisabledBorderColor};\n    }\n    \n    .ide-inputbox > .input-wrapper > input[disabled],\n    .ide-inputbox > .input-wrapper > textarea[disabled] {\n        background-color: ${e?"var(--vscode-input-background)":n.inputBoxDisabledBackground};\n        border-color: ${e?"var(--vscode-dropdown-border, transparent)":n.inputBoxDisabledBorderColor};\n        cursor: not-allowed;\n    }\n    \n     .ide-inputbox.medium > .input-wrapper.has-message {\n        margin-bottom: 24px;\n     }\n    \n    .ide-inputbox > .input-wrapper.prefix > .input-control {\n        padding-left: 32px;\n    }\n    \n    .ide-inputbox > .input-wrapper.suffix > .input-control {\n        padding-right: 32px;\n    }\n    \n    .ide-inputbox.medium > .input-wrapper .codicon {\n        width: 26px;\n        height: 26px;\n        line-height: 26px;\n        padding: 0 5px;\n    }\n    \n    .ide-inputbox.large > .input-wrapper .codicon {\n        width: 30px;\n        height: 30px;\n        line-height: 30px;\n        padding: 0 7px;\n    }\n    \n     .ide-inputbox.small > .input-wrapper .codicon {\n        width: 22px;\n        height: 22px;\n        line-height: 22px;\n        padding: 0 3px;\n    }\n    \n    .ide-inputbox > .input-wrapper > .prefix-icon {\n        left: 1px;\n    }\n    \n    .ide-inputbox > .input-wrapper > .suffix-icon {\n        right: 1px;\n    }\n    \n    .ide-inputbox > .input-wrapper > .prefix-icon,\n    .ide-inputbox > .input-wrapper > .suffix-icon {\n        display: inline-block;\n        cursor: pointer;\n        position: absolute;\n        top: 1px;\n    }\n    .ide-inputbox {\n        position: relative;\n    }\n    .ide-inputbox .limit {\n        position: absolute;\n        right: 1px;\n        bottom: -24px;\n        line-height: 24px;\n    }\n    .ide-inputbox.small > .input-wrapper .codicon-chevron-down {\n        height: 12px;\n        line-height: 12px;\n    }\n    .ide-inputbox.small > .input-wrapper .codicon-chevron-up {\n        height: 12px;\n        line-height: 12px;\n    }\n    .ide-inputbox.medium > .input-wrapper .codicon-chevron-down {\n        height: 14px;\n        line-height: 14px;\n    }\n    .ide-inputbox.medium > .input-wrapper .codicon-chevron-up {\n        height: 14px;\n        line-height: 14px;\n    }\n    .ide-inputbox.large > .input-wrapper .codicon-chevron-down {\n        height: 16px;\n        line-height: 16px;\n    }\n    .ide-inputbox.large > .input-wrapper .codicon-chevron-up {\n        height: 16px;\n        line-height: 16px;\n    }\n    .ide-inputbox.small > .input-wrapper > .icon-chevron-up {\n        top: -3px;\n        height: 12px;\n    }\n    .ide-inputbox.small > .input-wrapper > .icon-chevron-down {\n        top: -3px;\n        height: 12px;\n        margin-top: 12px;\n    }\n    .ide-inputbox.medium > .input-wrapper > .icon-chevron-up {\n        top: 1px;\n        height: 14px;\n    }\n    .ide-inputbox.medium > .input-wrapper > .icon-chevron-down {\n        top: 1px;\n        height: 14px;\n        margin-top: 14px;\n    }\n    .ide-inputbox.large > .input-wrapper > .icon-chevron-up {\n        top: -1px;\n        height: 16px;\n    }\n    .ide-inputbox.large > .input-wrapper > .icon-chevron-down {\n        top: 1px;\n        height: 16px;\n        margin-top: 16px;\n    }\n`,t.getMessageStyles=e=>`\n    #ide-context-view-inputBox {\n        color: ${e?"var(--vscode-foreground)":""};\n    } \n    .message {\n        font-size: 12px;\n        line-height: 18px;\n        text-align: left;\n        box-sizing: border-box;\n        padding: 4px;\n        word-break: break-all;\n        position: relative;\n        top: -1px;\n        color: ${e?"var(--vscode-inputValidation-infoForeground)":n.titleFontColor};\n        border: 1px solid ${e?"var(--vscode-inputValidation-infoBorder, transparent)":n.borderColor};\n        background: ${e?"var(--vscode-inputValidation-infoBackground)":n.inputMessageBgColor};\n        border-radius: ${n.radius.normal};\n    }\n    \n    .message p {\n        margin: 0;\n        padding: 0;\n    }\n    \n    .message.warning {\n        color: ${e?"var(--vscode-input-foreground)":"#fff"};\n        border-color: ${e?"var(--vscode-inputValidation-warningBorder, transparent)":"rgba(255, 255, 255, 0.24)"};\n    }\n    .message.error {\n        color: ${e?"var(--vscode-inputValidation-errorForeground)":"#fff"};\n        border-color: ${e?"var(--vscode-inputValidation-errorBorder, transparent)":"rgba(255, 255, 255, 0.24)"};\n    }\n    .message.warning,\n    .message.warning .pointer:after {\n       background: ${e?"var(--vscode-inputValidation-warningBackground)":n.inputMessageWarnBgColor}; \n    }\n    .message.error,\n    .message.error .pointer:after {\n       background: ${e?"var(--vscode-inputValidation-errorBackground)":n.inputMessageErrorBgColor}; \n    }\n    .message.success,\n    .message.success .pointer:after {\n       background: ${e?"var(--vscode-testing-iconPassed)":n.inputBoxSuccessBorderColor};\n       border-color: ${e?"var(--vscode-testing-iconPassed)":""};\n    }\n    .message .pointer {\n        position: absolute;\n        z-index: 41;\n        pointer-events: none;\n        top: -4px;\n        left: 50%;\n        transform: translateX(-50%);\n    }\n\n    .message .pointer:after {\n        content: '';\n        position: absolute;\n        width: 5px;\n        height: 5px;\n        background: ${e?"var(--vscode-inputValidation-infoBackground)":n.inputMessageBgColor};\n        transform: rotate(135deg);\n        border-left: 1px solid ${e?"var(--vscode-inputValidation-infoBorder)":n.borderColor};\n        border-bottom: 1px solid ${e?"var(--vscode-inputValidation-infoBorder)":n.borderColor};\n    }\n    \n    .message.warning .pointer:after,\n    .message.error .pointer:after {\n        border-color: rgba(255, 255, 255, 0.24);\n    }\n    \n    .message .pointer.left:after {\n        transform: rotate(135deg);\n    }\n    \n    .message .pointer.right:after {\n        transform: rotate(315deg);\n    }\n    \n    .message .pointer.top:after {\n        transform: rotate(225deg);\n    }\n    \n    .message .pointer.bottom:after {\n        transform: rotate(45deg);\n    }\n`},8614(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.HistoryNavigator=t.ArrayNavigator=void 0;class i{constructor(e,t=0,i=e.length,n=t-1){this.items=e,this.start=t,this.end=i,this.index=n}current(){return this.index===this.start-1||this.index===this.end?null:this.items[this.index]}next(){return this.index=Math.min(this.index+1,this.end),this.current()}previous(){return this.index=Math.max(this.index-1,this.start-1),this.current()}first(){return this.index=this.start,this.current()}last(){return this.index=this.end-1,this.current()}}t.ArrayNavigator=i,t.HistoryNavigator=class{constructor(e=[],t=10){this._initialize(e),this._limit=t,this._onChange()}getHistory(){return this._elements}add(e){this._history.delete(e),this._history.add(e),this._onChange()}next(){return this._currentPosition()!==this._elements.length-1?this._navigator.next():null}previous(){return 0!==this._currentPosition()?this._navigator.previous():null}current(){return this._navigator.current()}first(){return this._navigator.first()}last(){return this._navigator.last()}has(e){return this._history.has(e)}clear(){this._initialize([]),this._onChange()}_onChange(){this._reduceToLimit();const e=this._elements;this._navigator=new i(e,0,e.length,e.length)}_reduceToLimit(){const e=this._elements;e.length>this._limit&&this._initialize(e.slice(e.length-this._limit))}_currentPosition(){const e=this._navigator.current();return e?this._elements.indexOf(e):-1}_initialize(e){this._history=new Set(e)}get _elements(){return Array.from(this._history)}}},8653(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getBadgeStyle=t.Badge=t.BadgeType=void 0;const n=i(9084),o=i(2925),s=i(6199),r=i(8784),a=i(5754),l=i(5354);var d;(d=t.BadgeType||(t.BadgeType={})).DEFAULT="info",d.WARNING="warning",d.SUCCESS="success",d.ERROR="error";const c=e=>{const t=Number(e);return t>1&&t<1e4?`${t}`:t>9999?Math.round(t/1e3).toFixed(0)+"k":`${t}`};class u extends n.BaseComponent{constructor(e){super(),this.showCount=Number(this.getAttribute("count")),this.titleFormat=this.getAttribute("title")||"",this.countFormat=this.getAttribute("countFormat")||"",this.maxWidth=Number(this.getAttribute("maxWidth")),this.flexible="true"===this.getAttribute("flexible"),this.hide="true"===this.getAttribute("hidden"),this.showDot="true"===this.getAttribute("dot"),this.statusType=this.getAttribute("type"),this.iconClass=this.getAttribute("iconClass")||"",this.showZero="true"===this.getAttribute("showZero"),this.container=this.firstElementChild,this.initOptions(e),this.badge=document.createElement("span");const i=document.createElement("style");i.appendChild(document.createTextNode((0,t.getBadgeStyle)(l.ideChecker.isIDE))),this.badge.classList.add(u.PREFIX),this.badgeCount=document.createElement("span"),this.displayCount=c(this.showCount),this.countFormat=this.countFormat||"{0}",this.titleFormat=this.titleFormat||"",this.maxWidth=this.maxWidth||42,this.renderBody(),this.badge.appendChild(this.badgeCount),this.shadow.appendChild(i),this.shadow.appendChild(this.badge)}initOptions(e){var t,i,n,o,s,r,a;e&&("number"==typeof e.count&&(this.showCount=e.count),this.statusType=e.type,this.container=e.container,this.hide=e.hidden||!1,this.countFormat=null!==(t=e.countFormat)&&void 0!==t?t:"",this.titleFormat=null!==(i=e.titleFormat)&&void 0!==i?i:"",this.flexible=null!==(n=e.flexible)&&void 0!==n&&n,this.maxWidth=null!==(o=e.maxWidth)&&void 0!==o?o:42,this.showDot=null!==(s=e.dot)&&void 0!==s&&s,this.iconClass=null!==(r=e.iconClass)&&void 0!==r?r:"",this.showZero=null!==(a=e.showZero)&&void 0!==a&&a)}renderBody(){"number"==typeof this.showCount&&this.setCount(this.showCount),this.setCountFormat(this.countFormat),this.setDot(this.showDot),this.setDisplay(this.hide),this.setMaxWidth(this.maxWidth),this.statusType&&this.badgeCount.setAttribute("type",this.statusType),this.container&&(this.badgeCount.classList.add(`${u.PREFIX}-offset`),this.badge.appendChild(this.container)),this.iconClass&&this.setIcon(this.iconClass)}get element(){return this.badge}get type(){return this.badgeCount.getAttribute("type")}setType(e){e&&this.badgeCount.setAttribute("type",e)}get dot(){return Boolean(this.badgeCount.getAttribute("dot"))}setDot(e){this.showCount&&this.countFormat||this.showZero||(!0!==e&&"true"!==e||this.badgeCount.classList.add(`${u.PREFIX}-status-dot`),!1!==e&&"false"!==e||this.badgeCount.textContent||this.badgeCount.classList.remove(`${u.PREFIX}-status-dot`),this.badgeCount.classList.remove(`${u.PREFIX}-count`),this.badgeCount.setAttribute("dot",String(e)),this.badgeCount.removeAttribute("count"))}setMaxWidth(e){this.badgeCount.setAttribute("flexible",String(this.flexible)),e&&!this.flexible&&(this.maxWidth=e,this.badgeCount.setAttribute("maxWidth",String(this.maxWidth)),this.badgeCount.style.maxWidth=this.maxWidth+"px")}render(){this.displayCount=c(this.showCount);const e=(0,o.format)(this.countFormat,this.displayCount);"0"!==e||this.showZero?(this.setDisplay(this.hide),this.badgeCount.textContent=e):this.setDisplay(!0),this.iconClass&&this.badgeCount.classList.remove(...this.iconClass.split(" ")),this.badgeCount.classList.add(`${u.PREFIX}-count`),this.badgeCount.classList.remove(`${u.PREFIX}-status-dot`),this.badgeCount.setAttribute("dot","false"),this.renderTitle()}renderTitle(){this.titleFormat&&(this.hover&&this.hover.dispose(),this.hover=r.Hover.setupIconLabelHover({content:this.titleFormat,target:this.badgeCount,hoverPosition:r.HoverPosition.BELOW,showPointer:!1}))}setIcon(e){this.badgeCount.textContent&&(this.badgeCount.textContent="",this.badgeCount.removeAttribute("countFormat"),this.badgeCount.removeAttribute("count")),this.iconClass=e,(0,a.addIconStylebyClass)(e,this.shadow),this.badgeCount.classList.add(...this.iconClass.split(" ")),this.badgeCount.classList.add(`${u.PREFIX}-icon`),this.badgeCount.classList.remove(`${u.PREFIX}-count`)}setCount(e){this.showCount=e,this.badgeCount.setAttribute("count",String(this.showCount)),this.render()}setCountFormat(e){this.countFormat=""===e?"{0}":e,this.badgeCount.setAttribute("countFormat",this.countFormat),this.render()}setTitleFormat(e){this.titleFormat=e,this.renderTitle()}setDisplay(e){this.badgeCount.setAttribute("hidden",String(e)),this.badgeCount.classList.toggle(`${u.PREFIX}-count-hidden`,e)}dispose(){var e;null===(e=this.hover)||void 0===e||e.dispose()}}t.Badge=u,u.PREFIX="ui-badge",t.getBadgeStyle=e=>`\n.ui-badge {\n    box-sizing: border-box;\n    font-family: ${s.fontFamily};\n    margin: 0;\n    padding: 0;\n    font-size: 14px;\n    line-height: 1;\n    position: relative;\n    display: inline-flex;\n    align-items: center;\n}\n\n.ui-badge-offset {\n    position: absolute;\n    top: 0;\n    right: 0;\n    transform: translate(50%, -50%);\n    transform-origin: 100% 0%;\n}\n\n.ui-badge-count {\n    box-sizing: border-box;\n    display: inline-block;\n    min-width: 16px;\n    height: 16px;\n    padding: 0px 4px;\n    color: ${e?"var(--vscode-badge-foreground)":s.secondaryFontColor};\n    font-weight: 400;\n    font-size: 12px;\n    text-align: center;\n    line-height: 16px;\n    background: ${e?"var(--vscode-badge-background)":s.badgeBackground};\n    border: ${e?"1px solid var(--vscode-contrastBorder)":""};\n    border-radius: 8px;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.codicon.ui-badge-icon[class*='codicon-'] {\n    display: inline-flex;\n    width: 16px;\n    height: 16px;\n    justify-content: center;\n    align-items: center;\n    background: ${s.infoStatusColor};\n    border-radius: 8px;\n}\n\n.codicon::before {\n    color: #fff;\n    font-size: 12px;\n}\n\n.ui-badge-status-dot {\n    display:inline-block;\n    width: 6px;\n    min-width: 6px;\n    height: 6px;\n    background: ${e?"var(--vscode-editorInfo-foreground)":s.errorStatusColor};\n    border-radius: 100%;\n}\n\n.ui-badge-count[type] {\n    color: #fff;\n}\n\n.ui-badge-count[type=info],\n.ui-badge-status-dot[type=info] {\n    background: ${e?"var(--vscode-editorInfo-foreground)":s.infoStatusColor};\n}\n\n.ui-badge-count[type=error],\n.ui-badge-status-dot[type=error] {\n    background: ${e?"var(--vscode-testing-iconErrored)":s.errorStatusColor};\n}\n\n.ui-badge-count[type=warning],\n.ui-badge-status-dot[type=warning] {\n    background: ${e?"var(--vscode-editorWarning-foreground)":s.warnStatusColor};\n}\n\n.ui-badge-count[type=success],\n.ui-badge-status-dot[type=success] {\n    background: ${e?"var(--vscode-testing-iconPassed)":s.successStatusColor};\n}\n\n.codicon.ui-badge-count-hidden[class*='codicon-'],\n.ui-badge-count-hidden {\n    display: none;\n}\n`,(0,n.defineCustomElement)("ide-badge",u)},8784(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.Hover=t.HoverAction=t.HoverWidget=t.HoverStatus=t.HoverPosition=void 0;const o=i(9084),s=i(7953),r=i(308),a=i(3145),l=i(9483),d=i(5731),c=i(4835),u=i(5354);var h,p;!function(e){e[e.LEFT=0]="LEFT",e[e.RIGHT=1]="RIGHT",e[e.BELOW=2]="BELOW",e[e.ABOVE=3]="ABOVE"}(h=t.HoverPosition||(t.HoverPosition={})),function(e){e[e.INFO=0]="INFO",e[e.WARNING=1]="WARNING",e[e.ERROR=2]="ERROR"}(p=t.HoverStatus||(t.HoverStatus={}));class b extends o.BaseComponent{constructor(e){var t,i,n;super(),this.options=e,this._viewId="ide-context-view-hover",this.x=-1,this.y=-1,this.eventStore=new Set,this.dispose=()=>{this.target.dispose&&this.target.dispose(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.eventStore.clear(),this.disconnectedCallback()},this._viewId=null!==(t=e.customViewId)&&void 0!==t?t:this._viewId,this.target="targetElements"in e.target?e.target:{targetElements:[e.target]},this.hoverPosition=null!==(i=e.hoverPosition)&&void 0!==i?i:h.ABOVE,this.forcePosition=null!==(n=e.forcePosition)&&void 0!==n&&n;const o=(0,c.createElement)("div");switch(o.style.overflow="hidden",this.hoverContent=(0,c.createElement)(".ide-hover-content"),this.hoverContent.style.height="100%",this.hoverContentWrapper=new l.DomScrollableElement(this.hoverContent,{horizontal:d.ScrollbarVisibility.Auto,vertical:d.ScrollbarVisibility.Auto}),o.appendChild(this.hoverContentWrapper.getDomNode()),this.linkHandler=this.options.linkHandler,this.createContent(),this.hoverContainer=(0,c.createElement)(".ide-hover"),e.showPointer&&(this.hoverPointer=(0,c.createElement)(".ide-hover-pointer"),this.hoverContainer.appendChild(this.hoverPointer)),this.hoverContainer.appendChild(o),this.createStatusBarActions(),e.compact&&this.hoverContent.classList.add("compact"),e.status){case p.WARNING:this.hoverContainer.classList.add("warning");break;case p.ERROR:this.hoverContainer.classList.add("error")}this.hoverContainer.classList.add(e.skipFadeInAnimation?"skip-fade-in":"fade-in"),this.shadow.append((0,c.createStyles)((0,s.getHoverStyle)(u.ideChecker.isIDE)),this.hoverContainer),this.showContextView()}createContent(){const e=this.options.content,t=(0,c.createElement)(".content");if(e instanceof HTMLElement)t.append(e),t.classList.add("html-hover-contents");else if("string"==typeof e)t.textContent=e;else if("object"==typeof e&&e.value){t.classList.add("markdown-contents");const i=e,n=(0,a.renderMarkdown)(i,{actionHandler:{callback:e=>{this.linkHandler&&this.linkHandler(e)},disposables:this.eventStore},shadowRoot:this.shadow});t.append(n)}this.hoverContent.appendChild(t)}createStatusBarActions(){if(!this.options.actions||!this.options.actions.length)return;const e=(0,c.createElement)(".actions");this.options.forceActionsLeftAlign&&e.classList.add("force-left-align"),this.options.actions.forEach(t=>{g.render(e,{label:t.label,commandId:t.commandId,run:e=>{t.run(e),this.dispose()},iconClass:t.iconClass})}),this.statusBarElement=(0,c.createElement)(".hover-row.status-bar",void 0,e),this.hoverContent.appendChild(this.statusBarElement)}showContextView(){r.ContextView.showContextView({getAnchor:()=>{const e="number"==typeof window.scrollX?window.scrollX:document.body.scrollLeft+document.documentElement.scrollLeft,t="number"==typeof window.scrollY?window.scrollY:document.body.scrollTop+document.documentElement.scrollTop;return{x:this.x+e,y:this.y+t}},render:e=>{e.appendChild(this.shadow),this.layout()},anchorPosition:()=>this.hoverPosition===h.BELOW?r.AnchorPosition.BELOW:r.AnchorPosition.ABOVE,customViewId:this._viewId,upperLayer:this.options.upperLayer})}get viewId(){return this._viewId}layout(){const e=e=>{var t;let i=e,n=1;const o=null===(t=document.defaultView)||void 0===t?void 0:t.getComputedStyle(i,null);do{const e=o.zoom;e&&"1"!==e&&(n*=e),i=i.parentElement}while(i&&i!==document.documentElement);const s=e.getBoundingClientRect(),r={top:s.top,bottom:s.bottom,right:s.right,left:s.left},a=o.padding.match(/\d(?=px){0,4}/g);return(null==a?void 0:a.length)>3&&(this.hoverPosition!==h.LEFT&&this.hoverPosition!==h.RIGHT||(r.top+=parseInt(a[0]),r.bottom-=parseInt(a[2])),this.hoverPosition!==h.ABOVE&&this.hoverPosition!==h.BELOW||(r.right-=parseInt(a[1]),r.left+=parseInt(a[3]))),{top:r.top*n,bottom:r.bottom*n,right:r.right*n,left:r.left*n}},t=this.target.targetElements.map(t=>e(t)),i=Math.min(...t.map(e=>e.top)),n=Math.max(...t.map(e=>e.right)),o=Math.max(...t.map(e=>e.bottom)),s=Math.min(...t.map(e=>e.left)),r=n-s,a=o-i,l={top:i,right:n,bottom:o,left:s,width:r,height:a,center:{x:s+r/2,y:i+a/2}};if(this.adjustHoverPosition(l),this.setHoverBoundary(l),this.hoverPointer){switch(this.hoverPosition){case h.RIGHT:l.left+=m.PointerSize,l.right+=m.PointerSize;break;case h.LEFT:l.left-=m.PointerSize,l.right-=m.PointerSize,this.hoverContentWrapper.getDomNode().style.marginRight=`${m.PointerSize}px`;break;case h.BELOW:l.top+=m.PointerSize,l.bottom+=m.PointerSize;break;case h.ABOVE:l.top-=m.PointerSize,l.bottom-=m.PointerSize}l.center.x=l.left+r/2,l.center.y=l.top+a/2}this.computeXCordinate(l),this.computeYCordinate(l),this.hoverPointer&&(this.hoverPointer.classList.remove("top"),this.hoverPointer.classList.remove("left"),this.hoverPointer.classList.remove("right"),this.hoverPointer.classList.remove("bottom")),this.setHoverPointerPosition(l),this.hoverContentWrapper.scanDomNode()}computeXCordinate(e){const t=this.hoverContainer.clientWidth+m.HoverBorderWidth;void 0!==this.target.x?this.x=this.target.x:this.hoverPosition===h.RIGHT?this.x=e.right+(this.hoverPointer?2:1):this.hoverPosition===h.LEFT?this.x=e.left-t-(this.hoverPointer?2:0):this.x=this.hoverPointer?e.center.x-t/2:e.left,this.x+t>=document.documentElement.clientWidth&&(this.hoverContainer.classList.add("right-aligned"),this.x=Math.max(document.documentElement.clientWidth-t-m.HoverWindowEdgeMargin,document.documentElement.clientLeft)),this.x<document.documentElement.clientLeft&&(this.x=m.HoverWindowEdgeMargin)}computeYCordinate(e){const t=this.hoverContainer.clientHeight+m.HoverBorderWidth;void 0!==this.target.y?this.y=this.target.y+t/2:this.hoverPosition===h.ABOVE?this.y=e.top-(this.hoverPointer?2:1):this.hoverPosition===h.BELOW?e.bottom+t+m.HoverBorderWidth+m.PointerSize<document.documentElement.clientHeight?this.y=e.bottom+(this.hoverPointer?1:-1):this.y=Math.max(document.documentElement.clientHeight-t-m.HoverBorderWidth,0):(this.y=this.hoverPointer?e.center.y+t/2:e.bottom,this.y<t&&(this.y=t+2)),this.y>document.documentElement.clientHeight&&(this.y=e.bottom)}adjustHoverPosition(e){if(this.forcePosition)return;const t=m.HoverBorderWidth+(this.hoverPointer?m.PointerSize:0),i=this.hoverContainer.clientWidth+t,n=this.hoverContainer.clientHeight+t;switch(this.hoverPosition){case h.RIGHT:e.right+i>document.documentElement.clientWidth&&e.left>document.documentElement.clientWidth-e.right&&(this.hoverPosition=h.LEFT);break;case h.LEFT:e.left-i<document.documentElement.clientLeft&&e.left<document.documentElement.clientWidth-e.right&&(this.hoverPosition=h.RIGHT);break;case h.ABOVE:e.top-n<document.documentElement.clientTop&&e.top<document.documentElement.clientHeight-e.bottom&&(this.hoverPosition=h.BELOW);break;case h.BELOW:e.bottom+n>document.documentElement.clientHeight&&e.top>document.documentElement.clientHeight-e.bottom&&(this.hoverPosition=h.ABOVE)}}setHoverBoundary(e){const t=(this.hoverPointer?m.PointerSize:0)+m.HoverBorderWidth+3;let i=t+m.HoverContentMargin.horizontal;this.hoverPosition===h.RIGHT?this.hoverContentWrapper.getDomNode().style.maxWidth=document.documentElement.clientWidth-e.right-i+"px":this.hoverPosition===h.LEFT&&(this.hoverContentWrapper.getDomNode().style.maxWidth=e.left-i+"px"),i=t+m.HoverContentMargin.vertical,this.hoverPosition===h.ABOVE?this.hoverContentWrapper.getDomNode().style.maxHeight=e.top-i+"px":this.hoverPosition===h.BELOW&&(this.hoverContentWrapper.getDomNode().style.maxHeight=document.documentElement.clientHeight-e.bottom-i+"px"),this.hoverContentWrapper.getDomNode().style.height=this.hoverContainer.clientHeight-m.HoverContentMargin.vertical+"px"}setHoverPointerPosition(e){if(this.hoverPointer)switch(this.hoverPosition){case h.LEFT:case h.RIGHT:{this.hoverPointer.classList.add(this.hoverPosition===h.LEFT?"right":"left");const t=this.hoverContainer.clientHeight;if(t>e.height){const i=this.y<t?e.center.y:e.center.y-(this.y-t);this.hoverPointer.style.top=i-m.PointerSize+"px"}else this.hoverPointer.style.top=Math.round(t/2)-m.PointerSize+"px";break}case h.ABOVE:case h.BELOW:{this.hoverPointer.classList.add(this.hoverPosition===h.ABOVE?"bottom":"top");const t=this.hoverContainer.clientWidth;if(t>e.width){const i=this.x+t>document.documentElement.clientWidth?e.center.x:e.center.x-this.x;this.hoverPointer.style.left=i-m.PointerSize-.5+"px"}else this.hoverPointer.style.left=Math.round(t/2)-m.PointerSize+"px";break}}}focus(){this.hoverContainer.focus()}hide(){this.dispose(),r.ContextView.hideContextView(this._viewId),Array.from(r.ContextView.getContextViewElement(this._viewId).children).forEach(e=>{e.remove()})}get container(){return this.hoverContainer}}t.HoverWidget=b;const m={PointerSize:3,HoverBorderWidth:2,HoverWindowEdgeMargin:4,HoverContentMargin:{vertical:2,horizontal:4}};class g{static render(e,t){return new g(e,t)}constructor(e,t){if(this.actionContainer=(0,c.createElement)(".action-container",{tabindex:0}),e.appendChild(this.actionContainer),this.action=(0,c.createElement)("a.action",{role:"button"}),this.actionContainer.appendChild(this.action),t.iconClass){const e=(0,c.createElement)("span");e.classList.add("icon",`${t.iconClass}`),this.action.appendChild(e)}const i=(0,c.createElement)("span");this.action.appendChild(i),i.textContent=t.label,this.onClick=e=>{e.stopPropagation(),e.preventDefault(),t.run(this.actionContainer)},this.actionContainer.addEventListener("click",this.onClick),this.onKeyUp=e=>{"Enter"===e.key&&(e.stopPropagation(),e.preventDefault(),t.run(this.actionContainer))},this.actionContainer.addEventListener("keyup",this.onKeyUp),this.actionContainer.classList.remove("disabled"),this.actionContainer.removeAttribute("aria-disabled")}dispose(){this.actionContainer.removeEventListener("click",this.onClick),this.actionContainer.removeEventListener("keyup",this.onKeyUp)}}t.HoverAction=g;class v{static show(e,t=!1){var i,n,o;this.viewId=null!==(i=e.customViewId)&&void 0!==i?i:this.viewId,this.lastHover&&(this.removeEvents=!1),!this.lastHover&&this.hover&&this.hide(this.removeEvents),e.skipFadeInAnimation?this.hover=new b(Object.assign(Object.assign({},e),{skipFadeInAnimation:0===this.delay})):this.hover=new b(e),this.lastHoverTarget=e.target,t&&this.hover.focus();const s=()=>this.hide(this.removeEvents,!1),r=()=>{this.clearLastHoverTimeout(),this.hideLastHover(),this.hide(this.removeEvents,!0)};if(this.lastHover&&(this.eventStore.add({element:this.lastHover.container,type:"mouseleave",handler:()=>{this.lastHoverTimeout=window.setTimeout(()=>this.hideLastHover(),200)}}),this.eventStore.add({element:this.lastHover.container,type:"mouseover",handler:()=>{this.clearLastHoverTimeout()}})),!(null===(n=e.actions)||void 0===n?void 0:n.length)&&(null!==(o=e.hideOnHover)&&void 0!==o?o:"string"==typeof e.content))this.hover.target.targetElements.forEach(e=>{this.eventStore.add({element:e,type:"mousedown",handler:r}),this.eventStore.add({element:e,type:"mouseup",handler:r}),this.eventStore.add({element:e,type:"mouseleave",handler:s})});else{const e=()=>{this.clearHoverTimeout()},t=()=>{this.hoverTimeout=window.setTimeout(s,50)};this.hover.target.targetElements.forEach(i=>{this.eventStore.add({element:i,type:"mousedown",handler:r}),this.eventStore.add({element:i,type:"mouseup",handler:r}),this.eventStore.add({element:i,type:"mouseleave",handler:t}),this.eventStore.add({element:i,type:"mouseover",handler:e})}),this.eventStore.add({element:this.hover.container,type:"mouseover",handler:e}),this.eventStore.add({element:this.hover.container,type:"mouseleave",handler:t})}if(e.hideOnKeyDown){const e=document.activeElement;e&&this.eventStore.add({element:e,type:"keydown",handler:s})}this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}static setupIconLabelHover(e,t=!1){const i=e.target instanceof HTMLElement?{targetElements:[e.target]}:e.target,o=t=>{this.delayTimeout=window.setTimeout(()=>n(this,void 0,void 0,function*(){return yield this.update(Object.assign(Object.assign({},e),{target:i}),t)}),this.delay)};let s;e.showPointer||(s=n=>{e.hoverPosition===h.LEFT||e.hoverPosition===h.RIGHT?i.y=n.y:i.x=n.x,this.hover||this.delayTimeout||o(t)});const r=()=>{if(this.hover&&e.customViewId&&e.customViewId!==this.hover.viewId)return this.lastHover=this.hover,this.clearHoverTimeout(),void o(t);this.delayTimeout||this.hover&&this.lastHoverTarget===i||(this.clearHoverTimeout(),this.hide(),o(t))},a=()=>{this.clearDelayTimeout()};return i.targetElements.forEach(e=>{e.addEventListener("mouseover",r),e.addEventListener("mouseleave",a),s&&e.addEventListener("mousemove",s,!0)}),{show:e=>{this.hide(this.removeEvents,!1),o(e)},dispose:()=>{this.hide(this.removeEvents,!1),i.targetElements.forEach(e=>{e.removeEventListener("mouseover",r),e.removeEventListener("mouseleave",a),s&&e.removeEventListener("mousemove",s,!0)})}}}static update(e,t=!1){var i;return n(this,void 0,void 0,function*(){if(!e.content)return;if(!(e.target instanceof HTMLElement||e.target.targetElements[0].getBoundingClientRect().height))return;let n,o=e.content;"string"==typeof o||o instanceof HTMLElement?n=o:"function"==typeof o.markdown?(this.show(Object.assign(Object.assign({},e),{content:"Loading..."}),t),n=yield o.markdown(),n||(n=o.markdownNotSupportedFallback)):n=null!==(i=o.markdown)&&void 0!==i?i:o.markdownNotSupportedFallback,this.hasContent(n)&&this.show(Object.assign(Object.assign({},e),{content:n}),t)})}static hide(e=!0,t=!1){this.hover&&(this.hover.hide(),this.hover=void 0),this.clearHoverTimeout(),this.clearDelayTimeout(),this.lastHoverHideTime=t?0:Date.now(),e&&this.removeEventListener()}static clearDelayTimeout(){this.delayTimeout&&(clearTimeout(this.delayTimeout),this.delayTimeout=void 0)}static clearHoverTimeout(){this.hoverTimeout&&(clearTimeout(this.hoverTimeout),this.hoverTimeout=void 0)}static clearLastHoverTimeout(){this.lastHoverTimeout&&(clearTimeout(this.lastHoverTimeout),this.lastHoverTimeout=void 0)}static removeEventListener(){this.eventStore.forEach(e=>{e.element.removeEventListener(e.type,e.handler)}),this.eventStore.clear()}static hasContent(e){return!(!e||"object"==typeof e&&"string"==typeof e.value&&!e.value)}static hideLastHover(){this.lastHover&&(this.lastHover.hide(),this.lastHover=void 0,this.hide())}static get delay(){return Date.now()-this.lastHoverHideTime<500?0:500}}t.Hover=v,v.viewId="ide-context-view-hover",v.eventStore=new Set,v.lastHoverHideTime=0,v.removeEvents=!0,(0,o.defineCustomElement)("ide-hover",b)},9016(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Select=t.hideContextOptionsView=void 0;const n=i(4523),o=i(4835),s=i(9084),r=i(3145),a=i(519),l=i(4183),d=i(5754),c=i(7746),u=i(3814),h=i(1062),p=i(308),b=i(1609),m=i(359),g=i(231),v=i(5093),f=i(8565),w=i(5366),x=i(5354);var y;!function(e){e.Enter="Enter",e.Escape="Escape",e.ArrowDown="ArrowDown",e.ArrowUp="ArrowUp",e.Space="Space"}(y||(y={}));const k={[v.SelectPosition.TOP]:p.AnchorPosition.ABOVE,[v.SelectPosition.BOTTOM]:p.AnchorPosition.BELOW},C={[v.SelectAlignment.LEFT]:p.AnchorAlignment.LEFT,[v.SelectAlignment.RIGHT]:p.AnchorAlignment.RIGHT};function E(e){p.ContextView.hideContextView(e),(0,o.clearNode)(p.ContextView.getContextViewElement(e))}t.hideContextOptionsView=E;const D={placeholder:"Please select",options:[],allowClear:!1,showSearch:!1,disabled:!1,multiple:!1,widthAdaptive:!1,size:v.SelectSize.MEDIUM};class S extends s.BaseComponent{constructor(e){var t;super(),this.options=[],this.optionNodes=[],this.searchPlaceholder="Please enter a keyword to search",this._hasDetails=!1,this._skipLayout=!1,this._dropDownPosition=p.AnchorPosition.BELOW,this.loadMoreDescription="Load more...",this.multipleSelected=[],this.allowClear=!1,this.showSearch=!1,this.disabled=!1,this.multiple=!1,this.tagFlexibleWhenMultiple=!1,this.disableSelectOptions=!1,this.widthAdaptive=!1,this.autoWidthAdaptive=!1,this.size=v.SelectSize.MEDIUM,this.placeholder="Please select",this.ariaLabel="",this.maxHeight="",this.position=v.SelectPosition.TOP,this.alignment=v.SelectAlignment.LEFT,this._currentSelection=0,this._isVisible=!1,this.multipleTags=[],this.disposablesStore=new Set,this.eventStore=new a.EventStore,this.selectEmitter=new a.EventEmitter,this.onDidSelect=this.selectEmitter.asSubscriber("onDidSelect"),this.loadMoreEmitter=new a.EventEmitter,this.onDidLoadMore=this.loadMoreEmitter.asSubscriber("onDidLoadMore"),this.multipleSelectEmitter=new a.EventEmitter,this.onDidMultipleChange=this.multipleSelectEmitter.asSubscriber("onDidMultipleChange"),this.focusEmitter=new a.EventEmitter,this.onDidFocus=this.focusEmitter.asSubscriber("onDidFocus"),this.blurEmitter=new a.EventEmitter,this.onDidBlur=this.blurEmitter.asSubscriber("onDidBlur"),this.clearEmitter=new a.EventEmitter,this.onDidClear=this.clearEmitter.asSubscriber("onDidClear"),this.visibleChangeEmitter=new a.EventEmitter,this.onDropdownVisibleChange=this.visibleChangeEmitter.asSubscriber("onDropdownVisibleChange"),this.multipleTagDeleteEmitter=new a.EventEmitter,this.onMultipleTagDelete=this.multipleTagDeleteEmitter.asSubscriber("onMultipleTagDelete"),this.webviewChangeEmitter=new a.EventEmitter,this.onDidWebviewChange=this.webviewChangeEmitter.asSubscriber("onDidWebviewChange"),this.fireConnectedEventFlag=!1,this.windowScrollTop=0,this.mouseEnterScrollTop=0,this.setContextViewDomLayout=()=>({layout:()=>{this.dropdownContainer.style.position="relative",this.widthAdaptive?this.dropdownContainer.style.minWidth=`${(0,h.getTotalWidth)(this.selectElement)}px`:this.dropdownContainer.style.width=`${(0,h.getTotalWidth)(this.selectElement)}px`}}),this.initOptions(Object.assign(Object.assign({},D),e)),this.messageContainer=(0,o.createElement)(S.messageContainer),this.messageContainer.style.position="absolute",this.messageContainer.style.zIndex="999",this.render(),this.renderShadow(),this.addEvent();const i=this.shadowHandling();this.setOptions(i.length?i:null!==(t=null==e?void 0:e.options)&&void 0!==t?t:[])}get enabled(){return!this.disabled}set enabled(e){this.disabled!==!e&&(e||this.hideSelectOptions(),this.disabled=!e,this.setAttribute("disabled",this.disabled?"true":"false"),this.setAttribute("tabindex",this.disabled?"-1":"0"),this.selectElement.classList.toggle("ide-select-disabled",this.disabled),this.multipleTags.forEach(t=>{t.setDisable(!e)}))}get status(){return this._status}set status(e){this._status=e,this.changeStatusClass()}get searchValue(){var e,t;return null!==(t=null===(e=this.searchInput)||void 0===e?void 0:e.value)&&void 0!==t?t:""}set searchValue(e){this.searchInput&&(this.searchInput.value=null!=e?e:"",this.handleSearchInput(null!=e?e:"",!1))}get allowLoadMore(){return"none"===this.loadMoreElement.style.display}set allowLoadMore(e){this.loadMoreElement.style.display=e?"block":"none"}setSearchValue(e){this.searchValue=e}get element(){return this.selectElement}get optionChildNodes(){return Array.from(this.itemOptions.children)}initOptions(e){var t,i,n,o,s,r,a,l,d,c;const{showSearch:u,size:h,placeholder:p,ariaLabel:b,handler:m,scrollContainer:g,status:v,validationOptions:f,emptyOptions:w,maxHeight:x,alignment:y,position:k,searchPlaceholder:C=this.searchPlaceholder,minBottomMargin:E,loadMoreDescription:D}=e;this.handler=m,this.scrollContainer=g,["allowClear","disabled","multiple","widthAdaptive","autoWidthAdaptive","tagFlexibleWhenMultiple","disableSelectOptions"].forEach(t=>{const i=this.getAttribute(t);this[t]=""===i||"true"===i||i===t||!!e[t]});const A=this.getAttribute("showSearch");this.showSearch="inline"===A?"inline":""===A||"true"===A||u,this.size=null!==(t=this.getAttribute("size"))&&void 0!==t?t:h,this.placeholder=null!==(n=null!==(i=this.getAttribute("placeholder"))&&void 0!==i?i:p)&&void 0!==n?n:"",this.ariaLabel=null!==(s=null!==(o=this.getAttribute("ariaLabel"))&&void 0!==o?o:b)&&void 0!==s?s:"",this.maxHeight=null!==(a=null!==(r=this.getAttribute("maxHeight"))&&void 0!==r?r:x)&&void 0!==a?a:"",this.alignment=null!==(l=this.getAttribute("alignment"))&&void 0!==l?l:y,this.position=null!==(d=this.getAttribute("position"))&&void 0!==d?d:k,this._status=Number(null!==(c=this.getAttribute("status"))&&void 0!==c?c:v),this._validationOptions=f,this._emptyOptions=w,this.searchPlaceholder=C,this.minBottomMargin=null!=E?E:0,"number"!=typeof e.minBottomMargin?this.minBottomMargin=S.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN:e.minBottomMargin<0&&(this.minBottomMargin=0),this.loadMoreDescription=D||"Load more..."}render(){this.selectElement=(0,o.createElement)(".ide-select"),this.selectElement.classList.add(this.multiple?"ide-select-multiple":"ide-select-single"),this.selectElement.classList.add(g.SELECT_SIZE_CLASSNAMES[this.size]),this.autoWidthAdaptive&&this.selectElement.classList.add("auto-width"),!0===this.showSearch&&this.selectElement.classList.add("ide-select-show-search"),this.disabled?(this.selectElement.classList.add("ide-select-disabled"),this.setAttribute("tabindex","-1")):(this.tabIndex=0,this.setAttribute("tabindex","0")),this.ariaLabel&&this.selectElement.setAttribute("aria-label",this.ariaLabel),this.selector=(0,o.createElement)(".ide-select-selector"),this.arrow=(0,o.createElement)("span.ide-select-arrow",{},(0,d.renderIcon)({id:"triangle-down"},this.shadow)),this.selectElement.append(this.selector,this.arrow),this.multiple&&(this.multipleElement=(0,o.createElement)("div.ide-select-selection-multiple"),this.selector.append(this.multipleElement)),this.allowClear&&(this.clearElement=(0,o.createElement)(".ide-select-clear",{},(0,d.renderIcon)({id:"stop"},this.shadow)),this.selectElement.appendChild(this.clearElement)),this.loadMoreElement=(0,o.createElement)(".ide-select-loadmore",{title:this.loadMoreDescription}),this.loadMoreElement.innerText=this.loadMoreDescription,this.loadMoreElement.style.display="none",this.selectOptionNoDataPane=new l.Empty(this._emptyOptions),this.selectOptionDetailsPane=(0,o.createElement)(".ide-select-details-pane"),this.itemOptions=(0,o.createElement)(".ide-select-item-options"),this.itemOptionsPane=(0,o.createElement)(".ide-select-item-options-pane",{},this.selectOptionNoDataPane,this.itemOptions),this.dropdownContainer=(0,o.createElement)(".ide-select-dropdown"),this.renderSection(),this.placeholderElement=(0,o.createElement)("span.ide-select-selector-placeholder.no-value",{},this.placeholder),this.selector.append(this.placeholderElement),this.selectWrapper=(0,o.createElement)(".ide-select-item",{},this.selectElement,this.messageContainer)}renderShadow(){const e=(0,o.createStyles)((0,m.getSelectStyle)(x.ideChecker.isIDE),(0,m.getSelectItemStyle)(x.ideChecker.isIDE));this.shadow.append(e,this.selectWrapper)}handleToggleContextView(e){a.EventFlowAssister.stop(e,!0),this._isVisible?this.hideSelectOptions(e):this.showSelectOptions()}connectedCallback(){super.connectedCallback(),this.eventStore.add(window,"mousedown",e=>{this.outsideMouseDown(e)})}outsideMouseDown(e){var t,i;const n=e.target,o=n===this,s=null===(t=null==n?void 0:n.shadowRoot)||void 0===t?void 0:t.contains(this.itemOptionsPane);o||s||((null===(i=this._validationOptions)||void 0===i?void 0:i.enableStatus)||this.hideMessage(!0),this.hideSelectOptions())}addEvent(){var e;this.eventStore.add(window,"scroll",()=>{this.windowScrollTop=window.pageYOffset||document.documentElement.scrollTop}),this.eventStore.add(this.dropdownContainer,"mouseleave",()=>{this.mouseEnterScrollTop=this.windowScrollTop}),this.eventStore.add(this.itemOptions,"scroll",e=>{e.stopPropagation()}),this.handler&&this.eventStore.add(this.handler,"click",this.handleToggleContextView.bind(this)),this.scrollContainer&&this.eventStore.add(this.scrollContainer,"scroll",e=>{this.hideSelectOptions(e),p.ContextView.hideContextView(S.messageContextViewId)}),this.allowClear&&(this.eventStore.add(this.selectElement,"mouseenter",e=>{a.EventFlowAssister.stop(e,!0),this.handleToggleClear(!0),!0===this.showSearch&&this.searchIcon&&(this.searchIcon.style.display=void 0===this.selected?"block":"none")}),this.eventStore.add(this.selectElement,"mouseleave",e=>{a.EventFlowAssister.stop(e,!0),this.handleToggleClear(!1),!0===this.showSearch&&this.searchIcon&&(this.searchIcon.style.display=void 0===this.selected?"block":"none")})),this.eventStore.add(this.selectElement,"click",e=>{this.handleToggleContextView(e)}),this.eventStore.add(this.loadMoreElement,"mousedown",e=>{e.preventDefault(),this.handleLoadMoreClick()}),this.clearElement&&this.eventStore.add(this.clearElement,"click",e=>{e.stopPropagation(),this.clear()}),this.eventStore.add(this,"keydown",this.bindKeyboardEvent.bind(this)),"inline"===this.showSearch&&this.searchInput&&this.eventStore.add(this.itemOptionsPane,"keydown",this.bindKeyboardEvent.bind(this)),this.eventStore.add(this,"focus",e=>{this.selectElement.classList.add("focused"),!0===this.showSearch&&this.searchInput&&this.searchInput.focus(),this.focusEmitter.emit("onDidFocus",e)}),this.eventStore.add(this,"blur",e=>{var t,i,n;(null===(n=null===(i=null===(t=e.relatedTarget)||void 0===t?void 0:t.shadowRoot)||void 0===i?void 0:i.contains)||void 0===n?void 0:n.call(i,this.itemOptionsPane))||this.onBlurEvent(e)}),(null===(e=this._validationOptions)||void 0===e?void 0:e.validation)&&this.eventStore.add(window,"resize",()=>{this.doLayoutSelectOptions()})}onBlurEvent(e){var t;(null===(t=this._validationOptions)||void 0===t?void 0:t.enableStatus)||this.hideMessage(!0),this.hideSelectOptions(),this.selectElement.classList.remove("focused"),this.selector.classList.remove("ide-select-selector-focused"),this.blurEmitter.emit("onDidBlur",e)}onEnter(e){var t;if(a.EventFlowAssister.stop(e,!0),this._isVisible)if(0===this.optionChildNodes.length)this.hideSelectOptions();else{const e=this.optionChildNodes[null!==(t=this._currentSelection)&&void 0!==t?t:0].getOption();this.handleOptionClick(e)}else this.showSelectOptions()}onArrowDown(e){if(a.EventFlowAssister.stop(e,!0),this.getEnabledOptions().length<=1)return;let t=this._currentSelection;do{++t===this.optionNodes.length&&(t=0)}while(this.optionNodes[t].hide||this.optionNodes[t].disabled);this.setOptionActive(!0,t)}onArrowUp(e){if(a.EventFlowAssister.stop(e,!0),this.getEnabledOptions().length<=1)return;let t=this._currentSelection;do{-1===--t&&(t=this.optionNodes.length-1)}while(this.optionNodes[t].hide||this.optionNodes[t].disabled);this.setOptionActive(!0,t)}onEscape(e){e.code===y.Escape&&this._isVisible&&(a.EventFlowAssister.stop(e,!0),this.hideSelectOptions(e))}bindKeyboardEvent(e){const t=e;t.code===y.Enter&&this.onEnter(e),this._isVisible&&(t.code===y.ArrowUp&&this.onArrowUp(t),t.code===y.ArrowDown&&this.onArrowDown(t),t.code===y.Escape&&this.onEscape(t)),t.code===y.Space&&this.showSelectOptions()}shadowHandling(){const e=[];return this.shadow.host.childNodes.forEach(t=>{const i=t;if(i.tagName.toLocaleLowerCase()===b.IdeSelectOption.TAG_NAME){const t=i.attributes;e.push(t)}}),e}setOptionsWidth(e){const t=this.selectElement.offsetWidth;this.optionNodes.forEach(i=>{var n;const o=null===(n=i.getIconLabel())||void 0===n?void 0:n.element.firstElementChild;o&&(o.style.width=e?"initial":t-52+"px")})}handleToggleClear(e){var t;null===(t=this.clearElement)||void 0===t||t.classList.toggle("visible",e&&void 0!==this.selected)}toggleShowPlaceholder(e){this.placeholderElement.classList.toggle("hidden",!e)}renderSection(){var e,t,i;if(!0===this.showSearch||"inline"===this.showSearch){this.searchInput=(0,o.createElement)(`input.${null===(e=g.SELECT_SEARCH_CLASSNAMES.get(this.showSearch))||void 0===e?void 0:e.searchInput}`),this.searchIcon=(0,o.createElement)("span.ide-select-selector-search-icon",{},(0,d.renderIcon)({id:"search-save"},this.shadow));const n=(0,o.createElement)(`span.${null===(t=g.SELECT_SEARCH_CLASSNAMES.get(this.showSearch))||void 0===t?void 0:t.search}`,{},this.searchInput);if(!0===this.showSearch){if(this.arrow.style.display="none",this.multiple){this.mirror=(0,o.createElement)(".ide-select-selection-search-mirror",{textContent:"&nbsp;"}),n.append(this.mirror);const e=(0,o.createElement)(".ide-select-selection-multiple-item.search",{},n);null===(i=this.multipleElement)||void 0===i||i.append(e)}else this.selector.append(n);this.selectElement.append(this.searchIcon)}else"inline"===this.showSearch&&(this.searchInput.setAttribute("placeholder",this.searchPlaceholder),this.itemOptionsPane.insertBefore(n,this.itemOptionsPane.firstChild));this.addSearchInputEvent()}}renderDescriptionMarkdown(e,t){if(!t){const t=document.createElement("div");return t.textContent=e,t}const i={value:e},n=(0,r.renderMarkdown)(i,{actionHandler:{callback:t,disposables:this.disposablesStore},shadowRoot:this.shadow});return n.classList.add("ide-select-description-markdown"),this.disposablesStore.forEach(({element:e,type:t,handler:i})=>{this.eventStore.add(e,t,i)}),n}addSearchInputEvent(){this.searchInput&&(this.eventStore.add(this.searchInput,"input",e=>{var t;this.handleSearchInput(null===(t=e.target)||void 0===t?void 0:t.value)}),this.eventStore.add(this.searchInput,"click",e=>{var t;(null===(t=e.target)||void 0===t?void 0:t.value)&&a.EventFlowAssister.stop(e,!0)}),this.eventStore.add(this.searchInput,"focus",()=>{!0===this.showSearch&&this.selector.classList.toggle("ide-select-selector-focused",!0)}),this.eventStore.add(this.searchInput,"blur",e=>{e.target&&"inline"===this.showSearch&&e.relatedTarget!==this&&this.onBlurEvent(e)}),this.eventStore.add(this.searchInput,"keydown",e=>{e.stopPropagation()}))}searchInputValueChange(e){if(this.multiple&&this.mirror&&this.searchInput){this.mirror.textContent=null!=e?e:"&nbsp;";const{width:t}=this.mirror.getBoundingClientRect();this.searchInput.style.width=t+"px",this.doLayoutSelectOptions()}}handleSearchInput(e="",t=!0){!0===this.showSearch&&(this.toggleShowPlaceholder(!e&&0===this.multipleSelected.length),this.searchInputValueChange(e));let i=!0;this.optionNodes.forEach(t=>{var n;const o=-1===(null!==(n=t.getLabel())&&void 0!==n?n:"").toLocaleLowerCase().indexOf(e.toLocaleLowerCase());t.hide=o,o||(i=!1)});const s=()=>{var e;if(this.selectOptionNoDataPane.show=i,(0,o.clearNode)(this.itemOptions),i)this.selectOptionDetailsPane.style.display="none";else{let e=-1;if(this.optionNodes.forEach((t,i)=>{t.hide||(this.itemOptions.append(t),t.getOption().index===this.selected&&(e=i))}),-1===e)for(let t=0;t<this.optionChildNodes.length;t++)if(!this.optionChildNodes[t].disabled){e=this.optionChildNodes[t].getOption().index;break}this.setOptionActive(!0,e)}t&&(this.showSelectOptions(),null===(e=this.searchInput)||void 0===e||e.focus())};n.debounce(()=>{s(),this.doLayoutSelectOptions()},t?30:0)()}handleOptionClick(e){var t;return e.checkbox?(this.handleMultipleOptionClick(e),void this.selectEmitter.emit("onDidSelect",n.omit(e,"instance"))):e.actionRun?(this.hideSelectOptions(),e.instance.selected=!1,void e.actionRun()):("number"==typeof this.selected&&this.selected>=0&&(this.optionNodes[this.selected].selected=!1),e.instance.selected=!0,this.selected=e.index,this.renderPlaceholder(null!==(t=e.simplifiedText)&&void 0!==t?t:e.text,e.iconColor,e.renderDetailInPlaceholder,e.detail),this.hideSelectOptions(),this.focus(),void this.selectEmitter.emit("onDidSelect",n.omit(e,"instance")))}handleLoadMoreClick(){this.loadMoreEmitter.emit("onDidLoadMore")}handleMultipleOptionClick(e){this.renderTag(e)}handleMultipleTagOnClose(e){var t;this.multipleTagDeleteEmitter.emit("onMultipleTagDelete",e);const i=this.multipleSelected.findIndex(t=>t.text===e),n=this.multipleSelected[i].index;this.optionNodes[n].selected=!1,this.multipleSelected.splice(i,1),this.multipleTags.splice(i,1),null===(t=this.multipleElement)||void 0===t||t.children[i].remove(),this.toggleShowPlaceholder(0===this.multipleSelected.length),this._isVisible||this.fireConnectedEventFlag?(this._skipLayout=!0,this.doLayoutSelectOptions(),this._skipLayout=!1):this.showSelectOptions(),this.validate(),this.multipleSelectEmitter.emit("onDidMultipleChange",this.multipleSelected)}renderTag(e,t){var i,s,r,a,l;const d=this.multipleSelected.findIndex(t=>t.index===e.index);if(e.instance||(e.instance=this.optionNodes[e.index]),-1===d&&!0===e.isSelected){const t=this.size,a=null!==(i=e.instance.getLabel())&&void 0!==i?i:"",l=new c.Tag({type:c.TagType.CLOSEABLE,flexible:this.tagFlexibleWhenMultiple,label:a,size:t});l.onClose(e=>this.handleMultipleTagOnClose(e)),l.setDisable(!this.enabled),this.multipleTags.push(l);const d=(0,o.createElement)(".ide-select-selection-multiple-item",{},l);this.multipleSelected.push(n.omit(e,"instance")),!0===this.showSearch?null===(s=this.multipleElement)||void 0===s||s.insertBefore(d,this.multipleElement.lastChild):null===(r=this.multipleElement)||void 0===r||r.append(d),e.instance.selected=!0}else e.instance.selected=!1,-1!==d&&(this.multipleSelected.splice(d,1),this.multipleTags.splice(d,1),null===(l=null===(a=this.multipleElement)||void 0===a?void 0:a.children[d])||void 0===l||l.remove());this.toggleShowPlaceholder(0===this.multipleSelected.length),this._skipLayout=!0,this.doLayoutSelectOptions(),t||(this.validate(),this.multipleSelectEmitter.emit("onDidMultipleChange",this.multipleSelected)),this._skipLayout=!1}renderPlaceholder(e,t,i,n){var s,r;(0,o.clearNode)(this.placeholderElement);const a=this.createIconLabel(e,t);if(this.placeholderElement.appendChild(a),i&&n){const e=this.createIconLabel(n,t);e.classList.add("ide-select-item-option-detail"),this.placeholderElement.appendChild(e)}null===(s=this.placeholderElement)||void 0===s||s.classList.remove("no-value"),this.toggleShowPlaceholder(!0),this.validate(),this.selectElement.title=null!==(r=a.label)&&void 0!==r?r:""}handleSelectClick(){this.selectElement.classList.add("ide-select-drop-down"),this.selector.classList.add("ide-select-selector-focused"),this.arrow.classList.add("ide-select-arrow-up")}renderSelectOption(){let e;(0,o.clearNode)(this.itemOptions),this.optionNodes=[],this._hasDetails=!1;const t=[];if(this.multipleSelected.forEach(e=>{const i=this.options[e.index],n=e.index;if(i.isSelected){const e=new b.IdeSelectOption(i,n,this.multiple,this.widthAdaptive);t.push(Object.assign(Object.assign({},i),{index:n,instance:e,value:void 0===i.value||null===i.value?n:i.value}))}}),this.options.forEach((i,n)=>{const o=new b.IdeSelectOption(i,n,this.multiple,this.widthAdaptive);o.onDidClick(this.handleOptionClick.bind(this)),o.onMouseenter(e=>{this._skipLayout=!0,this.setOptionActive(!0,e.index)}),this.optionNodes.push(o),this.itemOptions.append(o),this.multiple?i.isSelected&&!this.multipleSelected.find(e=>e.text===i.text)&&t.push(Object.assign(Object.assign({},i),{index:n,instance:o,value:void 0===i.value||null===i.value?n:i.value})):i.isSelected&&void 0===e?e=n:i.isSelected&&void 0!==e&&(i.isSelected=!1),i.description&&"string"==typeof i.description&&(this._hasDetails=!0)}),this.multiple?this.multipleSelected=[]:this.selected=e,this.multiple||void 0===this.selected)this.multiple&&t.length&&t.forEach(e=>{this.renderTag(e,!0)});else{const{text:e,simplifiedText:t,iconColor:i,renderDetailInPlaceholder:n,detail:o}=this.options[this.selected];this.renderPlaceholder(null!=t?t:e,i,n,o)}this.options.length?this.setOptionActive(!0,0):this.resetOptionActive()}updateOptionsDetail(e){var t,i;const n=null!==(t=null==e?void 0:e.description)&&void 0!==t?t:"",s=null!==(i=null==e?void 0:e.descriptionIsMarkdown)&&void 0!==i&&i;(0,o.clearNode)(this.selectOptionDetailsPane),n&&this.selectOptionDetailsPane.append(s?this.renderDescriptionMarkdown(n,null==e?void 0:e.descriptionMarkdownActionHandler):n),this.selectOptionDetailsPane.style.display=n?"block":"none",this._skipLayout=!0,this.doLayoutSelectOptions(),this._skipLayout=!1}measureMaxDetailsHeight(){let e=0;return this.options.forEach(t=>{this.updateOptionsDetail(t),this.selectOptionDetailsPane.offsetHeight>e&&(e=this.selectOptionDetailsPane.offsetHeight)}),e}resetOptionsPane(e){this.itemOptionsPane.removeChild(this.selectOptionDetailsPane),this.itemOptionsPane.removeChild(this.itemOptions),e?(this.itemOptionsPane.append(this.itemOptions),this.itemOptionsPane.append(this.selectOptionDetailsPane),this.selectOptionDetailsPane.classList.remove("above"),this.selectOptionDetailsPane.classList.add("below")):(this.itemOptionsPane.append(this.selectOptionDetailsPane),this.itemOptionsPane.append(this.itemOptions),this.selectOptionDetailsPane.classList.remove("below"),this.selectOptionDetailsPane.classList.add("above"));const t=this.selectOptionNoDataPane.show;this.selectOptionDetailsPane.style.display=t?"none":"block"}calcSelectPosition(){var e;if(this._skipLayout&&this.mouseEnterScrollTop===this.windowScrollTop)return;this.mouseEnterScrollTop=this.windowScrollTop;const t=this.dropdownContainer,i=this.itemOptionsPane;t.style.removeProperty("max-height"),this.itemOptions.style.removeProperty("max-height");const n=this.getDomNodePagePosition(this.selectElement),o=getComputedStyle(this.selectElement),s=parseFloat(getComputedStyle(this.itemOptions).height),r=parseFloat(o.paddingTop)+parseFloat(o.paddingBottom),a=document.documentElement.clientHeight+document.documentElement.scrollTop-n.top-n.height-this.minBottomMargin,l=n.top-window.scrollY-S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN,d=this._hasDetails?this.measureMaxDetailsHeight():0,c=s+r+d,u=this.selectElement.offsetWidth,h=i.offsetWidth;t.style.width=Math.max(Math.round(h),Math.round(u))+"px";let m=s,g=c;const v="inline"===this.showSearch?null===(e=this.searchInput)||void 0===e?void 0:e.offsetHeight:0,f=b.IdeSelectOption.HEIGHT;if(this.maxHeight&&(m=Math.max(Math.min(parseFloat(this.maxHeight)-r-d,s),f),g=m+r+d),g<=a)this._dropDownPosition=p.AnchorPosition.BELOW,this.resetOptionsPane(!0);else if(g<=l)this._dropDownPosition=p.AnchorPosition.ABOVE,this.resetOptionsPane(!1);else{const e=d+r+(null!=v?v:0)+this.minBottomMargin;l>a?(m=l-e,this._dropDownPosition=p.AnchorPosition.ABOVE,this.resetOptionsPane(!1)):(m=a-e,this._dropDownPosition=p.AnchorPosition.BELOW,this.resetOptionsPane(!0))}this.itemOptions.style.maxHeight=`${m}px`,this.setOptionActive(!0),this.widthAdaptive&&!this.autoWidthAdaptive&&(t.style.maxWidth=document.documentElement.clientWidth-document.documentElement.scrollLeft-n.left-S.SELECT_RIGHT_PADDING+"px")}getDomNodePagePosition(e){const t=e.getBoundingClientRect(),i=new class{get scrollX(){return"number"==typeof window.scrollX?window.scrollX:document.body.scrollLeft+document.documentElement.scrollLeft}get scrollY(){return"number"==typeof window.scrollY?window.scrollY:document.body.scrollTop+document.documentElement.scrollTop}};return{left:t.left+i.scrollX,width:t.width,top:t.top+i.scrollY,height:t.height}}createIconLabel(e,t){const i=new u.HighlightedLabel({text:e,supportIcons:!0,iconColor:t});return i.element.style.width="100%",i}getEnabledOptions(){const e=[];return this.optionNodes.forEach((t,i)=>{t.disabled||t.hide||e.push(i)}),e}setOptionActive(e,t=this._currentSelection){this.optionChildNodes.length&&(this._currentSelection=t,this.optionNodes[t]&&(this.optionNodes[t].setActive(e),this.updateOptionsDetail(this.optionNodes[t].getOption())))}resetOptionActive(){this._currentSelection=0,this.updateOptionsDetail()}changeStatusClass(){this.selectElement.classList.remove(...g.SELECT_STATUS_CLASSNAMES.values()),this._status&&g.SELECT_STATUS_CLASSNAMES.get(this._status)&&this.selectElement.classList.add(g.SELECT_STATUS_CLASSNAMES.get(this._status))}doLayoutSelectOptions(){p.ContextView.layout(S.messageContextViewId),p.ContextView.layout(S.contextViewId)}focusContextView(){this.searchInput&&this.searchInput.focus()}validate(){var e,t,i;let n=null;if(this._validationOptions&&this._validationOptions.validation){const{validation:o}=this._validationOptions;n=this.multiple?o(this.multipleSelected):o(null!==(i=null===(t=this.optionNodes[null!==(e=this.selected)&&void 0!==e?e:-1])||void 0===t?void 0:t.getOption())&&void 0!==i?i:void 0),n?(this.selectWrapper.setAttribute("aria-invalid","true"),this.showMessage(n)):this.selectWrapper.hasAttribute("aria-invalid")&&(this.selectWrapper.removeAttribute("aria-invalid"),this.hideMessage())}return null==n?void 0:n.type}fireOnConnectedEvent(){this.isConnected||this.fireConnectedEventFlag||(this.connectedCallback(),this.fireConnectedEventFlag=!0)}showSelectOptions(e=!0){if(this.disabled)return;if(void 0===this._resizeEventId&&(this._resizeEventId=this.eventStore.add(window,"resize",this.doLayoutSelectOptions.bind(this))),this.hideMessage(!0),this.disableSelectOptions)return void(this.selectElement.classList.contains("ide-select-drop-down")&&this.selector.classList.contains("ide-select-selector-focused")?this.visibleChangeEmitter.emit("onDropdownVisibleChange",!1):(this.handleSelectClick(),this.visibleChangeEmitter.emit("onDropdownVisibleChange",!0)));if(this._isVisible)return void this.focusContextView();this.visibleChangeEmitter.emit("onDropdownVisibleChange",!0);const{layout:t}=this.setContextViewDomLayout(),i=this.getDelegate(e,t);p.ContextView.showContextView(i),this.focusContextView()}getDelegate(e,t){return{customViewId:S.contextViewId,anchorAlignment:C[this.alignment],anchorPosition:()=>{var e;return null!==(e=k[this.position])&&void 0!==e?e:this._dropDownPosition},getAnchor:()=>this.selectElement,render:e=>{var i;e.appendChild(this.dropdownContainer),this.handleSelectClick(),this.setOptionsWidth(this.widthAdaptive),this.dropdownContainer.childNodes.length||this.dropdownContainer.append((0,o.createStyles)((0,m.getSelectOptionsPaneStyle)(x.ideChecker.isIDE)),this.itemOptionsPane,this.loadMoreElement),this.itemOptionsPane.append(this.selectOptionDetailsPane),this.selectOptionDetailsPane.style.width=`${this.itemOptions.offsetWidth}px`,this.calcSelectPosition(),this.updateOptionsDetail(this.options[null!==(i=this.selected)&&void 0!==i?i:this._currentSelection]),t()},onHide:()=>{this.hideSelectOptions()},layout:()=>{this.setOptionsWidth(this.widthAdaptive),this.calcSelectPosition(),this.selectOptionDetailsPane.style.width=`${this.itemOptions.offsetWidth}px`,this._layoutTime=setTimeout(()=>{t()},30)},focus:()=>{var t;this.searchValue&&this.handleSearchInput(this.searchValue,!1),this.setOptionActive(!0,null!==(t=this.selected)&&void 0!==t?t:this._currentSelection),e&&this.focus(),this._isVisible=!0,this.focusContextView()},zIndex:"2499"}}hideSelectOptions(e){var t;this._isVisible?(e&&a.EventFlowAssister.stop(e,!0),void 0!==this._resizeEventId&&(this.eventStore.removeById(this._resizeEventId),this._resizeEventId=void 0),this.visibleChangeEmitter.emit("onDropdownVisibleChange",!1),this.selectHidden(),p.ContextView.hideContextView(S.contextViewId),(null===(t=this.searchInput)||void 0===t?void 0:t.value)&&(this.searchInput.value="",this.searchInputValueChange(""),this.handleSearchInput("",!1),this.multiple&&this.toggleShowPlaceholder(!this.multipleSelected.length)),this._isVisible=!1,this.validate()):this.selectHidden()}setOptions(e,t){if(!Array.isArray(e))return;let i=(0,w.deepClone)(e);const n=null!=t?t:this.selected;void 0!==n&&n>=0&&n<e.length&&(i=i.map((e,t)=>t===n?(this.selected=n,Object.assign(Object.assign({},e),{isSelected:!0})):Object.assign(Object.assign({},e),{isSelected:!1}))),this.optionNodes=[],this.options=i,this.renderSelectOption(),this.selectOptionNoDataPane.show=0===this.options.length,this.doLayoutSelectOptions()}setMultipleOptions(e){var t,i;if(this.multiple&&Array.isArray(e)){if(this.multipleSelected.length){this.optionNodes=[],this.multipleTags=[];const e=null===(t=this.multipleElement)||void 0===t?void 0:t.lastElementChild;(0,o.clearNode)(this.multipleElement),(null==e?void 0:e.classList.contains("search"))&&(null===(i=this.multipleElement)||void 0===i||i.append(e))}this.options=(0,w.deepClone)(e),this.renderSelectOption(),this.selectOptionNoDataPane.show=0===this.options.length,this.doLayoutSelectOptions()}}setAriaLabel(e){this.ariaLabel=e,this.selectElement.setAttribute("aria-label",e)}select(e){if(this.multiple||"number"!=typeof e)return;const t=this.selected;if(this.selected=e,!this.options.length||!this.options[e])return;const{text:i,simplifiedText:n,detail:o,renderDetailInPlaceholder:s,iconColor:r}=this.options[e];this.renderPlaceholder(null!=n?n:i,r,s,o),this.handleToggleClear(this.allowClear),void 0!==t&&this.options[t]&&(this.options[t].isSelected=!1,this.optionNodes[t].selected=!1),this.options[e].isSelected=!0,this.optionNodes[e].selected=!0}getSelectedIndex(){return this.selected}getMultipleSelected(){return this.multipleSelected}clear(e=!0){this.multiple?this.clearAllMultipleOptions(e):(void 0!==this.selected&&(this.optionNodes[this.selected].selected=!1),this.placeholderElement.innerText=this.placeholder,this.placeholderElement.classList.add("no-value"),this.selected=void 0,this.handleToggleClear(!1),!0===this.showSearch&&this.searchInput&&(this.searchInput.value="",this.searchIcon.style.display="block",this.arrow.style.display="none",this.searchInputValueChange(""),this.handleSearchInput("",!1)),e&&this.validate(),this.clearEmitter.emit("onDidClear",void 0)),this.selectElement.title=""}clearAllMultipleOptions(e=!0){var t,i;if(0===this.multipleSelected.length)return;this.multipleSelected.forEach(e=>{this.options[e.index].isSelected=!1,this.optionNodes[e.index].selected=!1}),this.multipleSelected=[],this.multipleTags=[];const n=null===(t=this.multipleElement)||void 0===t?void 0:t.lastElementChild;(0,o.clearNode)(this.multipleElement),(null==n?void 0:n.classList.contains("search"))&&(null===(i=this.multipleElement)||void 0===i||i.append(n)),this.toggleShowPlaceholder(!0),e&&this.validate(),this.multipleSelectEmitter.emit("onDidMultipleChange",[])}getOptions(){return this.multiple?this.options.forEach((e,t)=>{const i=this.multipleSelected.find(e=>e.index===t);e.isSelected=!!i}):this.options.forEach((e,t)=>{e.isSelected=t===this.selected}),this.options}hasFocus(){return document.activeElement===this}selectHidden(){this.selectElement.classList.remove("ide-select-drop-down"),this.selector.classList.remove("ide-select-selector-focused"),this.arrow.classList.remove("ide-select-arrow-up")}classForType(e){switch(e){case h.MessageType.INFO:return"info";case h.MessageType.WARNING:return"warning";case h.MessageType.ERROR:return"error";case h.MessageType.SUCCESS:return"success";default:return"info"}}showMessage(e,t){var i;this.focus(),this._validationOptions&&void 0!==(null===(i=this._validationOptions)||void 0===i?void 0:i.enableStatus)||(this._validationOptions=Object.assign(Object.assign({},this._validationOptions),{enableStatus:!!t}));const{enableStatus:n=!1}=this._validationOptions;if(n)this._messageElement=(0,o.createElement)(".ide-select-item-status-message"),this._messageElement.innerText=e.content,this.selectWrapper.classList.remove(...g.SELECT_STATUS_CLASSNAMES.values()),this.selectWrapper.classList.add(g.SELECT_STATUS_CLASSNAMES.get(e.type)),this.selectWrapper.append(this._messageElement);else{this.status&&this.messageContainer.replaceChildren();const t=()=>{if(!e)return;const t=document.createElement("div");t.style.width=`${(0,h.getTotalWidth)(this.selectElement)}px`,t.style.position="relative",t.style.top="5px";const i={inline:!0},n=document.createElement("style");n.appendChild(document.createTextNode((0,f.getMessageStyles)(x.ideChecker.isIDE)));const o=document.createElement("div");o.classList.add("message",this.classForType(e.type));const s={value:e.content,isTrusted:!0,supportThemeIcons:!1,supportHtml:!1},a=e.formatContent?(0,r.renderMarkdown)(s,i):function(e,t={}){const i=document.createElement(t.inline?"span":"div");return i.textContent=e,i}(e.content,i),l=document.createElement("i");l.classList.add("pointer"),o.append(l,a),t.append(n,o),this.messageContainer.appendChild(t)};setTimeout(()=>{t()},30)}this.status=e.type}hideMessage(e){var t,i;this.status&&((null===(t=this._validationOptions)||void 0===t?void 0:t.enableStatus)?(null===(i=this._messageElement)||void 0===i||i.remove(),this.selectWrapper.classList.remove(...g.SELECT_STATUS_CLASSNAMES.values())):this.messageContainer.replaceChildren(),e||(this.status=void 0))}setEmptyOptions({text:e,icon:t}){e&&(this.selectOptionNoDataPane.text=e),t&&(this.selectOptionNoDataPane.icon=t),this.doLayoutSelectOptions()}setSelectedTagType(e,t){if(!this.multiple)return;let i=-1;i="number"==typeof e?this.multipleSelected.findIndex(t=>t.index===e):this.multipleSelected.findIndex(t=>t.text===e.text),i>-1&&(this.multipleTags[i].type=t)}dispose(){clearTimeout(this._layoutTime),this.selectEmitter.clear(),this.focusEmitter.clear(),this.blurEmitter.clear(),this.eventStore.clear(),this.hideSelectOptions(),this.hideMessage(),E(S.contextViewId)}}t.Select=S,S.contextViewId="ide-select-context-view",S.messageContextViewId="ide-select-message",S.messageContainer=".message-container",S.TAG_NAME="ide-select",S.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN=15,S.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN=20,S.SELECT_RIGHT_PADDING=32,(0,s.defineCustomElement)(S.TAG_NAME,S)},9084(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.defineCustomElement=t.BaseComponent=void 0;const n=i(519);class o extends HTMLElement{constructor(){super(),this.emitter=new n.EventEmitter,this.onConnected=this.emitter.asSubscriber("connected"),this.onDisconnected=this.emitter.asSubscriber("disconnected"),this.shadow=this.attachShadow({mode:"open"})}connectedCallback(){this.emitter.emit("connected")}disconnectedCallback(){this.emitter.emit("disconnected")}}t.BaseComponent=o,t.defineCustomElement=function(e,t,i){return!window.customElements.get(e)&&(window.customElements.define(e,t,i),!0)}},9090(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ButtonBar=t.ButtonWithDropdown=t.ButtonWithDescription=t.Button=t.ButtonSize=void 0;const n=i(519),o=i(9084),s=i(5754),r=i(8391),a=i(4295),l=i(8784),d=i(5366),c=i(5354);var u;!function(e){e.DEFAULT="default",e.SMALL="small"}(u=t.ButtonSize||(t.ButtonSize={}));class h extends o.BaseComponent{constructor(e){var t,i,o,s,a,l,d;super(),this.options=e,this.eventStore=new Set,this.clickEmitter=new n.EventEmitter,this.onDidClick=this.clickEmitter.asSubscriber("onDidClick"),this.emitClick=e=>{this.clickEmitter.emit("onDidClick",e)},this.buttonText=null!==(t=this.textContent)&&void 0!==t?t:"",this.type=null!==(i=this.getAttribute("type"))&&void 0!==i?i:"",this.buttonTitle=null!==(o=this.getAttribute("title"))&&void 0!==o&&o,this.block="true"===this.getAttribute("block"),this.disabled="disabled"===this.getAttribute("disabled"),this.buttonIconId=null!==(s=this.getAttribute("iconId"))&&void 0!==s?s:"",this.buttonIcon=this.buttonIconId?{id:this.buttonIconId}:void 0,this.size=null!==(a=this.getAttribute("size"))&&void 0!==a?a:"",this.clearMargin=null!==(l="true"===this.getAttribute("clearMargin"))&&void 0!==l&&l,this.dangerType=null!==(d="true"===this.getAttribute("danger"))&&void 0!==d&&d,this.buttonMaxWidth=null!==this.getAttribute("maxWidth")?Number(this.getAttribute("maxWidth")):void 0,this.mnemonicIndex=null!==this.getAttribute("mnemonicIndex")?Number(this.getAttribute("mnemonicIndex")):void 0,this.initOptions(e),this.content=this.buttonText,this.button=document.createElement("button"),this.labelElement=document.createElement("span"),this.labelElement.classList.add("ui-button-label"),this.label=this.content,this.button.appendChild(this.labelElement);const u=document.createElement("style");u.appendChild(document.createTextNode((0,r.getButtonStyle)(c.ideChecker.isIDE))),this.renderBody(),this.renderEvent(),this.shadow.appendChild(u),this.shadow.appendChild(this.button)}initOptions(e){var t,i,n,o,s,r,a,l;e&&(this.buttonText=null!==(t=e.label)&&void 0!==t?t:"",this.clearMargin=null!==(i=e.clearMargin)&&void 0!==i&&i,this.type=e.secondary?"secondary":"primary",this.buttonIcon=null==e?void 0:e.buttonIcon,this.block=null!==(n=null==e?void 0:e.block)&&void 0!==n&&n,this.size=null!==(o=null==e?void 0:e.size)&&void 0!==o?o:u.DEFAULT,this.buttonTitle=null!==(s=e.title)&&void 0!==s&&s,this.dangerType=null!==(r=e.danger)&&void 0!==r&&r,this.mnemonicIndex=null!==(a=e.mnemonicIndex)&&void 0!==a?a:void 0,this.loadIcon=null!==(l=e.loading)&&void 0!==l&&l,this.buttonMaxWidth=e.maxWidth)}renderBody(){var e,t;this.button.disabled=this.disabled||!1,this.type&&"primary"!==this.type?"secondary"===this.type&&this.button.classList.add("ui-secondary-button"):this.button.classList.add("ui-button"),this.button.classList.toggle("ui-danger-button",this.dangerType),this.button.classList.add(`ui-button-${this.size}`),this.button.classList.toggle("ui-button-without-margin",this.clearMargin),this.button.classList.toggle("ui-button-block",this.block),this.buttonMaxWidth?(this.button.style.maxWidth=`${this.buttonMaxWidth}px`,this.button.classList.add("ui-button-maxWidth")):this.button.classList.remove("ui-button-maxWidth"),this.button.tabIndex=0,this.buttonIcon&&(this.icon=this.buttonIcon),this.loading=null!==(t=null===(e=this.options)||void 0===e?void 0:e.loading)&&void 0!==t&&t}renderEvent(){this.eventStore.add({element:this.button,type:"click",handler:this.emitClick}),this.eventStore.add({element:this.button,type:"keydown",handler:e=>{const t=e.code;let i=!1;!this.enabled||"Enter"!==t&&"Space"!==t?"Escape"===t&&this.button.blur():(this.emitClick(e),i=!0),i&&(e.stopPropagation(),e.preventDefault())}}),this.eventStore.forEach(e=>this.button.addEventListener(e.type,e.handler))}set icon(e){const t=(0,s.renderIcon)(e,this.shadow);t.classList.toggle("codicon-animation-spin",this.loadIcon),this.button.insertBefore(t,this.labelElement),this.removeIcon()}removeIcon(){this.loadIcon&&this.button.querySelectorAll(".codicon").forEach(e=>{e.className.includes(`${h.LOADING_ICON_ID} codicon-animation-spin`)||e.remove()})}set loading(e){var t;this.loadIcon=e,e?this.icon={id:h.LOADING_ICON_ID}:null===(t=this.button.querySelector(".codicon-loading-small"))||void 0===t||t.remove()}get element(){return this.button}get label(){return this.content}set label(e){this.deleteChild(this.labelElement),this.content=e,this.labelElement.append(...(0,s.renderLabelWithIcons)(e,this.shadow)),this.removeIcon(),this.renderTitle(),this.renderUnderline()}renderUnderline(){(this.mnemonicIndex||0===this.mnemonicIndex)&&this.updateMnemonicIndex(this.mnemonicIndex)}updateMnemonicIndex(e){var t;const i=null===(t=this.labelElement.firstElementChild)||void 0===t?void 0:t.classList.contains("codicon"),n=i?this.labelElement.innerText:this.content,o=(0,d.createUnderlineStr)(n,e);i?this.labelElement.removeChild(this.labelElement.childNodes[2]):this.labelElement.textContent="",this.labelElement.appendChild(o)}deleteChild(e){for(;e.hasChildNodes();)e.removeChild(e.firstChild)}renderTitle(){var e;this.buttonTitle&&(this.hover&&this.hover.dispose(),this.hover=l.Hover.setupIconLabelHover({content:"string"==typeof this.buttonTitle?this.buttonTitle:null!==(e=this.labelElement.textContent)&&void 0!==e?e:"",target:this.button,hoverPosition:l.HoverPosition.BELOW,showPointer:!1}),this.button.removeAttribute("title"),this.shadow.host.removeAttribute("title"))}get enabled(){return!this.button.classList.contains("disabled")}set enabled(e){this.button.disabled=!e,e?(this.button.classList.remove("disabled"),this.button.setAttribute("aria-disabled",String(!1))):(this.button.classList.add("disabled"),this.button.setAttribute("aria-disabled",String(!0)))}unsubscribeClickEvent(e){e?this.clickEmitter.removeEventListener("onDidClick",e):this.clickEmitter.clear()}focus(){this.button.tabIndex=0,this.button.focus()}hasFocus(){return this.button===document.activeElement}clearButtonBarMargin(e){this.button.classList.toggle("clear-margin-right",!!e)}dispose(){var e;this.disconnectedCallback(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.clickEmitter.clear(),null===(e=this.hover)||void 0===e||e.dispose()}}t.Button=h,h.LOADING_ICON_ID="loading-small";class p extends h{constructor(e){super(e);const t=this.getAttribute("description")||"";this.element.textContent="",this.element.classList.add("ui-button-description-wrapper"),this.element.appendChild(this.labelElement),this.descriptionElement=document.createElement("div"),this.descriptionElement.classList.add("ui-button-description"),this.description=t,this.element.appendChild(this.descriptionElement)}set description(e){this.deleteChild(this.descriptionElement),this.descriptionElement.append(...(0,s.renderLabelWithIcons)(e,this.shadow))}get description(){return this.descriptionElement.textContent||""}}t.ButtonWithDescription=p;class b extends o.BaseComponent{constructor(e){var t;super(),this.clickEmitter=new n.EventEmitter,this.onDidClick=this.clickEmitter.asSubscriber("onDidClick"),this.emitClick=e=>{this.clickEmitter.emit("onDidClick",e)},this.dispose=()=>{this.clickEmitter.clear(),this.buttonElement.dispose(),this.dropdownElement.dispose()},this.container=document.createElement("div"),this.container.classList.add("ui-button-dropdown"),this.container.classList.toggle("ui-secondary-button",null!==(t=null==e?void 0:e.secondary)&&void 0!==t&&t);const i=document.createElement("style");i.appendChild(document.createTextNode((0,r.getButtonDropdownStyle)(c.ideChecker.isIDE))),this.buttonElement=new h(e),this.container.append(this.buttonElement),this.renderButton(e),this.separator=document.createElement("div"),this.renderSeparator();const o=(null==e?void 0:e.size)===u.SMALL?"ide-button-small":"ide-button-default";this.separator.classList.add(o),this.action=new a.Action("primaryAction",this.buttonElement.label,void 0,!0,this.buttonElement.onDidClick),this.dropdownElement=new h({title:null==e?void 0:e.dropdownTitle,size:null==e?void 0:e.size,secondary:null==e?void 0:e.secondary}),this.renderDropDownButton(e),this.shadow.appendChild(i),this.shadow.appendChild(this.container)}renderButton(e){var t;this.buttonElement.element.classList.add("ui-button-dropdown","ui-button-dropdown-button"),this.buttonElement.classList.toggle("ui-button-dropdown-block",null!==(t=null==e?void 0:e.block)&&void 0!==t&&t),this.buttonElement.onDidClick(e=>{this.emitClick(e)})}renderSeparator(){this.separator.classList.add("ide-button-dropdown-separator");const e=document.createElement("div");e.classList.add("ui-dropdown-split"),this.separator.append(e),this.container.append(this.separator)}renderDropDownButton(e){var t,i;this.dropdownElement.element.classList.add("ui-button-dropdown","ui-button-dropdown-icon"),this.dropdownElement.icon={id:null!==(i=null===(t=null==e?void 0:e.buttonDropdownIcon)||void 0===t?void 0:t.id)&&void 0!==i?i:b.DROPDOWNICON},this.container.append(this.dropdownElement),this.dropdownElement.onDidClick(()=>{var t;null===(t=null==e?void 0:e.contextMenuProvider)||void 0===t||t.showContextMenu({getAnchor:()=>this.dropdownElement.element,getActions:()=>!1===e.addPrimaryActionToDropdown?[...e.actions]:[this.action,...e.actions],actionRunner:e.actionRunner,onHide:()=>this.dropdownElement.element.setAttribute("aira-expanded","false")}),this.dropdownElement.element.setAttribute("aira-expanded","true")})}get element(){return this.container}set icon(e){this.buttonElement.icon=e}set label(e){this.buttonElement.label=e,this.action.label=e}get label(){return this.buttonElement.label}set enabled(e){this.buttonElement.enabled=e,this.dropdownElement.enabled=e,this.separator.classList.toggle("disabled",!e)}get enabled(){return this.buttonElement.enabled}unsubscribeClickEvent(e){e?this.clickEmitter.removeEventListener("onDidClick",e):this.clickEmitter.clear()}focus(){this.buttonElement.focus()}hasFocus(){return this.buttonElement.hasFocus()||this.dropdownElement.hasFocus()}updateMnemonicIndex(e){var t,i,n;const o=null===(i=null===(t=this.buttonElement.shadowRoot)||void 0===t?void 0:t.lastElementChild)||void 0===i?void 0:i.firstElementChild,s=null===(n=null==o?void 0:o.firstElementChild)||void 0===n?void 0:n.classList.contains("codicon"),r=o.innerText,a=s?r:this.label,l=(0,d.createUnderlineStr)(a,e);o&&(s?o.removeChild(o.childNodes[2]):o.textContent="",o.appendChild(l))}clearButtonBarMargin(){}}t.ButtonWithDropdown=b,b.DROPDOWNICON="chevron-down";class m extends o.BaseComponent{constructor(e,t){super(),this._buttons=[],this.index=this.buttons.length-1,this.handleKeyDown=(e,t)=>{let i,n=!0;"ArrowLeft"===t.code?i=e>0?e-1:this._buttons.length-1:"ArrowRight"===t.code?i=e===this._buttons.length-1?0:e+1:n=!1,n&&"number"==typeof i&&(this._buttons[i].focus(),t.stopPropagation(),t.preventDefault())},this.dispose=()=>{this.buttons.forEach(e=>{e.element.removeEventListener("keydown",e.boundHandleKeyDown),e.dispose()})};const i=document.createElement("style");i.appendChild(document.createTextNode(r.ButtonBarStyle)),this.bar=document.createElement("div"),this.bar.classList.add("ui-button-bar"),this.clearMargin=t,!1===e&&this.bar.classList.add("ui-button-not-warp");const n=[];this.shadow.host.childNodes.forEach(e=>{n.push(e)}),this.bar.append(...n),this.shadow.appendChild(i),this.shadow.appendChild(this.bar)}get buttons(){return this._buttons}clearBurronMargin(){this.clearMargin&&this._buttons.forEach((e,t)=>{const i=t===this._buttons.length-1;e.clearButtonBarMargin(i)})}addButton(e,t){var i;const n=new h(e);return n.enabled=null===(i=!t)||void 0===i||i,n.element.classList.add("ui-button-focus"),this.pushButton(n),this.bar.appendChild(n),this.clearBurronMargin(),n}addButtonWithDescription(e,t){var i;const n=new p(e);return n.enabled=null===(i=!t)||void 0===i||i,n.element.classList.add("ui-button-focus"),this.pushButton(n),this.bar.appendChild(n),this.clearBurronMargin(),n}addButtonWithDropdown(e,t){var i;const n=new b(e);return n.enabled=null===(i=!t)||void 0===i||i,n.element.classList.add("ui-button-focus"),this.pushButton(n),this.bar.appendChild(n),this.clearBurronMargin(),n}pushButton(e){this.buttons.push(e);const t=this.buttons.length-1,i=this.handleKeyDown.bind(this,t);e.element.addEventListener("keydown",i),e.boundHandleKeyDown=i}}t.ButtonBar=m,(0,o.defineCustomElement)("ide-button",h),(0,o.defineCustomElement)("ide-button-description",p),(0,o.defineCustomElement)("ide-button-dropdown",b),(0,o.defineCustomElement)("ide-button-bar",m)},9165(e,t){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ScrollbarState=void 0;class i{constructor(e,t,i,n,o){this._scrollbarSize=Math.round(e),this._oppositeScrollbarSize=Math.round(t),this._visibleSize=i,this._scrollSize=n,this._scrollPosition=o,this._computedAvailableSize=0,this._computedIsNeeded=!1,this._computedSliderSize=0,this._computedSliderRatio=0,this._computedSliderPosition=0,this._refreshComputedValues()}clone(){return new i(this._scrollbarSize,this._oppositeScrollbarSize,this._visibleSize,this._scrollSize,this._scrollPosition)}setVisibleSize(e){const t=Math.round(e);return this._visibleSize!==t&&(this._visibleSize=t,this._refreshComputedValues(),!0)}setScrollSize(e){const t=Math.round(e);return this._scrollSize!==t&&(this._scrollSize=t,this._refreshComputedValues(),!0)}setScrollPosition(e){const t=Math.round(e);return this._scrollPosition!==t&&(this._scrollPosition=t,this._refreshComputedValues(),!0)}setScrollbarSize(e){this._scrollbarSize=Math.round(e)}setOppositeScrollbarSize(e){this._oppositeScrollbarSize=Math.round(e)}static _computeValues(e,t,i,n){const o=Math.max(0,t-e),s=Math.max(0,o),r=i>0&&i>t;if(!r)return{computedAvailableSize:Math.round(o),computedIsNeeded:r,computedSliderSize:Math.round(s),computedSliderRatio:0,computedSliderPosition:0};const a=Math.round(Math.max(20,Math.floor(t*s/i))),l=(s-a)/(i-t),d=n*l;return{computedAvailableSize:Math.round(o),computedIsNeeded:r,computedSliderSize:Math.round(a),computedSliderRatio:l,computedSliderPosition:Math.round(d)}}_refreshComputedValues(){const e=i._computeValues(this._oppositeScrollbarSize,this._visibleSize,this._scrollSize,this._scrollPosition);this._computedAvailableSize=e.computedAvailableSize,this._computedIsNeeded=e.computedIsNeeded,this._computedSliderSize=e.computedSliderSize,this._computedSliderRatio=e.computedSliderRatio,this._computedSliderPosition=e.computedSliderPosition}getScrollPosition(){return this._scrollPosition}getRectangleLargeSize(){return this._computedAvailableSize}getRectangleSmallSize(){return this._scrollbarSize}isNeeded(){return this._computedIsNeeded}getSliderSize(){return this._computedSliderSize}getSliderPosition(){return this._computedSliderPosition}getDesiredScrollPositionFromOffset(e){if(!this._computedIsNeeded)return 0;const t=e-this._computedSliderSize/2;return Math.round(t/this._computedSliderRatio)}getDesiredScrollPositionFromOffsetPaged(e){if(!this._computedIsNeeded)return 0;const t=e;let i=this._scrollPosition;return t<this._computedSliderPosition?i-=this._visibleSize:i+=this._visibleSize,i}getDesiredScrollPositionFromDelta(e){if(!this._computedIsNeeded)return 0;const t=this._computedSliderPosition+e;return Math.round(t/this._computedSliderRatio)}}t.ScrollbarState=i},9302(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.CheckBox=t.IconPosition=t.PREFIX=void 0;const n=i(519),o=i(9084),s=i(9733),r=i(5754),a=i(8784),l=i(5366),d=i(5354);var c;t.PREFIX="ide-checkbox",function(e){e.FRONT="front",e.BEHIND="behind"}(c=t.IconPosition||(t.IconPosition={}));class u extends o.BaseComponent{constructor(e){super(),this.domId="checkbox_id_"+u.InstanceCount++,this.uiPrefix=t.PREFIX,this.clickEmitter=new n.EventEmitter,this.onDidChange=this.clickEmitter.asSubscriber("onDidChange"),this.eventStore=new Set,this.checkBoxState=this.getOptions(e,this.getFilterAttributesOptions()),this.checkBoxWrapper=document.createElement("div"),this.checkBoxWrapper.classList.add(`${this.uiPrefix}-wrapper`),this.symbol=document.createElement("div"),this.checkBox=document.createElement("span"),this.checkBox.id=this.domId,this.checkBox.classList.add(`${this.uiPrefix}`),this.labelElement=document.createElement("label"),this.labelElement.setAttribute("for",this.checkBox.id),this.labelElement.classList.add(`${this.uiPrefix}-label`),this.indicatorIcon=document.createElement("span"),this.indicatorIcon.classList.add(`${this.uiPrefix}-indicatorIcon`),this.descriptionElement=document.createElement("label"),this.descriptionElement.classList.add(`${this.uiPrefix}-description`),this.render()}getOptions(e,t){const i=Object.assign(Object.assign({},t),e);return void 0===i.isChecked&&(i.isChecked=!1),void 0===i.isEnabled&&(i.isEnabled=!0),i}getFilterAttributesOptions(){return{label:(0,l.filterAttribute)(this.getAttribute("label")),value:(0,l.filterAttribute)(this.getAttribute("value")),secondaryLabel:(0,l.filterAttribute)(this.getAttribute("secondaryLabel")),mnemonicIndex:Number((0,l.filterAttribute)(this.getAttribute("mnemonicIndex"))),indicatorIcon:(0,l.filterAttribute)(this.getAttribute("indicatorIcon")),isChecked:(0,l.filterAttribute)(this.getAttribute("checked")),isWidgets:(0,l.filterAttribute)(this.getAttribute("widgets")),title:(0,l.filterAttribute)(this.getAttribute("title")),isEnabled:(0,l.filterAttribute)(this.getAttribute("enabled")),description:(0,l.filterAttribute)(this.getAttribute("description")),descriptionTitle:(0,l.filterAttribute)(this.getAttribute("descriptionTitle"))}}addEvent(){this.eventStore.add({element:this.checkBoxWrapper,type:"click",handler:()=>{this.isEnabled&&this.checkedEvent()}}),this.eventStore.add({element:this.checkBoxWrapper,type:"keydown",handler:e=>{"Space"===e.code&&this.checkedEvent()}}),this.eventStore.forEach(e=>e.element.addEventListener(e.type,e.handler))}checkedEvent(){this.setChecked(!this.isChecked),this.updateSymbol(),this.clickEmitter.emit("onDidChange",this.checkBoxState)}render(){var e,t;(0,l.updateSpacingFromAttribute)(this.parentElement,this.style),this.updateIsCheckedFromGroupCheckedAttribute(),this.hover&&this.hover.dispose(),this.hover=a.Hover.setupIconLabelHover({content:"string"==typeof this.checkBoxState.title?this.checkBoxState.title:null!==(e=this.labelElement.innerText)&&void 0!==e?e:"",target:this.checkBoxWrapper,hoverPosition:a.HoverPosition.BELOW,showPointer:!1}),this.checkBoxWrapper.removeAttribute("title"),this.shadow.host.removeAttribute("title"),this.hover=a.Hover.setupIconLabelHover({content:"string"==typeof this.checkBoxState.descriptionTitle?this.checkBoxState.descriptionTitle:null!==(t=this.descriptionElement.innerText)&&void 0!==t?t:"",target:this.descriptionElement,hoverPosition:a.HoverPosition.BELOW,showPointer:!1}),this.descriptionElement.removeAttribute("descriptionTitle"),this.shadow.host.removeAttribute("descriptionTitle"),this.checkBoxWrapper.setAttribute("value",this.checkBoxState.value),this.checkBoxWrapper.setAttribute("enabled",this.checkBoxState.isEnabled?"true":"false"),this.checkBoxWrapper.setAttribute("tabindex",this.checkBoxState.isEnabled?"0":"-1"),this.addEvent(),this.updateSymbol(),this.symbol.appendChild(this.checkBoxState.isIndeterminate?(0,r.renderIcon)({id:"chrome-minimize"},this.shadow):(0,r.renderIcon)({id:"check"},this.shadow)),isNaN(this.checkBoxState.mnemonicIndex)?this.labelElement.innerText=this.checkBoxState.label:this.updateMnemonicIndex(this.checkBoxState.mnemonicIndex),this.renderWidgets(),this.checkBoxState.indicatorIcon&&this.indicatorIcon.appendChild((0,r.renderIcon)({id:`${this.checkBoxState.indicatorIcon}`},this.shadow)),this.checkBox.appendChild(this.symbol),this.checkBoxState.iconPosition===c.FRONT?this.checkBoxWrapper.insertBefore(this.indicatorIcon,this.labelElement):this.checkBoxWrapper.appendChild(this.indicatorIcon),this.descriptionElement.innerText=this.checkBoxState.description||"",this.checkBoxWrapper.appendChild(this.descriptionElement);const i=document.createElement("style");i.appendChild(document.createTextNode((0,s.getCheckBoxStyle)(d.ideChecker.isIDE))),this.shadow.append(i,this.checkBoxWrapper)}renderWidgets(){if(this.checkBoxState.isWidgets){this.checkBoxWrapper.classList.add(`${this.uiPrefix}-wrapper`,`${this.getAttribute("widgets")||this.checkBoxState.isWidgets}`);const e=document.createElement("div");e.classList.add(`${this.uiPrefix}-left-container`);const t=document.createElement("div");t.classList.add(`${this.uiPrefix}-right-container`);const i=document.createElement("label");i.innerText=this.checkBoxState.secondaryLabel,i.setAttribute("for",this.checkBox.id),i.classList.add(`${this.uiPrefix}-secondary-label`),e.append(this.labelElement,i),t.appendChild(this.checkBox),this.checkBoxWrapper.append(e,t)}else this.checkBoxWrapper.append(this.checkBox,this.labelElement)}updateIsCheckedFromGroupCheckedAttribute(){if(this.parentElement){const e=this.parentElement.getAttribute("groupchecked");if("true"===e)this.checkBoxState.isChecked=!0;else{if("false"!==e)return;this.checkBoxState.isChecked=!1}}}updateSymbol(){this.isChecked?(this.checkBox.setAttribute("checked","true"),this.symbol.style.visibility="visible",this.symbol.style.display="flex",this.checkBoxState.isWidgets&&(this.checkBoxWrapper.classList.toggle(`${this.uiPrefix}-wrapper`,!1),this.checkBoxWrapper.classList.toggle(`${this.uiPrefix}-wrapper-active`,!0))):(this.checkBox.hasAttribute("checked")&&this.checkBox.removeAttribute("checked"),this.symbol.style.visibility="hidden",this.checkBoxState.isWidgets&&(this.checkBoxWrapper.classList.toggle(`${this.uiPrefix}-wrapper`,!0),this.checkBoxWrapper.classList.toggle(`${this.uiPrefix}-wrapper-active`,!1)))}setChecked(e){this.checkBoxState.isChecked=e,this.updateSymbol()}setEnabled(e){this.checkBoxState.isEnabled=e,this.checkBoxWrapper.setAttribute("enabled",this.checkBoxState.isEnabled?"true":"false")}focus(){this.checkBox.focus()}hasFocus(){return this.checkBox===document.activeElement}updateMnemonicIndex(e){const t=this.checkBoxState.label,i=(0,l.createUnderlineStr)(t,e);this.labelElement.textContent="",this.labelElement.appendChild(i)}set label(e){this.labelElement.innerText=e,this.checkBoxState.label=e}get label(){return this.checkBoxState.label}set secondaryLabel(e){this.labelElement.innerText=e,this.checkBoxState.secondaryLabel=e}get secondaryLabel(){return this.checkBoxState.secondaryLabel}set description(e){this.labelElement.innerText=e,this.checkBoxState.description=e}get description(){return this.checkBoxState.description}set mnemonicIndex(e){this.checkBoxState.mnemonicIndex=e}get mnemonicIndex(){return this.checkBoxState.mnemonicIndex}get isChecked(){return this.checkBoxState.isChecked}get isEnabled(){return this.checkBoxState.isEnabled}get isIndeterminate(){return this.checkBoxState.isIndeterminate}set isWidgets(e){this.checkBoxState.isWidgets=e}get isWidgets(){return this.checkBoxState.isWidgets}get value(){return this.checkBoxState.value}set title(e){this.checkBoxState.title=e}get title(){return this.checkBoxState.title}set descriptionTitle(e){this.checkBoxState.descriptionTitle=e}get descriptionTitle(){return this.checkBoxState.descriptionTitle}set icon(e){for(this.checkBoxState.indicatorIcon=e;this.indicatorIcon.firstChild;)this.indicatorIcon.firstChild.remove();e&&this.indicatorIcon.appendChild((0,r.renderIcon)({id:`${this.checkBoxState.indicatorIcon}`},this.shadow))}get icon(){return this.checkBoxState.indicatorIcon}dispose(){this.clickEmitter.clear(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler))}}t.CheckBox=u,u.InstanceCount=0,(0,o.defineCustomElement)("ide-checkbox",u)},9472(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.SimpleIconLabel=t.IconStyle=void 0;const n=i(9084),o=i(5754),s=i(6199),r=i(2994);t.IconStyle={warning:`color:${s.warnStatusColor};font-size:48px;`};class a extends n.BaseComponent{constructor(e){var t,i;super(),this.addStyleSheet(),this.initOptions(e),this.simpleIconLabel=document.createElement("div"),this.style.display="inline-flex",this.style.alignItems="center",this.simpleIconLabel.style.fontFamily=s.fontFamily,this.simpleIconLabel.style.display="inline-flex",this.simpleIconLabel.style.alignItems="center",this.resetChildren(this.simpleIconLabel,...(0,o.renderLabelWithIcons)(null!==(t=this.options.text)&&void 0!==t?t:"",this.shadow,this.options.iconColor)),this.simpleIconLabel.title=null!==(i=this.options.title)&&void 0!==i?i:"",this.shadow.appendChild(this.simpleIconLabel)}initOptions(e){var t,i,n;e=e||{};const{text:o=(null!==(t=this.textContent)&&void 0!==t?t:""),iconColor:s=(null!==(i=this.getAttribute("iconColor"))&&void 0!==i?i:""),title:r=(null!==(n=this.getAttribute("title"))&&void 0!==n?n:""),isWarning:a=this.hasAttribute("isWarning")}=e;this.options=Object.assign({text:o,title:r,iconColor:s,isWarning:a},e)}addStyleSheet(){const e=document.createElement("style");e.appendChild(document.createTextNode(r.SimpleIconLabelStyle)),this.shadow.appendChild(e)}resetChildren(e,...i){e.textContent="",this.options.isWarning&&i.forEach(e=>{e&&"string"!=typeof e&&e.setAttribute("style",t.IconStyle.warning)}),e.append(...i)}set text(e){this.options.text=e,this.resetChildren(this.simpleIconLabel,...(0,o.renderLabelWithIcons)(null!=e?e:"",this.shadow,this.options.iconColor))}get label(){var e,t;return null!==(t=null===(e=this.simpleIconLabel.textContent)||void 0===e?void 0:e.trim())&&void 0!==t?t:""}get iconlabel(){return this.options.text}set title(e){this.simpleIconLabel.title=e}setFontFamily(e){e&&(this.simpleIconLabel.style.fontFamily=e)}dispose(){}}t.SimpleIconLabel=a,(0,n.defineCustomElement)("ide-simple-icon-label",a)},9483(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.DomScrollableElement=t.SmoothScrollableElement=t.ScrollableElement=t.AbstractScrollableElement=t.MouseWheelClassifier=t.scheduleAtNextAnimationFrame=void 0;const n=i(1922),o=i(613),s=i(5731),r=i(519);class a{constructor(e,t=0){this._runner=e,this.priority=t,this._canceled=!1}dispose(){this._canceled=!0}execute(){if(!this._canceled)try{this._runner()}catch(e){throw new Error("execute requestAnimationFrame runner error")}}static sort(e,t){return t.priority-e.priority}}function l(e,t=0){let i=[],n=null,o=!1,s=!1;const r=new a(e,t);return i.push(r),o||(o=!0,window.requestAnimationFrame(()=>{for(o=!1,n=i,i=[],s=!0;n.length>0;){n.sort(a.sort);const e=n.shift();null==e||e.execute()}s=!1})),r}t.scheduleAtNextAnimationFrame=l;class d{constructor(e,t,i){this.timestamp=e,this.deltaX=t,this.deltaY=i,this.score=0}}class c{constructor(){this._capacity=5,this._memory=[],this._front=-1,this._rear=-1}isPhysicalMouseWheel(){if(-1===this._front&&-1===this._rear)return!1;let e=1,t=0,i=1,n=this._rear;for(;;){const o=n===this._front?e:Math.pow(2,-i);if(e-=o,t+=this._memory[n].score*o,n===this._front)break;n=(this._capacity+n-1)%this._capacity,i++}return t<=.5}accept(e,t,i){const n=new d(e,t,i);n.score=this._computeScore(n),-1===this._front&&-1===this._rear?(this._memory[0]=n,this._front=0,this._rear=0):(this._rear=(this._rear+1)%this._capacity,this._rear===this._front&&(this._front=(this._front+1)%this._capacity),this._memory[this._rear]=n)}_computeScore(e){if(Math.abs(e.deltaX)>0&&Math.abs(e.deltaY)>0)return 1;let t=.5;return this._isAlmostInt(e.deltaX)&&this._isAlmostInt(e.deltaY)||(t+=.25),Math.min(Math.max(t,0),1)}_isAlmostInt(e){return Math.abs(Math.round(e)-e)<.01}}t.MouseWheelClassifier=c,c.INSTANCE=new c;class u{get options(){return this._options}constructor(e,t,i){this._hideTimeout=void 0,this._onScroll=new r.EventEmitter,this.onScroll=this._onScroll.asSubscriber("onScroll"),this._onWillScroll=new r.EventEmitter,this.onWillScroll=this._onWillScroll.asSubscriber("onWillScroll"),e.style.overflow="hidden",this._options=(0,o.resolveOptions)(t),this._scrollable=i,this._scrollable.onScroll(e=>{this._onWillScroll.emit("onWillScroll",e),this._onDidScroll(e),this._onScroll.emit("onScroll",e)});const s={onMouseWheel:(e,t,i)=>this._onMouseWheel(e,t,i),onDragStart:()=>this._onDragStart(),onDragEnd:()=>this._onDragEnd()};this._verticalScrollbar=new n.Scrollbar(this._scrollable,this._options,s,"vertical"),this._horizontalScrollbar=new n.Scrollbar(this._scrollable,this._options,s,"horizontal"),this._domNode=document.createElement("div"),this._domNode.className="monaco-scrollable-element "+this._options.className,this._domNode.setAttribute("role","presentation"),this._domNode.style.position="relative",this._domNode.style.overflow="hidden",this._domNode.appendChild(e),this._domNode.appendChild(this._horizontalScrollbar),this._domNode.appendChild(this._verticalScrollbar),this._options.useShadows?(this._leftShadowDomNode=document.createElement("div"),this._leftShadowDomNode.classList.add("shadow"),this._domNode.appendChild(this._leftShadowDomNode),this._topShadowDomNode=document.createElement("div"),this._topShadowDomNode.classList.add("shadow"),this._domNode.appendChild(this._topShadowDomNode),this._topLeftShadowDomNode=document.createElement("div"),this._topLeftShadowDomNode.classList.add("shadow"),this._domNode.appendChild(this._topLeftShadowDomNode)):(this._leftShadowDomNode=null,this._topShadowDomNode=null,this._topLeftShadowDomNode=null),this._listenOnDomNode=this._options.listenOnDomNode||this._domNode,this._mouseWheelToDispose=[],this._setListeningToMouseWheel(this._options.handleMouseWheel),this._listenOnDomNode.addEventListener("mouseover",()=>this._onMouseOver()),this._listenOnDomNode.addEventListener("mouseleave",()=>this._onMouseLeave()),this._isDragging=!1,this._mouseIsOver=!1,this._shouldRender=!0,this._revealOnScroll=!0}dispose(){this._mouseWheelToDispose=[]}getDomNode(){return this._domNode}getOverviewRulerLayoutInfo(){return{parent:this._domNode,insertBefore:this._verticalScrollbar}}delegateVerticalScrollbarPointerDown(e){this._verticalScrollbar.delegatePointerDown(e)}getScrollDimensions(){return this._scrollable.getScrollDimensions()}setScrollDimensions(e){this._scrollable.setScrollDimensions(e,!1)}updateClassName(e){this._options.className=e,this._domNode.className="monaco-scrollable-element "+this._options.className}updateOptions(e){void 0!==e.handleMouseWheel&&(this._options.handleMouseWheel=e.handleMouseWheel,this._setListeningToMouseWheel(this._options.handleMouseWheel)),void 0!==e.mouseWheelScrollSensitivity&&(this._options.mouseWheelScrollSensitivity=e.mouseWheelScrollSensitivity),void 0!==e.fastScrollSensitivity&&(this._options.fastScrollSensitivity=e.fastScrollSensitivity),void 0!==e.scrollPredominantAxis&&(this._options.scrollPredominantAxis=e.scrollPredominantAxis),void 0!==e.horizontal&&(this._options.horizontal=e.horizontal),void 0!==e.vertical&&(this._options.vertical=e.vertical),void 0!==e.horizontalScrollbarSize&&(this._options.horizontalScrollbarSize=e.horizontalScrollbarSize),void 0!==e.verticalScrollbarSize&&(this._options.verticalScrollbarSize=e.verticalScrollbarSize),void 0!==e.scrollByPage&&(this._options.scrollByPage=e.scrollByPage),this._horizontalScrollbar.updateOptions(this._options),this._verticalScrollbar.updateOptions(this._options),this._options.lazyRender||this._render()}setRevealOnScroll(e){this._revealOnScroll=e}triggerScrollFromMouseWheelEvent(e){this._onMouseWheel(e)}_setListeningToMouseWheel(e){this._mouseWheelToDispose.length>0!==e&&(this._mouseWheelToDispose=[],e&&this._mouseWheelToDispose.push(this._listenOnDomNode.addEventListener("wheel",e=>{this._onMouseWheel(e)},{passive:!1})))}wheelDeltaDimension(e,t,i){let n=i,o=t;return e&&(e.deltaMode===e.DOM_DELTA_LINE?navigator.userAgent.indexOf("Firefox")>=0?(n=-e.deltaY/3,o=-e.deltaX/3):(n=-e.deltaY,o=-e.deltaX):(n=-e.deltaY/100,o=-e.deltaX/100)),{deltaX:o,deltaY:n}}_onMouseWheel(e,t=0,i=0){const n=c.INSTANCE,o=this.wheelDeltaDimension(e,t,i);{const e=window.devicePixelRatio;n.accept(Date.now(),o.deltaX/e,o.deltaY/e)}let s=!1;if(o.deltaY||o.deltaX){let t=o.deltaY*this._options.mouseWheelScrollSensitivity,i=o.deltaX*this._options.mouseWheelScrollSensitivity;this._options.scrollPredominantAxis&&(Math.abs(t)>=Math.abs(i)?i=0:t=0);const r=e&&e.shiftKey;!this._options.scrollYToX&&!r||i||(i=t,t=0),e&&e.altKey&&(i*=this._options.fastScrollSensitivity,t*=this._options.fastScrollSensitivity);const a=this._scrollable.getFutureScrollPosition();let l={};if(t){const e=50*t,i=a.scrollTop-(e<0?Math.floor(e):Math.ceil(e));this._verticalScrollbar.writeScrollPosition(l,i)}if(i){const e=50*i,t=a.scrollLeft-(e<0?Math.floor(e):Math.ceil(e));this._horizontalScrollbar.writeScrollPosition(l,t)}l=this._scrollable.validateScrollPosition(l),(a.scrollLeft!==l.scrollLeft||a.scrollTop!==l.scrollTop)&&(this._options.mouseWheelSmoothScroll&&n.isPhysicalMouseWheel()?this._scrollable.setScrollPositionSmooth(l):this._scrollable.setScrollPositionNow(l),s=!0)}let r=s;!r&&this._options.alwaysConsumeMouseWheel&&(r=!0),!r&&this._options.consumeMouseWheelIfScrollbarIsNeeded&&(this._verticalScrollbar.isNeeded()||this._horizontalScrollbar.isNeeded())&&(r=!0),r&&(e&&e.preventDefault(),e&&e.stopPropagation())}_onDidScroll(e){this._shouldRender=this._verticalScrollbar.onDidScroll(e)||this._horizontalScrollbar.onDidScroll(e)||this._shouldRender,this._options.useShadows&&(this._shouldRender=!0),this._revealOnScroll&&this._reveal(),this._options.lazyRender||this._render()}renderNow(){if(!this._options.lazyRender)throw new Error("Please use `lazyRender` together with `renderNow`!");this._render()}_render(){if(this._shouldRender&&(this._shouldRender=!1,this._horizontalScrollbar.render(),this._verticalScrollbar.render(),this._options.useShadows)){const e=this._scrollable.getCurrentScrollPosition(),t=e.scrollTop>0,i=e.scrollLeft>0,n=i?" left":"",o=t?" top":"",s=i||t?" top-left-corner":"";this._leftShadowDomNode.className=`shadow${n}`,this._topShadowDomNode.className=`shadow${o}`,this._topLeftShadowDomNode.className=`shadow${s}${o}${n}`}}_onDragStart(){this._isDragging=!0,this._reveal()}_onDragEnd(){this._isDragging=!1,this._hide()}_onMouseLeave(){this._mouseIsOver=!1,this._hide()}_onMouseOver(){this._mouseIsOver=!0,this._reveal()}_reveal(){this._verticalScrollbar.beginReveal(),this._horizontalScrollbar.beginReveal(),this._scheduleHide()}_hide(){this._mouseIsOver||this._isDragging||(this._verticalScrollbar.beginHide(),this._horizontalScrollbar.beginHide())}_scheduleHide(){this._mouseIsOver||this._isDragging||(this._hideTimeout&&(clearTimeout(this._hideTimeout),this._hideTimeout=void 0),this._hideTimeout=setTimeout(()=>{this._hide(),this._hideTimeout=void 0},500))}}t.AbstractScrollableElement=u,t.ScrollableElement=class extends u{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1,super(e,t,new s.Scrollable({forceIntegerValues:!0,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>l(e)}))}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}},t.SmoothScrollableElement=class extends u{constructor(e,t,i){super(e,t,i)}setScrollPosition(e){e.reuseAnimation?this._scrollable.setScrollPositionSmooth(e,e.reuseAnimation):this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}},t.DomScrollableElement=class extends u{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1,super(e,t,new s.Scrollable({forceIntegerValues:!1,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>l(e)})),this._element=e,this.onScroll(e=>{e.scrollTopChanged&&(this._element.scrollTop=e.scrollTop),e.scrollLeftChanged&&(this._element.scrollLeft=e.scrollLeft)}),this.scanDomNode()}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}scanDomNode(){this.setScrollDimensions({width:this._element.clientWidth,scrollWidth:this._element.scrollWidth,height:this._element.clientHeight,scrollHeight:this._element.scrollHeight}),this.setScrollPosition({scrollLeft:this._element.scrollLeft,scrollTop:this._element.scrollTop})}}},9574(e,t,i){"use strict";var n=this&&this.__awaiter||function(e,t,i,n){return new(i||(i=Promise))(function(o,s){function r(e){try{l(n.next(e))}catch(e){s(e)}}function a(e){try{l(n.throw(e))}catch(e){s(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i(function(e){e(t)})).then(r,a)}l((n=n.apply(e,t||[])).next())})};Object.defineProperty(t,"__esModule",{value:!0}),t.DropdownMenu=t.BaseDropdown=void 0;const o=i(519),s=i(9084),r=i(7157),a=i(308),l=i(4295),d=i(8784);var c;!function(e){e[e.RIGHT=0]="RIGHT",e[e.LEFT=1]="LEFT",e[e.DOWN=2]="DOWN"}(c||(c={}));const u="mousedown";class h extends s.BaseComponent{constructor(e){super(),this._onDidRun=new o.EventEmitter,this.onDidRun=this._onDidRun.asSubscriber("onDidRun"),this._onBeforeRun=new o.EventEmitter,this.onBeforeRun=this._onBeforeRun.asSubscriber("onDidRun"),this.eventStore=new Set,this._onDidChangeVisibility=new o.EventEmitter,this.onDidChangeVisibility=this._onDidChangeVisibility.asSubscriber("onDidChangeVisibility"),this.dropdown=document.createElement("div"),this.dropdown.classList.add("ide-dropdown"),this._label=document.createElement("div"),this._label.classList.add("dropdown-label"),this.dropdown.appendChild(this._label),this._toolTip="";const t=document.createElement("style");t.appendChild(document.createTextNode(r.dropdownStyle)),this._actionRunner=new l.ActionRunner,this._actionRunner.onDidRun(e=>this._onDidRun.emit("onDidRun",e)),this._actionRunner.onBeforeRun(e=>this._onBeforeRun.emit("onBeforeRun",e));let i=e.labelRenderer;i||(i=t=>(t.textContent=e.label||"",null)),this.render(),i(this._label)&&i(this._label),this.shadow.appendChild(t),this.shadow.appendChild(this.dropdown)}render(){this._addEventStoreMouse(),this._addEventStoreKeyboard(),this.eventStore.forEach(e=>this.element.addEventListener(e.type,e.handler))}_addEventStoreMouse(){this.eventStore.add({element:this.element,type:"click",handler:e=>{o.EventFlowAssister.stop(e,!0)}}),this.eventStore.add({element:this.element,type:u,handler:e=>{d.Hover.hide(),o.EventFlowAssister.stop(e,!0)}}),this.eventStore.add({element:this.element,type:"mouseenter",handler:()=>{this.toolTip&&""!==this.toolTip&&d.Hover.show({content:this.toolTip,target:this.element})}}),this.eventStore.add({element:this._label,type:u,handler:e=>{e instanceof MouseEvent&&(e.detail>1||0!==e.button&&2!==e.button)||(this.visible?this.hide():this.show())}})}_addEventStoreKeyboard(){this.eventStore.add({element:this._label,type:"keyup",handler:e=>{const t=e;"Enter"!==t.key&&"Space"!==t.key&&"3"!==t.code&&"10"!==t.code||(o.EventFlowAssister.stop(e,!0),this.visible?this.hide():this.show())}})}get element(){return this.dropdown}get label(){return this._label}set toolTip(e){this._toolTip=e}get toolTip(){return this._toolTip}isVisible(){return!!this.visible}show(){this.visible||(this.visible=!0,this._onDidChangeVisibility.emit("onDidChangeVisibility",!0))}hide(){this.visible&&(this.visible=!1,this._onDidChangeVisibility.emit("onDidChangeVisibility",!1))}onEvent(){this.hide()}run(e,t){return n(this,void 0,void 0,function*(){yield this._actionRunner.run(e,t)})}dispose(){this.disconnectedCallback(),this.hide(),this._label&&this._label.remove(),this.eventStore.forEach(e=>e.element.removeEventListener(e.type,e.handler)),this.eventStore.clear(),this._onDidChangeVisibility.clear(),this._onDidRun.clear(),this._onBeforeRun.clear()}}t.BaseDropdown=h;class p extends h{constructor(e){super(e),this._actions=[],this._contextMenuProvider=e.contextMenuProvider,this.menuClassName=e.menuClassName||"",this.menuAsChild=!!e.menuAsChild,this.actionProvider=e.actionProvider,this.actions=e.actions||[]}get actions(){return this.actionProvider?this.actionProvider.getActions():this._actions}set actions(e){this._actions=e}show(){super.show(),this.element.classList.add("active"),this._contextMenuProvider.showContextMenu({actionRunner:this.menuOptions?this.menuOptions.actionRunner:void 0,anchorAlignment:this.menuOptions?this.menuOptions.anchorAlignment:a.AnchorAlignment.LEFT,domForShadowRoot:this.menuAsChild?this.element:void 0,getAnchor:()=>this.element,getActions:()=>this.actions,getActionsContext:()=>this.menuOptions?this.menuOptions.context:null,getActionViewItem:e=>this.menuOptions&&this.menuOptions.actionViewItemProvider?this.menuOptions.actionViewItemProvider(e):void 0,getKeyBinding:e=>this.menuOptions&&this.menuOptions.getKeyBinding?this.menuOptions.getKeyBinding(e):void 0,getMenuClassName:()=>this.menuClassName,onHide:()=>this.onHide()})}set menuOptions(e){this._menuOptions=e}get menuOptions(){return this._menuOptions}hide(){super.hide()}onHide(){this.hide(),this.element.classList.remove("active")}}t.DropdownMenu=p,(0,s.defineCustomElement)("ide-base-dropdown",h),(0,s.defineCustomElement)("ide-dropdown-menu",p)},9603(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Util=void 0;const n=i(2541);class o{static get formData(){return{score:"",reasons:new Map,otherReason:"",otherSuggestion:"",reasonsKeys:"",reasonsValues:""}}static createElement(e,t){const i=document.createElement(e);return t?(t.attrKey&&t.attrValue&&i.setAttribute(t.attrKey,t.attrValue),t.text&&(i.textContent=t.text),t.class&&(Array.isArray(t.class)?t.class:[t.class]).forEach(e=>i.classList.add(e)),i):i}static renderTitleBar(e){const t=this.createElement("div",{class:"title-bar-container"}),i=this.createElement("div",{text:e,class:"title-bar"}),n=this.createElement("div",{class:"close"}),o=this.createElement("div",{class:["codicon","codicon-chrome-close"]});return n.append(o),t.append(i,n),{titleBar:t,closeContainer:n}}static renderRatesContainer(e,t){const i=this.createElement("div",{class:"rates"}),n=this.createElement("div",{class:"rates-title"});n.append(this.createElement("span",{text:e,class:"unsatisfactory"}),this.createElement("span",{text:t,class:"satisfied"})),i.append(n);const o=this.createElement("div",{class:"score"});for(let e=0;e<=10;e++){const t=this.createElement("span",{class:["rate",`rate-${e}`],attrKey:"id",attrValue:e.toString(),text:e.toString()});o.append(t)}return i.append(n,o),i}static renderErrorTips(e){const t=this.createElement("div",{class:["error-tips-container",this.HIDE_CLASS_NAME]}),i=this.createElement("span",{class:["codicon","codicon-error"]}),n=this.createElement("span",{text:e,class:"error-tips"});return t.append(i,n),t}static renderButtonContainer(e,t){const i=this.createElement("div",{class:"button-container"}),n=this.createElement("a",{text:e,class:["button","primary"],attrKey:"role",attrValue:"button"}),o=this.createElement("span",{class:["codicon","codicon-loading-small"]});o.classList.add(this.HIDE_CLASS_NAME),n.insertBefore(o,n.firstChild);const s=this.createElement("a",{text:t,class:["button","secondary"],attrKey:"role",attrValue:"button"});return i.append(n,s),i.classList.add(this.HIDE_CLASS_NAME),{buttonElement:i,okButton:n,cancelButton:s,loading:o}}static renderOtherSuggestion(e,t,i,o){const s=this.createElement("div",{class:"suggestion"}),r=this.createElement("div",{class:"other-suggestion"}),a=this.createElement("span",{text:e,class:"title"}),l=this.createElement("span",{text:t,class:"description"});r.append(a,l);const d=new n.InputBox({type:"multiple",multipleMaxLength:400});d.value=i;const c=new n.InputBox({type:"multiple",multipleMaxLength:400});c.value=i;const u=this.renderErrorTips(o);return s.append(r,d,c,u),s.classList.add(this.HIDE_CLASS_NAME),{input:d,title:a,description:l,errorTips:u,container:s,unsatisfiedInput:c}}static renderReasonContainer(e,t,i,o,s,r){const a=this.createElement("div",{class:"reason"}),l=this.createElement("div",{class:"reason-title"});l.append(this.createElement("span",{text:e,class:"title"}),this.createElement("span",{text:t,class:"description"}));const d=this.createElement("div",{class:"reason-checkbox"}),c=i.map((e,t)=>{const i=new n.CheckBox({label:e,value:t.toString(),title:e});return this.disposables.push(i),i}),u=this.renderErrorTips(o);d.append(...c,u);const h=new n.InputBox({placeholder:s});h.classList.add(this.HIDE_CLASS_NAME);const p=this.renderErrorTips(r);return a.append(l,d,h,p),a.classList.add(this.HIDE_CLASS_NAME),{reasonContainer:a,reasonInput:h,checkboxList:c,reasonErrorTips:u,reasonInputErrorTips:p}}}t.Util=o,o.HIDE_CLASS_NAME="hide-element",o.DEFAULT_HEIGHT=512,o.INPUT_HEIGHT=30,o.ERROR_TIP_HEIGHT=18,o.disposables=[],o.satisfiedReasonsList=["reason.right","reason.understand","reason.stable","reason.convenience","reason.rich","reason.other"],o.reasonsList=["reason.noRight","reason.noUnderstand","reason.noStable","reason.noConvenience","reason.noRich","reason.other"]},9733(e,t,i){"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.getCheckBoxStyle=void 0;const n=i(6199);t.getCheckBoxStyle=e=>`\n.ide-checkbox-wrapper {\n    display: flex;\n    font-family: ${n.fontFamily};\n    align-items: center;\n    height: 20px;\n    outline: none;\n}\n\n.ide-checkbox-wrapper[enabled='false'] {\n    cursor: not-allowed;\n}\n\n.ide-checkbox-wrapper>.ide-checkbox {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    box-sizing: border-box;\n    cursor: pointer;\n    border-radius: 2px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.radioColor};\n    outline: none;\n    height: 16px;\n    width: 16px;\n}\n\n.ide-checkbox-wrapper[enabled='false']>.ide-checkbox .codicon {\n    color: ${e?"var(--vscode-disabledForeground)":n.borderColor};\n}\n\n.ide-checkbox-wrapper[enabled='true']>.ide-checkbox {\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n    background-color: ${e?"var(--vscode-checkbox-custom-background)":n.radioBackgroundColor};\n}\n\n.ide-checkbox-wrapper[enabled='true']:hover>.ide-checkbox,\n.ide-checkbox-wrapper[enabled='true']:focus>.ide-checkbox {\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.primaryColor};\n}\n\n.ide-checkbox-wrapper[enabled='true']>.ide-checkbox:focus {\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.primaryColor};\n}\n\n.ide-checkbox-wrapper[enabled='true']:active>.ide-checkbox {\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.primaryColorClick};\n}\n\n.ide-checkbox-wrapper[enabled='true']>.ide-checkbox[checked] {\n    background-color: ${e?"var(--vscode-checkbox-selectBackground)":n.primaryColor};\n    border: ${e?"1px solid var(--vscode-checkbox-border)":"none"};\n    color: ${e?"var(--vscode-checkbox-foreground)":""};\n}\n\n.ide-checkbox-wrapper[enabled='true']:hover>.ide-checkbox[checked] {\n    background-color: ${e?"var(--vscode-checkbox-selectBackground)":n.primaryColorHover};\n    color: ${e?"var(--vscode-checkbox-foreground)":""};\n}\n\n.ide-checkbox-wrapper[enabled='true']>.ide-checkbox[checked]:focus {\n    background-color: ${e?"var(--vscode-checkbox-selectBackground)":n.primaryColorHover};\n    color: ${e?"var(--vscode-checkbox-foreground)":""};\n}\n\n.ide-checkbox-wrapper[enabled='true']:active>.ide-checkbox[checked] {\n    background-color: ${e?"var(--vscode-checkbox-selectBackground)":n.primaryColorClick};\n    color: ${e?"var(--vscode-checkbox-foreground)":""};\n}\n\n.ide-checkbox-wrapper[enabled='false']>.ide-checkbox {\n    cursor: not-allowed;\n    border: 1px solid ${e?"var(--vscode-checkbox-border)":n.borderColor};\n    background-color: ${e?"var(--vscode-checkbox-custom-disabled-background)":n.disbaledradioBackgroundColor};\n}\n\n.ide-checkbox-wrapper>.ide-checkbox-label {\n    display: inline-block;\n    font-size: 13px;\n    color: ${e?"var(--vscode-foreground)":n.primaryFontColor};\n    line-height: 28px;\n    height: 28px;\n    cursor: pointer;\n    user-select: none;\n    font-weight: 400;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    margin-left: 4px;\n}\n\n.ide-checkbox-wrapper[enabled='false']>.ide-checkbox-label {\n    cursor:not-allowed;\n    color: ${e?"var(--vscode-disabledForeground)":n.disabledFontColor};\n}\n\n.ide-checkbox-wrapper>.ide-checkbox-label .codicon {\n    line-height: 20px;\n    height: 20px;\n    vertical-align: middle;\n}\n\n.ide-checkbox-wrapper.true {\n    width: 154px;\n    height: 56px;\n    background: ${e?"var(--vscode-checkbox-background)":n.defaultTagBackground};\n    border: 1px solid rgba(255, 255, 255, 0);\n    border-radius: 8px;\n    justify-content: space-between;\n}\n\n.ide-checkbox-wrapper.true:hover,\n.ide-checkbox-wrapper.true:focus {\n    background: ${e?"var(--vscode-focusBorder-background)":n.secondaryBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 8px;\n    outline: none;\n}\n\n.ide-checkbox-wrapper.true:focus .ide-checkbox {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n}\n\n.ide-checkbox-wrapper-active.true {\n    display: flex;\n    width: 154px;\n    height: 56px;\n    background: ${e?"var(--vscode-focusBorder-background)":n.secondaryBackgroundColor};\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 8px;\n    justify-content: space-between;\n    outline: none;\n}\n\n.ide-checkbox-left-container {\n    display: flex;\n    flex-direction: column;\n    justify-content: start;\n    padding: 9px 0 9px 12px;\n}\n\n.ide-checkbox-wrapper.true .ide-checkbox-left-container .ide-checkbox-label {\n    width: 100px;\n    font-size: 14px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.primaryFontColor};\n    line-height: 20px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-checkbox-wrapper-active.true .ide-checkbox-left-container .ide-checkbox-label {\n    width: 100px;\n    font-size: 14px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.titleFontColor};\n    line-height: 20px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-checkbox-wrapper.true:hover .ide-checkbox-left-container .ide-checkbox-label,\n.ide-checkbox-wrapper-active.true:hover .ide-checkbox-left-container .ide-checkbox-label {\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.titleFontColor};\n}\n\n.ide-checkbox-wrapper.true .ide-checkbox-left-container .ide-checkbox-secondary-label,\n.ide-checkbox-wrapper-active.true .ide-checkbox-left-container .ide-checkbox-secondary-label {\n    width: 100px;\n    font-size: 12px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.secondaryFontColor};\n    opacity: ${e?"0.6":""};\n    line-height: 18px;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n\n.ide-checkbox-wrapper.true>.ide-checkbox-right-container,\n.ide-checkbox-wrapper-active.true>.ide-checkbox-right-container {\n    display: flex;\n    margin: 20px 9px 20px 0;\n}\n\n.ide-checkbox-wrapper.true:hover .ide-checkbox-right-container .ide-checkbox,\n.ide-checkbox-wrapper-active.true:hover .ide-checkbox-right-container .ide-checkbox {\n    border: 1px solid ${e?"var(--vscode-focusBorder)":n.primaryColor};\n    border-radius: 2px;\n}\n\n.ide-checkbox-wrapper.true>.ide-checkbox-right-container>.ide-checkbox[checked],\n.ide-checkbox-wrapper-active.true>.ide-checkbox-right-container>.ide-checkbox[checked] {\n    background-color: ${e?"var(--vscode-checkbox-selectBackground)":n.primaryColor};\n    border: ${e?"1px solid var(--vscode-checkbox-border)":""};\n    color: ${e?"var(--vscode-checkbox-foreground)":""};\n    border-radius: 2px;\n}\n\n.ide-checkbox-wrapper.true>.ide-checkbox-right-container>.ide-checkbox,\n.ide-checkbox-wrapper-active.true>.ide-checkbox-right-container>.ide-checkbox {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    box-sizing: border-box;\n    cursor: pointer;\n    border-radius: 2px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.radioColor};\n    outline: none;\n    height: 16px;\n    width: 16px;\n}\n\n.ide-checkbox-wrapper.true[enabled='false'] .ide-checkbox-left-container,\n.ide-checkbox-wrapper.true[enabled='false'] {\n    cursor: ${e?"not-allowed":""};\n}\n\n.ide-checkbox-wrapper.true[enabled='false']:hover,\n.ide-checkbox-wrapper.true[enabled='false']:focus {\n    background-color: ${e?"var(--vscode-checkbox-background)":""};\n    border-color: ${e?"rgba(255, 255, 255, 0)":""};\n}\n\n.ide-checkbox-wrapper.true[enabled='false']:hover .ide-checkbox-right-container .ide-checkbox,\n.ide-checkbox-wrapper.true[enabled='false']:focus .ide-checkbox-right-container .ide-checkbox {\n    border: ${e?"none":""};\n}\n\n.ide-checkbox-wrapper-active.true[enabled='false'],\n.ide-checkbox-wrapper-active.true[enabled='false']:hover {\n    background-color: ${e?"var(--vscode-checkbox-wrapper-background)":""};\n    border-color: ${e?"var(--vscode-checkbox-border)":""};\n}\n\n.ide-checkbox-wrapper-active.true:hover .ide-checkbox-right-container .ide-checkbox[checked='true'] {\n    border-color: ${e?"var(--vscode-checkbox-border)":""}\n}\n\n.ide-checkbox-indicatorIcon {\n    display: flex;\n    margin-left: 4px;\n}\n\n.ide-checkbox-wrapper .ide-checkbox-description {\n    text-align: right;\n    flex-grow: 1;\n    font-size: 13px;\n    color: ${e?"var(--vscode-checkbox-labelForeground)":n.disabledFontColor};\n    opacity: ${e?"0.6":""};\n    line-height: 28px;\n    height: 28px;\n    cursor: pointer;\n    user-select: none;\n    font-weight: 400;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n    margin-left: 4px;\n    width: 0%;\n}`}},t={};function i(n){var o=t[n];if(void 0!==o)return o.exports;var s=t[n]={exports:{}};return e[n].call(s.exports,s,s.exports,i),s.exports}return i.d=(e,t)=>{for(var n in t)i.o(t,n)&&!i.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},i.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),i.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),i.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i(5079)})());
//# sourceMappingURL=index.js.map